'use strict';
define(function() {
  var gcelement = function(
    NetworkFactory,
    $timeout,
    gcInteractions,
    gclayers,
    gcWFS
  ) {
    var GEOJSON_FORMAT = new ol.format.GeoJSON();
    return {
      templateUrl: 'js/XG/widgets/utilities/network/views/gcorthogonalhit.html',

      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        pathprocessconfig: '=pathprocessconfig',
        projectdist: '=projectdist',
        result: '=res',
        state: '=',
        onactivated: '&',
        onfinish: '&',
        toolBarWidget: '=?toolbarwidget',
      },
      transclude: true,
      link: function(scope, element, attrs, ctrl) {
        var wfsLayer = null;
        scope.snappingActivated = false;
        var networkName = scope.netname;
        var pathProcessConfig = null;
        if (scope.pathprocessconfig)
          pathProcessConfig = simplifyPathProcessConfig(
            scope.pathprocessconfig
          );

        var map = scope.map;
        var inSrid = map
          .getView()
          .getProjection()
          .getCode();
        var btnElt = $(element.children()[0]);

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function simplifyPathProcessConfig(networkTool) {
          var networkToolConfig = {
            label: networkTool.label,
            toolType: networkTool.toolType,
            amontElements: [],
            avalElements: [],
            networkElements: [],
            amontElementsFilters: [],
            avalElementsFilters: [],
            networkElementsFilters: [],
          };

          var amontElementsConfigPart = dataToSavePartConfig(
            networkTool.amontElementsData
          );
          var avalElementsConfigPart = dataToSavePartConfig(
            networkTool.avalElementsData
          );
          var networkElementsConfigPart = dataToSavePartConfig(
            networkTool.edgesAndNodesData
          );

          networkToolConfig.amontElements = amontElementsConfigPart;
          networkToolConfig.avalElements = avalElementsConfigPart;
          networkToolConfig.networkElements = networkElementsConfigPart;

          var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAmontEditFTypeAttributeValues
          );
          var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAvalEditFTypeAttributeValues
          );
          var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentEditFTypeAttributeValues
          );

          networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
          networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
          networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

          networkToolConfig.genericConfig = networkTool.genericConfig;
          return networkToolConfig;
        }

        function deactivate() {
          scope.isActive = false;
          if (scope.snappingActivated == true && wfsLayer != null) {
            map.removeLayer(wfsLayer);
            scope.snappingActivated = false;
            wfsLayer = null;
          }
          //map.removeInteraction(scope.pointer);
          if (scope.networkSelectInteraction) {
            map.removeInteraction(scope.networkSelectInteraction);
            scope.networkSelectInteraction.setActive(false);
            scope.networkSelectInteraction = null;
          }
          if (scope.networkSnapInteraction) {
            map.removeInteraction(scope.networkSnapInteraction);
            scope.networkSnapInteraction.setActive(false);
            scope.networkSnapInteraction = null;
          }
        }

        function networkSelectStart(evt) {
          /*sketchFeature = evt.feature;*/
        }

        function cloneFeature(olFeature) {
          var clonedFeature = olFeature.clone();
          clonedFeature.setProperties(olFeature.getProperties());
          clonedFeature.setId(olFeature.getId());
          return clonedFeature;
        }

        function getSnappedFeature(featureGeometry) {
          if (wfsLayer == null) return null;
          else {
            var featureGeometryString = GEOJSON_FORMAT.writeGeometry(
              featureGeometry
            );
            var features = wfsLayer.getSource().getFeatures();
            for (var i = 0; i < features.length; i++) {
              var featGeometryString = GEOJSON_FORMAT.writeGeometry(
                features[i].getGeometry()
              );
              if (featureGeometryString == featGeometryString)
                return cloneFeature(features[i]);
            }
            return null;
          }
        }

        function networkSelectEnd(evt) {
          //scope.features = evt.feature;

          var clickFeature = evt.feature;
          var feature = GEOJSON_FORMAT.writeFeatureObject(evt.feature);
          //

          if (scope.radiomode) {
            scope.networkSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkSelectInteraction);
          }

          scope.resgeometry = feature.geometry;
          var coordX = scope.resgeometry.coordinates[0];
          var coordY = scope.resgeometry.coordinates[1];

          var featureGeometry = evt.feature.getGeometry();
          NetworkFactory.getorthogonalpoint(
            networkName,
            inSrid,
            coordX,
            coordY,
            scope.projectdist
          ).then(function(res) {
            if (res.data != null && res.data != '') {
              var snappedFeature = getSnappedFeature(featureGeometry);
              var isSnappedFeature = snappedFeature != null;
              res.data.clickFeature = isSnappedFeature
                ? snappedFeature
                : clickFeature;
              res.data.isSnappedFeature = isSnappedFeature;
              scope.result = res.data;
              $timeout(scope.onfinish, 100);
            }
          });
        }

        function geometryCoordinatesUpdated(coordinates, geom) {
          //Si première fois, geom pas encore instanciée
          if (!geom) {
            geom = new ol.geom.Point(coordinates);
            //Si dessin avec contrainte X et/ou Y
            if (scope.isXConstraint || scope.isYConstraint) {
              geom.setCoordinates(getProjConstraintsCoordinates(coordinates));
            }
            return geom;
          }

          //Si dessin avec contrainte X et/ou Y
          if (scope.isXConstraint || scope.isYConstraint) {
            coordinates = getProjConstraintsCoordinates(coordinates);
          }

          geom.setCoordinates(coordinates);
          return geom;
        }

        function toggleActionLaunch() {
          if (
            scope.isActive &&
            scope.networkSelectInteraction &&
            scope.networkSelectInteraction.getActive()
          ) {
            scope.isActive = false;
            //map.removeInteraction(scope.pointer);
            if (scope.networkSelectInteraction) {
              scope.networkSelectInteraction.setActive(false);
              map.removeInteraction(scope.networkSelectInteraction);
            }

            //ajouter ce code si on veut enlever la sélection après la désactivation du tool
            //SelectManager.clear();
          } else {
            scope.isActive = true;
          }

          if (scope.isActive) {
            scope.networkSelectInteraction =
              wfsLayer == null
                ? new ol.interaction.Draw({
                    type: 'Point',
                    geometryFunction: geometryCoordinatesUpdated,
                  })
                : new ol.interaction.Draw({
                    source: wfsLayer.getSource(),
                    type: 'Point',
                    geometryFunction: geometryCoordinatesUpdated,
                  });
            scope.networkSelectInteraction.set('gctype', 'kis');
            scope.networkSelectInteraction.set('interaction', 'Draw');
            scope.networkSelectInteraction.set('widget', 'network');
            scope.networkSelectInteraction.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            map.addInteraction(scope.networkSelectInteraction);
            //on start
            scope.networkSelectInteraction.on('drawstart', networkSelectStart);

            // on end
            scope.networkSelectInteraction.on('drawend', networkSelectEnd);

            checkAndAddPropagationSnappingFeatures();
          } else deactivate();
        }

        function checkAndAddPropagationSnappingFeatures() {
          if (
            scope.snappingActivated == false &&
            scope.pathprocessconfig &&
            scope.pathprocessconfig.genericConfig &&
            scope.pathprocessconfig.genericConfig.projectLayer
          ) {
            //Chargement des objets des couches sur lesquelles s'accrocher
            var layersToLoad = [];
            var layers = gclayers.getOperationalLayer();
            var projectLayerUID =
              scope.pathprocessconfig.genericConfig.projectLayer;

            //Pour chaque layer opérationelle
            for (var i = 0; i < layers.length; i++) {
              var l = layers[i];
              if (l.fti == undefined) continue;
              if (projectLayerUID == l.fti.uid) {
                var fti = l.fti;
                layersToLoad.push(fti);
                break;
              }
            }

            wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,map);
            map.addLayer(wfsLayer);
            //var source = wfsLayer.getSource();
            //var srcDrawedDXF = gclayers.getImportLayer().getSource();
            //source.addFeatures(srcDrawedDXF.getFeatures());

            var snapTolerance = 20;

            //Instanciation de l'interaction OpenLayer d'accroche sur objets
            // appartenant aux layers chargées dans l'objet 'source' de la couche WFS crée.
            scope.networkSnapInteraction = new ol.interaction.Snap({
              source: wfsLayer.getSource(),
              vertex: true,
              pixelTolerance: snapTolerance,
            });

            scope.networkSnapInteraction.set('gctype', 'kis');
            scope.networkSnapInteraction.set('interaction', 'Snap');
            scope.networkSnapInteraction.set('widget', 'network');
            scope.networkSnapInteraction.setActive(true);

            //Ajout de l'interaction à la carte
            map.addInteraction(scope.networkSnapInteraction);
            if (
              map
                .getInteractions()
                .getArray()
                .indexOf(scope.networkSnapInteraction) !== -1
            ) {
              //Envoi de l'information de l'interaction ajoutée.
              map.dispatchEvent({ type: 'snapAddedEvent' });
              console.info('Configuration de orthogonalHit chargée.');
            }

            scope.snappingActivated = true;
          }
        }

        scope.addHitFeatures = function(event) {
          console.log('go for add hit features');
          if (!scope.isActive) scope.onactivated();

          toggleActionLaunch();
        };

        scope.$watch('state', function(newVal, oldVal) {
          if (newVal == 'DEACTIVATED' && scope.isActive == true)
            toggleActionLaunch();
        });
      },
    };
  };

  gcelement.$inject = [
    'NetworkFactory',
    '$timeout',
    'gcInteractions',
    'gclayers',
    'gcWFS',
  ];
  return gcelement;
});
