'use strict';
define(function () {
  const itvSoummissionPartList = function () {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionPartList.html',
      restrict: 'EA',
      link: function (scope) {
        /**
         * Transforme le tableau "[troncon.1, troncon.12]"
         * en chaine de caracteres "troncon.1, troncon.12"
         * @param {*} headerValue : valeur de header à transformer
         * @returns valeur de header transformée
         */
        const cleanHeaderValue = (headerValue) => {
          if (headerValue instanceof Array) {
            headerValue = headerValue.join(',');
          }
          if (typeof (headerValue) === 'string') {
            return headerValue.replace(/"/g, '')
              .replace(/\[/g, '').replace(/\]/g, '');
          }
          return '';
        };

        /**
         * Retourne la valeur du header à afficher.
         *
         * @param {*} partHeader : entête du fichier ITV
         * @param {*} col : description de la colonne à afficher
         * @returns valeur du header
         */
        scope.getHeaderValue = (partHeader, col) => {
          return !partHeader[col.cname] && col.cnameAlt
            ? cleanHeaderValue(partHeader[col.cnameAlt])
            : partHeader[col.cname];
        };
      }
    };
  };

  itvSoummissionPartList.$inject = [];
  return itvSoummissionPartList;
});
