'use strict';
define(function () {
  const itvSoumissionCorresp = (SelectManager, $filter, $timeout,
    gclayers, gcInteractions, $rootScope, itvSoumValidSelection,
    itvUtilsFactory, ogcFactory, FeatureTypeFactory, itvSoumFactory,
    itvDrawPartsFactory,
    PortalsFactory,
    gaJsUtils
    ) => {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionCorrespondance.html',
      restrict: 'EA',
      scope: {
        corresp: '=corresp',
        information: '=information',
        map: '=map',
        networks: '=networks',
        conf: '=conf',
        config: '=config',
        $hiderow: '=$hiderow',
        correspPolygons: '=correspPolygons',
        pointer: '=pointer',
        selected: '=selected',
        currentPart: '=currentPart',
        wrongLength: '&',
        selectedPart: '=selectedPart',
        getItvId: '=getItvId',
        zoomOnFeatures: '=zoomOnFeatures'
      },
      link: function (scope) {

        let portalid = angular.module('gcMain').portalid;
        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }
        const mapProjCode = scope.map.getView().getProjection().getCode();


        scope.lastDPath = {
          fullData: null,
          featureCollectionData: null,
          nFeatureCollectionData: null,
        };


        /**
         * Gestion de l'activation de l'outil de parcours réseau.
         */
        scope.usenetwork = false;
        scope.network = () => {
          scope.usenetwork = !scope.usenetwork;
        };


        /**
         * Ce=herche un "polygon" d'aprés son nom.
         * Il y a 4 polygones possibles les polygones amont, aval, centre et
         * alone.
         *
         * @param {*} polygonName
         * @returns
         */
        const getPolygon = (polygonName) => {
          return scope.correspPolygons.find(
            polygon => polygon.name === polygonName);
        };


        scope.closeCfgPopovers = () => {
          $('.svgitvpopover2 .popover').remove();
          scope.showinver = false;
          scope.pointer.setActive(false);
          scope.map.removeInteraction(scope.pointer);
        };


        scope.removeSelection = () => {
          if (scope.pointer && scope.pointer instanceof ol.interaction.Draw)
            scope.pointer.setActive(false);
          scope.map.removeInteraction(scope.pointer);
          scope.selected = false;
          SelectManager.clear();
          scope.tovalidate = false;
          scope.usenetwork = false;
        };


        /**
         * Mettre dans le "polygon" aval la decription du noeud amont, et
         * dans le "polygon" amont celle du noeud aval.
         */
        scope.inverserlaselection = () => {
          //-- Récupération des "polygons" à inverser
          const aval = getPolygon('polygonAval');
          const amont = getPolygon('polygonAmont');
          if (amont && aval) {
            //-- Sauvegarde du noeud affecté au "polygon" aval
            const avalFeature = aval.feature;
            const avalFtiUid = aval.id;
            //-- Mettre la description du noeud amont dans le "polygon" aval.
            aval.feature = amont.feature;
            aval.id = amont.id;
            //-- Mettre la description du noeud aval sauvegardé
            //-- dans le "polygon" amont.
            amont.feature = avalFeature;
            amont.id = avalFtiUid;

            //-- RAFRAICHIR LES REPRESENTATIONS GRAPHIQUES
            //-- "addPolygons" va définir les identifiants associés aux entêtes
            //-- de la portion, il faut, donc, les nettoyer au préalable.
            itvUtilsFactory.clearHeaderIds(amont);
            itvUtilsFactory.clearHeaderIds(aval);
            const corresp = scope.information.correspondance;
            //-- Sauvegarde du "currentPolygon" (au cas où il y en ait un)
            const curPolygon = corresp.parts.currentPolygon;
            //-- Rafraichir représentation du noeud aval
            corresp.parts.currentPolygon = aval;
            itvUtilsFactory.addpolygons(scope, aval);
            scope.corresp.partHeaderAval.partHeader = aval.partHeader;
            //-- Rafraichir représentation du noeud amont
            corresp.parts.currentPolygon = amont;
            itvUtilsFactory.addpolygons(scope, amont);
            scope.corresp.partHeaderAmont.partHeader = amont.partHeader;
            //-- Restaurer le "currentPolygon"
            corresp.parts.currentPolygon = curPolygon;
          }
        };


        /**
         * Exécutée à la fin du parcours réseau.
         * @returns {undefined}
         */
        scope.lastDPathFound = () => {
          scope.tovalidate = true;
          scope.information.correspondance.lastDPath = scope.lastDPath;
        };


        /**
         * Mettre en place l'environnement de travail correspondant
         * au "header" (AAB, AAD, AAA, CAA) associé au "polygone".
         *
         * @param {*} polygon
         */
        const clickOnPolygon = (polygon) => {
          if (!polygon) {
            //-- Cas où un polgone n'est pas utilisé, par exemple
            //-- en correspondance de tronçon, on n'utilise pas
            //-- le "polygonAlone" qui gére la correspodnance
            //-- dans le cas d'une inspection de regard. Et vice versa.
            return;
          }
          const name = polygon.name;

          if (angular.isUndefined(
            scope.information.correspondance.parts.polygons)) {
            scope.information.correspondance.parts.polygons = {};
            var Key = 'part' + polygon.part.objValeur.indTroncon;
            scope.information.correspondance.parts.polygons[Key] = {};
            scope.information.correspondance.parts.currentPolygon
              = polygon;
            scope.information.correspondance.parts.polygons[Key][
              name
            ] = polygon;
          }
          else {
            const indTroncon = itvUtilsFactory.getIndTronconFrom(polygon.part);
            Key = 'part' + indTroncon;
            const keys = Object.keys(
              scope.information.correspondance.parts.polygons
            );
            if (!keys.includes(Key)) {
              scope.information.correspondance.parts.polygons[Key] = {};
            }
            const objk = Object.keys(
              scope.information.correspondance.parts.polygons[Key]
            );
            if (objk.includes(name)) {
              scope.information.correspondance.parts.currentPolygon
                = scope.information.correspondance.parts.polygons[Key][name];
            }
            else {
              scope.information.correspondance.parts.polygons[Key][
                name
              ] = polygon;
              scope.information.correspondance.parts.currentPolygon = polygon;
            }
          }
        };


        /**
         * Appelé sur clic utilisateur sur un rond de représentation de
         * regard ou sur le rectangle de représentation de collecteur.
         * Cette fonction position le menu "popover" au bon endroit
         * par rapport au "polygone" cliqué, puis appel la fonction
         * qui met en place l'environnement de travail correspondant
         * au "header" (AAB, AAD, AAA, CAA) associé au "polygone".
         *
         * @param {*} name : nom identifiant le polygone
         *                   (noeud amont, aval
         *                    ou centre pour le(s) collecteur(s))
         * @param {*} evt : evenment du clic souris
         */
        scope.clickOnPolygon = (name, evt) => {
          if (name === 'polygonCenter' || name === 'polygonAlone') {
            $('.svgitvpopover2')
              .css('top', '70px')
              .css('left', evt.offsetX + 'px');
          }
          else if (name === 'polygonAmont') {
            $('.svgitvpopover2')
              .css('top', '76px')
              .css('left', '30px');
          }
          else if (name === 'polygonAval') {
            $('.svgitvpopover2')
              .css('top', '75px')
              .css('left', '450px');
          }

          if (name === 'polygonCenter') {
            scope.notCenter = true;
          }
          else {
            scope.notCenter = false;
          }

          clickOnPolygon(getPolygon(name));
          // KIS-3571: sauvegarde l'élement du SVG cliqué pour clore la popover proprement après validation
          setElementCliked(evt);
        };


        /**
         * Récupérer l'identifiant à afficher sous les ronds ou sous le trait
         * matérialisant les ouvragres mis ou à mettre en correspondance.
         *
         * @param {*} elementName : 'partHeaderAmont' ou 'partHeaderAval'
         *                          ou 'partHeaderCenter' selon l'élément
         *                          duquel on doit récupérer la valeur
         *                          d'identifiant.
         * @returns un objet avec les propriété id pour l'identifiant
         * à afficher, et changed pour indiquer si la valeur a été changé
         *  par rapport à celle contenu dans le fichier ITV
         */
        const getIdOf = (elementName, headerCode) => {
          let idInfo = { id: '', changed: false };
          if (scope[headerCode]) {
            idInfo = scope[headerCode];
            idInfo.id = '';
          }
          else {
            scope[headerCode] = idInfo;
          }
          const header = scope.corresp[elementName];
          if (!header || !header.partHeader) {
            //-- Pas encore d'identifiant à afficher.
            return idInfo;
          }
          idInfo.originalId = header.partHeader.originalValue;
          if (header.partHeader.values.length === 0) {
            idInfo.id = header.partHeader.value;
            const ptInd = idInfo.id.indexOf('.');
            idInfo.id
              = ptInd === -1 ? idInfo.id : idInfo.id.substring(ptInd + 1);
          }
          else {
            const ids = header.partHeader.values;
            for (const idOfIds of ids) {
              const ptInd = idOfIds.indexOf('.');
              if (idInfo.id !== '') {
                idInfo.id += ',';
              }
              idInfo.id +=
                ptInd === -1 ? idOfIds : idOfIds.substring(ptInd + 1);
            }
          }
          // -- Le cas où les tronçons sont trouvés par kis => originalValue est nul, et
          // -- donc différent de la valeur d'identifiant trouvé, on marque donc
          // -- l'identifiant comme ayant été changé par KIS.
          idInfo.changed = idInfo.id != header.partHeader.originalValue;
        };


        scope.$watch('corresp.partHeaderAmont.partHeader.value', () => {
          if (scope.corresp.inspectionType === 'branchement') {
            getIdOf('partHeaderAmont', 'AAT');
          }
          else {
            getIdOf('partHeaderAmont', 'AAD');
          }
        });

        scope.$watch('corresp.partHeaderAval.partHeader.value', () => {
          if (scope.corresp.inspectionType === 'branchement') {
            getIdOf('partHeaderAval', 'AAU');
          }
          else {
            getIdOf('partHeaderAval', 'AAF');
          }
        });

        scope.$watch('corresp.partHeaderCenter.partHeader.value', () => {
          if (scope.corresp.inspectionType === 'branchement') {
            //-- On ne peut pas utilise @01, cela perturbe angularjs, donc
            //-- on utilise A01 à la place
            getIdOf('partHeaderCenter', 'A01');
          }
          else {
            //-- AAA_id contient l'identifiant de la cana (AAA)
            //-- ou du regard inspecté (CAA)
            getIdOf('partHeaderCenter', 'AAA');
          }
        });

        /**
         * Dans le cas d'un parcours réseau on modifie la liste des values
         * sans modifier la value (pour laquelle il y a un watch
         * juste au dessus) ... du coup il faut ce watch sur la lsite "values",
         * sans quoi l'affichage des identifiants n'est pas actualisée
         * dans ce cas.
         */
        scope.$watchCollection('corresp.partHeaderCenter.partHeader.values', () => {
          //-- AAA_id contient l'identifiant des canas (AAA)
          getIdOf('partHeaderCenter', 'AAA');
        });


        scope.validerSelection = (partovalidate, casValiderSel02) => {
          itvSoumValidSelection.validerSelection(scope, partovalidate,
            casValiderSel02);

          // KIS-3571: simule un clic sur l'élement SVG pour clore la popover proprement
          if(scope.elementClicked) {
            $(scope.elementClicked).trigger('click');
          }
        };

        scope.zoomOn = () => {
          const parts = scope.information.correspondance.parts;
          if (angular.isDefined(parts.currentPolygon.partHeader)) {
            let polygon;
            const partsIndexes = Object.keys(parts.polygons);
            const Key = 'part' + parts.currentPolygon.part.objValeur.indTroncon;
            const name = parts.currentPolygon.name;
            if ($.inArray(Key, partsIndexes) !== -1) {
              polygon = angular.copy(parts.polygons[Key][name]);
              parts.currentPolygon = angular.copy(polygon);
            }
            if (angular.isDefined(parts.currentPolygon.feature) ||
              parts.currentPolygon.data == 'single') {
              const uid = parts.currentPolygon.partHeader.featUid;
              if (angular.isDefined(uid) && uid !== null) {
                scope.zoomOnFeatures([parts.currentPolygon.feature]);
                //-- Effacer la sélection au bout de 3 secondes.
                $timeout(function () {
                  SelectManager.clear();
                }, 3000);
              }
              else {
                require('toastr').error(
                  $filter('translate')('itv.correspondance.nofeature')
                );
              }
            }
            else if (angular.isDefined(parts.currentPolygon.features)) {
              scope.zoomOnFeatures(parts.currentPolygon.features);
              $timeout(function () {
                SelectManager.clear();
              }, 3000);
            }
          }
          else {
            require('toastr').error(
              $filter('translate')('itv.correspondance.nofeature')
            );
          }
        };


        const getFeaturesFromFiltersNoSelection = () => {
          scope.information.correspondance.parts.currentPolygon.feature
            = undefined;
          require('toastr').error(
            $filter('translate')('itv.correspondance.nofeatureselected')
          );
        };


        /**
       * Retourne la partie nom du composant depuis l'identifiant GeoTools
       * de type "composant.NNN".
       * Utilisé lors de l'exploitation du résultat de la recherche des ouvrages
       * du réseau se trouvant sur le point cliqué par l'opérateur.
       * En effet, on fait une seule recherhe avec plusieurs UID de FTI, et
       * il faut dans le résultat identifier le comosant auquel appartient
       * la feature trouvée.
       *
       * @param {*} id
       * @returns
       */
        const getFtiNameFromId = (id) => {
          return id.split('.')[0];
        };




        /**
         * Recherche des ouvrages du réseau présent la boîte
         * de selection correspondant au pointage souris de l'opérateur.
         *
         * @param {*} uids : uids des ouvrages à chercher
         * @param {*} leftX : x des coins gauches
         * @param {*} rightX : x des coins droits
         * @param {*} topY : y des coins haut
         * @param {*} bottomY : y des coins bas
         * @param {*} x : x du point pointé par l'opérateur
         * @param {*} y : y du point pointé par l'opérateur
         */
        const getFeaturesFromFilters = (uids, leftX, rightX, topY, bottomY,
          x, y) => {
          const currentPolygon
            = scope.information.correspondance.parts.currentPolygon;
          const cql_filter = 'INTERSECTS(geom, POLYGON((' + leftX
            + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' + rightX + ' '
            + topY + ',' + leftX + ' ' + topY + ',' + leftX + ' ' + bottomY +
            ')))';
          ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', uids, 'json',
            mapProjCode, cql_filter).then((res) => {
            if (res.data.totalFeatures !== 0) {
              const ftiName = getFtiNameFromId(res.data.features[0].id);
              const ftiUid = FeatureTypeFactory.getFeatureUidByName(ftiName);
              currentPolygon.feature = res.data.features[0];
              currentPolygon.crs = res.data.crs;
              currentPolygon.id = ftiUid;
              currentPolygon.coord = [x, y];
              const features = { features: [currentPolygon.feature] };
              SelectManager.addFeaturesFromGeojson(features);
              require('toastr').success(
                $filter('translate')('itv.correspondance.featureselected')
              );
              scope.tovalidate = true;
            }
            else {
              getFeaturesFromFiltersNoSelection();
            }
          });
        };


        scope.pointer.on('drawend', (evt) => {
          let leftX, rightX, bottomY, topY;
          let filter = gclayers.getSelectFilterasStringuid(scope.map);
          if (filter != '') {
            var format = new ol.format.GeoJSON();
            var feature = format.writeFeatureObject(evt.feature);

            let x = feature.geometry.coordinates[0];
            let y = feature.geometry.coordinates[1];
            var resolution = scope.map.getView().getResolution();

            if (resolution != 'undefined') {
              leftX = x - 5 * resolution;
              rightX = x + 5 * resolution;
              bottomY = y - 5 * resolution;
              topY = y + 5 * resolution;
            }
            else {
              leftX = x - 5;
              rightX = x + 5;
              bottomY = y - 5;
              topY = y + 5;
            }

            getFeaturesFromFilters(filter, leftX, rightX, topY, bottomY, x, y);
          }
          else {
            require('toastr').error(
              $filter('translate')('itv.correspondance.nolayerselected')
            );
          }
        });


        /**
         * Ne rendre sélectionnable que les layers listés
         * dans le paramétre netFtiToSelect.
         *
         * @param {*} layer : layer à traiter
         * @param {*} netFtiToSelect : liste des UIDs des layers du réseau
         *                             soit ponctuels, soit linéaires
         */
        const setSelectableLayers = (layer, netFtiToSelect) => {
          if (netFtiToSelect.indexOf(layer.get('fti').uid) !== -1) {
            if (!layer.selected) {
              //-- Layer linéaire du réseau à rendre sélectionnable
              layer.selected = true;
              gclayers.addToSelectFilter(layer);
            }
          }
          else {
            if (layer.selected) {
              //-- Autre layer non sélectionnable
              layer.selected = false;
              gclayers.removeSelectFilter(layer);
            }
          }
        };


        let networkEdgesFTI;
        let networkNodesFTI;

        /**
         * Récupére la liste des UIDs des composants du réseau à utiliser pour
         * travailler avec les ITVs.
         * La liste "networkEdgesFTI" est alimentée avec la liste des UIDs
         * des éléments linéaires du réseau.
         * La liste "networkNodesFTI" est alimentée avec la liste des UIDs
         * des éléments ponctuels du réseau.
         */
        const getNetworkFtiUids = () => {
          if (networkEdgesFTI) {
            //-- Listes déjà alimentées => ne rien faire
            return;
          }
          //-- Récupération de la description du réseau.
          let network = scope.networks.find(
            network => network.name === scope.conf.config.network);
          if (!network) {
            network = scope.networks.find(
              network => network.name === 'main.indigauNetworkCfg');
          }
          //-- Alimenter la liste des composants lignes du réseau
          //-- réseau traditionnel + branchements
          networkEdgesFTI = network.edgesTypes.map((x) => {
            return x.ftiUID;
          }).concat(network.connectionLinearTypes.map(x => x.ftiUID));
          //-- Alimenter la liste des composants points du réseau
          //-- réseau traditionnel + branchements
          networkNodesFTI = network.nodesTypes.map((x) => {
            return x.ftiUID;
          }).concat(network.connectionAmontTypes.map(x => x.ftiUID)
            .concat(network.connectionAvalTypes.map(x => x.ftiUID)));
        };

        /**
         * Activation de la sélection d'un regard ou d'un tronçon.
         */
        scope.selectFeature = () => {
          //-- Pour le cas où la sélection par parcours réseau est active,
          //-- on la désactive.
          scope.usenetwork = false;
          getNetworkFtiUids();

          const polygon = scope.information.correspondance.parts.currentPolygon;
          var name = polygon.name;
          scope.tovalidate = false;
          const layers = gclayers.getOperationalLayer();
          if (name.indexOf('Center') !== -1) {
            //-- Ne rendre sélectionnable que les linéaires du réseau
            for (let layer of layers) {
              setSelectableLayers(layer, networkEdgesFTI);
            }
          }
          else {
            //-- Ne rendre sélectionnable que les noeuds du réseau
            for (let layer of layers) {
              setSelectableLayers(layer, networkNodesFTI);
            }
          }

          scope.selected = !scope.selected;
          if (scope.selected) scope.showinver = true;
          if (scope.selected) {
            scope.pointer.setActive(scope.selected);
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            scope.map.addInteraction(scope.pointer);
          }
          else {
            if (scope.pointer && scope.pointer instanceof ol.interaction.Draw)
              scope.pointer.setActive(scope.selected);
            scope.map.removeInteraction(scope.pointer);
            SelectManager.clear();
          }
        };


        /**
         * Message affiché au dessus des coches quand l'écart de longueur
         * entre ITV et SIG est trop important.
         *
         * @returns message à afficher
         */
        scope.getWrongLengthMessage = () => {
          if (scope.currentPart) {
            //-- La fonction peut être appelé à l'initialisation
            //-- de la directive, dans quel cas, il n'y a aps de currentPart.
            let message = $filter('translate')('itv.soumission.wrongLength');
            return message.replace('$1', scope.currentPart.lengthDelta.toFixed(2))
              .replace('$2', scope.currentPart.partLength.toFixed(2))
              .replace('$3', scope.currentPart.gisLength.toFixed(2));
          }
        };



        /**
         * Remettre les valeurs d'identifiant d'ouvrage de l'entête descriptif
         * de la portion inspectée avant travail de mise en correspondance
         * de l'opérateur. Selon le cas, on récupére les valeurs d'identifiant
         * trouvées par correspondance automatique, ou les valeurs qui étaient
         * dans le fichier ITV.
         *
         * @param {*} header : header à réinitialiser
         */
        const resetHeader = (header) => {
          if (header.matchedAutomatically) {
            //-- Dans le cas où la correspondance initiale
            //-- est automatique alors l’action de Réiniitaliser
            //-- rétablit cette correspondance initiale.
            header.value = header.valueMa;
            header.featUid = header.featUidMa;
            header.values = angular.copy(header.valuesMa);
            header.featUids = angular.copy(header.featUidsMa);
            if (header.featId4Net) {
              header.featId4Net = header.value;
            }
            if (header.featIds4Net && header.featIds4Net.length) {
              header.featIds4Net = angular.copy(header.values);
            }
          }
          else {
            //-- Remise en place des valeurs du fichiers ITV
            header.value = header.originalValue;
            header.values = [];
            header.featId4Net = header.featUid = '';
            header.featUids = [];
            header.featIds4Net = [];
          }
        };

        /**
         * Réinitialisation d'un header décrit par un des "polygones"
         * (rond vert, rond rouge, trait vert ou rond bleu).
         * Réinitialiser = remettre les valeurs avant intervention
         * de l'opérateur, c'est à dire selon le cas les valeurs trouvées
         * par correspondance automatique, ou les valeurs qui étaient
         * dans le fichier ITV.
         *
         * @param {*} itvResponse : conteneur des portions stockées
         *                          dans le repository
         * @param {*} polygon : rond vert, ou bleu, ou rouhe ou trait vert
         */
        const resetMatchingOf = (itvResponse, polygon) => {
          const partHeader = polygon.partHeader;
          const part = itvResponse.objValeur.parts.find(
            part => part.partIndex === polygon.part.objValeur.indTroncon);
          if (part) {
            const header
              = part.partHeaders.find(
                header => header.code === partHeader.code);
            if (header) {
              //-- La portion et l'entête ne sont plus valides
              //-- => Actualisation des couleurs de l'entête dans la liste
              //-- des portions, et des couleurs de coches au dessus
              //-- des "polygones".
              polygon.part.objValeur.validated = polygon.part.validated
                = part.validated = header.validated = false;
              resetHeader(header);
              if (header.code === 'AAD') {
                //-- Le test aurait pu porter sur AAF, l'essentiel est que
                //-- s'agissant d'une inspection de collecteur,
                //-- le regard AAB doit aussi être réinitialisé.
                const headerAAB
                  = part.partHeaders.find(header => header.code === 'AAB');
                headerAAB.validated = false;
                resetHeader(headerAAB);
              }

              //-- On doit avoir la même entête dans le polygone
              //-- pour le travail, et pour l'enregistrement du fichier.
              polygon.partHeader = header;
              const headerInd = polygon.part.objValeur.headers.findIndex(
                thisHeader => thisHeader.code === header.code);
              if (headerInd !== -1) {
                polygon.part.objValeur.headers[headerInd] = header;
              }
            }
          }
        };


        /**
         * L'utilisateur demande à réinitialiser la portion avec
         * les valeurs  d'identifiant des ouvrages qui étaient
         * dans le fichier ITV.
         */
        scope.resetMatching = () => {
          const itvResponse = scope.information.impor.itvResponse;
          const polygons = scope.corresp;
          itvUtilsFactory.clearAllSources();
          let lastPolygon;
          for (const polygonName in polygons) {
            const polygon = polygons[polygonName];
            if (polygon && polygon.part) {
              lastPolygon = polygon;
              resetMatchingOf(itvResponse, polygon);
            }
          }
          //-- Il y a trop d'informations un peu partout dupliquées
          //-- qu'il faudra regrouper.
          const ind = scope.information.correspondance.parts.part.findIndex(
            part => part.objValeur.indTroncon === lastPolygon.part.objValeur.indTroncon);
          scope.information.correspondance.parts.part[ind] = lastPolygon.part;
          itvSoumFactory.saveItvPart(itvResponse.objValeur, lastPolygon.part,
            scope.dontSaveItvPart, scope.conf.config.network, scope.conf.config.datastore).then(() => {
            itvDrawPartsFactory.drawParts(scope, lastPolygon.part);
          });
        };

        /**
         * Vérifie si l'utilisateur a sélectionné les noeuds amont et aval
         * afin afficher le bouton permettant d'inverser le sens des noeuds
         * @return {boolean} true si le bouton doit être affiché
         */
        scope.canReverseNodes = () => {
          return gaJsUtils.notNullAndDefined(scope.corresp,'partHeaderAmont.partHeader.validated')
              && typeof scope.corresp.partHeaderAmont.partHeader.validated === 'boolean'
              && scope.corresp.partHeaderAmont.partHeader.validated
              && gaJsUtils.notNullAndDefined(scope.corresp,'partHeaderAval.partHeader.validated')
              && typeof scope.corresp.partHeaderAval.partHeader.validated === 'boolean'
              && scope.corresp.partHeaderAval.partHeader.validated;
        };

        /**
         * Vérifie si la div .itvNetworkPath du parcours réseau et
         * inversion du sens d'inspection n'affiche que la case à cocher
         * "Ignorer la portion".
         * Dans ce cas, on positionne celle-ci à droite
         * de la div .itvNetworkPath
         * Gère le ng-class de la div .itvNetworkPath
         * @return {boolean} true si les conditions d'affichage des boutons
         *                   du parcours réseau et du bouton d'inversion
         *                   du sens sont négatives
         */
        scope.isOnlyIgnorePortionShown = () => {
          return scope.$hiderow && gaJsUtils.notNullAndDefined(scope.conf, 'config.mayIgnorePortions')
              && scope.conf.config.mayIgnorePortions && !scope.usenetwork && !scope.canReverseNodes();
        };


        /**
         * Sauvegarde de l'ITV Part avec son état (ignoré ou non).
         */
        scope.savePortionIgnoredState = (part) => {
          itvUtilsFactory.saveItvPart(scope.getItvId(),
            itvUtilsFactory.getIndTronconFrom(part), part, scope.conf.config.network,
            scope.conf.config.datastore);
        };


        /**
         * Sauvegarde du caractére visible et du caractère sélectionnable
         * de chaque couche dans une liste indexée sur l'UID du composant.
         */
        const saveCurrentVisibilities = () => {
          if (scope.initialVisibilities) {
            //-- La sauvegarde a déjà été faite, donc on ne la refait pas.
            return;
          }
          //-- Liste indexée sur l'UID des composants
          scope.initialVisibilities = {};
          //--  Parcours des layers de la carte
          const layers = gclayers.getOperationalLayer();
          for (let layer of layers) {
            //-- Sauvegarde de la visibilité et de la sélectionnabilité
            //-- de la couche.
            scope.initialVisibilities[layer.get('fti').uid] = {
              visible: layer.getVisible(),
              selected: layer.selected
            };
          }
        };


        /**
         * Ne rendre visible que les couches du réseau d'assainissement.
         */
        const setNetWorkVisible = () => {
          //-- Récupérer les UIDs des composants du réseau d'assainissement
          getNetworkFtiUids();
          //-- Récupérer les couches de la carte
          const layers = gclayers.getOperationalLayer();
          let modified = false;
          //-- Parcours des couches de la carte
          for (let layer of layers) {
            const layerUid = layer.get('fti').uid;
            if (networkNodesFTI.includes(layerUid)
              || networkEdgesFTI.includes(layerUid)) {
              //-- La couche appartient au réseau
              if (!layer.getVisible()) {
                //-- et elle n'est pas déjà visible
                //-- donc on la rend visible.
                modified = true;
                layer.setVisible(true);
              }
            }
            else {
              //-- La couche n'appartient pas au réseau
              if (layer.getVisible()) {
                //--  et elle est visible, donc on la rend invisible.
                modified = true;
                layer.setVisible(false);
              }
            }
          }
          if (modified) {
            //-- Des couches ont été modifiées, donc on rafraîchit la carte.
            $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
          }
        };


        /**
         * Remet en place la visibilité et la sélectabilité de chaque couche
         * telles que sauvegardé quand l'utilisateur a demandé à ne voir
         * que les couches du réseau d'assainissement.
         */
        const restoreVisibility = () => {
          if (!scope.initialVisibilities) {
            //-- Pas de visibilités initiales sauvegardées
            //-- peut-être parceque l'on n'a pas demandé à ne voir
            //-- que les couches du réseau.
            return;
          }
          const layers = gclayers.getOperationalLayer();
          //-- Parcours de chaque layer de la carte
          for (let layer of layers) {
            //-- Remise en place de la visibilité et e la sélectabilité
            //-- de la couche
            const visibility = scope.initialVisibilities[layer.get('fti').uid];
            layer.setVisible(visibility.visible);
            layer.selected = visibility.selected;
          }
          //-- Demande de prise en compte de la configuration des couches
          //-- avec dessin de la carte actualisée.
          $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
        };


        //-- Remettre les visibilités et sélectionnabilitéss initiales
        //-- lorsque l'on ferme le widget.
        scope.$on('closingWidget', restoreVisibility);


        /**
         * L'opérateur demande à changer les couches visibles
         * par clic sur la case à cocher
         * "Afficher uniquement les couches du réseau"
         */
        scope.manageLayersOnMap = () => {
          if (scope.displayOnlyNetwork) {
            //-- La case est cochée
            saveCurrentVisibilities();
            setNetWorkVisible();
          }
          else {
            //-- La case est décochée
            restoreVisibility();
          }
        };

        /**
         * Sauvegarde l'élement du SVG cliqué au moment de faire apparaître la popover.
         * Cet élément servira à clore la popover proprement
         * @param {MouseEvent} $event clic sur un élement SVG (circle ou rect)
         */
        const setElementCliked = ($event) => {
          if (scope.elementClicked) {
            scope.elementClicked = null;
          } else {
            scope.elementClicked = $event.target;
          }
        };

      }
    };
  };


  itvSoumissionCorresp.$inject = ['SelectManager', '$filter', '$timeout',
    'gclayers', 'gcInteractions', '$rootScope',
    'itvSoumValidSelection', 'itvUtilsFactory', 'ogcFactory',
    'FeatureTypeFactory', 'itvSoumFactory', 'itvDrawPartsFactory',
    'PortalsFactory',
    'gaJsUtils'
  ];
  return itvSoumissionCorresp;
});
