'use strict';
define(function () {
  /**
   * Quelques principes de fonctionnement:
   * LAYERS:
   * -> 3 layers sont utilisés pour représenter la portion inspectées
   *    sur la carte.
   *    -> layer nommé 'amont' pour le point vert = entrée de caméra
   *    -> layer nommé 'aval' pour le point rouge = sortie de caméra
   *    -> layer nommé 'canal' pour les lignes vertes = canalisation inspectées
   * Il semblerait qu'il y  ait aussi un layer 'center' : voir à quoi il sert.
   */
  const itvSoumission = function ($filter, itvSoumFactory, $timeout,
    ngProgressFactory, $interval, $compile, ngTableParams,
    gclayers, NetworkFactory, extendedNgDialog, $rootScope, $modal,
    DataStoreFactory, gaDomUtils, $location,
    ConfigFactory, gaJsUtils, $q, ngDialog,
    itvSoumValidSelection, itvDrawPartsFactory, itvUtilsFactory, EditFactory, PortalsFactory,
    FeatureTypeFactory, ogcFactory, SelectManager, QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/soumission/itvSoumission.html',
      restrict: 'A',

      link: function (scope) {
        let portalid = angular.module('gcMain').portalid;
        scope.corresp = {};
        scope.work = {};
        scope.work.createConnectionPipes = false;
        scope.featuresTree = {};
        scope.featuresData = [];
        scope.totalFeaturesNumber = 0;
        let features = [];
        /**
         * Dans le cas où le widget est appelé et ouvert depuis une action,
         * on récupère l'identifiant de l'ITV que l'action veut ouvrir.
         */
        const getIdOfItvFeature = () => {
          if (scope.featureToOpenWith) {
            return scope.featureToOpenWith.features[0].id;
          }
          return null;
        };

        /**
         * Fichier ITV choisi dans la liste des fichiers ITV en attente.
         */
        scope.$watch('itvxmltxtfileName', function (newobj, oldobj) {
          // au changement de valeur du model du select des itv en attente
          scope.alreadySubmitedItv = false;
          if (newobj !== oldobj) {
            scope.rapportSoumis = false;
          }
          if (scope.listInspection.length > 0 &&
            newobj !== $filter('translate')('itv.soumission.xmltxtname')) {
            if (scope.listInspection.indexOf(newobj) === -1) {
              if (scope.featureToOpenWith && newobj) {
                scope.alreadySubmitedItv = true;
              }
            }
            else {
              // -- Etre sûr que l'on ouvre le panneau correspondance
              // -- avec juste la liste des portions à de l'ITV, et
              // -- non avec la partie gestion de corrspondance active..
              scope.$hiderow = false;
              scope.itvxmltxtfile = newobj + '.txt';
              scope.xmlfileexist = true;
              gaDomUtils.showGlobalLoader();
              let idName = '';
              if (scope.useoldid && scope.useoldid.name) {
                idName = scope.useoldid.name;
              }
              itvSoumFactory.uploaditv({ name: newobj + '.txt' }, idName,
                scope.conf.config.network, '', scope.ConfigName,
                getIdOfItvFeature(), false,
                itvSoumFactory.arcgisConfToUrl(scope.conf)).then((res) => {
                if (res.data.etat === 'en cours' &&
                    res.data.progression == 0) {
                  const threadid = res.data.strValeur;
                  const stop = $interval(function () {
                    if (res.data.etat == 'en cours') {
                      itvSoumFactory.getProgression(threadid).then((res2) => {
                        if (res2.data.etat == 'en cours' &&
                          res2.data.progression !== 100 &&
                          res2.data.objValeur == null) {
                          res.data = res2.data;
                        }
                        else if (res2.data.etat == 'erreur') {
                          itvUtilsFactory.soumissionProgressionError(res2.data);
                        }
                        else if (res2.data.etat == 'en cours avec alerte' &&
                              res2.data.objValeur !== null) {
                          const promise = getInspectionProperties(res2, stop);
                          if (promise) {
                            promise.then().then((result) => {
                              if ((angular.isDefined(result.data.strValeur) &&
                                        result.data.strValeur !== null) ||
                                        result.data.etat == 'fini') {
                                loadInspectionAttributes(result);
                              }
                            });
                          }
                          getPictureNames('WARNING');
                        }
                        else {
                          const promise = getInspectionProperties(res2, stop);
                          if (promise) {
                            promise.then().then((result) => {
                              if (angular.isDefined(result.data.strValeur) &&
                                    result.data.strValeur !== null &&
                                    result.data.strValeur !== '') {
                                loadInspectionAttributes(result);
                              }
                              scope.newItvLoaded = true;
                              scope.$hiderow = false;
                              scope.tableParams.page(1);
                              preparePartsForMapping();
                            });
                            getPictureNames('SUCCESS');
                          }
                        }
                      });
                    }
                    else if (res.data.etat == 'erreur') {
                      gaDomUtils.hideGlobalLoader();
                      require('toastr').clear();
                      require('toastr').error(
                        $filter('translate')('itv.soumission.existerreur')
                      );

                      $interval.cancel(stop);
                    }
                  }, 2000);
                }
              });
            }
          }
        });

        const init = () => {
          scope.useoldid = {
            active: false,
            name: null,
            alias: $filter('translate')('itv.soumission.useoldid.identifiant')
          };
          scope.notSaving = true;
        };

        init();

        const toastrError = (messageId, suffix) => {
          if (!suffix) {
            suffix = '';
          }
          require('toastr').error(
            $filter('translate')(messageId) + suffix
          );
        };

        const getConfFromParents = (theScope) => {
          if (theScope.ConfigName) {
            scope.ConfigName = theScope.ConfigName;
            if (theScope.apptype === 'indigau') {
              scope.conf = theScope.conf;
            }
          }
          else getConfFromParents(theScope.$parent);
        };

        getConfFromParents(scope);

        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }
        if (scope.map == undefined) {
          scope.map = $rootScope.xgos.getMapAppMap();
        }

        const user = $rootScope.xgos.user;

        scope.config = {};
        if (NetworkFactory.resources.networks.length > 0) {
          scope.networks = NetworkFactory.resources.networks;
        }
        else {
          NetworkFactory.get().then(function () {
            scope.networks = NetworkFactory.resources.networks;
          });
        }
        scope.btnManagement = {};
        scope.btnManagement.apply1 = 'apply0';

        function loadIndigauNetworkFtiUids (ftiList, networkFtiList) {
          for (const fti of ftiList) {
            networkFtiList.push({ ftiUID: fti.uid });
          }
        }

        function loadNetworks () {
          if (!scope.networks) scope.networks = [];
          if (NetworkFactory.resources.networks.length > 0) {
            scope.networks = NetworkFactory.resources.networks;
          }
          else {
            NetworkFactory.get().then(function () {
              scope.networks = scope.networks.concat(
                NetworkFactory.resources.networks
              );
            });
          }
          if ($rootScope.xgos.sector === 'indigau') {
            ConfigFactory.get('main', 'indigauNetworkCfg').then(function (res) {
              if (res.data) {
                const indigauNetwork = {};
                indigauNetwork.name = 'main.indigauNetworkCfg';
                indigauNetwork.edgesTypes = [];
                indigauNetwork.nodesTypes = [];
                loadIndigauNetworkFtiUids(
                  res.data.visibleEdgesTypes,
                  indigauNetwork.edgesTypes
                );
                loadIndigauNetworkFtiUids(
                  res.data.visibleNodesTypes,
                  indigauNetwork.nodesTypes
                );
                scope.networks.push(indigauNetwork);
              }
            });
          }
        }

        loadNetworks();
        DataStoreFactory.get().then(function () {
          scope.datastores = DataStoreFactory.resources.datastores;
        });

        scope.translateAttributes = function (x) {
          let alias = x.alias;
          if (
            $filter('translate')(
              'features.' +
                scope.information.EVT_full_Inspection.EVT_Inspection.name +
                '.properties.' +
                x.name
            ).indexOf('features.') === -1
          ) {
            alias = $filter('translate')(
              'features.' +
                scope.information.EVT_full_Inspection.EVT_Inspection.name +
                '.properties.' +
                x.name
            );
          }
          return alias;
        };

        scope.$watch('config.datastore', function (newval, oldval) {
          if (angular.isDefined(newval) && newval !== oldval &&
            newval !== null && !scope.firstConfget) {
            gaDomUtils.showGlobalLoader();
            itvSoumFactory.initDb(newval).then(function (res) {
              if (res.data.etat === 'fini') {
                require('toastr').clear();
                require('toastr').success(
                  $filter('translate')('itv.soumission.dbsucces')
                );
                itvSoumFactory.setEVT_full_Inspection(scope.conf).then(
                  () => {
                    scope.information.EVT_full_Inspection = itvSoumFactory.getEVT_full_Inspection();
                    if (angular.isUndefined(scope.information.impor.attributes)) {
                      scope.information.impor.attributes
                        = scope.information.EVT_full_Inspection.EVT_Inspection.attributes.sort(
                          function (a, b) {
                            if (a.alias > b.alias) return 1;
                            if (a.alias < b.alias) return -1;
                            return 0;
                          }
                        );
                    }

                    scope.information.impor.attributes.client = {
                      choices: {},
                      edit: {}
                    };
                    gaDomUtils.hideGlobalLoader();
                  });
              }
              else if (res.data.etat === 'erreur') {
                require('toastr').clear();
                toastrError('itv.soumission.dberror');
                gaDomUtils.hideGlobalLoader();
              }
            });
          }
          else {
            scope.firstConfget = false;
          }
        });

        scope.$watch('config.network', function (newval) {
          if (newval !== undefined && scope.conf.config.datastore !== undefined
            && gclayers.getOperationalLayerByName('EVT_Inspection') === null
            && $rootScope.xgos.sector !== 'indigau') {
            scope.saveitvConfig();
          }
        });

        scope.config.minnodes = 10;
        scope.config.maxnodes = 100;
        scope.config.nodesincr = 10;

        scope.information = {
          impor: {
            images: [],
            zipfile: null,
            rapportpdf: []
          },
          correspondance: {},
          synthese: {}
        };

        scope.addAttributes = function (s) {
          scope.information.impor.attributes.client = {
            choices: {},
            edit: {}
          };
          scope.attrib = s;
          if (scope.attrib.length != 0) {
            for (let i = 0; i < scope.attrib.length; i++) {
              scope.information.impor.attributes.client[scope.attrib[i].name] =
                scope.attrib[i];
              scope.information.impor.attributes.client.edit[
                scope.attrib[i].name
              ] = false;
            }
          }
        };
        scope.removeAttributes = function () {
          scope.information.impor.attributes.client = {
            choices: {},
            edit: {}
          };
          scope.attrib = [];
        };

        scope.reduce = false;
        // les variables qui definissent les titres sont recuperees dans la fonctions precedente
        scope.tabs = [
          {
            title: $filter('translate')('itv.soumission.import'),
            disabled: false
          },
          {
            title: $filter('translate')('itv.soumission.correspondance'),
            disabled: true
          },
          {
            title: $filter('translate')('itv.soumission.synthese'),
            disabled: true
          }
        ];
        scope.tabs.activeTab = 0;

        scope.xmlfileexist = false;
        scope.useoldid = {
          active: false,
          name: null,
          alias: $filter('translate')('itv.soumission.useoldid.identifiant')
        };
        scope.$watch('useoldid', function () {
          scope.information.impor.useoldid = scope.useoldid;
        });

        scope.saveitvConfig = () => {
          const res = {
            client: [],
            useoldid: {}
          };
          if (angular.isDefined(scope.information.impor.attributes)) {
            angular.forEach(
              Object.keys(scope.information.impor.attributes.client),
              function (key) {
                if (key != 'choices' && key != 'edit') {
                  res.client.push(
                    scope.information.impor.attributes.client[key]
                  );
                }
              }
            );
          }
          res.useoldid = scope.useoldid;
          res.config = {};
          res.config.network = scope.conf.config.network;
          res.config.datastore = scope.conf.config.datastore;
          res.extraconfig = scope.extraconfig;
          res.displayUseoldid = scope.conf.displayUseoldid;
          itvSoumFactory.saveconf(res, scope.ConfigName);
        };
        scope.firstConfget = false;

        const getItvLayerDescription = (conf) => {
          if (scope.conf.config.datastore !== null) {
            scope.firstConfget = true;

            const promise = itvSoumFactory.setEVT_full_Inspection(scope.conf);
            promise.then(function () {
              scope.information.EVT_full_Inspection = itvSoumFactory.getEVT_full_Inspection();
              scope.information.impor.attributes
                = scope.information.EVT_full_Inspection.EVT_Inspection.attributes.sort(
                  function (a, b) {
                    if (a.alias > b.alias) return 1;
                    if (a.alias < b.alias) return -1;
                  }
                );

              scope.information.impor.attributes.client = {
                choices: {},
                edit: {}
              };
              if (conf && conf.client) {
                scope.attrib = conf.client;
                angular.forEach(Object.keys(conf.client), function (key) {
                  scope.information.impor.attributes.client[key] =
                    conf.client[key];
                  scope.information.impor.attributes.client.edit[
                    conf.client[key].name
                  ] = false;
                });
              }
            });
            require('toastr').clear();
            require('toastr').success(
              $filter('translate')('itv.soumission.getConf')
            );
            if (conf && conf.useoldid) {
              scope.useoldid = conf.useoldid;
            }
            scope.information.impor.useoldid = scope.useoldid;
          }
        };

        const getConfigFromWidget = () => {
          itvSoumFactory.getConf(scope.ConfigName).then(function (conf) {
            // send images
            scope.extraconfig = conf.extraconfig;
            if (!scope.conf) {
              // -- Nécessaire quand appel depuis l'action d'ouverture
              // -- du widget de soumission.
              scope.conf = {};
            }
            scope.conf.displayUseoldid = conf.displayUseoldid;
            if (conf.config) {
              scope.conf.config = conf.config;
            }
            if (conf.extraconfig) {
              scope.conf.extraconfig = conf.extraconfig;
            }
            if (conf.arcgiscomponent && !scope.conf.arcgiscomponent) {
              scope.conf.arcgiscomponent = conf.arcgiscomponent;
            }
            scope.conf.itvLengthTolerance = conf.itvLengthTolerance;
            getItvLayerDescription(conf);
            // -- Charger une fois la configuration définie.
            loadInspectionList();
          });
        };

        function getConfigFromIndigau () {
          // -- Nom de la configuration où sont stockés les composants
          // -- du réseau d'assainissement.
          // -- Côté serveur quand le nom du réseau ne fait pas partie de
          // -- la liste des réseaux définis sur le portail, on cherche
          // -- le fichier de configuration correspondant à celui reçu
          // -- dans le nom du réseau sachant que le point sépare le type et
          // -- le nom du fichier de configuration.
          ConfigFactory.get('main', 'appconfig').then(function (res) {
            if (res.data) {
              scope.conf.config.datastore = res.data.datastoreName;
              getItvLayerDescription();
              // -- Charger une fois la configuration définie.
              loadInspectionList();
            }
          });
        }

        function getitvConfig () {
          if ($rootScope.xgos.sector === 'indigau') getConfigFromIndigau();
          else getConfigFromWidget();
        }
        getitvConfig();

        scope.headerin = true;
        scope.$watch('headerin', function (newval) {
          if (!newval) {
            d3.select('.svgitv')
              .selectAll('*')
              .remove();
            angular.element('#details').empty();
            angular.element('.detailtablesec .ng-table-pager').remove();
            itvUtilsFactory.removeLayers(scope);
            itvUtilsFactory.clearoriginsourcecanal();
            itvUtilsFactory.clearitvoperationalLayers();
            if (scope.pointer && scope.pointer instanceof ol.interaction.Draw) {
              scope.pointer.setActive(false);
            }
            scope.map.removeInteraction(scope.pointer);

            angular.forEach(
              scope.information.impor.itvResponse.objValeur.parts,
              function (partofparts, i) {
                scope.information.impor.itvResponse.objValeur.parts[
                  i
                ].$hideRows = false;
              }
            );
          }
        });

        scope.listInspection = [];

        /**
         * Récupération de la liste des ITVs en cours de mise en correspondance.
         */
        const loadInspectionList = () => {
          gaDomUtils.showGlobalLoader('getPendingItvs');
          itvSoumFactory.getPendingItvs().then((res) => {
            if (res.data.etat == 'fini') {
              const listinspec = res.data.objValeur;
              scope.multiintervexist = !(listinspec && listinspec.length > 0);
              angular.forEach(listinspec, (insp) => {
                const str = user.uid + '__';
                scope.listInspection.push(insp.replace(str, ''));
              });
              if (scope.featureToOpenWith) {
              // -- L'affectation à itvxmltxtfileName permet le rechrgement
              // -- des portions($watch).
                scope.itvxmltxtfile = scope.itvxmltxtfileName
                  = scope.featureToOpenWith.features[0].properties.brchtnums;
                if (scope.itvxmltxtfile) {
                  const ind = scope.itvxmltxtfileName.indexOf('.');
                  if (ind !== -1) {
                    scope.itvxmltxtfileName
                      = scope.itvxmltxtfileName.substring(0, ind);
                  }
                }
              }
            }
            else if (res.data.etat == 'erreur') {
              scope.multiintervexist = true;
              require('toastr').clear();
              require('toastr').error(
                $filter('translate')('itv.soumission.erreurimportlist')
              );
            }
          }).finally(() => {
            gaDomUtils.hideGlobalLoader('getPendingItvs');
          });
        };

        function loadInspectionAttributes (result) {
          const inspectionValeurs = JSON.parse(result.data.strValeur);
          const inspectionValeursKeys = Object.keys(inspectionValeurs);
          angular.forEach(inspectionValeursKeys, function (key) {
            scope.information.impor.attributes.client.choices[key] = {};
            scope.information.impor.attributes.client.choices[key][key] =
              inspectionValeurs[key];
          });
        }

        function getPictureNamesOnly () {
          if (scope.information.impor.itvResponse.objValeur) {
            const arcgisLayers = itvSoumFactory.arcgisConfToUrl(scope.conf);
            itvSoumFactory
              .getPicturesNames(
                scope.information.impor.itvResponse.objValeur.ItvId,
                scope.conf.config.network, arcgisLayers, scope.ConfigName
              )
              .then(function (result) {
                if (result.data.etatpicturesaddedbyuser == 'exists') {
                  angular.forEach(result.data.names, function (img) {
                    if (scope.information.impor.images.indexOf(img) == -1) {
                      scope.information.impor.images.push(img);
                    }
                  });
                }

                if (result.data.etatpicturesindetails == 'exists') {
                  angular.forEach(result.data.pictures, function (img) {
                    if (scope.imagesextracted.indexOf(img)) {
                      scope.imagesextracted.push(img);
                    }
                  });
                }
              });
          }
        }

        function getPictureNames (toastrType, IHMInteraction) {
          getPictureNamesOnly();
          if (IHMInteraction == 'PROGRESS_BAR') scope.progressbar.complete();
          else gaDomUtils.hideGlobalLoader();
          require('toastr').clear();
          if (toastrType == 'SUCCESS') {
            require('toastr').success(
              $filter('translate')('itv.soumission.chargementfini')
            );
          }
          else {
            require('toastr').warning(
              $filter('translate')('itv.soumission.existerreur')
            );
          }
        }

        /**
         * Vérifier et récupérer l'encodage du fichier ITV quand celui-ci
         * est un fichier au format texte (.TXT).
         *
         * @param {*} fileContent : Contenu du fichier ITV
         * @param {*} file : Description du fichier ITV
         * @param {*} resolve : Méthode à appeler
         *                      quand la vérification est résolue
         * @param {*} reject : Méthode à appeler en cas d'échec
         * @returns Le nom de l'encodage du fichier ITV format txt
         */
        const checkTxtEncoding = (fileContent, file, resolve, reject) => {
          const indexes = [];
          let encoding;
          // -- Récupération de l'index du 1er et du 2eme caractère #
          for (let i = 0; i < fileContent.length; i++) {
            if (fileContent[i] === '#') {
              // plus rapide que indexOf:
              indexes.push(i);
              if (indexes.length === 2) {
                break;
              }
            }
          }
          if (indexes.length === 2) {
            // #A1=ISO-8859-1:1998 \r\n #A2...
            // filtre ISO-8859-1
            encoding = fileContent.substring(indexes[0] + 1, indexes[1])
              .split('=').pop().trim().split(':')[0];
            console.log('Encodage de texte du fichier ITV '
              + file.name + ': ' + encoding); // ISO-8859-1
            resolve(encoding);
          }
          else {
            reject($filter('translate')('itv.soumission.readEncodingError') + file.name + ': \n'
                + $filter('translate')('itv.soumission.missingCharacterError'));
          }
          return encoding;
        };

        /**
         * Vérifier et récupérer l'encodage du fichier ITV quand celui-ci
         * est un fichier au format XML.
         *
         * @param {*} fileContent : Contenu du fichier ITV
         * @param {*} file : Description du fichier ITV
         * @param {*} resolve : Méthode à appeler
         *                      quand la vérification est résolue
         * @param {*} reject : Méthode à appeler en cas d'échec
         * @returns Le nom de l'encodage du fichier ITV format txt
         */
        const checkXmlEncoding = (fileContent, file, resolve, reject) => {
          let encoding;
          const encodingInd = fileContent.indexOf('encoding=');
          let quote1 = -1; let quote2 = -1;
          if (encodingInd !== -1) {
            // -- On a bien le mot clef "encoding" dans le fichier XMl
            // -- Récupération de l'index de la double quote de début
            // -- du nom de l'encodage
            quote1 = fileContent.indexOf('"', encodingInd);
          }
          if (quote1 !== -1) {
            // -- "encoding" et première double quote trouvés:
            // -- Récupération de l'index de la double quote de fin
            // -- du nom de l'encodage
            quote2 = fileContent.indexOf('"', quote1 + 1);
          }
          if (quote2 !== -1) {
            // <?xml version="1.0" encoding="UTF-8" standalone="yes" ?>
            // filtre UTF-8
            encoding = fileContent.substring(quote1 + 1, quote2);
            console.log('Encodage de texte du fichier ITV ' + file.name + ': ' + encoding); // UTF-8
            resolve(encoding);
          }
          else {
            reject($filter('translate')('itv.soumission.readEncodingError') + file.name + ': \n'
                + $filter('translate')('itv.soumission.missingCharacterError'));
          }
          return encoding;
        };

        /**
         * Vérifie si le format du fichier est le format XML.
         *
         * @param {*} fileContent : Contenu du fichier ITV
         * @returns VRAI si le ficheir est au format XML (et non TXT)
         */
        const filesIsXml = (fileContent) => {
          return fileContent.indexOf('<?xml') !== -1;
        };

        const getInspectionProperties = (res2, stop) => {
          if (stop) {
            $interval.cancel(stop);
          }
          scope.information.impor.itvResponse = res2.data;
          if (scope.information.impor.itvResponse.objValeur) {
            return itvSoumFactory.getInspectionProperties(
              scope.information.impor.itvResponse.objValeur.ItvId);
          }
          else {
            return null;
          }
        };

        scope.modifOpt = {
          imagefile: false,
          pdffile: false,
          xmltxtfile: false
        };
        scope.inprogress = false;
        scope.imagesextracted = [];

        /**
         * Transformation d'un fichier en String pour déterminer l'encodage du fichier
         * @param file fichier de type <code>Blob</code>.
         *             Fichier ITV dont on veut déterminer l'encodage
         * @return {Promise<string>} encodage du fichier en chaîne de caractères
         */
        const getEncoding = (file) => {
          return new Promise((resolve, reject) => {
            let encoding;
            const fileReader = new FileReader();
            fileReader.onload = () => {
              if (fileReader.result) {
                const fileContent = fileReader.result;
                // indexes contient les positions des 2 premiers caractères "#" dans le fichier
                if (filesIsXml(fileContent)) {
                  encoding = checkXmlEncoding(fileContent, file, resolve,
                    reject);
                }
                else {
                  encoding = checkTxtEncoding(fileContent, file, resolve,
                    reject);
                }
              }
              else {
                reject($filter('translate')('itv.soumission.readFileError')
                );
              }
            };
            fileReader.readAsText(file, encoding);
          });
        };

        scope.getItvId = () => {
          return scope.information.impor.itvResponse.objValeur.itvId;
        };

        const recupInspectionProps = (res2, stop) => {
          const promise = getInspectionProperties(res2, stop);
          if (promise) {
            promise.then(
              (result) => {
                if (angular.isDefined(result.data.strValeur)
                  && result.data.strValeur !== null
                  && result.data.strValeur !== '') {
                  const inspectionValeurs = JSON.parse(result.data.strValeur);
                  const inspectionValeursKeys = Object.keys(inspectionValeurs);
                  angular.forEach(inspectionValeursKeys, (key) => {
                    const client = scope.information.impor.attributes.client;
                    client.choices[key] = {};
                    client.choices[key][key] = inspectionValeurs[key];
                  });
                }
              }
            );
          }
        };

        /**
         * Mise  à jour de l'ITV en base de données avec le nom du fichier ITV
         * associé. Celui-ci permettra lors de la ré-ouverture du widget
         * depuis un autre widget de reprendre la mise en correspondance
         * en cours.
         */
        const storeItvFileName = () => {
          const itv = scope.featureToOpenWith.features[0];
          itv.properties.brchtnums = scope.itvxmltxtfile;
          const ftiUid
            = scope.information.EVT_full_Inspection.EVT_Inspection.uid;
          const featUpdate = {
            type: 'FeatureCollection',
            features: [itv]
          };
          EditFactory.update(ftiUid, featUpdate);
        };

        /**
         * Initialisation de la  barre de progression
         * pour l'upload du fichier ITV.
         */
        const uploadPrepareProgresBar = () => {
          scope.progressbar = ngProgressFactory.createInstance();
          angular.element('#forprogression')
            .prepend('<div id="progression" ng-show="inprogress" ></div>');
          scope.progressbar.setParent(document.getElementById('progression'));
          scope.progressbar.setHeight('34px');
          scope.progressbar.setColor('#339999');
          $compile(angular.element('#forprogression'))(scope);
        };

        /**
         * Exploitation du résultat d'interrogation du serveur sur le
         * chargement de fichier ITV en cours.
         *
         * @param {*} res : réponse du lancement de l'upload
         * @param {*} res2 : réponse à l'interrogation
         *                   sur le déroulement de l'upload
         * @param {*} stop : description pour gestion interval (appel
         *                   de fonction à intervale régulier pour vérifier
         *                   l'état du chargement).
         */
        const checkUploadStatus = (res, res2) => {
          if (res2.data.etat == 'en cours' &&
          res2.data.progression !== 100 &&
          res2.data.objValeur == null) {
            const p = res2.data.progression;
            scope.progressbar.set(p);
            res.data = res2.data;
          }
          else if (res2.data.etat == 'erreur') {
            itvUtilsFactory.soumissionProgressionError(res2.data);
            scope.progressbar.complete();
            scope.inprogress = false;
            angular.element('#progression').remove();
            res.data.etat = 'erreur';
          }
          else if ((res2.data.etat == 'en cours' &&
                      res2.data.progression == -1 &&
                      res2.data.objValeur !== null) ||
                  res2.data.etat === 'fini' ||
                  res2.data.progression == 100
          ) {
            recupInspectionProps(res2);
            getPictureNames('SUCCESS', 'PROGRESS_BAR');
            scope.inprogress = false;
            gaDomUtils.hideGlobalLoader();
            angular.element('#progression').remove();
            scope.$hiderow = false;
            scope.tableParams.page(1);
            scope.newItvLoaded = true;
            preparePartsForMapping();
            // -- Actualiser la liste des ITVs avec cette ITV dont le chargement vient de réussir.
            const itvName = res2.data.objValeur.itvId.split('__')[1];
            scope.listInspection.push(itvName);
            scope.itvxmltxtfileName = itvName;
          }
          else if (
            res2.data.etat == 'en cours avec alerte' &&
                  res2.data.objValeur !== null
          ) {
            recupInspectionProps(res2);
            scope.progressbar.complete();
            require('toastr').clear();
            require('toastr').success(
              $filter('translate')(
                'itv.soumission.chargementfini')
            );
            scope.inprogress = false;
            gaDomUtils.hideGlobalLoader();
            angular.element('#progression').remove();
          }
        };

        /**
         * Attend la fin du chargement (upload) du fichier ITV.
         * En cas de réussite ou d'erreur l'attente est arrêtée.
         * En cas d'alerte un message est affiché.
         *
         * @param {Object} res  L'objet de réponse du serveur
         *                       au lancement du service "startItvUpload".
         * @param {string} threadid  L'ID du thread de chargement.
         */
        const waitForUploadCompletion = (uploadResult, threadId) => {
          itvSoumFactory.getProgression(threadId).then((progressionResponse) => {
            checkUploadStatus(uploadResult, progressionResponse);
            if (scope.inprogress) {
              $timeout(() => {
                waitForUploadCompletion(uploadResult, threadId);
              }, 2000);
            }
          });
        };


        /**
         * Le chargement du fichier a commencé.
         *
         * @param {*} uploadResult : réponse du lancement de l'upload
         */
        const uploadIsRunning = (uploadResult) => {
          const threadid = uploadResult.data.strValeur;
          const p = uploadResult.data.progression;
          scope.inprogress = true;
          scope.progressbar.set(p);
          if (uploadResult.data.etat === 'en cours') {
            waitForUploadCompletion(uploadResult, threadid);
          }
          else if (uploadResult.data.etat == 'erreur') {
            itvUtilsFactory.soumissionProgressionError(uploadResult.data);
            scope.progressbar.complete();
            scope.inprogress = false;
            angular.element('#progression').remove();
          }
        };


        /**
         * Si le champ identifiant est renseigné alors une popup message doit
         * demander la confirmation de la recherche automatique.
         *
         * @param {*} idName : nom du champ identifiant à utiliser
         *                     pour la correspondance
         */
        const askIdConfirmation = (idName) => {
          const defer = $q.defer();
          if (!idName || idName.length == 0) {
            defer.resolve('do_not_do_matching');
          }
          else {
            swal({
              title: $filter('translate')(
                'itv.soumission.confirmAutomaticMatching'
              ),
              text: $filter('translate')(
                'itv.soumission.confirmAutomaticMatchingText'
              ),
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
              closeOnCancel: true
            },
            function (inputValue) {
              if (inputValue === false) {
                // -- Pas de recherche automatique de correspondance
                // -- des identifiants
                defer.resolve('do_not_do_matching');
              }
              else {
                // -- Recherche automatique de correspondance des identifiants
                defer.resolve('do_matching');
              }
            });
          }
          return defer.promise;
        };


        /**
         * Ajouter le nom du fichier à uploader dans la zone de texte adéquate.
         *
         * @param {*} a
         * @param {*} str Nom de la propriété contenant les noms de fichiers
         * @param {*} modifOpt Nom de la propriété contenant l'indicateur
         *                    de modification utile juste pour le fichier ITV lui même
         */
        const setTxtFieldContent = (a, str, modifOpt) => {
          // -- Ajouter le nom du fichier chargé dans le champ texte
          if (scope[str] && str==='itvxmltxtfile') {
            scope.modifOpt[modifOpt] = false;
          }
          if (scope[str] && str!=='itvxmltxtfile') {
            scope[str] += '; ';
          }
          else {
            scope[str] = '';
          }
          const files = a.target ? a.target.files : a.files;
          scope[str] += Object.keys(files)
            .map(key => files[key].name)
            .join(';');
        };


        /**
         * Nouveau fichier ITV choisi, on l'upload et lance la recherche
         * de correspondance des ouvrages référencés dans le fichier
         * avec ceux du SIG.
         *
         * @param {*} a
         */
        const itvTxtXmlFileNameChanged = (a) => {
          if (a.files && a.files.length > 0) {
            if (isItvPendingExists(a.files[0])) {
              require('toastr').error($filter('translate')('itv.soumission.pendingItvExistError').replace('$1', a.files[0].name));
              gaDomUtils.hideGlobalLoader();
              scope.itvxmltxtfile = null;
              return;
            }
            const idName = scope.useoldid ? scope.useoldid.name : '';
            askIdConfirmation(idName).then((answer) => {
              scope.alreadySubmitedItv = false;
              scope.information.impor.itvResponse = null;
              uploadPrepareProgresBar();
              // récupère l'encodage et exécute la 2nde lecture du fichier
              getEncoding(a.files[0]).then(encoding => {
                const reader = new FileReader();
                reader.onload = () => {
                  const senddata = reader.result;
                  gaDomUtils.showGlobalLoader();
                  itvSoumFactory.uploaditv(a.files[0], idName,
                    scope.conf.config.network, senddata, scope.ConfigName,
                    getIdOfItvFeature(), answer,
                    itvSoumFactory.arcgisConfToUrl(scope.conf)
                  ).then((res) => {
                    if (res.data.etat === 'en cours' &&
                            res.data.progression == 0) {
                      uploadIsRunning(res);
                    }
                  });
                };
                // démarre la lecture du fichier.
                reader.readAsText(a.files[0], encoding);
              }
              );
              scope.xmlfileexist = true;
              if (scope.featureToOpenWith) {
                // -- Si widget appelé depuis action (depuis intervention simple
                // -- par exemple), on devra être capable
                // -- lors d'une prochaine "action" du même type de rouvrir
                // -- le fichier ITV en cours de travail.
                storeItvFileName();
              }
            });
          }
        };

        scope.fileNameChanged = (a, str) => {
          if (str === 'itvVideofile') {
            setTxtFieldContent(a,str,'videofile');
          }
          else if (str === 'itvImagefile') {
            setTxtFieldContent(a,str,'imagefile');
          }
          else if (str === 'itvpdffile') {
            setTxtFieldContent(a,str,'pdffile');
          }
          else if (str === 'itvxmltxtfile') {
            setTxtFieldContent(a,str,'xmltxtfile');
          }
          if (str === 'itvxmltxtfile') {
            itvTxtXmlFileNameChanged(a, str);
          }
          else {
            if (
              scope.itvxmltxtfile ===
                $filter('translate')('itv.soumission.xmltxt') ||
              scope.itvxmltxtfile === ''
            ) {
              require('toastr').clear();
              toastrError('itv.soumission.errorxmltxt');
              scope.modifOpt.xmltxtfile = true;
            }
            else {
              if (str === 'itvImagefile') {
                gaDomUtils.showGlobalLoader();
                const forzip = [];
                for (let i = 0; i < a.target.files.length; i++) {
                  if (
                    (a.target.files[i].name &&
                      a.target.files[i].name.split('.').length === 2 &&
                      a.target.files[i].name.split('.')[1].toLowerCase() === 'zip') ||
                    a.target.files[i].type === 'application/x-zip-compressed'
                  ) {
                    const size = a.target.files[i].size;
                    const count = size / Math.pow(1024, 2);
                    if (count <= 1) {
                      const reader = new FileReader();
                      reader.onload = function (e) {
                        const text = e.target.result;
                        gaDomUtils.showGlobalLoader();
                        itvSoumFactory.uploadzip(a.target.files[i], getItvFileName(), text, false)
                          .then(function (res) {
                            // send images
                            if (res.data.etat === 'fini') {
                              angular.forEach(res.data.names, function (f) {
                                if (
                                  scope.information.impor.images.indexOf(f) ===
                                    -1
                                ) {
                                  scope.information.impor.images.push(f);
                                }
                              });
                              require('toastr').clear();
                              require('toastr').success(
                                $filter('translate')(
                                  'importwms.upload_succeeded'
                                )
                              );
                              gaDomUtils.hideGlobalLoader();
                              scope.tabs[1].disabled = false;
                            }
                          }).finally(
                            () => {
                              gaDomUtils.hideGlobalLoader();
                            }
                          );
                      };
                      reader.readAsDataURL(a.target.files[i]);
                    }
                    else {
                      forzip.push({
                        file: a.target.files[i],
                        done: false
                      });
                      const fr = new FileReader();
                      const namef = a.target.files[i];
                      fr.onload = function (e) {
                        const buf = new Uint8Array(e.target.result);
                        let fichiercur = null;
                        let bool = false;
                        angular.forEach(forzip, function (fichier) {
                          if (!bool) {
                            if (!fichier.done) {
                              fichiercur = fichier.file;
                              bool = true;
                            }
                          }
                        });
                        gaDomUtils.showGlobalLoader();
                        const portion = 5e6;
                        for (
                          let ind = 0, formData, blob;
                          ind < buf.length;
                          ind += portion
                        ) {
                          const extent =
                                ind + portion > buf.length
                                  ? buf.length
                                  : ind + portion;
                          blob = new Blob([buf.subarray(ind, extent)]);
                          formData = new FormData();
                          formData.append(
                            'file',
                            blob,
                            Math.ceil(extent / portion) + '_' + fichiercur.name
                          );
                          itvSoumFactory
                            .uploadzipMultiple(
                              fichiercur,
                              null,
                              Math.ceil(extent / portion),
                              Math.ceil(buf.length / portion),
                              formData,
                              getItvFileName()
                            )
                            .then(function (res) {
                              if (res.data.etat === 'fini') {
                                angular.forEach(res.data.names, function (f) {
                                  if (
                                    scope.information.impor.images.indexOf(
                                      f
                                    ) === -1
                                  ) {
                                    scope.information.impor.images.push(f);
                                  }
                                });
                                require('toastr').clear();
                                require('toastr').success(
                                  $filter('translate')(
                                    'importwms.upload_succeeded'
                                  )
                                );
                                gaDomUtils.hideGlobalLoader();
                                scope.tabs[1].disabled = false;
                              }
                              else if (
                                res.data.etat !== 'fini' &&
                                  res.data.etat !== 'en cours'
                              ) {
                                require('toastr').clear();
                                toastrError('itv.soumission.errorxmltxt');
                              }
                            }).finally(
                              () => {
                                gaDomUtils.hideGlobalLoader();
                              }
                            );
                        }
                      };
                      fr.readAsArrayBuffer(namef);
                    }
                    scope.information.impor.zipfile = a.target.files[i];
                  }
                  else {
                    const itvFolderName = getItvFileName();
                    itvSoumFactory.uploadimage(
                      a.target.files[i],
                      itvFolderName,
                      'images'
                    );
                    if (
                      scope.information.impor.images.indexOf(
                        a.target.files[i].name
                      ) === -1
                    ) {
                      scope.information.impor.images.push(a.target.files[i].name);
                    }
                  }
                }
              }
              else if (str === 'itvpdffile') {
                gaDomUtils.showGlobalLoader();
                for (const file of a.files) {
                  const itvFolderName = getItvFileName();
                  itvSoumFactory.uploadimage(
                    file,
                    itvFolderName,
                    'pdffile'
                  );
                  scope.information.impor.rapportpdf.push(file);
                }
                gaDomUtils.hideGlobalLoader();
              }
              else if (str === 'itvVideofile') {
                // si l'input modifié est l'input de vidéos
                importVideos(a);
              }
            }
          }
        };

        scope.reset = function (str) {
          scope[str] = null;
        };

        scope.checkInputs = function (str, newval, oldval, v) {
          if (
            angular.isUndefined(scope.conf.config.network) ||
            angular.isUndefined(scope.conf.config.datastore)
          ) {
            require('toastr').clear();
            require('toastr').info(
              $filter('translate')('itv.datastoreandnetwork')
            );
            scope.tabs.activeTab = oldval;
            return false;
          }
          let bool = true;
          if (v) {
            console.log(scope.conf.config);
            if (str === scope.tabs[0].title) {
              if (
                scope.itvxmltxtfile ==
                  $filter('translate')('itv.soumission.xmltxt') ||
                scope.itvxmltxtfile == ''
              ) {
                require('toastr').clear();
                toastrError('itv.soumission.errorxmltxt');
                scope.modifOpt.xmltxtfile = true;
                bool = false;
                return bool;
              }
              else {
                scope.modifOpt.xmltxtfile = false;
              }

              if (bool) {
                scope.modifOpt = {
                  imagefile: false,
                  pdffile: false,
                  xmltxtfile: false
                };
                scope.tabs[newval].diabled = false;
                scope.tabs.activeTab = newval;
                if (
                  angular.isDefined(scope.information.impor.attributes) &&
                  Object.keys(scope.information.impor.attributes.client.edit)
                    .length != 0
                ) {
                  const clientAttributesKeys = Object.keys(
                    scope.information.impor.attributes.client.choices
                  );
                  const objectTosave = {};
                  angular.forEach(clientAttributesKeys, function (key) {
                    objectTosave[key] =
                      scope.information.impor.attributes.client.choices[key][
                        key
                      ];
                  });
                  itvSoumFactory.saveInspectionProperties(
                    objectTosave,
                    scope.information.impor.itvResponse.objValeur.ItvId
                  );
                }
                return true;
              }
            }
            else if (str === scope.tabs[1].title) {
              const validatedParts = scope.information.impor.itvResponse.objValeur.parts.map(
                function (x) {
                  return x.validated || x.ignorePortion;
                }
              );
              const compteurSuccess = validatedParts.filter(function (value) {
                if (value) return value;
              }).length;

              var compteurError = validatedParts.length - compteurSuccess;
              if (compteurError == 0) {
                passToSynthese();
                scope.tabs.activeTab = newval;
                return true;
              }
              else {
                toastrError('itv.correspondance.errorcorrespondancenotfull',
                  ' ' + compteurError + ' ' +
                    $filter('translate')('itv.correspondance.parts'));
                scope.tabs.activeTab = oldval;
                return false;
              }
            }
          }
          else {
            if (angular.isUndefined(scope.config.iv)) {
              if (str === scope.tabs[0].title) {
                if (
                  scope.itvxmltxtfile ==
                    $filter('translate')('itv.soumission.xmltxt') ||
                  scope.itvxmltxtfile == null
                ) {
                  toastrError('itv.soumission.errorxmltxt');
                  scope.modifOpt.xmltxtfile = true;
                  scope.tabs.activeTab = oldval;
                  bool = false;
                  return bool;
                }
                if (!bool) {
                  scope.tabs.activeTab = oldval;
                  return bool;
                }
                else {
                  return bool;
                }
              }
              else if (str === scope.tabs[1].title) {
                passToSynthese();
                scope.tabs.activeTab = newval;
                return true;
              }
              else {
                toastrError('itv.correspondance.errorcorrespondancenotfull',
                  ' ' + compteurError + ' ' +
                    $filter('translate')('itv.correspondance.parts'));
                scope.tabs.activeTab = oldval;
                return false;
              }
            }
          }
        };


        /**
         * Chercher la premiere liste de headers non vide.
         * @param {*} parts Parts dans lesquelles chercher la liste de headers
         * @returns Liste de headers ou undefined si rien trouvé
         */
        const getNonEmptyHeaders = (parts) => {
          for (const part of parts) {
            if (part.partHeaders && part.partHeaders.length) {
              return part.partHeaders;
            }
          }
        };


        /**
         * Mise en place des noms de colonne des observations dans la structure
         * de travail pour la mise en correspondance.
         *
         * @param {*} corresp
         */
        const getReadHeaders = (corresp) => {
          const nonEmptyHeaders = getNonEmptyHeaders(
            scope.information.impor.itvResponse.objValeur.parts);
          if (nonEmptyHeaders) {
            corresp.headers = {
              keys: Object.keys(nonEmptyHeaders).sort().filter((value) => {
                if (value.slice(value.length - 2, value.length) != 'Ma'
                && value.slice(0, 1) !== '_') {
                  return value != '$$hashKey';
                }
              }),
              columns: null
            };
          }
        };

        const setAdressOfEachPart = (parts) => {
          for (let ind = 0; ind < parts.length; ind++) {
            const part = parts[ind];
            const address = part.partHeaders.map((x) => {
              if (x.code === 'AAJ') return x.value;
            })
              .filter((value) => {
                return value !== undefined;
              });
            part.address = address[0];
          }
        };

        scope.partsOfCurrentItv = [];
        scope.tableParams = new ngTableParams(
          {
            page: 1,
            count: 10
          },
          {
            total: scope.partsOfCurrentItv.length,
            counts: [2, 5, 10, 20],
            getData: ($defer, params) => {
              params.total(scope.partsOfCurrentItv.length);
              $defer.resolve(
                scope.partsOfCurrentItv.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                )
              );
              if (scope.newItvLoaded) {
                // -- Sinon apr défaut à 2 (le premier de la liste).
                params.count(10);
                scope.newItvLoaded = false;
              }
            }
          }
        );


        /**
         * Ajouter dans la liste des entêtes d'une portion inspectée,
         * les entêtes indiquant les valeurs initiales trouvées
         * dans le fichier ITV des identfiants des ouvrages.
         *
         * @param {*} itvPart Portion inspectée à traitée
         */
        const addOriginalHeadersInPart = (itvPart) => {
          // -- Liste des codes ayant pour valeur l'identifiant d'un ouvrage
          const headerCodes = ['AAD', 'AAB', 'AAF', 'AAA', 'CAA', 'AAT', 'AAU'];
          // -- Recherche des entêtes de chaque code (dans la portion)
          for (const code of headerCodes) {
            const headerIndex = itvPart.partHeaders.findIndex(header => header.code === code);
            if (headerIndex !== -1) {
              // -- Entête trouvée
              const header = itvPart.partHeaders[headerIndex];
              if (header.originalValue) {
                // -- L'entête a une valeur originale (valeur initale
                // -- qui est dans le fichier ITV).
                // -- Préparation de l'alias à afficher
                header.alias = header.alias ? header.alias : '';
                let alias
                  = header.alias.replace('Référence', 'Réf. initiale');
                if (alias.search('Réf.') === -1) {
                  alias += ' initial';
                }
                // -- Ajout de l'entête qui indique la valeur initiale
                // -- de l'identifiant de l'ouvrage
                const newHeader = {
                  code: code.replaceAll('A', '0'),
                  alias: alias,
                  value: header.originalValue
                };
                itvPart.partHeaders.splice(headerIndex + 1, 0, newHeader);
              }
            }
          }
        };


        /**
         * Ajouter dans la liste des entêtes de chaque portion inspectée,
         * les entêtes indiquant les valeurs initiales trouvées
         * dans le fichier ITV des identifiants des ouvrages.
         *
         * @param {*} parts Liste des portions à traiter
         */
        const addOriginalHeadersInParts = (parts) => {
          for (let part of parts) {
            if (!part.originalHeaderTreated) {
              addOriginalHeadersInPart(part);
              part.originalHeaderTreated = true;
            }
          }
        };


        const preparePartsForMapping = () => {
          const corresp = scope.information.correspondance;
          const parts
              = scope.information.impor.itvResponse.objValeur.parts;
          addOriginalHeadersInParts(parts);
          if (angular.isUndefined(scope.tableCols)) {
            scope.tableCols = [{ cname: 'alias' },
              { cname: 'code' },
              { cname: 'value', cnameAlt: 'values' }
            ];
            for (const col of scope.tableCols) {
              col.title
                = $filter('translate')('itv.correspondance.' + col.cname);
            }
            if (parts && parts.length !== 0) {
              getReadHeaders(corresp);
              setAdressOfEachPart(parts);
            }
          }
          // -- Pas de portion sélectionnée donc on impose 10 portions
          // -- dans la liste, il est probable (mais pas sûr)
          // -- que ce fichier n'est pas déjà chargé
          // -- dans l'onglet correspondance.
          $timeout(() => {
            scope.tableParams.count(10);
            scope.tableParams.reload();
          });
          scope.partsOfCurrentItv = parts;
          document.querySelector('.itvtable');
        };

        scope.$watch('tabs.activeTab', function (newVal, oldval) {
          if (newVal > 0 && scope.checkInputs(scope.tabs[0].title, 1, 0, false)) {
            try {
              scope.hideHeaderTitle = true;
              const conf = scope.config.arcgiscomponent ? scope.config : scope.conf;
              const arcgisLayers = itvSoumFactory.arcgisConfToUrl(conf);
              //Extract the videos from the folder and the file
              itvSoumFactory.getVideosNames(
                scope.information.impor.itvResponse.objValeur.ItvId,
                scope.conf.config.network, arcgisLayers, scope.ConfigName
              ).then((res) => {
                scope.videos = res.data;
              });
              itvSoumFactory.getPicturesNames(
                scope.information.impor.itvResponse.objValeur.ItvId,
                scope.conf.config.network, arcgisLayers, scope.ConfigName
              ).then((res) => {
                scope.pictures = res.data;
                scope.checkInputs(scope.tabs[newVal - 1].title, newVal,
                  newVal - 1, false)
                    && scope.checkInputs(scope.tabs[newVal - 1].title, newVal,
                      newVal - 1, true)
                  ? (scope.tabs.activeTab = newVal)
                  : (scope.tabs.activeTab = oldval);
                if (oldval == 1 && scope.tabs.activeTab == oldval
                  && scope.selectedPart) {
                  $timeout(() => {
                    scope.getPart(scope.selectedPart, scope.$hiderow);
                  });
                }
              }).finally(() => {
                scope.hideHeaderTitle = false;
              });
            }
            catch (e) {
              console.log(e.stack);
              scope.tabs.activeTab = oldval;
            }
          }
        });

        scope.first = true;

        scope.information.correspondance.parts = {
          partIndex: [],
          part: []
        };

        scope.status = {
          isFirstOpen: true,
          isFirstDisabled: false
        };

        const drawPartAddDetail = (part) => {
          const def = $q.defer();
          itvDrawPartsFactory.drawParts(scope, part);
          if (part.objValeur) {
            scope.currentDetails = part.objValeur.details;
            def.resolve();
          }
          else {
            const correspParts = scope.information.correspondance.parts;
            const thePart = correspParts.part.find(
              part2 => part2.objValeur
                && part2.objValeur.indTroncon === part.partIndex
            );
            if (thePart) {
              scope.currentDetails = thePart.objValeur.details;
              def.resolve();
            }
            else {
              itvSoumFactory.getitvPart(
                scope.information.impor.itvResponse.objValeur.ItvId,
                part.partIndex).then((res) => {
                scope.currentDetails = res.data.objValeur.details;
                def.resolve();
              });
            }
          }
          return def.promise;
        };

        /**
         * Vérifie que la portion courante est bien sur la page courante
         * dela liste des portions. Si tel n'est pas le cas,
         * on se positionne sur la bonne page.
         *
         * @param {*} iPart : index de la portion courante
         *                    dans la liste des portions
         */
        const checkDisplayedPage = (iPart) => {
          // -- Calcul du numéro de la page qui contient la portion
          const pageOfPart = Math.floor(1 + iPart / scope.tableParams.count());
          if (pageOfPart !== scope.tableParams.page()) {
            // -- La page de la portion n'est pas la page courante
            // -- on se postionne donc sur la page de la portion.
            scope.tableParams.page(pageOfPart);
            scope.tableParams.reload();
          }
        };

        /**
         * Appelé quand on choisi la portion courante par
         * les commandes "Suivant" ou "Précédent".
         * On positione le contenu du conteneur scrollé
         * de sorte que la portion choisie soit visible.
         *
         * @param {*} part
         * @returns
         */
        scope.gotoAnchor = (step) => {
          const item = document.getElementById('parts_container_' + scope.$id);
          let index = scope.information.currentPartListIndex += step;
          const maxLineCount = scope.tableParams.count();
          if (index < 0) {
            // -- On recule d'une page
            index = scope.information.currentPartListIndex = maxLineCount - 1;
          }
          else if (index >= maxLineCount) {
            // -- On passe à la page suivante
            index = scope.information.currentPartListIndex = 0;
          }
          $timeout(() => {
            // -- Récupération de l'élément HTML contenant le titre de la portion
            const lineElt = document.getElementById('anchor' + index);
            // -- Positionnement de la zone scrollée sur l'entếte choisie
            item.scrollTop = lineElt.offsetTop;
          }, 1000);
        };

        const prepareNextPrevPart = (objValeur, partIn) => {
          // -- Effacer les dessins sur la carte de la portion précédemment
          // -- choisie et positionnement des portions suivantes et
          // -- précédentes pour les commandes permettant
          // -- de passer à la portion suivante ou  précédente.
          for (let iPart = 0; iPart < objValeur.parts.length; iPart++) {
            const partOfParts = objValeur.parts[iPart];
            if (partOfParts.partIndex === partIn.partIndex) {
              scope.previousPart = scope.nextPart = undefined;
              if (iPart > 0) {
                scope.previousPart = objValeur.parts[iPart - 1];
              }
              if (iPart < objValeur.parts.length - 1) {
                scope.nextPart = objValeur.parts[iPart + 1];
              }
              checkDisplayedPage(iPart);
            }
            else {
              if (partOfParts.$hideRows) {
                itvUtilsFactory.removeLayers(scope);
              }
              partOfParts.$hideRows = false;
            }
          }
        };

        /**
         * Appelé quand on choisi la portion courante.
         * Le choix se fait par clic direct dans la liste ou
         * par les commandes "Suivant" ou "Précédent".
         *
         * @param {*} partIn : aprt en entrée
         * @param {boolean} hideRow
         * @returns
         */
        scope.getPart = (partIn, hideRow) => {
          scope.selectedPart = partIn;
          const defer = $q.defer();
          scope.closeCfgPopovers();
          itvUtilsFactory.clearAllSources();
          if (hideRow !== undefined) {
            partIn.$hideRows = hideRow;
          }
          scope.$hiderow = partIn.$hideRows;
          if (partIn.$hideRows) {
            scope.currentPart = partIn;
            const objValeur = scope.information.impor.itvResponse.objValeur;
            prepareNextPrevPart(objValeur, partIn);

            const correspParts = scope.information.correspondance.parts;
            if (!correspParts.partIndex.includes(partIn.partIndex)) {
              // -- Portion non encore traitée, donc on récupére sa description
              // -- depuis le repository.
              itvSoumFactory.getitvPart(
                scope.information.impor.itvResponse.objValeur.ItvId,
                partIn.partIndex).then((resultat) => {
                let part = resultat.data;
                part = itvSoumFactory.checkITVParts(part);
                correspParts.partIndex.push(partIn.partIndex);
                correspParts.part.push(part);
                drawPartAddDetail(part).then(() => {
                  defer.resolve();
                });
              });
            }
            else {
              // -- Portion déjà traitée, sa description est déjà stockée.
              const ind = correspParts.partIndex.indexOf(partIn.partIndex);
              let part = correspParts.part[ind];
              part = itvSoumFactory.checkITVParts(part);
              drawPartAddDetail(part).then(() => {
                defer.resolve();
              });
            }
          }
          else {
            d3.select('.svgitv').selectAll('*').remove();
            angular.element('#details').empty();
            angular.element('.detailtablesec .ng-table-pager').remove();
            itvUtilsFactory.removeLayers(scope);
            itvUtilsFactory.clearoriginsourcecanal();
            itvUtilsFactory.clearitvoperationalLayers();
            defer.resolve();
          }
          return defer.promise;
        };

        scope.pointer = new ol.interaction.Draw({
          type: 'Point',
          style: new ol.style.Style({
            image: new ol.style.Circle({
              radius: 6,
              fill: new ol.style.Fill({
                color: 'rgba(0, 128, 255, 1)'
              }),
              stroke: new ol.style.Stroke({
                width: 2,
                color: 'rgba(255, 255, 255, 1)'
              })
            })
          })
        });

        scope.pointer.set('gctype', 'kis');
        scope.pointer.set('interaction', 'Draw');
        scope.pointer.set('widget', 'itv');

        /**
         * On appuie sur la coche de validation aprés avoir cliqué
         * sur un tronçon ou sur un regard.
         *
         * @param {*} partovalidate
         */
        scope.validerSelection = (partovalidate, casValiderSel02) => {
          itvSoumValidSelection.validerSelection(scope, partovalidate,
            casValiderSel02);
        };

        /**
         * Si le popover est ouvert, et que l'on passe à une autre portion,
         * il faut le fermer, sinon, le popover ouvert ne va pas traveiller
         * sur la bonne portion.
         * On ne doit le fermer que s'il est ouvert afin d'ebnvoyer un click.
         * Si on n'envoie pas un click quand on ferme, il manque un clic
         * au gestionnaire du popover, du coup, il faudra cliquer 2 fois
         * pour afficher le popover.
         */
        scope.closeCfgPopovers = () => {
          $timeout(() => {
            if ($('.svgitvpopover2 .popover').is(':visible')) {
              $('.svgitvpopover2 .popover').remove();
              scope.pointer.setActive(false);
              scope.selected = false;
              scope.map.removeInteraction(scope.pointer);
            }
          });
          scope.showinver = false;
        };

        scope.openImage = (picname, partIndex, partdetail) => {
          const index = scope.information.correspondance.parts.part
            .map((x) => {
              return x.objValeur.indTroncon;
            })
            .indexOf(partIndex);
          scope.partdetails =
            scope.information.correspondance.parts.part[
              index
            ].objValeur.details;
          scope.partdetail = partdetail;
          scope.picname = picname;

          createRapport();
        };

        const createRapport = () => {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionImageRapport.html',
            className:
              'ngdialog-theme-plain width400 nopadding miniclose itv-soumission-rapport',
            closeByDocument: false,
            scope,
            title: $filter('translate')('itv.correspondance.obsDetails'),
            draggable: true,
            doNotForcePopupHeightToMinHeight: true,
            minWidth: '400px',
            minHeight: '550px'
          });
        };

        const showErrorMessage = (errorList) => {
          require('toastr').error(
            $filter('translate')('itv.soumission.errorGettingWarnings') + ': '
            + errorList[0].composant + '.' + errorList[0].fonction
            + ': ' + errorList[0].exception);
        };


        const passToSynthese = () => {
          angular.forEach(
            scope.information.impor.itvResponse.objValeur.parts,
            function (partofparts, i) {
              if (
                scope.information.impor.itvResponse.objValeur.parts[i].$hideRows
              ) {
                itvUtilsFactory.removeLayers(scope);
                itvUtilsFactory.clearoriginsourcecanal();
                itvUtilsFactory.clearitvoperationalLayers();
              }
              scope.information.impor.itvResponse.objValeur.parts[
                i
              ].$hideRows = false;
            }
          );
          d3.select('.svgitv').selectAll('*').remove();
          angular.element('#details').empty();
          angular.element('.detailtablesec .ng-table-pager').remove();
          itvUtilsFactory.removeLayers(scope);
          itvUtilsFactory.clearoriginsourcecanal();
          itvUtilsFactory.clearitvoperationalLayers();
          scope.showinver = false;
          scope.selected = false;
          scope.tovalidate = false;
          scope.usenetwork = false;
          if (scope.pointer && scope.pointer instanceof ol.interaction.Draw) {
            scope.pointer.setActive(false);
          }
          scope.map.removeInteraction(scope.pointer);

          scope.information.imagesinDetails = [];
          let imagesnamesindetails = [];
          angular.forEach(scope.information.correspondance.parts.part, function (
            part
          ) {
            part.objValeur.details.map(function (x) {
              if (angular.isDefined(x.ref_photo) && x.ref_photo !== '') {
                imagesnamesindetails.push(
                  x.ref_photo.substring(0, x.ref_photo.lastIndexOf('.'))
                );
              }
            });
          });
          if (scope.imagesextracted.length > 0) {
            angular.forEach(scope.imagesextracted, function (img) {
              if (angular.isDefined(img) && img !== '' &&
                imagesnamesindetails.indexOf(
                  img.substring(0, img.lastIndexOf('.'))
                ) === -1
              ) {
                imagesnamesindetails.push(
                  img.substring(0, img.lastIndexOf('.'))
                );
              }
            });
          }
          imagesnamesindetails = $.unique(imagesnamesindetails).sort(function (
            a, b) {
            return a - b;
          });
          angular.forEach(imagesnamesindetails, function (imagesnames) {
            const obj = {
              name: imagesnames,
              status: ''
            };
            scope.information.imagesinDetails.push(obj);
          });

          scope.compteurImages = 0;
          scope.information.synthese.avertissementCount = 0;
          scope.totalImage = imagesnamesindetails.length;
          scope.information.synthese.avertissement = [];
          let presence = true;
          angular.forEach(scope.information.imagesinDetails, function (
            imagename
          ) {
            if (scope.pictures.namesWithoutExt &&
              scope.pictures.namesWithoutExt.indexOf(imagename.name) !== -1) {
              imagename.status = $filter('translate')('itv.synthese.present');
              scope.compteurImages++;
            }
            else {
              imagename.status = $filter('translate')('itv.synthese.absent');
              scope.information.synthese.avertissement.push({
                text:
                  imagename.name +
                  ' ' +
                  $filter('translate')('itv.synthese.absent')
              });
              scope.information.synthese.avertissementCount++;
              presence = false;
            }
          });

          const arcgisLayers = itvSoumFactory.arcgisConfToUrl(scope.conf);
          itvSoumFactory
            .getErrors(scope.information.impor.itvResponse.objValeur.ItvId,
              itvSoumFactory.getTolerance(scope), arcgisLayers, scope.ConfigName)
            .then((res) => {
              if (res.data.errorList && res.data.errorList.length) {
                showErrorMessage(res.data.errorList);
              }
              else {
                for (const avertissement of res.data.objValeur) {
                  const optional = scope.information.synthese.avertissement.find(
                    a => a.text === avertissement);
                  if (!optional) {
                    scope.information.synthese.avertissement.push({
                      text: avertissement,
                    });
                    scope.information.synthese.avertissementCount++;
                  }
                }
                scope.information.synthese.avertissement
                  = $.unique(scope.information.synthese.avertissement)
                    .sort((a, b) => {
                      return a - b;
                    });
                scope.avertissementsDoesNotExist
                  = scope.information.synthese.avertissementCount > 0;
              }
            });

          scope.information.synthese.avertissement = $.unique(
            scope.information.synthese.avertissement
          ).sort((a, b) => {
            return a - b;
          });

          scope.information.synthese.checkedSynthese = {
            formulaire: true,
            normeEn: true,
            identifantcorrecte: true,
            picpresence: presence
          };

          angular.element('.detailtablesec').empty();
          const str =
            `<table ng-table="ImageParams" class="table image-params table-stripped table-bordered table-hover"
              show-filter="false">
              <tr>
                <th>{{'itv.synthese.Name' | translate}}</th>
                <th>{{'itv.synthese.Etat' | translate}}</th>
                <th>{{'itv.synthese.generate' | translate}}</th>
              </tr>
              <tr ng-repeat="pic in $data">
                <td ng-attr-title="{{'itv.synthese.Name' | translate}}">
                    {{pic.name}}</td>
                <td ng-attr-title="{{'itv.synthese.Etat' | translate}}">
                    {{pic.status}}</td>
                <td class="generated" ng-attr-title="{{'itv.synthese.generate' | translate}}">
                    {{pic.generated}}</td>
              </tr>
            </table>`;
          angular.element('.detailtablesec').append(str);
          $compile(angular.element('.detailtablesec'))(scope);

          let dataImages = scope.information.imagesinDetails;
          if (scope.generatedImages) {
            scope.information.imagesinDetails.map(img =>
              img.generated = scope.generatedImages.includes(img.name));
          }
          scope.ImageParams = new ngTableParams(
            {
              page: 1,
              count: dataImages.length
              // group : $filter('translate')('itv.correspondance.parts')
            },
            {
              total: dataImages.length,
              counts: [5, 10, 20, 100],
              getData: function ($defer, params) {
                dataImages = scope.information.imagesinDetails;
                params.total(dataImages.length);
                $defer.resolve(
                  dataImages.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  )
                );
              }
            }
          );
          scope.information.videosinDetails = [];
          scope.compteurVideos = 0;

          // Utiliser videosExtractedFromFile après avoir éliminé les chaînes vides et les doublons
          let uniqueVideoNames = [...new Set(scope.videos.videosExtractedFromFile.filter(name => name && name !== ''))]
            .map(name => name.substring(0, name.lastIndexOf('.')));

          uniqueVideoNames.forEach((videoname) => {
            const obj = {
              name: videoname,
              status: scope.videos.videosFolderWithoutExt.includes(videoname)
                ? $filter('translate')('itv.synthese.present')
                : $filter('translate')('itv.synthese.absent')
            };

            if (obj.status === $filter('translate')('itv.synthese.present')) {
              scope.compteurVideos++;
            }
            scope.information.videosinDetails.push(obj);
          });
          // Create a table for videos
          angular.element('.detailvideotablesec').empty();
          const str2 =
            `<table ng-table="VideoParams" class="table image-params table-stripped table-bordered table-hover"
              show-filter="false">
              <tr>
                <th>{{'itv.synthese.Video' | translate}}</th>
                <th>{{'itv.synthese.Etat' | translate}}</th>
              </tr>
              <tr ng-repeat="video in $data">
                <td ng-attr-title="{{'itv.synthese.Name' | translate}}">
                    {{video.name}}</td>
                <td ng-attr-title="{{'itv.synthese.Etat' | translate}}">
                    {{video.status}}</td>
              </tr>
            </table>`;
          angular.element('.detailvideotablesec').append(str2);
          $compile(angular.element('.detailvideotablesec'))(scope);

          let dataVideos = scope.information.videosinDetails;
          scope.VideoParams = new ngTableParams(
            {
              page: 1,
              count: dataVideos.length
            },
            {
              total: dataVideos.length,
              counts: [5, 10, 20, 100],
              getData: function ($defer, params) {
                dataVideos = scope.information.videosinDetails;
                params.total(dataVideos.length);
                $defer.resolve(
                  dataVideos.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  )
                );
              }
            }
          );
          $timeout(() => {
            // remplace true par la coche verte
            const generatedTds = document.getElementsByClassName('generated');
            if (generatedTds) {
              for (const genTd of generatedTds) {
                if (genTd.innerText === 'true' || genTd.innerText === 'false') {
                  genTd.innerHTML
                    = genTd.innerText === 'true'
                      ? '<i class="fa fa-check greenColor"/>'
                      : '';
                }
              }
            }
          }, 500);
        };

        let raportModel;
        scope.exporter =  () => {
          const arcgisLayers = itvSoumFactory.arcgisConfToUrl(scope.conf);
          itvSoumFactory
            .getReport(scope.information.impor.itvResponse.objValeur.ItvId,
              itvSoumFactory.getTolerance(scope), arcgisLayers, scope.ConfigName)
            .then(function (res) {
              try {
                scope.information.synthese.report = {
                  text: res.data.objValeur.report.replace(/\n/g, '<br/>'),
                  file: $location.protocol() + '://' + $location.host() + ':' +
                    $location.port() + '/xgos5' +
                    res.data.strValeur.replace(/\\/g, '/')
                };
                if (angular.isDefined(res.data.objValeur.errors)) {
                  if (res.data.objValeur.errors.length > 0) {
                    const errorsExisting = scope.information.synthese.avertissement.map(
                      function (x) {
                        return x.text;
                      }
                    );
                    angular.forEach(res.data.objValeur.errors, function(error) {
                      if (errorsExisting.indexOf(error) === -1) {
                        scope.information.synthese.avertissement.push({
                          text: error
                        });
                        scope.information.synthese.avertissementCount++;
                      }
                    });
                  }
                }
                // Si la fenêtre est déja ouverte, on la ferme tout d'abord
                if (raportModel) {
                  raportModel.hide();
                }
                raportModel = $modal({
                  scope,
                  template:
                    'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionReport.html',
                  contentTemplate: false,
                  html: true
                });
                raportModel.$promise.then(raportModel.show);
              }
              catch (e) {
                e.stack;
                toastrError('itv.synthese.rapporterreur');
              }
            });
        };

        const showSpinner = () => {
          if (!scope.showSpinnerCount) {
            scope.showSpinnerCount = 0;
          }
          if (scope.showSpinnerCount === 0) {
            scope.showSpinner2 = false;
            scope.showSpinner1 = true;
            scope.showSpinner3 = false;
          }
          else if (scope.showSpinnerCount === 1 || scope.showSpinnerCount === 3) {
            scope.showSpinner2 = false;
            scope.showSpinner1 = false;
            scope.showSpinner3 = true;
            if (scope.showSpinnerCount === 3) {
              scope.showSpinnerCount = 0;
            }
          }
          else if (scope.showSpinnerCount === 2) {
            scope.showSpinner2 = true;
            scope.showSpinner1 = false;
          }
          scope.showSpinnerCount++;
        };

        const checkingSoumissionThread = (threadId, stop) => {
          itvSoumFactory.getItvLoadingStatus(threadId).then((res) => {
            if (res.data.etat === 'RUNNING') {
              // -- Chargement en cours
              showSpinner();
            }
            else if ('FAILEDFINISHED'.indexOf(res.data.etat) != -1) {
              // -- Chargement terminé
              gaDomUtils.hideGlobalLoader();
              require('toastr').clear();
              if (res.data.etat === 'FAILED') {
                // -- Chargement en échec
                toastrError('itv.synthese.soumettreerreur',
                  res.data.errorMessage ? res.data.errorMessage : '');
              }
              else {
                // -- Chargement réussi
                require('toastr').success(
                  $filter('translate')('itv.synthese.soumettre'), '',
                  { timeOut: 15000 });
                scope.rapportSoumis = true;
                if (res.data.warningMessage
                  && res.data.warningMessage.length != 0) {
                  require('toastr').warning(
                    $filter('translate')(res.data.warningMessage), '',
                    { timeOut: 15000 });
                }
                // -- Rafraîchir la carte
                const itvFti = scope.information.EVT_full_Inspection.EVT_Inspection;
                gclayers.refreshlayerByid(itvFti.uid, scope.map);
              }
              scope.notSaving = true;
              $interval.cancel(stop);
            }
          });
        };

        scope.soumettre = (withRerau) => {
          if (withRerau == undefined) {
            //-- Cas où on utilise le widget de soumission dans kis map.
            withRerau = scope.conf.indigau
              && scope.conf.indigau.withIndigauAutmaticCalc;
          }
          if (withRerau !== true) {
            withRerau = false;
          }
          gaDomUtils.showGlobalLoader();
          let idName = '';
          if (scope.useoldid && scope.useoldid.name) {
            idName = scope.useoldid.name;
          }
          itvSoumFactory.saveItv(
            scope.information.impor.itvResponse.objValeur.ItvId,
            scope.conf,
            scope.ConfigName,
            withRerau,
            itvSoumFactory.arcgisConfToUrl(scope.conf),
            scope.conf.indigau ? (
              scope.conf.indigau.nbQueryParts ?
                scope.conf.indigau.nbQueryParts : 10) : 10,
            itvSoumFactory.getTolerance(scope),
            scope.conf.config.useIndigauEngine,
            scope.work.createConnectionPipes,
            idName,
            scope.conf.config.importVideo
          ).then((res) => {
            if (res.data.etat === 'en cours' && res.data.progression === 0) {
              scope.notSaving = false;
              var stop = $interval(() => {
                checkingSoumissionThread(res.data.objValeur.threadId, stop);
              }, 5000);
            }
          },
          () => {
            gaDomUtils.hideGlobalLoader();
            toastrError('itv.synthese.soumettreerreur');
          });
        };

        /**
         * Copie les vidéos sélectionnées dans le dossier de travail de l'ITV
         * @param event fichiers chargés dans l'input
         */
        const importVideos = (event) => {
          const files = event.target.files;
          const itvFolderName = getItvFileName();
          gaDomUtils.showGlobalLoader();
          scope.waitImport = true;
          scope.tabs[1].disabled = true;
          const forzip = [];
          if (gaJsUtils.isFilesUnzipped(files)) {
            itvSoumFactory.readAllImages(event).then(
              filesAsString => {
                if (filesAsString && Array.isArray(filesAsString)) {
                  itvSoumFactory.uploadImages(files, filesAsString, itvFolderName, 'videos').then(
                    res => {
                      if (res && typeof res === 'boolean') {
                        scope.waitImport = false;
                        scope.tabs[1].disabled = false;
                        gaDomUtils.hideGlobalLoader();
                      }
                    }
                  );
                }
              }
            );
          }
          else {
            for (const file of files) {
              if ((file.name && file.name.split('.').length === 2
                      && file.name.split('.')[1].toLowerCase() === 'zip')
                  || file.type === 'application/x-zip-compressed') {
                const size = file.size;
                const count = size / Math.pow(1024, 2);
                if (count <= 1) {
                  const reader = new FileReader();
                  reader.onload = function (e) {
                    const text = e.target.result;
                    gaDomUtils.showGlobalLoader();
                    itvSoumFactory.uploadzip(file, itvFolderName, text, true)
                      .then((res) => {
                      // send images
                        if (res.data.etat === 'fini') {
                          require('toastr').clear();
                          require('toastr').success(
                            $filter('translate')('itv.soumission.videoLaunchingSuccess'));
                          gaDomUtils.hideGlobalLoader();
                        }
                      }).finally(
                        () => {
                          scope.waitImport = false;
                          scope.tabs[1].disabled = false;
                          gaDomUtils.hideGlobalLoader();
                        }
                      );
                    reader.readAsDataURL(file);
                  };
                }
                else {
                  // multipart
                  forzip.push({
                    file,
                    done: false
                  });
                  const fr = new FileReader();
                  const namef = file;
                  fr.onload = (e) => {
                    const buf = new Uint8Array(e.target.result);
                    let fichiercur = null;
                    let bool = false;
                    for (const fichier of forzip) {
                      if (!bool) {
                        if (!fichier.done) {
                          fichiercur = fichier.file;
                          bool = true;
                        }
                      }
                    }
                    gaDomUtils.showGlobalLoader();
                    const portion = 5e6;
                    for (let i = 0, formData, blob; i < buf.length; i += portion) {
                      const extent = i + portion > buf.length ? buf.length : i + portion;
                      blob = new Blob([buf.subarray(i, extent)]);
                      formData = new FormData();
                      formData.append(
                        'file',
                        blob,
                        Math.ceil(extent / portion) + '_' + fichiercur.name
                      );
                      itvSoumFactory.uploadzipMultiple(
                        fichiercur,
                        null,
                        Math.ceil(extent / portion),
                        Math.ceil(buf.length / portion),
                        formData,
                        itvFolderName,
                        true
                      )
                        .then((res) => {
                          if (res.data.etat === 'fini') {
                            require('toastr').clear();
                            require('toastr').success(
                              $filter('translate')('itv.soumission.videoLaunchingSuccess')
                            );
                            gaDomUtils.hideGlobalLoader();
                            scope.waitImport = false;
                          // console.log(scope.information.impor , "scope.information.impor")
                          }
                          else if (res.data.etat !== 'fini' && res.data.etat !== 'en cours'
                          ) {
                            require('toastr').clear();
                            toastrError('itv.soumission.errorxmltxt');
                          }
                        });
                    }
                  };
                  fr.readAsArrayBuffer(namef);
                }
              }
              else {
                itvSoumFactory.uploadimage(file, itvFolderName, 'videos');
              }
            }
          }
        };

        /**
         * Au clic sur le bouton "Extraire les photos depuis les vidéos"
         * de l'onglet "Correspondance".<br>
         * Vérifie la présence de l'image de chaque détail,
         * si elle est absente l'image est générée
         * depuis la vidéo du détail.<br>
         * Récupère la liste des noms d'images générées pour les distinguer en
         * synthèse
         */
        scope.generatePicturesFromVideos = () => {
          if (gaJsUtils.notNullAndDefined(scope.information,
            ['impor', 'itvResponse', 'objValeur', 'ItvId'])) {
            const itvId = scope.information.impor.itvResponse.objValeur.ItvId;
            if (!scope.config || !scope.config.network || !scope.config.datastore
              || !scope.config.arcgiscomponent) {
              const getConfFromWidget = (curScope) => {
                if (curScope.conf && curScope.conf.config) {
                  for (const [key, value] of Object.entries(curScope.conf.config)) {
                    if (key === 'network' || key === 'datastore' || key === 'arcgiscomponent') {
                      scope.config[key] = value;
                    }
                  }
                  if (!scope.config.arcgiscomponent
                    && Object.prototype.hasOwnProperty.call(curScope.conf, 'arcgiscomponent')) {
                    scope.config.arcgiscomponent = curScope.conf.arcgiscomponent;
                  }
                }
                else {
                  getConfFromWidget(curScope.$parent);
                }
              };
              getConfFromWidget(scope);
            }
            gaDomUtils.showGlobalLoader();
            const arcgisLayers = itvSoumFactory.arcgisConfToUrl(scope.config);
            itvSoumFactory.generatePicturesFromVideos(itvId, scope.config.network,
              scope.config.datastore, arcgisLayers, scope.ConfigName
            ).then(
              res => {
                scope.generatedImages = res.data && Array.isArray(res.data) ? res.data : [];
                require('toastr').info($filter('translate')('itv.soumission.sucessGenerateImg'));
              },
              err => {
                toastrError('itv.soumission.errorGenerateImg',
                  err && err.data && err.data.message ? '\n' + err.data.message : '');
              }
            ).finally(
              () => {
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        /**
         * Vider les informations de correspondance
         * de l'ITV précédemment choisie.
         */
        const clearCurrentPart4Corresp = () => {
          const parts = scope.information.correspondance.parts;
          parts.part.splice(0, parts.part.length);
          parts.partIndex.splice(0, parts.partIndex.length);
          for (const prop in parts.polygons) {
            delete parts.polygons[prop];
          }
        };

        /**
         * Vider le contenu des champs où apparaissent les noms des ficheirs chargés pour l'ITV.
         */
        const clearInputsOfItvFiles = () => {
          scope.itvVideofile = '';
          scope.itvImagefile = '';
          scope.itvpdffile = '';
        };


        /**
         * Affiche/masque le bouton rouge carré "Supprimer" (corbeille)
         * de suppression de l'itv en attente
         */
        scope.toggleDeletePendingItvButton = () => {
          clearCurrentPart4Corresp();
          clearInputsOfItvFiles();
          const selectContainer
            = document.querySelector('.pending-itv');
          if (selectContainer) {
            if (scope.itvxmltxtfileName && scope.itvxmltxtfileName.length > 0) {
              // si une itv en attente est sélectionné on affiche le bouton
              if (selectContainer.classList.contains('col-xs-12')
                && document.getElementById('del-pending-itv-btn') === null) {
                // reduit la largeur du select pour placer le bouton à droite
                selectContainer.classList.remove('col-xs-12');
                selectContainer.classList.add('col-xs-10');
                // créé le bouton "supprimer" à injecter
                const deleteButtonContainer = document.createElement('div');
                deleteButtonContainer.id = 'del-pending-itv-btn';
                deleteButtonContainer.classList.add('col-xs-2');
                deleteButtonContainer.innerHTML
                  = '<button type="button" class="btn btn-danger"><i class="fa fa-trash"></i></button>';
                deleteButtonContainer.addEventListener('click', () => {
                  scope.confirmDialog = ngDialog.open({
                    template: 'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionPendingItvRemove.html',
                    className: 'ngdialog-theme-plain width400 nopadding miniclose itv-pending-remove',
                    closeByDocument: false,
                    scope
                  });
                });
                // insère le bouton dans le dom après le select
                selectContainer.parentNode.insertBefore(deleteButtonContainer,
                  selectContainer.nextSibling);
              }
            }
            else if (selectContainer.classList.contains('col-xs-10')) {
              // si pas d'itv en attente sélectionné et le bouton est déjà présent

              // enlève le bouton et son conteneur du dom
              const deleteButtonContainer
                = document.getElementById('del-pending-itv-btn');
              if (deleteButtonContainer) {
                deleteButtonContainer.remove();
              }
              // augmente la largeur du select
              selectContainer.classList.add('col-xs-12');
              selectContainer.classList.remove('col-xs-10');
            }
          }
        };

        /**
         * Après confirmation, supprime l'itv en attente sélectionné
         * Supprime le dossier de travail de l'itv et son contenu
         */
        scope.deletePendingItv = () => {
          itvSoumFactory.deletePendingItv(scope.itvxmltxtfileName).then(
            res => {
              if (res.data) {
                const index = scope.listInspection.findIndex(e => e === scope.itvxmltxtfileName);
                if (index > -1) {
                  scope.listInspection.splice(index, 1);
                  scope.itvxmltxtfileName = null;
                  if (scope.itvxmltxtfile && scope.itvxmltxtfile.length > 0) {
                    scope.itvxmltxtfile = null;
                  }
                  scope.toggleDeletePendingItvButton();
                }
              }
              else {
                toastrError('itv.soumission.deletionError',
                  scope.itvxmltxtfileName + res && res.data && res.data.message ?
                    '\n' + res.data.message
                    : '');
              }
            },
            err => {
              toastrError('itv.soumission.deletionError',
                scope.itvxmltxtfileName + err && err.data && err.data.message ?
                  '\n' + err.data.message
                  : '');
            }
          );
        };

        /**
         * A l'initialisation de la directive,
         * vérifie la présence de la variable de configuration FFMPEG pour
         * afficher le bouton
         * "Extraire les photos des vidéos".
         * En l'absence de la variable, la génération est impossible.
         */
        itvSoumFactory.canGeneratePictures().then(
          res => {
            if (res.data && typeof res.data === 'boolean') {
              scope.canGeneratePictures = res.data;
            }
          },
          err => {
            toastrError('itv.soumission.errorCheckingFfMpeg',
              err && err.data && err.data.message
                ? '\n' + err.data.message
                : '');
          }
        );

        /**
         * Construit le nom du dossier de travail de l'ITV à partir du nom de
         * fichier txt ou xml importé
         * Remplace la malfaçon d'utiliser le model de l'itv en attente
         * @return {string|null} nom du dossier de travail de l'ITV
         */
        const getItvFileName = () => {
          if (scope.itvxmltxtfile) {
            const extensionIndex = scope.itvxmltxtfile.lastIndexOf('.');
            return scope.itvxmltxtfile.substring(0, extensionIndex);
          }
          else {
            return null;
          }
        };

        //Augmenter l'étendue du boundBox
        const enlargeExtent = (ext, value = 10) => {
          ext[0] -= value;
          ext[1] -= value;
          ext[2] += value;
          ext[3] += value;
        };
        /**
         * Zoomer sur l'emprise d'un ensemble de features.
         *
         * @param {*} features
         */
        scope.zoomOnFeatures = (features) => {
          let allextends = [];
          let boole = true;
          const format = new ol.format.GeoJSON();
          //-- Parcours de la liste des features sur lesquelles on zoom.
          for (const feature of features) {
            //-- Récupération de l'étendu de la feature courante.
            const featuref = format.readFeature(feature);
            const ext = featuref.getGeometry().getExtent();
            if (boole) {
              allextends = ext;
              boole = false;
            }
            else {
              //-- Etendre l'étendue des features avec celle de la feature courante.
              allextends[0] = Math.min(allextends[0], ext[0]);
              allextends[1] = Math.min(allextends[1], ext[1]);
              allextends[2] = Math.max(allextends[2], ext[2]);
              allextends[3] = Math.max(allextends[3], ext[3]);
            }
          }
          //-- Sélectionner les features (sur la carte).
          const selFeatures = { features: features };
          enlargeExtent(allextends);
          scope.map.getView().fit(allextends, scope.map.getSize());
          SelectManager.addFeaturesFromGeojson(selFeatures);
        };

        // Fonction pour regrouper les IDs par composant
        function groupIdsByComponent(headersUid) {
          return headersUid.reduce((obj, item) => {
            const [table, id] = item.split('.');
            if (!obj[table]) {
              obj[table] = [];
            }
            obj[table].push(id);
            return obj;
          }, {});
        }

        //Visualiser les éléments en correspondance
        scope.zoomOnList = () => {
          const filteredCodes = ['AAA', 'AAD', 'AAF', 'AAT', '@01'];
          const filteredParts = scope.partsOfCurrentItv.filter(
            part => (part.matchedAutomatically || part.validated ) && !part.ignorePortion);
          const headersUid = [];
          let allPromises = [];
          // extraire les headers qui ont un matchedAutomatically ou validated true
          filteredParts.forEach(part => {
            part.partHeaders.filter(header => filteredCodes.includes(header.code))
              .forEach(item => {
                if (item && item.featId4Net) {
                  headersUid.push(item.featId4Net);
                } else if (item && item.featIds4Net && item.featIds4Net.length > 0) {
                  for(let featId of item.featIds4Net){
                    headersUid.push(featId);
                  }
                }
              });
          });
          // coustruire un json qui regroupe chaque composant avec ses ids
          const groupedIds = groupIdsByComponent(headersUid);
          for (let tableName in groupedIds) {
            // on construit un tableau des ids en supprimant les doublons en utilisant un Set
            let uniqueIds = Array.from(new Set(groupedIds[tableName]));
            let cql_filter = "IN('" + uniqueIds.join("','") + "')";
            let uid = FeatureTypeFactory.getFeatureUidByName(tableName);
            let projection = scope.map.getView().getProjection().getCode();
            let promise = ogcFactory.getfeatures(
              'GetFeature',
              'WFS',
              '1.0.0',
              uid,
              'json',
              projection,
              cql_filter
            );

            allPromises.push(promise.then((res) => {
              if (res.data.features && Array.isArray(res.data.features)) {
                return res.data.features;
              } else {
                return [];
              }
            }));
          }

          Promise.all(allPromises).then((promise) => {
            features = promise.flat();
            if (features.length > 0) {
              scope.zoomOnFeatures(features);
            } else {
              require('toastr').warning(
                $filter('translate')('itv.correspondance.listMenu.warningMsg'));
            }
          });
        };

        //Vider la liste séléctionnées sur la carte
        scope.emptyList = () => {
          SelectManager.clear();
          features = [];
          scope.totalFeaturesNumber = 0;
          scope.featuresData = [];
        };

        const getPairFromFeatId = (featureId) => {
          const pair = [];
          if (featureId) {
            const iDot = featureId.lastIndexOf('.');
            pair.push(featureId.substring(0, iDot));
            pair.push(featureId.substring(iDot + 1));
          }
          return pair;
        };

        scope.containFeatureClass = (featureTypeName) => {
          return scope.featuresData.some(feature => feature.label === featureTypeName);
        };

        scope.getFeatureClass = (featureTypeName) => {
          return scope.featuresData.find(feature => feature.label === featureTypeName) || null;
        };

        const sortLayersByLabel = (layer1, layer2) => {
          let index1 = layer1.label;
          let index2 = layer2.label;
          if (index1 == null) return -1;
          else if (index2 == null) return 1;
          else if (index1 < index2) return -1;
          return 1;
        };

        // Afficher l'élément de itvPartList lié l'élément selectioné
        scope.featTreeSelected = (branch) => {
          if (branch.data.id) {
            let found = false;
            scope.partsOfCurrentItv.forEach((part) => {
              if (!found) {
                part.$hideRows = false;
                part.partHeaders.forEach((p) => {
                  if (!found && (p.featId4Net == branch.data.id
                    || p.featIds4Net == branch.data.id)) {
                    part.$hideRows = true;
                    scope.getPart(part);
                    scope.information.currentPartListIndex = scope.currentPart.partIndex;
                    // Positionner la fenêtre sur l'élément sélectionné
                    scope.gotoAnchor(0);
                    found = true;
                  }
                });
              }
            });
          }
        };

        let correspObjetPopup;
        //Afficher la liste des éléments en correspondance
        scope.showList = () =>{
          let spatialFiltredFeatures =[];
          let allPromises = [];
          scope.featuresData = [];
          scope.totalFeaturesNumber = 0;
          //Si le popup est deja ouvert, on ferme l'ancien d'abord
          if (correspObjetPopup){
            correspObjetPopup.close();
          }
          if(features && features.length>0){
            const headersUid = features.map(feature => feature.id);
            // coustruire un json qui regroupe chaque composant avec ses ids
            const groupedIds = groupIdsByComponent(headersUid);
            for (let tableName in groupedIds) {
              let uniqueIds = groupedIds[tableName];
              let cql_filter = "IN('" + uniqueIds.join("','") + "')";
              let uid = FeatureTypeFactory.getFeatureUidByName(tableName);
              let projection = scope.map.getView().getProjection().getCode();
              // Construire le filtre spatial basé sur l'étendue de la vue actuelle
              let extent = scope.map.getView().calculateExtent(scope.map.getSize());
              let leftX = extent[0];
              let bottomY = extent[1];
              let rightX = extent[2];
              let topY = extent[3];
              let spatialClause =
                'INTERSECTS(geom, POLYGON((' +
                leftX   + ' ' + bottomY + ',' +
                rightX  + ' ' + bottomY + ',' +
                rightX  + ' ' + topY    + ',' +
                leftX   + ' ' + topY    + ',' +
                leftX   + ' ' + bottomY + ')))';
              let promise = ogcFactory.getfeatures(
                'GetFeature',
                'WFS',
                '1.0.0',
                uid,
                'json',
                projection,
                spatialClause,
                cql_filter
              );
              allPromises.push(promise.then((res) => {
                if (res.data.features && Array.isArray(res.data.features)) {
                  spatialFiltredFeatures = spatialFiltredFeatures.concat(res.data.features);
                } else {
                  return [];
                }
              }));
            }
            Promise.all(allPromises).then(() => {
              scope.totalFeaturesNumber = spatialFiltredFeatures.length;
              spatialFiltredFeatures.forEach((feat) =>{
                let pair = getPairFromFeatId(feat.id);
                let fti = FeatureTypeFactory.getFeatureByName(pair[0]);
                // Vérifier si FeatureClass existe déjà
                if (scope.containFeatureClass('features.' + pair[0] + '.alias ')) {
                  scope
                    .getFeatureClass('features.' + pair[0] + '.alias ')['children'].push({
                      label: QueryFactory.getObjectId(feat, fti),
                      children: [],
                      data: {
                        properties: feat['properties'],
                        id: feat.id,
                        featuretype: pair[0],
                      },
                    });
                } else {
                  // Ajouter la fonctionnalité à la classe correspondante
                  scope.featuresData.push({
                    label: 'features.' + pair[0] + '.alias ',
                    data: { featuretype: pair[0] },
                    children: [],
                  });
                  scope
                    .getFeatureClass('features.' + pair[0] + '.alias ')['children'].push({
                      label: QueryFactory.getObjectId(feat, fti),
                      children: [],
                      data: {
                        properties: feat['properties'],
                        id: feat.id,
                        featuretype: pair[0],
                      },
                    });
                }
              });
              if (Array.isArray(scope.featuresData) && scope.featuresData.length > 0) {
                scope.featuresData.forEach(feature => {
                  if (Array.isArray(feature.children) && feature.children.length > 0) {
                    feature.children.sort(sortLayersByLabel);
                  }
                });
              }
            });
          } else {
            require('toastr').warning(
              $filter('translate')('itv.correspondance.listMenu.warningMsg'));
          }
          correspObjetPopup = extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionCorrespondanceList.html',
            className: 'ngdialog-theme-plain overflowY width350 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('itv.correspondance.showListTitle'),
            resizable: false,
            minimizeMaximize: true,
            disableMaximizeButton: true,
            draggable: true,
          });
        };

        // Valider les partHeaders (Amont,Aval,Center) en fonction de la nature d'équipement
        const validerPartHeaders = (part) =>{
          scope.corresp.partHeaderCenter.partHeader.validated = true;
          if(scope.corresp.inspectionType !== 'regard'){
            scope.corresp.partHeaderAmont.partHeader.validated = true;
            if(scope.corresp.inspectionType !='branchement'){
              scope.corresp.partHeaderAval.partHeader.validated = true;
            }
          }
          part.validated = true;
        };

        scope.validationList = () =>{
          // Vérifier les conditions pour chaque partie
          const partsToValidate = scope.partsOfCurrentItv.filter(
            part => (part.matchedAutomatically && !part.validated && !part.ignorePortion));
          const itvResponse = scope.information.impor.itvResponse;
          const partsCorresp = scope.information.correspondance.parts;
          partsToValidate.forEach((part) => {
            // Basculer la visibilité des lignes
            part.$hideRows = !part.$hideRows;
            // Obtenir les détails de la partie
            scope.getPart(part).then(() =>{
              // Valider les partHeaders en correspondance
              validerPartHeaders(part);
              // Valider la partie et sauvegarder
              partsCorresp.part.forEach(p => {
                if (p.objValeur.indTroncon == part.partIndex) {
                  p.objValeur.validated = true;
                  itvSoumFactory.saveItvPart(
                    itvResponse.objValeur,
                    p,
                    false,
                    scope.conf.config.network,
                    scope.conf.config.datastore
                  );
                }
              });
            });
            //Ferme le dernier part
            part.$hideRows = !part.$hideRows;
            scope.getPart(part);
          });
        };

        scope.ignoreList = () =>{
          if(gaJsUtils.notNullAndDefined(scope.information, 'impor.itvResponse.objValeur.parts')){
            scope.information.impor.itvResponse.objValeur.parts
              .forEach(part => {
                if(['Branchement', "Regard de visite ou Chambre d'inspection"]
                  .includes(part.natureEquipement)){
                  part.ignorePortion = true;
                  itvUtilsFactory.saveItvPart(
                    scope.getItvId(),
                    itvUtilsFactory.getIndTronconFrom(part),
                    part,
                    scope.conf.config.network,
                    scope.conf.config.datastore
                  );
                }
              });
          } else {
            require('toastr').warning(
              $filter('translate')('itv.correspondance.listMenu.warningMsg'));
          }
        };

        scope.loadMenu = () =>{
          scope.insPortionsListMenu = [
            {
              text: '<i class="fa fa-search"></i> '
                + $filter('translate')('itv.correspondance.listMenu.zoomOnList'),
              click: 'zoomOnList()',
            },
            {
              text: '<i class="fa fa-list"></i> '
                + $filter('translate')('itv.correspondance.listMenu.showList'),
              click: 'showList()',
            },
            {
              text: '<i class="fa fa-close"></i> '
                + $filter('translate')('itv.correspondance.listMenu.emptyList'),
              click: 'emptyList()',
            },
            {
              text: '<i class="fa fa-check-square custom-check-square"></i> '
                + $filter('translate')('itv.correspondance.listMenu.globalValidation'),
              click: 'validationList()',
            }
          ];

          if (scope.conf && scope.conf.config && scope.conf.config.mayIgnorePortions) {
            scope.insPortionsListMenu.push({
              text: '<i class="fa fa-square-o"></i> '
                + $filter('translate')('itv.correspondance.listMenu.ignore'),
              click: 'ignoreList()',
            });
          }

        };

        scope.openDetails = () => {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/itv/views/soumission/itvSoumissionDetails.html',
            className:
              'ngdialog-theme-plain width750 maxheight650 nopadding miniclose',
            closeByDocument: false,
            scope,
            title: $filter('translate')('itv.correspondance.infodetailed'),
            draggable: true
          });
        };

        /**
         * Vérifie si la portion est OK pour les ouvrages.
         *
         * @param {*} part Portion à vérifier
         * @return <code>true</code> si portion valide, sinon <code>false</code>
         */
        scope.areAadAafAaaValid = (part) => {
          const headers = itvUtilsFactory.getHeadersFrom(part);
          const codes = ['AAD', 'AAF', 'AAA'];
          let valid = true;
          for (const code of codes) {
            const header = headers.find(header => header.code === code);
            if (!header || !header.validated) {
              valid = false;
            }
          }
          if (!valid) {
            const headerBrcht = headers.find(header => header.code === '@01');
            if (headerBrcht && headerBrcht.validated) {
              valid = false;
            }
          }
          return valid;
        };


        /**
         * Vérifie que l'écart de longueur entre la mesure du fichier ITV et
         * la longueur des canamisations mises en correspondance est
         * dans la tolérance.
         *
         * @param {*} part : portion inspectée à vérifier
         * @returns VRAI si l'écart est dans la tolérancen FAUX sinon
         */
        scope.wrongLength = (part) => {
          if (!part) {
            //-- Cette fonction peut être appelée avec part undefined
            //-- lors de l'initialisation du widget.
            return false;
          }
          else {
            return part.lengthDelta >
              itvSoumFactory.getTolerance(scope) * part.partLength;
          }
        };
        scope.choseColorForItvPart = (part) => {
          if (part.validated && !part.ignorePortion) {
            return 'success';
          }
          if (!part.validated && (part.matchedAutomatically
            || scope.areAadAafAaaValid(part)) && !part.ignorePortion) {
            return 'warning';
          }
          if (!part.validated && !part.matchedAutomatically
            && !scope.areAadAafAaaValid(part) && !part.ignorePortion) {
            return 'danger';
          }
          if (part.ignorePortion) {
            return 'portionIgnored';
          }
        };

        scope.choseCssForItvPartButton = (part) => {
          if (part.validated || part.ignorePortion) {
            return 'validated';
          }
          if (!part.validated && (part.matchedAutomatically
            || scope.areAadAafAaaValid(part)) && !part.ignorePortion) {
            return 'to_validate';
          }
          if (!part.validated && !part.matchedAutomatically
            && !scope.areAadAafAaaValid(part) && !part.ignorePortion) {
            return 'no_match';
          }
        };

        // -- Définition de la fonction qui récupére
        // -- la liste des couches de gestion des ITVs configurées
        const readArcgisLayers = () => {
          const conf = scope.config.arcgiscomponent ? scope.config : scope.conf;
          return itvSoumFactory.arcgisConfToUrl(conf);
        };
        // -- Référencement de cette fonction sur ItvUtilsFactory pour
        itvUtilsFactory.setReadArcgisLayersFn(readArcgisLayers);

        /**
         * Vérifie la présence du fichier en cours de chargement dans la liste
         * des noms de fichier ITV en attente de soumission. <br>
         * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3520">
         *   KIS-3520 | Interdire l'ajout d'un fichier txt avec le même nom d'un déjà en attente
         * </a>
         * @param {File} file fichier ITV en cours de chargement depuis l'input txt/xml
         * @return {boolean} true si le fichier est déjà en cours de soumission: présent
         *      dans la liste des fichiers en attente de soumission
         */
        const isItvPendingExists = (file) => {
          let itvPendingFileExists = false;
          if (Array.isArray(scope.listInspection) && scope.listInspection.length > 0 && gaJsUtils.notNullAndDefined(file)) {
            let filename = file.name;
            if (filename) {
              const dotIndex = filename.lastIndexOf('.');
              if (dotIndex > -1) {
                filename = filename.substring(0, dotIndex);
              }
              itvPendingFileExists = scope.listInspection.includes(filename);
            }
          }
          return itvPendingFileExists;
        };
      }
    };
  };

  itvSoumission.$inject = ['$filter', 'itvSoumFactory',
    '$timeout', 'ngProgressFactory', '$interval', '$compile',
    'ngTableParams', 'gclayers', 'NetworkFactory',
    'extendedNgDialog', '$rootScope', '$modal', 'DataStoreFactory',
    'gaDomUtils', '$location', 'ConfigFactory',
    'gaJsUtils', '$q', 'ngDialog', 'itvSoumValidSelection',
    'itvDrawPartsFactory', 'itvUtilsFactory', 'EditFactory', 'PortalsFactory',
    'FeatureTypeFactory', 'ogcFactory', 'SelectManager', 'QueryFactory'
  ];
  return itvSoumission;
});
