'use strict';
define(function() {
  var saveAndGetTemplate = function(
    ngDialog,
    $filter,
    $rootScope,
    $timeout,
    ParametersFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/getAndSaveTemplates/views/save_and_get_template.html',
      restrict: 'EA',
      scope: {
        configName: '=',
        data: '=',
        saveTemplateHtml: '=?',
        getTemplateHtml: '=?',
        verifyLoadedData: '=?',
        runReturn: '=?',
        res: '=?',
        excludeProperties: '=?',
        icons: '=?',
        specialPreTreatement: '=?',
        disableButtons: '=?',
        saveLabel: '=',
        getLabel: '=',
        displayCurrentTemplateName: '=',
        savedquery: '=',
      },
      link: function(scope) {
        if (scope.savedquery != undefined) {
          scope.saved = {};
          scope.saved.query = scope.savedquery;
        }
        scope.writequeryname = true;
        scope.changeWrtieMode = function() {
          scope.writequeryname = !scope.writequeryname;
        };
        if (angular.isUndefined(scope.saveTemplateHtml))
          scope.saveTemplateHtml =
            'js/XG/widgets/utilities/getAndSaveTemplates/views/dialog/templates.html';
        if (angular.isUndefined(scope.getTemplateHtml))
          scope.getTemplateHtml =
            'js/XG/widgets/utilities/getAndSaveTemplates/views/dialog/getTemplates.html';
        var ngDialogPromise;
        scope.saveTemplate = function() {
          ParametersFactory.getbytype(scope.configName).then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                };
              }
            },
            function(data) {
              console.log(scope.config);
            }
          );
          var data = angular.copy(scope.data);
          if (scope.excludeProperties)
            data = Object.assign(data, scope.excludeProperties);
          if (scope.specialPreTreatement)
            data = scope.specialPreTreatement(data);
          scope.saveData = {
            user: $rootScope.xgos.user.login,
            savedata: data,
          };
          scope.queryname = undefined;
          ngDialogPromise = ngDialog.openConfirm({
            template: scope.saveTemplateHtml,
            scope: scope,
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
          });
          ngDialogPromise.then(
            function(data) {
              ParametersFactory.getbytype(scope.configName).then(function(res) {
                var nameSaved = res.data.map(function(x) {
                  return x.name;
                });
                if (nameSaved.indexOf(data) !== -1) {
                  var idx = res.data
                    .map(function(x) {
                      return x.name;
                    })
                    .indexOf(data);
                  var id = res.data[idx].id;
                  ParametersFactory.remove(id).then(
                    function() {
                      ParametersFactory.add(
                        scope.saveData,
                        scope.configName,
                        data
                      ).then(
                        function() {
                          scope.saved.query = data;
                          if (scope.savedquery != undefined)
                            scope.savedquery = data;
                          require('toastr').success(
                            $filter('translate')('elastic.search.save_ok')
                          );
                        },
                        function() {
                          require('toastr').error(
                            $filter('translate')('elastic.search.save_nok')
                          );
                        }
                      );
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                } else {
                  ParametersFactory.add(
                    scope.saveData,
                    scope.configName,
                    data
                  ).then(
                    function() {
                      scope.saved.query = data;
                      if (scope.savedquery != undefined)
                        scope.savedquery = data;
                      require('toastr').success(
                        $filter('translate')('elastic.search.save_ok')
                      );
                    },
                    function() {
                      require('toastr').error(
                        $filter('translate')('elastic.search.save_nok')
                      );
                    }
                  );
                }
              });
            },
            function(data) {
              require('toastr').info(
                $filter('translate')('elastic.search.annuler')
              );
            }
          );
        };
        scope.removeSavedAdvanced = function(idx) {
          var callback = function(confirmed) {
            if (confirmed) {
              $timeout(function() {
                ParametersFactory.deletebyname(
                  scope.saved.realNames[idx].name
                ).then(
                  function() {
                    scope.saved.realNames.splice(idx, 1);
                    scope.saved.queries.splice(idx, 1);
                    require('toastr').success(
                      $filter('translate')('hpo.data.exchange.updates')
                    );
                  },
                  function() {
                    require('toastr').error(
                      $filter('translate')('hpo.data.exchange.updatesfail')
                    );
                  }
                );
              }, 600);
            }
          };
          swal(
            {
              title: $filter('translate')('exportGeopackage.sure'),
              //text: "You will not be able to recover this imaginary file!",
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#DD6B55',
              confirmButtonText: $filter('translate')('common.yes'),
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            callback
          );
        };
        scope.getTemplate = function() {
          ParametersFactory.getbytype(scope.configName).then(
            function(res) {
              if (res.data.length > 0) {
                scope.datas = res.data;
                scope.saved = {
                  realNames: scope.datas,
                  queries: scope.datas
                    .map(function(x) {
                      return x.name;
                    })
                    .filter(function(x) {
                      if (x) return x;
                    }),
                };
                scope.currentuser = $rootScope.xgos.user.login;
                ngDialogPromise = ngDialog.openConfirm({
                  template: scope.getTemplateHtml,
                  scope: scope,
                  className:
                    'ngdialog-theme-plain width600 nopadding miniclose',
                });
                ngDialogPromise.then(
                  function(data) {
                    if (data && data.query) {
                      var filename = data.query;
                      var filenames = scope.datas.map(function(x) {
                        return x.name;
                      });
                      var index = filenames.indexOf(filename);
                      var dataHPO = scope.datas[index].data;
                      if (angular.isDefined(scope.verifyLoadedData))
                        scope.verifyLoadedData(dataHPO);
                      scope.res = dataHPO;
                      if (angular.isDefined(scope.runReturn))
                        scope.runReturn(dataHPO, filename);
                    }
                  },
                  function() {
                    require('toastr').info(
                      $filter('translate')('elastic.search.annuler')
                    );
                  }
                );
              } else {
                require('toastr').info(
                  $filter('translate')('elastic.search.no_save')
                );
              }
            },
            function() {
              require('toastr').error(
                $filter('translate')('elastic.search.save_nok')
              );
            }
          );
        };
      },
    };
  };
  saveAndGetTemplate.$inject = [
    'ngDialog',
    '$filter',
    '$rootScope',
    '$timeout',
    'ParametersFactory',
  ];
  return saveAndGetTemplate;
});
