'use strict';
define(function() {
  var gchyperlink = function(isUtils) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/gchyperlink.html',
      restrict: 'A',
      scope: {
        att: '=gcatt',
        result: '=result',
        activelabel: '=activelabel',
        initvalue: '=initvalue',
        fieldData: '=?fieldData'
      },

      link: function(scope, elt) {
        // Mettre à jour l'éditeur d'URL lorsque le résultat change
        scope.$watch('result', () => {
          scope.editUrl = false;
        });
        scope.openEdit = () => {
          scope.tempValue = angular.copy(scope.result[scope.att.name]);  
          scope.editUrl = true;
        };

        // Annuler l'édition et restaurer la valeur originale
        scope.cancelEdit = () => {
          scope.result[scope.att.name] = scope.tempValue;
          scope.editUrl = false;
        };

        scope.saveEdit = () => {
          const urlValue = scope.result[scope.att.name];
          // Vérifier si l'URL commence par "http://" ou "https://"
          if (urlValue && (urlValue.startsWith('http://') || urlValue.startsWith('https://'))) {
              scope.editUrl = false; 
          }
          //Vider le contenu du champ Hyperlien possible quand le champ est n’est pas obligatoire
          if (!scope.fieldData.required && (urlValue === '' || (urlValue && urlValue.trim() === ''))) {
            scope.result[scope.att.name] = '';
            scope.editUrl = false;
          }
        };

        scope.addListener = () => {
          isUtils.addIsListenersAndObservers();
        };
      }
    };
  };

  gchyperlink.$inject = ['isUtils'];
  return gchyperlink;
});
