'use strict';
define(function() {
  var sitesPlanningCtrl = function(
    $scope,
    $location,
    SirocoFactory,
    gaDomUtils,
    ParametersFactory,
    $filter
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
    $scope.planning = {};
    var newPlanning = true;
    $scope.seuilsList = [
      { key: 'annee', label: 'Année' },
      { key: 'budget', label: 'Budget Annuel' },
      { key: 'lineaire', label: 'Linéaire annuel' },
    ];

    // get current planification
    ParametersFactory.getbytype('siroco_plannification').then(function(res) {
      if (res.data.length > 0) {
        res.data.forEach(function(cfg) {
          if (cfg.data.app == sirocoCfg.appuid) {
            $scope.planning = cfg;
            newPlanning = false;
            getPlanificationTranches();
          }
        });
      }
    });

    // init siroco_plannification parameter

    /*ParametersFactory.add(saveData, "siroco_variante" , $scope.newVarianteData.name).then(function(res){
         $scope.cfgList.push(res.data);
         });*/

    /**
     * save plannification in siroco_plannification dbparameter
     */
    var savePlannification = function() {
      if (newPlanning) {
        $scope.planning.data.app = sirocoCfg.appuid;
        ParametersFactory.add(
          $scope.planning.data,
          'siroco_plannification',
          'siroco_plannification'
        ).then(function(res) {
          require('toastr').success($filter('translate')('common.saved'));
        });
      } else {
        console.log('ici');
        ParametersFactory.update($scope.planning, $scope.planning.id).then(
          function(res) {
            require('toastr').success($filter('translate')('common.saved'));
          }
        );
      }
    };

    /**
     * getPlanificationTranches
     */
    var getPlanificationTranches = function() {
      SirocoFactory.listertranches().then(
        function(res) {
          $scope.tranches = JSON.parse(res.data.strValeur);
          gaDomUtils.hideGlobalLoader();
        },
        function() {
          require('toastr').error(
            'Erreur lors de la planification des chantiers'
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
      gaDomUtils.hideGlobalLoader();
    };

    /**
     * planifierChantiers
     */
    $scope.planifierChantiers = function() {
      gaDomUtils.showGlobalLoader();
      SirocoFactory.creertranches(
        $scope.planning.data.seuil,
        sirocoCfg.appname,
        $scope.planning.data.year,
        $scope.planning.data.years,
        $scope.planning.data.seuilvalue
      ).then(
        function() {
          getPlanificationTranches();
          savePlannification();
        },
        function() {
          require('toastr').error(
            'Erreur lors de la planification des chantiers'
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    /**
     * edition de tranche
     * @param tranche
     */
    $scope.editTranche = function(tranche) {
      SirocoFactory.modifiertranche(tranche.annee, tranche.valeur).then(
        function(res) {
          console.log(res.data);
          require('toastr').success('Tranche modifiée');
        },
        function() {
          require('toastr').error(
            'Erreur lors de la modification de la tranche'
          );
        }
      );
    };

    $scope.planifierChantiersTEST = function() {
      $scope.planning = {
        year: 2015,
        years: 5,
        seuil: 'annee',
        seuilvalue: 1000,
      };
      $scope.planifierChantiers();
    };

    /**
     * goToExportPage
     */
    $scope.goToExportPage = function() {
      $location.path('/siroco/schedule');
    };
  };

  sitesPlanningCtrl.$inject = [
    '$scope',
    '$location',
    'SirocoFactory',
    'gaDomUtils',
    'ParametersFactory',
    '$filter',
  ];
  return sitesPlanningCtrl;
});
