'use strict';
define(function() {
  var scheduleCtrl = function(
    $scope,
    ImportExportFactory,
    gaDomUtils,
    SirocoFactory,
    FeatureTypeFactory
  ) {
    $scope.canaAepFt = false;
    $scope.chantierFt = false;

    // get cana and chantier feature
    SirocoFactory.getSirocoCfg().then(function(res) {
      var sirocoCFG = JSON.parse(res);
      /*
            var canaAepName = sirocoCFG.layersNames.cana_aep;
            var chantierName = sirocoCFG.layersNames.chantier;
            */
      var canaAepName = sirocoCFG.layersNames.cana_aep;
      var chantierName = sirocoCFG.layersNames.chantier;

      FeatureTypeFactory.get().then(function() {
        console.log(canaAepName);
        FeatureTypeFactory.resources.featuretypes.forEach(function(fType) {
          if (fType.name == canaAepName) {
            $scope.canaAepFt = fType;
          }
          if (fType.name == chantierName) {
            $scope.chantierFt = fType;
          }
        });
      });
    });

    $scope.exportChantiers = function() {
      var attributes = [
        {
          uid: $scope.chantierFt.uid,
          attributes: $scope.chantierFt.attributes
            .map(function(x) {
              return x.name;
            })
            .join(';'),
        },
      ];

      attributes = JSON.stringify(attributes);
      ImportExportFactory.exportLayersFeatures(
        'SHAPEFILE',
        null,
        $scope.chantierFt.uid,
        attributes,
        ''
      ).then(function(exportResult) {
        var resultFileName = exportResult.data;
        var downloadurl =
          '/services/'+localStorage.getItem('portal')+'/export/downloadexportedfile?f=json' +
          '&exportedFileId=' +
          resultFileName;
        window.open(downloadurl);
      });
    };

    $scope.exportCanas = function() {
      var attributes = [
        {
          uid: $scope.canaAepFt.uid,
          attributes: $scope.canaAepFt.attributes
            .map(function(x) {
              return x.name;
            })
            .join(';'),
        },
      ];

      attributes = JSON.stringify(attributes);
      ImportExportFactory.exportLayersFeatures(
        'SHAPEFILE',
        null,
        $scope.canaAepFt.uid,
        attributes,
        ''
      ).then(function(exportResult) {
        var resultFileName = exportResult.data;
        var downloadurl =
          '/services/'+localStorage.getItem('portal')+'/export/downloadexportedfile?f=json' +
          '&exportedFileId=' +
          resultFileName;
        window.open(downloadurl);
      });
    };
  };
  scheduleCtrl.$inject = [
    '$scope',
    'ImportExportFactory',
    'gaDomUtils',
    'SirocoFactory',
    'FeatureTypeFactory',
  ];
  return scheduleCtrl;
});
