'use strict';
define(function() {
  var networkwidget = function(
    gclayers,
    NetworkFactory,
    FeatureTypeFactory,
    ConfigFactory,
    SelectManager,
    ngDialog,
    $filter,
    $translate
  ) {
    var CONFIG_TYPE = 'NETWORK';

    var DEFAULT_TYPE = 'defaultTypeElts';

    var NETWORK_CROPPED_PATH_CLASS = 'fa fa-code-fork';
    var NETWORK_CROPPED_TYPE = 'fromAmontNodeToNextCroppedElements';

    var NETWORK_DIRECTED_PATH_CLASS = 'fa fa-random';
    var NETWORK_DIRECTED_TYPE = 'fromAmontNodeToNextElements';

    var NETWORK_FAST_PATH_CLASS = 'fa fa-crop';
    var NETWORK_FAST_PATH_TYPE = 'fromAmontNodeToAvalNode';

    var NETWORK_AMONT_AVAL_PATH_CLASS = 'fa fa-exchange';
    var NETWORK_AMONT_AVAL_PATH_TYPE = 'amontAndAvalPartNet';

    var NETWORK_DISTANCE_PATH_CLASS = 'fa fa-crosshairs';
    var NETWORK_DISTANCE_PATH_TYPE = 'distanceNet';

    var BUFFERS_TYPES = [
      {
        value: 'FLAT',
        label:
          $filter('translate')('model.network.flatBufferLabel') +
          '&nbsp;&nbsp;<i class="fa fa-credit-card"></i>',
      },
      {
        value: 'SQUARE',
        label:
          $filter('translate')('model.network.squareBufferLabel') +
          '&nbsp;&nbsp;<i class="fa fa-object-group"></i>',
      },
      {
        value: 'ROUND',
        label:
          $filter('translate')('model.network.roundBufferLabel') +
          '&nbsp;&nbsp;<i class="fa fa-square-o"></i>',
      },
    ];

    var BUFFERS_TYPES2 = [
      {
        label: $filter('translate')('model.network.flatBufferLabel'),
        value: 'FLAT',
      },
      {
        label: $filter('translate')('model.network.squareBufferLabel'),
        value: 'SQUARE',
      },
      {
        label: $filter('translate')('model.network.roundBufferLabel'),
        value: 'ROUND',
      },
    ];

    var GENERIC_CONFIG = {
      defProjectDist: 10,
      minProject: 10,
      maxProject: 100,
      stepProject: 10,
      projectLayer: null,
      defPropDist: 10,
      minProp: 10,
      maxProp: 100,
      stepProp: 10,
      defBuffer: 10,
      minBuffer: 10,
      maxBuffer: 100,
      stepBuffer: 10,
      typeBuffer: 'ROUND',
    };

    var DEFAULT_CONFIG_TABS = [
      {
        tabId: 'am',
        title: 'model.network.partAmontElements',
        visible: true,
      },
      {
        tabId: 'av',
        title: 'model.network.partAvalElements',
        visible: true,
      },
      {
        tabId: 'el',
        title: 'model.network.allEdgesAndNodes',
        visible: true,
      },
      {
        tabId: 'advam',
        title: 'model.network.amontAdvanceConfig',
        visible: true,
      },
      {
        tabId: 'advav',
        title: 'model.network.avalAdvanceConfig',
        visible: true,
      },
      {
        tabId: 'advel',
        title: 'model.network.advanceConfig',
        visible: true,
      },
    ];

    var DISTANCE_CONFIG_TABS = [
      {
        tabId: 'distgen',
        title: 'model.network.distanceGenConfig',
        visible: true,
      },
      {
        tabId: 'el',
        title: 'model.network.allEdgesAndNodes',
        visible: true,
      },
      {
        tabId: 'am',
        title: 'model.network.partAmontElements',
        visible: false,
      },
      {
        tabId: 'av',
        title: 'model.network.partAvalElements',
        visible: false,
      },
      {
        tabId: 'advam',
        title: 'model.network.amontAdvanceConfig',
        visible: false,
      },
      {
        tabId: 'advav',
        title: 'model.network.avalAdvanceConfig',
        visible: false,
      },
      {
        tabId: 'advel',
        title: 'model.network.advanceConfig',
        visible: false,
      },
    ];

    var AMONT_AVAL_CONFIG_TABS = [
      {
        tabId: 'am',
        title: 'model.network.amontNetStartPathNodes',
        visible: true,
      },
      {
        tabId: 'av',
        title: 'model.network.amontNetStopPathNodes',
        visible: true,
      },
      {
        tabId: 'el',
        title: 'model.network.allAmontNetPathElements',
        visible: true,
      },
      {
        tabId: 'advam',
        title: 'model.network.amontAdvNetStartPathNodes',
        visible: true,
      },
      {
        tabId: 'advav',
        title: 'model.network.amontAdvNetStopPathNodes',
        visible: true,
      },
      {
        tabId: 'advel',
        title: 'model.network.allAdvAmontNetPathElements',
        visible: true,
      },
    ];

    function initConfigs() {
      CONFIG_MAP[DEFAULT_TYPE] = {
        amontElementsTitle: 'model.network.partAmontElements',
        avalElementsTitle: 'model.network.partAvalElements',
        allEdgesAndNodesTitle: 'model.network.allEdgesAndNodes',
        amontAdvElementsTitle: 'model.network.amontAdvanceConfig',
        avalAdvElementsTitle: 'model.network.avalAdvanceConfig',
        allAdvEdgesAndNodesTitle: 'model.network.advanceConfig',
      };

      CONFIG_MAP[NETWORK_AMONT_AVAL_PATH_TYPE] = {
        amontElementsTitle: 'model.network.amontNetStartPathNodes',
        avalElementsTitle: 'model.network.amontNetStopPathNodes',
        allEdgesAndNodesTitle: 'model.network.allAmontNetPathElements',
        amontAdvElementsTitle: 'model.network.amontAdvNetStartPathNodes',
        avalAdvElementsTitle: 'model.network.amontAdvNetStopPathNodes',
        allAdvEdgesAndNodesTitle: 'model.network.allAdvAmontNetPathElements',
      };

      CONFIG_MAP[NETWORK_DISTANCE_PATH_TYPE] = {
        genConfigTitle: 'model.network.distanceGenConfig',
        amontElementsTitle: 'model.network.amontNetStartPathNodes',
        avalElementsTitle: 'model.network.distanceGenConfig',
        allEdgesAndNodesTitle: 'model.network.allAmontNetPathElements',
        amontAdvElementsTitle: 'model.network.amontAdvNetStartPathNodes',
        avalAdvElementsTitle: 'model.network.amontAdvNetStopPathNodes',
        allAdvEdgesAndNodesTitle: 'model.network.allAdvAmontNetPathElements',
      };

      /////////////////////////////////////////////////////////////////////////////////

      GEN_CONFIGS[NETWORK_DISTANCE_PATH_TYPE] = [
        {
          groupTitle: 'model.network.configDefaultProjectDistanceGroupTitle',
          items: [
            {
              title: 'model.network.configDefaultProjectDistanceTitle',
              dataKey: 'defProjectDist',
              type: 'Number',
            },
            {
              title: 'model.network.configMinTitle',
              dataKey: 'minProject',
              type: 'Number',
            },
            {
              title: 'model.network.configMaxTitle',
              dataKey: 'maxProject',
              type: 'Number',
            },
            {
              title: 'model.network.configStepTitle',
              dataKey: 'stepProject',
              type: 'Number',
            },
            {
              title: 'model.network.configPropagationPointsLayer',
              dataKey: 'projectLayer',
              type: 'Layers',
            },
          ],
        },
        {
          groupTitle:
            'model.network.configDefaultPropagationDistanceGroupTitle',
          items: [
            {
              title: 'model.network.configDefaultPropagationDistanceTitle',
              dataKey: 'defPropDist',
              type: 'Number',
            },
            {
              title: 'model.network.configMinTitle',
              dataKey: 'minProp',
              type: 'Number',
            },
            {
              title: 'model.network.configMaxTitle',
              dataKey: 'maxProp',
              type: 'Number',
            },
            {
              title: 'model.network.configStepTitle',
              dataKey: 'stepProp',
              type: 'Number',
            },
          ],
        },
        {
          groupTitle: 'model.network.configDefaultPropagationBufferGroupTitle',
          items: [
            {
              title: 'model.network.configDefaultPropagationBufferTitle',
              dataKey: 'defBuffer',
              type: 'Number',
            },
            {
              title: 'model.network.configMinTitle',
              dataKey: 'minBuffer',
              type: 'Number',
            },
            {
              title: 'model.network.configMaxTitle',
              dataKey: 'maxBuffer',
              type: 'Number',
            },
            {
              title: 'model.network.configStepTitle',
              dataKey: 'stepBuffer',
              type: 'Number',
            },
            {
              title: 'model.network.configDefaultPropagationBufferTypeTitle',
              dataKey: 'typeBuffer',
              type: 'Select',
              dataSource: BUFFERS_TYPES,
            },
          ],
        },
      ];
    }

    var CONFIG_MAP = {};
    var GEN_CONFIGS = {};
    initConfigs();

    var NETWORK_TOOL_TEMPLATE = {
      class: '',
      toolType: '',
      label: '',
      conf: {},
      amontElementsData: {},
      avalElementsData: {},
      edgesAndNodesData: {},
      currentEditFType: null,
      currentEditFTypeAttribute: null,
      currentEditFTypeAttributeValues: {},
      currentAmontEditFType: null,
      currentAmontEditFTypeAttribute: null,
      currentAmontEditFTypeAttributeValues: {},
      currentAvalEditFType: null,
      currentAvalEditFTypeAttribute: null,
      currentAvalEditFTypeAttributeValues: {},
    };

    var NOEUD_AMONT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudamont.png',
        })
      ),
    });

    var NOEUD_AVAL_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudaval.png',
        })
      ),
    });

    var BARRIER_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          opacity: 0.75,
          src: 'img/widget/network/barrier.png',
        })
      ),
    });

    var PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        color: '#ffcc33',
        width: 3,
      }),
    });

    var geoJsoNFormat = new ol.format.GeoJSON();

    return {
      templateUrl: 'js/XG/widgets/mapapp/network/views/networkWidget.html',

      restrict: 'AE',
      link: function(scope, element, attrs, ctrl) {
        scope.tabsDifferentOrder = false;
        var lastConfigDialog = null;
        var lastConfigTool = null;
        scope.currentNetworkToolToConfig = null;
        scope.currentNetworkToolIndex = 0;
        scope.lastDPath = {
          fullData: {},
          featureCollectionData: {},
          nFeatureCollectionData: {},
        };

        scope.lastAPath = {
          fullData: {},
          resumeData: {},
          nResumeData: {},
        };

        scope.lastXPath = {
          fullData: {},
          resumeData: {},
          nResumeData: {},
        };

        scope.lastDistPath = {
          fullData: {},
          resumeData: {},
          nResumeData: {},
        };

        scope.configIsLoaded = false;
        scope.noeudAmontState = false;
        scope.noeudAvalState = false;
        scope.lastDirectedPathState = false;
        scope.addBarrier = false;
        scope.selectedNetwork = null;

        scope.networkTools = [];

        scope.elementsFeatureTypes = [];
        scope.nodesFeatureTypes = [];
        scope.edgesFeatureTypes = [];

        scope.networkNodesFeatureTypes = [];
        scope.networkEdgesFeatureTypes = [];
        scope.networkElementsFeatureTypes = [];

        scope.advanceSelectedType = null;
        scope.advanceSelectedTypeAttribute = null;

        scope.advanceSelectedAttributes = [];
        scope.advanceAmontSelectedAttributes = [];
        scope.advanceAvalSelectedAttributes = [];

        scope.res = {};

        scope.configTabs = DEFAULT_CONFIG_TABS;

        function setConfigTabs() {
          switch (scope.currentNetworkToolToConfig.toolType) {
            case NETWORK_AMONT_AVAL_PATH_TYPE:
              scope.configTabs = AMONT_AVAL_CONFIG_TABS;
              scope.tabsDifferentOrder = false;
              break;
            case NETWORK_DISTANCE_PATH_TYPE:
              scope.configTabs = DISTANCE_CONFIG_TABS;
              scope.tabsDifferentOrder = true;
              break;
            default:
              scope.configTabs = DEFAULT_CONFIG_TABS;
              scope.tabsDifferentOrder = false;
          }

          scope.configTabs.activeTab = '0';
        }

        scope.dropdown = [
          {
            text:
              "<i class='fa fa-random'></i>" +
              $filter('translate')(
                'model.network.networkDirectedPathToolLabel'
              ),
            click: 'addAssistedNetworkTool()',
          },
          {
            text:
              "<i class='fa fa-crop'></i> " +
              $filter('translate')('model.network.networkFastPathToolLabel'),
            click: 'addFastNetworkTool()',
          },
          {
            text:
              "<i class='fa fa-code-fork'></i>" +
              $filter('translate')(
                'model.network.networkSelectSubNetworkToolLabel'
              ),
            click: 'addSelectSubNetworkTool()',
          },
          {
            text:
              "<i class='fa fa-exchange'></i>" +
              $filter('translate')(
                'model.network.networkAmontAvalNetworkPartToolLabel'
              ),
            click: 'addAmontAvalPartNetworkTool()',
          },
          {
            text:
              "<i class='fa fa-crosshairs'></i>" +
              $filter('translate')(
                'model.network.networkDistancePartToolLabel'
              ),
            click: 'addDistanceNetTool()',
          },
        ];

        scope.$watch('noeudAmontState', function() {
          if (scope.noeudAmontState == true) {
            scope.noeudAvalState = false;
            scope.addBarrier = false;
          }
        });

        scope.$watch('noeudAvalState', function() {
          if (scope.noeudAvalState == true) {
            scope.noeudAmontState = false;
            scope.addBarrier = false;
          }
        });

        scope.$watch('addBarrier', function() {
          if (scope.addBarrier == true) {
            scope.noeudAmontState = false;
            scope.noeudAvalState = false;
          }
        });

        scope.noeudAmont = null;
        scope.noeudAval = null;
        scope.lastFastPath = null;
        scope.barrier = null;
        scope.barriers = [];

        scope.noeudAmontFeature = null;
        scope.noeudAvalFeature = null;
        scope.lastFastPathFeature = null;
        scope.lastDirectedPathFeature = null;
        scope.lastDirectedPathNoeudAmontFeature = null;
        scope.lastDirectedPathNoeudAvalFeature = null;
        scope.lastBarrierFeature = null;
        scope.barriersFeatures = [];

        var map = scope.map;
        var projection = map.getView().getProjection();

        function updateFTypes() {
          scope.featuretypes = FeatureTypeFactory.resources.featuretypes;

          scope.elementsFeatureTypes = [];
          scope.nodesFeatureTypes = [];
          scope.edgesFeatureTypes = [];

          angular.forEach(scope.featuretypes, function(featureType) {
            if (featureType.geographic) {
              if (featureType.typeInfo == 'LINE')
                scope.edgesFeatureTypes.push(featureType);
              else if (featureType.typeInfo == 'POINT')
                scope.nodesFeatureTypes.push(featureType);
              scope.elementsFeatureTypes.push(featureType);
            }
          });

          updateFromWidgetConfig();

          if (scope.selectedNetwork) updateFilteredNodesFeatureTypes();
        }

        function updateFTypesAndProcessNextCallBack(openModal) {
          scope.featuretypes = FeatureTypeFactory.resources.featuretypes;

          scope.elementsFeatureTypes = [];
          scope.nodesFeatureTypes = [];
          scope.edgesFeatureTypes = [];

          angular.forEach(scope.featuretypes, function(featureType) {
            if (featureType.geographic) {
              if (featureType.typeInfo == 'LINE')
                scope.edgesFeatureTypes.push(featureType);
              else if (featureType.typeInfo == 'POINT')
                scope.nodesFeatureTypes.push(featureType);
              scope.elementsFeatureTypes.push(featureType);
            }
          });

          updateFromWidgetConfig();

          if (openModal) openConfigModalCallBack2();
        }

        function openConfigModalCallBack1(openModal) {
          if (scope.allNetworks.length == 0)
            require('toastr').warning('Pas de réseau éxistant .', 'Erreur');
          else {
            if (FeatureTypeFactory.resources.featuretypes.length > 0)
              updateFTypesAndProcessNextCallBack(openModal);
            else
              FeatureTypeFactory.get().then(function() {
                updateFTypesAndProcessNextCallBack(openModal);
              });
          }
        }

        function processToUpdateFTypes(options) {
          if (scope.allNetworks.length == 0)
            require('toastr').warning('Pas de réseau éxistant .', 'Erreur');
          else {
            if (FeatureTypeFactory.resources.featuretypes.length > 0)
              updateFTypes();
            else
              FeatureTypeFactory.get().then(function() {
                updateFTypes();
              });
          }
        }

        function openConfigToolModal() {
          lastConfigTool = ngDialog.open({
            template:
              'js/XG/widgets/mapapp/network/views/networkWidgetToolConfig.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            showClose: false,
            scope: scope,
          });
        }

        function openConfigModalCallBack2() {
          lastConfigDialog = ngDialog.open({
            template:
              'js/XG/widgets/mapapp/network/views/networkWidgetConfig.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            showClose: false,
            scope: scope,
          });
        }

        function loadConfig(callBack, options) {
          if (!scope.configIsLoaded) {
            ConfigFactory.get(CONFIG_TYPE, scope.ConfigName).then(function(
              res
            ) {
              if (res.data == undefined || res.data == '')
                scope.widgetConfig = null;
              else scope.widgetConfig = res.data;

              loadNetworks(callBack);
            });
          } else if (callBack) callBack(options);
        }

        function loadNetworks(callBack) {
          if (NetworkFactory.resources.networks.length == 0) {
            NetworkFactory.get().then(function() {
              scope.allNetworks = NetworkFactory.resources.networks;
              scope.configIsLoaded = true;
              if (callBack) callBack();
            });
          } else {
            scope.allNetworks = NetworkFactory.resources.networks;
            scope.configIsLoaded = true;
            if (callBack) callBack();
          }
        }

        function openConfigModal() {
          loadConfig(openConfigModalCallBack1, true);
        }

        function getFeatureTypeByUID(ftiUID) {
          for (var i = 0; i < scope.elementsFeatureTypes.length; i++) {
            var elementFeatureType = scope.elementsFeatureTypes[i];
            if (elementFeatureType.uid == ftiUID) return elementFeatureType;
          }

          return null;
        }

        function fTypeAttributeValueToMainConf(elementsFilters) {
          var fTypeAttributeValues = {};

          for (var i = 0; i < elementsFilters.length; i++) {
            var elementFilter = elementsFilters[i];
            if (!fTypeAttributeValues.hasOwnProperty(elementFilter.ftiUID))
              fTypeAttributeValues[elementFilter.ftiUID] = [];

            var typeAttributesContainer =
              fTypeAttributeValues[elementFilter.ftiUID];

            for (var j = 0; j < elementFilter.attributesFilters.length; j++) {
              var attributeFilter = elementFilter.attributesFilters[j];
              var attributeId = Math.floor(Math.random() * 1000);

              var attributeItem = {
                attributeId: attributeId,
                attributeName: attributeFilter.attrName,
                res: {},
              };
              attributeItem.res[attributeFilter.attrName] =
                attributeFilter.value;
              typeAttributesContainer.push(attributeItem);
            }
          }

          return fTypeAttributeValues;
        }

        function networkToolConfigToNetToolData(networkToolConf) {
          var toolTemplate = angular.copy(NETWORK_TOOL_TEMPLATE);
          var networkToolConfigMap = CONFIG_MAP.hasOwnProperty(
            networkToolConf.toolType
          )
            ? CONFIG_MAP[networkToolConf.toolType]
            : CONFIG_MAP[DEFAULT_TYPE];

          switch (networkToolConf.toolType) {
            case NETWORK_DIRECTED_TYPE:
              toolTemplate.class = NETWORK_DIRECTED_PATH_CLASS;
              break;
            case NETWORK_FAST_PATH_TYPE:
              toolTemplate.class = NETWORK_FAST_PATH_CLASS;
              break;
            case NETWORK_AMONT_AVAL_PATH_TYPE:
              toolTemplate.class = NETWORK_FAST_PATH_CLASS;
              break;
            case NETWORK_DISTANCE_PATH_TYPE:
              toolTemplate.class = NETWORK_DISTANCE_PATH_CLASS;
              break;
            default:
              toolTemplate.class = NETWORK_CROPPED_PATH_CLASS;
          }

          toolTemplate.toolType = networkToolConf.toolType;
          toolTemplate.label = networkToolConf.label;
          toolTemplate.addPathAtEnd =
            networkToolConf.toolType == NETWORK_CROPPED_TYPE;

          var amontLeftData = [];
          for (var i = 0; i < networkToolConf.amontElements.length; i++) {
            var amontElementUID = networkToolConf.amontElements[i];
            var amontFeatureType = getFeatureTypeByUID(amontElementUID);
            if (amontFeatureType) amontLeftData.push(amontFeatureType);
          }

          var avalLeftData = [];
          for (var i = 0; i < networkToolConf.avalElements.length; i++) {
            var avalElementUID = networkToolConf.avalElements[i];
            var avalFeatureType = getFeatureTypeByUID(avalElementUID);
            if (avalFeatureType) avalLeftData.push(avalFeatureType);
          }

          var edgesAndNodesLeftData = [];
          for (var i = 0; i < networkToolConf.networkElements.length; i++) {
            var netElementUID = networkToolConf.networkElements[i];
            var netFeatureType = getFeatureTypeByUID(netElementUID);
            if (netFeatureType) edgesAndNodesLeftData.push(netFeatureType);
          }

          toolTemplate.amontElementsData = {
            leftData: amontLeftData,
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.networkNodesFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: networkToolConfigMap['amontElementsTitle'],
            rightTitle: 'model.network.allElements',
            source: 'right',
          };

          toolTemplate.avalElementsData = {
            leftData: avalLeftData,
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.networkNodesFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: networkToolConfigMap['avalElementsTitle'],
            rightTitle: 'model.network.allElements',
            source: 'right',
          };

          toolTemplate.edgesAndNodesData = {
            leftData: edgesAndNodesLeftData,
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.networkElementsFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: networkToolConfigMap['allEdgesAndNodesTitle'],
            rightTitle: 'model.network.allEdgesAndNodes',
            source: 'right',
          };

          toolTemplate.currentAmontEditFTypeAttributeValues = fTypeAttributeValueToMainConf(
            networkToolConf.amontElementsFilters
          );
          toolTemplate.currentAvalEditFTypeAttributeValues = fTypeAttributeValueToMainConf(
            networkToolConf.avalElementsFilters
          );
          toolTemplate.currentEditFTypeAttributeValues = fTypeAttributeValueToMainConf(
            networkToolConf.networkElementsFilters
          );

          toolTemplate.genericConfig = networkToolConf.genericConfig;

          if (GEN_CONFIGS.hasOwnProperty(networkToolConf.toolType))
            toolTemplate.genConfigModel = GEN_CONFIGS[networkToolConf.toolType];
          // console.log(toolTemplate);
          return toolTemplate;
        }

        function updateFromWidgetConfig() {
          if (scope.widgetConfig != null) {
            for (var i = 0; i < scope.allNetworks.length; i++) {
              var network = scope.allNetworks[i];
              if (
                network.uid == scope.widgetConfig.networkUID &&
                network.name == scope.widgetConfig.networkName
              ) {
                scope.selectedNetwork = network;
                break;
              }
            }

            if (
              scope.selectedNetwork != null &&
              scope.widgetConfig.networkTools != null &&
              scope.widgetConfig.networkTools.length > 0
            ) {
              scope.networkTools = [];

              for (var i = 0; i < scope.widgetConfig.networkTools.length; i++) {
                var networkToolConf = scope.widgetConfig.networkTools[i];
                var networkTool = networkToolConfigToNetToolData(
                  networkToolConf
                );

                scope.networkTools.push(networkTool);
              }
            }
          }
        }

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function cancelNetworkWidgetConfig() {
          loadConfig(openConfigModalCallBack1, false);
          lastConfigDialog.close();
        }

        function handleCloseToolConfig() {
          scope.currentNetworkToolIndex = 0;
          scope.currentNetworkToolToConfig = null;
          lastConfigTool.close();
        }

        function handleSaveToolConfig() {
          scope.networkTools[scope.currentNetworkToolIndex] =
            scope.currentNetworkToolToConfig;
          handleCloseToolConfig();
        }

        function saveNetworkWidgetConfig2() {
          //console.log(scope.networkTools);
          console.log(scope.networkTools);
        }

        function saveNetworkWidgetConfig() {
          var networkWidgetConfig = {
            networkUID: scope.selectedNetwork.uid,
            networkName: scope.selectedNetwork.name,
            networkTools: [],
          };

          angular.forEach(scope.networkTools, function(networkTool) {
            var networkToolConfig = {
              label: networkTool.label,
              toolType: networkTool.toolType,
              amontElements: [],
              avalElements: [],
              networkElements: [],
              amontElementsFilters: [],
              avalElementsFilters: [],
              networkElementsFilters: [],
            };

            var amontElementsConfigPart = dataToSavePartConfig(
              networkTool.amontElementsData
            );
            var avalElementsConfigPart = dataToSavePartConfig(
              networkTool.avalElementsData
            );
            var networkElementsConfigPart = dataToSavePartConfig(
              networkTool.edgesAndNodesData
            );

            networkToolConfig.amontElements = amontElementsConfigPart;
            networkToolConfig.avalElements = avalElementsConfigPart;
            networkToolConfig.networkElements = networkElementsConfigPart;

            var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
              networkTool.currentAmontEditFTypeAttributeValues
            );
            var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
              networkTool.currentAvalEditFTypeAttributeValues
            );
            var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
              networkTool.currentEditFTypeAttributeValues
            );

            networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
            networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
            networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

            networkToolConfig.genericConfig = networkTool.genericConfig;
            networkWidgetConfig.networkTools.push(networkToolConfig);
          });

          scope.widgetConfig = networkWidgetConfig;
          //scope.networkTools = networkWidgetConfig.networkTools;

          ConfigFactory.add(
            scope.widgetConfig,
            CONFIG_TYPE,
            scope.ConfigName
          ).then(
            function(res) {
              //require('toastr').success(res.data);
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );

          lastConfigDialog.close();
        }

        function isNetworkType(types, featureType) {
          for (var i = 0; i < types.length; i++) {
            var networkElType = types[i];
            if (networkElType.ftiUID == featureType.uid) return true;
          }

          return false;
        }

        function updateFilteredNodesFeatureTypes() {
          scope.networkNodesFeatureTypes = [];
          scope.networkEdgesFeatureTypes = [];
          scope.networkElementsFeatureTypes = [];

          angular.forEach(scope.nodesFeatureTypes, function(nodeFeatureType) {
            if (
              isNetworkType(scope.selectedNetwork.nodesTypes, nodeFeatureType)
            ) {
              scope.networkNodesFeatureTypes.push(nodeFeatureType);
              scope.networkElementsFeatureTypes.push(nodeFeatureType);
            }
          });

          angular.forEach(scope.edgesFeatureTypes, function(edgeFeatureType) {
            if (
              isNetworkType(scope.selectedNetwork.edgesTypes, edgeFeatureType)
            ) {
              scope.networkEdgesFeatureTypes.push(edgeFeatureType);
              scope.networkElementsFeatureTypes.push(edgeFeatureType);
            }
          });
        }

        function addNetworkTool(
          networkToolClass,
          networkToolType,
          networkToolLabel
        ) {
          var toolTemplate = angular.copy(NETWORK_TOOL_TEMPLATE);
          toolTemplate.class = networkToolClass;
          toolTemplate.toolType = networkToolType;
          toolTemplate.label = networkToolLabel;

          var networkToolConfigMap = CONFIG_MAP.hasOwnProperty(networkToolType)
            ? CONFIG_MAP[networkToolType]
            : CONFIG_MAP[DEFAULT_TYPE];

          toolTemplate.amontElementsData = {
            leftData: [],
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.networkNodesFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: networkToolConfigMap['amontElementsTitle'],
            rightTitle: 'model.network.allElements',
            source: 'right',
          };

          toolTemplate.avalElementsData = {
            leftData: [],
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.networkNodesFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: networkToolConfigMap['avalElementsTitle'],
            rightTitle: 'model.network.allElements',
            source: 'right',
          };

          toolTemplate.edgesAndNodesData = {
            leftData: [],
            leftDisplayAttribute: 'name',
            rightData: angular.copy(scope.networkElementsFeatureTypes),
            rightDisplayAttribute: 'name',
            leftTitle: networkToolConfigMap['allEdgesAndNodesTitle'],
            rightTitle: 'model.network.allEdgesAndNodes',
            source: 'right',
          };

          toolTemplate.genericConfig = angular.copy(GENERIC_CONFIG);

          if (GEN_CONFIGS.hasOwnProperty(networkToolType))
            toolTemplate.genConfigModel = GEN_CONFIGS[networkToolType];
          console.log(toolTemplate.genConfigModel);
          scope.networkTools.push(toolTemplate);

          scope.currentNetworkToolIndex = scope.networkTools.length - 1;
          scope.currentNetworkToolToConfig = angular.copy(toolTemplate);
          setConfigTabs();
          openConfigToolModal();
        }

        function findLayerByName(layerName, layersArray) {
          for (var i = 0; i < layersArray.length; i++) {
            var layer = layersArray[i];

            var loopLayerName = layer.name;

            if (loopLayerName == layerName) {
              return layer;
            }
          }

          return null;
        }

        loadConfig(processToUpdateFTypes);

        scope.noeudAmontSelected = function() {
          var olGeometry = geoJsoNFormat.readGeometry(
            scope.noeudAmont.geometry
          );
          scope.noeudAmontFeature = new ol.Feature({
            name: '',
            geometry: olGeometry,
          });
          scope.noeudAmontFeature.setId('noeudAmontFeature');
          scope.noeudAmontFeature.setStyle(NOEUD_AMONT_STYLE);

          if (scope.noeudAmontFeature != undefined)
            gclayers.removehighLightFeatures(scope.noeudAmontFeature);

          gclayers.addhighLightFeature(scope.noeudAmontFeature);
        };

        scope.noeudAvalSelected = function() {
          var olGeometry = geoJsoNFormat.readGeometry(scope.noeudAval.geometry);
          scope.noeudAvalFeature = new ol.Feature({
            name: '',
            geometry: olGeometry,
          });
          scope.noeudAvalFeature.setId('noeudAvalFeature');
          scope.noeudAvalFeature.setStyle(NOEUD_AVAL_STYLE);

          if (scope.noeudAvalFeature != undefined)
            gclayers.removehighLightFeatures(scope.noeudAvalFeature);

          gclayers.addhighLightFeature(scope.noeudAvalFeature);
        };

        scope.lastAPathUpdated = function() {
          var lastAPathFeatureCollection = scope.lastAPath.resumeData;
          SelectManager.addFeaturesFromGeojson(lastAPathFeatureCollection);
          SelectManager.openpop(scope);
          //console.log(scope.lastAPath.nResumeData);
        };

        scope.lastXPathUpdated = function() {
          var lastXPathFeatureCollection = scope.lastXPath.resumeData;
          SelectManager.addFeaturesFromGeojson(lastXPathFeatureCollection);
          SelectManager.openpop(scope);
          //console.log(scope.lastXPath.nResumeData);
        };

        scope.lastDistPathUpdated = function() {
          var lastDistPathFeatureCollection = scope.lastDistPath.resumeData;
          SelectManager.addFeaturesFromGeojson(lastDistPathFeatureCollection);
          SelectManager.openpop(scope);
          //console.log(scope.lastDistPath.nResumeData);
        };

        scope.lastDPathFound = function() {
          var lastPathFeatureCollection = scope.lastDPath.featureCollectionData;
          SelectManager.addFeaturesFromGeojson(lastPathFeatureCollection);
          SelectManager.openpop(scope);
          /*var olNoeudAmontGeometry = geoJsoNFormat.readGeometry(lastPath.startPathNode.geometry);
                    scope.lastDirectedPathNoeudAmontFeature = new ol.Feature({
                        'name': '',
                        'geometry': olNoeudAmontGeometry
                    });
                    scope.lastDirectedPathNoeudAmontFeature.setId("lastDirectedPathNoeudAmontFeature");
                    scope.lastDirectedPathNoeudAmontFeature.setStyle(NOEUD_AMONT_STYLE);

                    if (scope.lastDirectedPathNoeudAmontFeature != undefined)
                        gclayers.removehighLightFeatures(scope.lastDirectedPathNoeudAmontFeature);

                    gclayers.addhighLightFeature(scope.lastDirectedPathNoeudAmontFeature);

                    var olNoeudAvalGeometry = geoJsoNFormat.readGeometry(lastPath.endPathNode.geometry);
                    scope.lastDirectedPathNoeudAvalFeature = new ol.Feature({
                        'name': '',
                        'geometry': olNoeudAvalGeometry
                    });
                    scope.lastDirectedPathNoeudAvalFeature.setId("lastDirectedPathNoeudAvalFeature");
                    scope.lastDirectedPathNoeudAvalFeature.setStyle(NOEUD_AVAL_STYLE);

                    if (scope.lastDirectedPathNoeudAvalFeature != undefined)
                        gclayers.removehighLightFeatures(scope.lastDirectedPathNoeudAvalFeature);

                    gclayers.addhighLightFeature(scope.lastDirectedPathNoeudAvalFeature);

                    var olPathGeometry = lastPath.path.olGeometry
                    scope.lastDirectedPathFeature = new ol.Feature({
                        'name': '',
                        'geometry': olPathGeometry
                    });
                    scope.lastDirectedPathFeature.setId("lastDirectedPathFeature");
                    scope.lastDirectedPathFeature.setStyle(PATH_STYLE);

                    if (scope.lastDirectedPathFeature != undefined)
                        gclayers.removehighLightFeatures(scope.lastDirectedPathFeature);

                    gclayers.addhighLightFeature(scope.lastDirectedPathFeature);*/
        };

        scope.lastDirectedPathFound = function() {
          var olNoeudAmontGeometry = geoJsoNFormat.readGeometry(
            scope.lastDirectedPath.startPathNode.geometry
          );
          scope.lastDirectedPathNoeudAmontFeature = new ol.Feature({
            name: '',
            geometry: olNoeudAmontGeometry,
          });
          scope.lastDirectedPathNoeudAmontFeature.setId(
            'lastDirectedPathNoeudAmontFeature'
          );
          scope.lastDirectedPathNoeudAmontFeature.setStyle(NOEUD_AMONT_STYLE);

          if (scope.lastDirectedPathNoeudAmontFeature != undefined)
            gclayers.removehighLightFeatures(
              scope.lastDirectedPathNoeudAmontFeature
            );

          gclayers.addhighLightFeature(scope.lastDirectedPathNoeudAmontFeature);

          var olNoeudAvalGeometry = geoJsoNFormat.readGeometry(
            scope.lastDirectedPath.endPathNode.geometry
          );
          scope.lastDirectedPathNoeudAvalFeature = new ol.Feature({
            name: '',
            geometry: olNoeudAvalGeometry,
          });
          scope.lastDirectedPathNoeudAvalFeature.setId(
            'lastDirectedPathNoeudAvalFeature'
          );
          scope.lastDirectedPathNoeudAvalFeature.setStyle(NOEUD_AVAL_STYLE);

          if (scope.lastDirectedPathNoeudAvalFeature != undefined)
            gclayers.removehighLightFeatures(
              scope.lastDirectedPathNoeudAvalFeature
            );

          gclayers.addhighLightFeature(scope.lastDirectedPathNoeudAvalFeature);

          var olPathGeometry = scope.lastDirectedPath.path.olGeometry;
          scope.lastDirectedPathFeature = new ol.Feature({
            name: '',
            geometry: olPathGeometry,
          });
          scope.lastDirectedPathFeature.setId('lastDirectedPathFeature');
          scope.lastDirectedPathFeature.setStyle(PATH_STYLE);

          if (scope.lastDirectedPathFeature != undefined)
            gclayers.removehighLightFeatures(scope.lastDirectedPathFeature);

          gclayers.addhighLightFeature(scope.lastDirectedPathFeature);
        };

        scope.lastFastPathFound = function() {
          var olGeometry = geoJsoNFormat.readGeometry(
            scope.lastFastPath.geometry
          );
          scope.lastFastPathFeature = new ol.Feature({
            name: '',
            geometry: olGeometry,
          });
          scope.lastFastPathFeature.setId('lastFastPathFeature');
          scope.lastFastPathFeature.setStyle(PATH_STYLE);

          if (scope.lastFastPathFeature != undefined)
            gclayers.removehighLightFeatures(scope.lastFastPathFeature);

          gclayers.addhighLightFeature(scope.lastFastPathFeature);
        };

        scope.barrierAdded = function() {
          scope.barriers.push(scope.barrier.edge);
          var olGeometry = geoJsoNFormat.readGeometry(scope.barrier.hitPoint);
          scope.lastBarrierFeature = new ol.Feature({
            name: '',
            geometry: olGeometry,
          });
          scope.lastBarrierFeature.setId('lastBarrierFeature');
          scope.lastBarrierFeature.setStyle(BARRIER_STYLE);

          gclayers.addhighLightFeature(scope.lastBarrierFeature);
        };

        scope.configNetworkWidget = function() {
          openConfigModal();
        };

        scope.configNetworkTool = function(networkTool, index) {
          scope.currentNetworkToolIndex = index;
          scope.currentNetworkToolToConfig = angular.copy(networkTool);
          setConfigTabs();
          openConfigToolModal();
        };

        scope.saveNetworkConfig = function() {
          saveNetworkWidgetConfig();
        };

        scope.addSelectSubNetworkTool = function() {
          addNetworkTool(
            NETWORK_CROPPED_PATH_CLASS,
            NETWORK_CROPPED_TYPE,
            'model.network.networkSelectSubNetworkToolLabel'
          );
        };

        scope.addAssistedNetworkTool = function() {
          addNetworkTool(
            NETWORK_DIRECTED_PATH_CLASS,
            NETWORK_DIRECTED_TYPE,
            'model.network.networkDirectedPathToolLabel'
          );
        };

        scope.addFastNetworkTool = function() {
          addNetworkTool(
            NETWORK_FAST_PATH_CLASS,
            NETWORK_FAST_PATH_TYPE,
            'model.network.networkFastPathToolLabel'
          );
        };

        scope.addDistanceNetTool = function() {
          addNetworkTool(
            NETWORK_DISTANCE_PATH_CLASS,
            NETWORK_DISTANCE_PATH_TYPE,
            'model.network.networkDistancePartToolLabel'
          );
        };

        scope.addAmontAvalPartNetworkTool = function() {
          addNetworkTool(
            NETWORK_AMONT_AVAL_PATH_CLASS,
            NETWORK_AMONT_AVAL_PATH_TYPE,
            'model.network.networkAmontAvalNetworkPartToolLabel'
          );
        };

        scope.networkChange = function(selNetwork) {
          scope.selectedNetwork = selNetwork;
          scope.networkTools = [];

          if (scope.selectedNetwork) updateFilteredNodesFeatureTypes();
        };

        scope.removeNetworkTool = function(networkTool) {
          var networkToolIndex = scope.networkTools.indexOf(networkTool);
          scope.networkTools.splice(networkToolIndex, 1);
        };

        scope.advanceChooseType = function(networkTool) {
          if (networkTool != null && networkTool.currentEditFType != null) {
            scope.advanceSelectedAttributes =
              networkTool.currentEditFType.attributes;
          } else scope.advanceSelectedAttributes = [];
        };

        scope.addNetworkAttributeField = function(networkTool) {
          if (
            !networkTool.currentEditFTypeAttributeValues.hasOwnProperty(
              networkTool.currentEditFType.uid
            )
          )
            networkTool.currentEditFTypeAttributeValues[
              networkTool.currentEditFType.uid
            ] = [];

          var typeAttributesContainer =
            networkTool.currentEditFTypeAttributeValues[
              networkTool.currentEditFType.uid
            ];
          var attributeId = Math.floor(Math.random() * 1000);

          var attributeItem = {
            attributeId: attributeId,
            attributeName: networkTool.currentEditFTypeAttribute.name,
          };

          //attributeItem.res[networkTool.currentEditFTypeAttribute.name] = ''null'';

          typeAttributesContainer.push(attributeItem);
        };

        scope.removeNetworkAttributeField = function(
          networkTool,
          attributeItem
        ) {
          var attributeItemIndex = networkTool.currentEditFTypeAttributeValues[
            networkTool.currentEditFType.uid
          ].indexOf(attributeItem);
          networkTool.currentEditFTypeAttributeValues[
            networkTool.currentEditFType.uid
          ].splice(attributeItemIndex, 1);
        };

        scope.advanceAmontChooseType = function(networkTool) {
          if (
            networkTool != null &&
            networkTool.currentAmontEditFType != null
          ) {
            scope.advanceAmontSelectedAttributes =
              networkTool.currentAmontEditFType.attributes;
          } else scope.advanceAmontSelectedAttributes = [];
        };

        scope.addAmontNetworkAttributeField = function(networkTool) {
          if (
            !networkTool.currentAmontEditFTypeAttributeValues.hasOwnProperty(
              networkTool.currentAmontEditFType.uid
            )
          )
            networkTool.currentAmontEditFTypeAttributeValues[
              networkTool.currentAmontEditFType.uid
            ] = [];

          var typeAttributesContainer =
            networkTool.currentAmontEditFTypeAttributeValues[
              networkTool.currentAmontEditFType.uid
            ];
          var attributeId = Math.floor(Math.random() * 1000);

          var attributeItem = {
            attributeId: attributeId,
            attributeName: networkTool.currentAmontEditFTypeAttribute.name,
          };

          //attributeItem.res[networkTool.currentEditFTypeAttribute.name] = ''null'';

          typeAttributesContainer.push(attributeItem);
        };

        scope.removeAmontNetworkAttributeField = function(
          networkTool,
          attributeItem
        ) {
          var attributeItemIndex = networkTool.currentAmontEditFTypeAttributeValues[
            networkTool.currentAmontEditFType.uid
          ].indexOf(attributeItem);
          networkTool.currentAmontEditFTypeAttributeValues[
            networkTool.currentAmontEditFType.uid
          ].splice(attributeItemIndex, 1);
        };

        scope.advanceAvalChooseType = function(networkTool) {
          if (networkTool != null && networkTool.currentAvalEditFType != null) {
            scope.advanceAvalSelectedAttributes =
              networkTool.currentAvalEditFType.attributes;
          } else scope.advanceAvalSelectedAttributes = [];
        };

        scope.addAvalNetworkAttributeField = function(networkTool) {
          if (
            !networkTool.currentAvalEditFTypeAttributeValues.hasOwnProperty(
              networkTool.currentAvalEditFType.uid
            )
          )
            networkTool.currentAvalEditFTypeAttributeValues[
              networkTool.currentAvalEditFType.uid
            ] = [];

          var typeAttributesContainer =
            networkTool.currentAvalEditFTypeAttributeValues[
              networkTool.currentAvalEditFType.uid
            ];
          var attributeId = Math.floor(Math.random() * 1000);

          var attributeItem = {
            attributeId: attributeId,
            attributeName: networkTool.currentAvalEditFTypeAttribute.name,
          };

          //attributeItem.res[networkTool.currentEditFTypeAttribute.name] = ''null'';

          typeAttributesContainer.push(attributeItem);
        };

        scope.removeAvalNetworkAttributeField = function(
          networkTool,
          attributeItem
        ) {
          var attributeItemIndex = networkTool.currentAvalEditFTypeAttributeValues[
            networkTool.currentAvalEditFType.uid
          ].indexOf(attributeItem);
          networkTool.currentAvalEditFTypeAttributeValues[
            networkTool.currentAvalEditFType.uid
          ].splice(attributeItemIndex, 1);
        };

        scope.cancelNetworkConfig = function() {
          cancelNetworkWidgetConfig();
        };

        scope.cancelToolConfig = function() {
          handleCloseToolConfig();
        };

        scope.saveToolConfig = function() {
          handleSaveToolConfig();
        };

        scope.testMe = function() {
          console.log(scope.configTabs.activeTab);
        };

        /*
                Just to test networks directive
                scope.ssNetwork = {};
                scope.ssNetworkSelected = function() {
                    console.log(scope.ssNetwork);
                };
                */
      },
    };
  };

  networkwidget.$inject = [
    'gclayers',
    'NetworkFactory',
    'FeatureTypeFactory',
    'ConfigFactory',
    'SelectManager',
    'ngDialog',
    '$filter',
    '$translate',
  ];
  return networkwidget;
});
