'use strict';
define(function() {
  var magicDockWidget = function(
    gcPopup,
    ConfigFactory,
    ngDialog,
    FeatureTypeFactory,
    gclayers,
    $rootScope,
    MajicFactory,
    $timeout
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/majic/views/majicDockWidget.html',
      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        /**
         * Open the widget into a popup.
         *
         * @returns {undefined}
         */
        scope.majicPopup = undefined;

        scope.openWidget = function() {
          // -- Si on a déjà ouvert une fenêtre majic depuis le
          // sélecteur d'objet, on le ferme.
          if (scope.majicPopup != undefined) {
            scope.majicPopup.destroy();
            scope.majicPopup = undefined;
          }
          $rootScope.$broadcast('pleaseRemoveExistingMajicForm', {
            id: 'majicWidgets',
          });
          scope.majicPopup = gcPopup.open({
            scope: scope,
            title: 'Majic',
            template: 'js/XG/widgets/mapapp/majic/views/majicwidget.html',
            showClose: true,
            minimizeMaximize: true,
            resizable: true,
            onclose: function() {
              gclayers.getselectSource().clear();
              gclayers.clearhighLightFeatures();
            },
          });
          $timeout(()=>{
            MajicFactory.setInitPopupWidthAndMinWidth('consult')
          }, 400);
        };

        // -- On peut ouvrir une fiche majic depuis le "i rouge",
        // -- dans ce cas, pour éviter d'avoir plusieur fenêtre
        // -- majic à l'écran, on demande à effacer toute fiche majic
        // -- déjà dans lapage Web.
        scope.$on('pleaseRemoveExistingMajicForm', function(context, origin) {
          if (origin.id != 'majicWidgets')
            if (scope.majicPopup != undefined) {
              scope.majicPopup.destroy();
              scope.majicPopup = undefined;
            }
        });

        // ////////////////////////////////////////////////////////////
        // Gestion de la configuration
        // ///////////////////////////////////////////////////////////
        scope.MatCadReportName = 'MatCad';
        scope.RelPropReportName = 'RelProp';
        scope.parcelles_uid = '';
        scope.ftisid = undefined;
        scope.parcelleIdName = '';

        scope.config = {
          reports: {
            MatCad: '',
            RelProp: '',
          },
          parcelles_uid: '',
          parcelleIdName: '',
        };

        if (FeatureTypeFactory.resources.featuretypes.length > 0) {
          scope.features = FeatureTypeFactory.resources.featuretypes;
        } else {
          FeatureTypeFactory.get().then(function() {
            scope.features = FeatureTypeFactory.resources.featuretypes;
          });
        }

        scope.getFeatureAttributes = function(feature_uid) {
          if (feature_uid == null) return;
          for (var i = 0; i < scope.features.length; i++) {
            if (scope.features[i].uid == feature_uid) {
              scope.parcAttributes = scope.features[i].attributes;
              break;
            }
          }
        };

        /**
         * Lit les données depuis la configuration.
         *
         * @returns {undefined}
         */
        scope.readConfig = function() {

          // Nom des rapports Jasper
          const reportsNames = MajicFactory.getReportNames(scope.config);
          if (reportsNames.has('MatCadReportName')){
            scope.MatCadReportName = reportsNames.get('MatCadReportName');
          }
          if (reportsNames.has('RelPropReportName')){
            scope.RelPropReportName = reportsNames.get('RelPropReportName');
          }

          // Identifiant (uid) de la layer parcelles publié par
          // Geoserver.
          scope.parcelles_uid = scope.config['parcelles_uid'];
          // ftisid : propriété du composant de selection spatial
          // (gcselect)
          scope.ftisid = [scope.parcelles_uid];

          // Nom de l'attribut utilisé en tant qu'identifiant de
          // parcelle
          scope.parcelleIdName = scope.config['parcelleIdName'];
        };

        /**
         * Récupère et charge la configuration depuis le fichier.
         *
         * @returns {undefined}
         */

        scope.getConfig = function() {
          ConfigFactory.get('widgets', 'majic').then(
            function(res) {
              if (res.data != '') {
                scope.config = res.data;
                console.info('Configuration de Majic chargée.');
              }
              scope.readConfig();
            },
            function(reason) {
              console.error('Configuration de Majic non chargée:' + reason);
            }
          );
        };
        scope.$on('openTools_majicdockwidget', () => {
          scope.getConfig();
        });

        /**
         * Ouvre une fenetre de consultation et de modification de la
         * configuration.
         *
         * @returns {undefined}
         *
         */
        var ngDialogPromise;
        scope.openConfig = function() {
          ngDialogPromise = ngDialog.openConfirm({
            template: 'js/XG/widgets/mapapp/majic/views/configuration.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            scope: scope,
          });
          ngDialogPromise.then(
            function(data) {
              scope.saveconfig();
              require('toastr').info(data);
            },
            function(data) {
              scope.getConfig();
              require('toastr').info(data);
            }
          );
        };

        /**
         * Sauve la configuration dans le fichier.
         *
         * @returns {undefined}
         */
        scope.saveconfig = function() {
          ConfigFactory.add(scope.config, 'widgets', 'majic').then(
            function(res) {
              scope.readConfig();
              require('toastr').success(res.data);
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };

        /**
         * A chaque mise à jour du dom,
         * renvoie true si la largeur de la popup est inférieure à 780px
         * ajoute des modifications de mise en page spécifique suivant l'onglet
         * et la largeur de la popup
         * @param viewMode search/consult...
         * @return {boolean} est true si la largeur de la popup est inférieure à 780px
         */
        scope.adaptPopupSizeByViewMode = (viewMode) => {
          return MajicFactory.adaptPopupSizeByViewMode(viewMode);
        };
      },
    };
  };

  magicDockWidget.$inject = [
    'gcPopup',
    'ConfigFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'gclayers',
    '$rootScope',
    'MajicFactory',
    '$timeout'
  ];

  return magicDockWidget;
});
