'use strict';
define(function() {
  var toolbarextractcoordinates = function(
    $http,
    SelectManager,
    gclayers,
    gcPopup,
    $filter,
    gcInteractions,
    $rootScope,
    ngDialog,
    SridFactory,
    extractCoordsService
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/extractcoordinates/views/toolbarextractcoordinates.html',
      restrict: 'AE',

      link: function(scope, element) {
        scope.isActive = false;

        scope.altKeyPressed = false;
        var btnElt = $(element[0]);

        scope.$on('closeToolsBar_toolbarextractcoordinates', () => {
          if (scope.pointerByPoint.getActive()) {
            deactivate();
          }
        });

        btnElt.bind('click', () => {
          if (scope.pointerByPoint.getActive()) {
            deactivate();
          } else {
            activate();
          }
        });

        const activate = () => {
          scope.projectionEdit();
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.pointerByPoint.setActive(true);
          scope.map.addInteraction(scope.pointerByPoint);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(
              'toolbarextractcoordinates'
            );
          }
        }

        const deactivate = () => {
          scope.pointerByPoint.setActive(false);
          scope.map.removeInteraction(scope.pointerByPoint);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(undefined);
          }
          removeOverlay();
        }

        var addedoverlay = false;
        var overlay;

        const uniqid = 'textpopup_' + Date.now();
        const tpl =
          `<div id="${uniqid}" class="ol-popup extract-coords-tool">
            <div class="popup-content"></div>
          </div>`;

        var addOverlay = function(coordinates, x, y, srid) {

          let container;

          const positionLabel = $filter('translate')('extractcoordinates.position');
          const sridLabel = $filter('translate')('extractcoordinates.srid');

          const html =
              `<div class="text">
                <div>${positionLabel} : ${x} , ${y}
                </div>
                <div>${sridLabel} : ${srid}
                </div>
              </div>
              <div class="copy-button">
                <button class="btn btn-default">
                  <i class="fa fa-clone" aria-hidden="true"></i>
                </button>
              </div>`;

          if (!addedoverlay) {
            angular
              .element(document)
              .find('body')
              .eq(0)
              .append(tpl);

            container = document.getElementById(uniqid);

            $(container).find('.popup-content').html(html);
            overlay = new ol.Overlay({
              element: container,
              autoPan: true,
              positioning: 'center-center',
              autoPanAnimation: { duration: 250 },
            });
            overlay.set('origin', 'annotations');
            overlay.set('uid', Math.random());
            scope.map.addOverlay(overlay);
            addedoverlay = true;
          } else {
            container = document.getElementById(uniqid);
            $(container).find('.popup-content').html(html);
          }

          overlay.setPosition(coordinates);

          // ajoute un évènement onclick sur le bouton "Copier" de l'infobulle
          const button = container.querySelector('.copy-button button');
          if (button) {
            button.setAttribute('title', $filter('translate')('extractcoordinates.copy'))
            button.addEventListener('click', copyCoordinates);
          }

        };

        var removeOverlay = function() {
          if (addedoverlay && overlay) {
            scope.map.removeOverlay(overlay);
            overlay = undefined;
            addedoverlay = false;
          }
        };

        scope.pointerByPoint = new ol.interaction.Draw({
          type: 'Point',
          condition: function(e) {
            scope.altKeyPressed = e.originalEvent.ctrlKey;
            //always return true but need to set whether shift key is pressed or not
            return true;
          },
        });

        scope.pointerByPoint.set('gctype', 'kis');
        scope.pointerByPoint.set('interaction', 'Draw');
        scope.pointerByPoint.set('widget', 'toolbarextractcoordinates');
        scope.pointerByPoint.setActive(false);

        scope.pointerByPoint.on('drawend', function(evt) {
          let currentCoordinates = {};
          let currentsrid = {};
          let positionX = {};
          let positionY = {};
          if (
            scope.selectedsrid &&
            scope.selectedsrid.name &&
            $rootScope.xgos.mouseposition.srid.name != scope.selectedsrid.name
          ) {
            scope.getNewPosition();
            currentsrid = scope.selectedsrid;
            currentCoordinates = scope.currentFeature
              .getGeometry()
              .getCoordinates();
            positionX = currentCoordinates[0];
            positionY = currentCoordinates[1];
          } else {
            currentsrid = $rootScope.xgos.mouseposition.srid;
            positionX = $rootScope.xgos.mouseposition.position.x;
            positionY = $rootScope.xgos.mouseposition.position.y;
          }

          // coordonnées du point cliquées. Stockage dans le scope pour préparer l'envoi au presse-papiers
          scope.clickedPosition = {x: positionX, y: positionY};

          addOverlay(
            evt.feature.getGeometry().getCoordinates(),
            positionX,
            positionY,
            currentsrid.name
          );
        });

        /**
         * Select the projection
         */
        scope.srids = SridFactory.sridsList;

        // KIS-3201: Si l’utilisateur choisit un autre SRID
        // alors celui-ci doit être proposé par défaut à la prochaine activation de l’outil au sein de la même session
        const defaultSridCode = extractCoordsService.defaultProjection
            ? extractCoordsService.defaultProjection.name
            : scope.map.getView().getProjection().getCode();

        scope.selectedsrid = {
          name: defaultSridCode
        };

        scope.projectionEdit = function() {
          ngDialog.open({
            template:
              'js/XG/widgets/mapapp/mouseposition/views/gcmouseposition_edit.html',
            className: 'ngdialog-theme-plain miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.getandsave = function() {

          // KIS-3201: à la prochaine activation de l’outil au sein de la même session
          // le srid précédemment choisi doit être proposé par défaut
          extractCoordsService.defaultProjection = scope.selectedsrid;

          SridFactory.getbycode(scope.selectedsrid.name).then(
            function(res) {
              scope.selectedsrid.description = res.data;
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
          ngDialog.close();
        };
        /**
         *Calcule des nouvelles cordoonées  
         */
        scope.getNewPosition = function() {
          let mapProjDescription =
            $rootScope.xgos.mouseposition.srid.description;
          scope.currentFeature = new ol.Feature({
            geometry: new ol.geom.Point(
              proj4(mapProjDescription, scope.selectedsrid.description, [
                $rootScope.xgos.mouseposition.position.x,
                $rootScope.xgos.mouseposition.position.y,
              ])
            ),
          });
        };

        /**
         * Copie de la position cliquée vers le presse-papiers.
         * Format "X,Y"
         */
        const copyCoordinates = () => {
          const position = scope.clickedPosition.x + ',' + scope.clickedPosition.y; // Remplacez par le texte que vous souhaitez copier
          navigator.clipboard.writeText(position)
          .then(() => {
            console.log('Position copiée dans le presse-papiers :', position);
            require('toastr').success($filter('translate')('extractcoordinates.copySuccess'));
          })
          .catch(err => {
            console.error('Impossible de copier le texte :', err);
          });
        };
      },
    };
  };
  toolbarextractcoordinates.$inject = [
    '$http',
    'SelectManager',
    'gclayers',
    'gcPopup',
    '$filter',
    'gcInteractions',
    '$rootScope',
    'ngDialog',
    'SridFactory',
    'extractCoordsService'
  ];
  return toolbarextractcoordinates;
});
