/**
 *
 */
'use strict';
define(function() {
  var gcMainCarteController = function(
    $scope,
    IndigauAppFactory,
    AlertHpoFactory,
    $filter,
    ngDialog,
    DataStoreFactory,
    CarteInitProvider,
    gaDomUtils,
    ConfigFactory,
    $rootScope,
    $location,
    $interval,
    itvSoumfactory,
    IndigauFactory,
    gaJsUtils,
    $route
  ) {
    $scope.isConfigDone = undefined;
    $scope.updateConfig = function() {
      gaDomUtils.showGlobalLoader();
      IndigauAppFactory.updateConfig($scope.CarteConfig).then(
        function(res) {
          if (res && res.data) {
            $scope.CarteConfig = res.data;
            CarteInitProvider.setHpoConfig($scope.CarteConfig);
            CarteInitProvider.initialiseApplication().then(
              function() {
                IndigauFactory.initMatrices($scope.CarteConfig.datastoreName);
                initializeDb(false);
                $scope.dialog.close();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            gaDomUtils.hideGlobalLoader();
          }
        },
        function(res) {
          AlertHpoFactory.showErrorMessage(res);
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    function initializeDb(withUserInterface) {
      $scope.isConfigDone = false;
      //-- Initialistion des tables "hpo": KIS_CARTE_ANALYSE_HISTORIQUE, KIS_CARTE_AUTOMATISATION, .....
      IndigauAppFactory.initFactory();
      if ($scope.CarteConfig.datastoreName != undefined) {
        //-- Initialisation des tables de gestion des Inspections Télévisées.
        //-- On ne le fait qu'une fois la base de données choisie.
        //-- on peut arriver ici avant d'activer la commande d'initialisation.
        itvSoumfactory
          .initDb($scope.CarteConfig.datastoreName)
          .then(function() {
            //-- Création du schéma INDIGAU avec ses tables de travail.
            IndigauFactory.initDb($scope.CarteConfig.datastoreName).then(
              function(res) {
                if (res.data.etat === 'fini') {
                  $scope.isConfigDone = $scope.CarteConfig.isConfigDone = true;
                  if (withUserInterface) {
                    swal(
                      $filter('translate')(
                        'indigau.init.initialization_succeeded'
                      ),
                      '',
                      'success'
                    );
                    CarteInitProvider.setHpoConfig($scope.CarteConfig);
                    $scope.updateConfig();
                    $route.reload();
                  }
                } else {
                  if (withUserInterface)
                    swal({
                      type: 'error',
                      title: $filter('translate')(
                        'indigau.init.initialization_failed'
                      ),
                      text: gaJsUtils.errorListToOneString(res.data.errorList),
                    });
                }
              }
            );
          });
      }
    }

    $scope.initApp = function(datastore) {
      if (datastore) {
        $scope.CarteConfig.datastoreuid = datastore.uid;
        $scope.CarteConfig.datastoreName = datastore.name;
        $scope.CarteConfig.dbmutualise = datastore.dbmutualise;
        $scope.CarteConfig.manipulate_data = true;
        $scope.CarteConfig.multicritere = true;
        initializeDb(true);
      }
    };

    ConfigFactory.get('main', 'appconfig').then(
      function(res) {
        if (((res && res.data) || res.data === '')&& (res.data.code !== 403)) {
          CarteInitProvider.initialiseApplication().then(function() {
            if (res.data && res.data.datastoreuid) {
              $scope.CarteConfig = res.data;
              $scope.isConfigDone = $scope.CarteConfig.isConfigDone;
              CarteInitProvider.setHpoConfig($scope.CarteConfig);
              if (!$scope.isConfigDone) initializeDb(true);
              //-- Récupération des feature types spécifiques AMC
              else IndigauAppFactory.initFactory();
            } else {
              $scope.CarteConfig = {};
              CarteInitProvider.setHpoConfig($scope.CarteConfig);
              initializeDb(false);
              $scope.isConfigDone = false;
              DataStoreFactory.get().then(
                function(res) {
                  if (res && res.data) {
                    $scope.datastores = res.data;
                    $scope.initDatastore = undefined;
                    $scope.multicritere = false;
                    $scope.dialog = ngDialog.open({
                      template:
                        'js/XG/widgets/indigauapp/main/views/controller/config.html',
                      className: 'ngdialog-theme-plain width800 configHpo',
                      closeByDocument: false,
                      title: $filter('translate')('hpo.init.datastore'),
                      scope: $scope,
                    });
                  }
                },
                function(res) {
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            }
          });
        }
      },
      function(res) {
        AlertHpoFactory.showErrorMessage(res);
      }
    );

    // TODO Recup id from URL
    function getParameterByName(name) {
      name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
      var regex = new RegExp('[\\?&]' + name + '=([^&#]*)'),
        results = regex.exec($location.$$absUrl);
      return results === null
        ? ''
        : decodeURIComponent(results[1].replace(/\+/g, ' '));
    }

    $scope.mode = getParameterByName('mode');
    localStorage.setItem('mode', $scope.mode);

    $scope.app = getParameterByName('app');
    localStorage.setItem('app', $scope.app);

    $scope.portalid = getParameterByName('portal');

    var gcMain = angular.module('gcMainHpo');
    gcMain.app = $scope.app;
    gcMain.portalid = $scope.portalid;

    if (!$rootScope.xgos) $rootScope.xgos = {};
    if (!$rootScope.xgos.hpo)
      $rootScope.xgos.hpo = {
        clauseWhere: '1=1',
        srid: undefined,
        operands: [],
      };

    $rootScope.initApplicationInformations = function() {
      CarteInitProvider.initialiseApplication().then(
        function() {
          console.log('Init done with success');
          var callback = function(isconfirm) {
            if (isconfirm) {
              $rootScope.$broadcast('inititaliseApplicationBranch');
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.info'),
            $filter('translate')('hpo.common.refreshModule'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
          // AlertHpoFactory.getSimpleSuccess( $filter('translate')('hpo.common.info'),
          //         $filter('translate')('hpo.common.reloaded') , false , "success");
        },
        function(res) {
          console.error('unable to reinitialise application parameter');
          AlertHpoFactory.showErrorMessage(res);
        }
      );
    };
  };
  gcMainCarteController.$inject = [
    '$scope',
    'IndigauAppFactory',
    'AlertHpoFactory',
    '$filter',
    'ngDialog',
    'DataStoreFactory',
    'CarteInitProvider',
    'gaDomUtils',
    'ConfigFactory',
    '$rootScope',
    '$location',
    '$interval',
    'itvSoumFactory',
    'IndigauFactory',
    'gaJsUtils',
    '$route',
  ];

  return gcMainCarteController;
});
