'use strict';
define([
  'angular',
  /**
   * Directive modelisation
   */
  'widgets/hpoapp/model/directives/model/modelSurvieHpo',
  'widgets/hpoapp/model/directives/model/modelJeuHpo',
  'widgets/hpoapp/model/directives/model/modelCalageHpo',
  'widgets/hpoapp/model/directives/model/modelValidationHpo',
  'widgets/hpoapp/model/directives/model/modelPrevisionHpo',
  'widgets/hpoapp/model/directives/model/leakSearchHpo',
  'widgets/hpoapp/model/directives/model/strategicOptimalRenewalRateHpo',

  /**
   * utilities
   */
  'widgets/hpoapp/model/directives/utilities/modelJeuDataHpo',
  'widgets/hpoapp/model/directives/utilities/modelSelectDataHpo',

  /**
   * Services
   */
  'widgets/hpoapp/model/services/HpoAppModelServices',

  /**
   * dependencies
   */
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'ngDragDrop',
], function(
  angular,
  modelSurvieHpo,
  modelJeuHpo,
  modelCalageHpo,
  modelValidationHpo,
  modelPrevisionHpo,
  leakSearchHpo,
  strategicOptimalRenewalRateHpo,
  modelJeuDataHpo,
  modelSelectDataHpo,
  HpoAppModelServices
) {
  // generation du module
  var gcMain = angular.module('gcMainHpoModel', [
    'model',
    'ga_urlutils_service',
    'ngRoute',
    'ngDragDrop',
  ]);

  /**
   * Directives
   */
  gcMain.directive('modelSurvieHpo', modelSurvieHpo);
  gcMain.directive('modelJeuHpo', modelJeuHpo);
  gcMain.directive('modelCalageHpo', modelCalageHpo);
  gcMain.directive('modelValidationHpo', modelValidationHpo);
  gcMain.directive('modelPrevisionHpo', modelPrevisionHpo);
  gcMain.directive('leakSearchHpo', leakSearchHpo);
  gcMain.directive('strategicOptimalRenewalRateHpo', strategicOptimalRenewalRateHpo);

  /**
   * utilities
   */
  gcMain.directive('modelJeuDataHpo', modelJeuDataHpo);
  gcMain.directive('modelSelectDataHpo', modelSelectDataHpo);

  /**
   * Services
   */
  gcMain.factory('HpoAppModelServices', HpoAppModelServices);

  return gcMain;
});
