'use strict';
define(() =>{
  class strategicOptimalRenewalRateHpo {
    constructor(HpoCarteAppFactory,
      QueryFactory,
      gaDomUtils,
      AlertHpoFactory,
      HpoDataVisServices, $filter
    ) {
      return {
        templateUrl: 'js/XG/widgets/hpoapp/model/views/directives/model/strategic_optimal_renewal_rate_hpo.html',
        restrict: 'EA',
        link: (scope, element, attrs) => {
          // -- Work Space
          scope.ws = {};
          scope.ws.listOfHtmlNames = attrs.listOfHtmlNames.split(';');
          scope.ws.listOfTitles = attrs.listOfTitles.split(';');
          scope.ws.pageTitle = $filter('translate')(attrs.pageTitle);
          scope.ws.suffix = attrs.suffix;
          let previsionUid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'prevision'
          )[0].uid;


          const loadNamedHtmlFiles = (res) => {
            let index = 0;
            for (let askedHtml of scope.ws.listOfHtmlNames) {
              const htmlFile = res.data.find(file => file.endsWith(askedHtml + ".html"));
              if (htmlFile) {
                scope.htmlList.push({url:htmlFile,
                  title: $filter('translate')( scope.ws.listOfTitles[index])
                });
              }
              else {
                scope.htmlList.push({
                  title: $filter('translate')('hpo.strategic.missingMessage')});
              }
              index++;
            }
          };


          const loadAllHtmlFiles = (res) => {
            for (let file of res.data) {
              if (file.endsWith('.html')) {
                scope.htmlList.push({url:file,
                  title: ''
                });
              }
            }
            if (!scope.htmlList.length) {
              scope.htmlList.push({
                title: $filter('translate')('hpo.strategic.missingMessage')});
            }
          };



          QueryFactory.data(
            previsionUid,
            "\"STATUS\"='FINISHED' AND \"FINALISER\"='true'",
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          ).then((res) =>{
            if (res.data && res.data.features) {
              scope.previsionList = res.data.features;
            } else {
              AlertHpoFactory.showErrorMessage(res);
            }
          },(err) =>{
            AlertHpoFactory.showErrorMessage(err);
          }
          );

          scope.renewalRateEvolution = false;
          scope.linearRepartitionRenewal = false;
          scope.lateLinearRepartitionRenewal = false;
          scope.newStrategySelected = ()=>{
            gaDomUtils.showGlobalLoader();
            scope.components = {
              identifiant: scope.selectedPrevision.IDENTIFIANT,
              identifiantCalage: scope.selectedPrevision.IDENTIFIANT_CALAGE,
            };
            scope.components.prefix = attrs.suffix ? attrs.suffix : 'RR';
            scope.renewalRateEvolution = true;
            scope.linearRepartitionRenewal = true;
            scope.lateLinearRepartitionRenewal = true;
            scope.htmlList = [];
            HpoDataVisServices.strategySearch(scope.components).then((res) => {
              if (res.data && Array.isArray(res.data)) {
                if (scope.ws.listOfHtmlNames.length) {
                  loadNamedHtmlFiles(res);
                }
                else {
                  loadAllHtmlFiles(res);
                }
              }
              else {
                AlertHpoFactory.showErrorMessage(res);
              }
              gaDomUtils.hideGlobalLoader();
            },
            (err) => {
              AlertHpoFactory.showErrorMessage(err);
              gaDomUtils.hideGlobalLoader();
            }
            );
          };
        },
      };
    }
  }

  strategicOptimalRenewalRateHpo.$inject = [
    'HpoCarteAppFactory',
    'QueryFactory',
    'gaDomUtils',
    'AlertHpoFactory',
    'HpoDataVisServices', '$filter'
  ];
  return strategicOptimalRenewalRateHpo;
});
