'use strict';
define(function() {
  var modelJeuHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    HpoAppModelServices,
    gaDomUtils,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/model/views/directives/model/model_jeu_hpo.html',
      restrict: 'EA',
      scope: {
        model: '=?',
        uniqueElement: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        if(scope.ftihistory){
          scope.ftihistoryattributes = scope.ftihistory.attributes.filter(
            function(x) {
              if (
                x &&
                ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftihistory.name
                ) &&
                  HpoCarteAppFactory.getAppFactory()
                    .getExcludedAttributes(scope.ftihistory.name)
                    .indexOf(x.name) === -1) ||
                  !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                    scope.ftihistory.name
                  ))
              )
                return x;
            }
          );
        }
        scope.ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        scope.ftijeudonneeattributes = scope.ftijeudonnee.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftijeudonnee.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftijeudonnee.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftijeudonnee.name
                ))
            )
              return x;
          }
        );

        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoModelJeuConfig' +
          scope.ftijeudonnee.uid;
        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';
        scope.propertiestoexclude = {};
        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.currentModel = dataHpo.savedata;
          }
        };

        scope.tabs = [
          {
            title: 'hpo.model.jeu.informations',
          },
          {
            title: 'hpo.model.jeu.listejeudedonnee',
          },
        ];
        scope.tabs.activeTab = 0;

        /**
         * Historique des modèles
         * @type {Array}
         */
        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.currentheight = ($window.innerHeight * 1.2) / 2 + 'px';

        scope.existingNames = [];
        var getExistingNames = function() {
          gaDomUtils.showGlobalLoader();
          var where = '';
          if (scope.currentModel && scope.currentModel.namedata)
            where += ' NOT ("NOM" = \'' + scope.currentModel.namedata + "')";
          QueryFactory.dataattributeCorrectedDate(
            scope.ftijeudonnee.uid,
            'NOM',
            where
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res && res.data) {
                scope.existingNames = res.data;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        getExistingNames();

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: $filter('translate')('hpo.data.standardisation.suivi.viewTableAndFailure'),
            },
          },
        ];

        scope.editJeu = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            HpoAppModelServices.getJeuInformation(
              scope.ftijeudonnee.uid,
              obj.properties.IDENTIFIANT,
              true
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.data = HpoCarteAppFactory.getAppFactory().updateFtiWithAttributs(res.data, ['MATAGE']);
                  var dialog = ngDialog.open({
                    template:
                      'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.jeu.update.html',
                    className:
                      'ngdialog-theme-plain width1100 nopadding miniclose',
                    scope: scope,
                  });
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.refreshData = function() {
          $rootScope.$broadcast('reloadDatatable', scope.ftijeudonnee.uid);
        };

        scope.datatableJeuCrudHpo = {
          update: { func: scope.editJeu },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        /**
         * Création d'un nouveau modèle
         * @type {Array}
         */
        scope.emptyModel = function(btn) {
          if (!btn) {
            scope.currentModel = scope.model || {
              result: {},
              ftiuid: scope.ftihistory?scope.ftihistory.uid: undefined,
              ftiuidjeu: scope.ftijeudonnee.uid,
              useexisting: 'no',
            };
          } else {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.currentModel = scope.model || {
                  result: {},
                  ftiuid: scope.ftihistory?scope.ftihistory.uid: undefined,
                  ftiuidjeu: scope.ftijeudonnee.uid,
                  useexisting: 'no',
                };
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.model.choice.empty') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          }
        };
        scope.emptyModel(false);

        var keysjeu = ['namedata'];
        scope.disableAnalyseButton = function(currentModel) {
          if (!currentModel) return true;
          if(!scope.currentModel.namedata || !currentModel.fti){
            return true;
          }

          if (
            scope.currentModel &&
            scope.currentModel.namedata &&
            scope.existingNames &&
            scope.existingNames.length > 0 &&
            scope.existingNames.indexOf(currentModel.namedata) !== -1
          ) {
            return true;
          }

          var noexists = false;
          if (currentModel.useexisting === 'no') {
            for (var i = 0; i < keysjeu.length; i++) {
              if (!currentModel.hasOwnProperty(keysjeu[i])) {
                noexists = true;
                break;
              }
            }
          } else {
            if (!currentModel.selectedjeu) noexists = true;
          }
          return noexists;
        };

        /**
         * Jeu de données
         * @type {Array}
         */
        scope.ftis = [];
        scope.ftisdefail = [];
        scope.ftis_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid'
        );
        scope.ftisnodefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_no_defail'
        );
        scope.ftisdefail_valid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'valid_defail'
        );

        if(HpoCarteAppFactory.getAppFactory().isIndigau){
          scope.ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();
        } else {
          var ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
          for (var i = 0; i < ftis.length; i++) {
            var fti = ftis[i];
            if (!HpoCarteAppFactory.getAppFactory().getFuiteTables(fti)) {
              scope.ftis.push(fti);
              var ftidefailuid = HpoCarteAppFactory.getAppFactory().getFuiteTableFrom(
                fti
              );
              var idx = ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(ftidefailuid);
              if (idx !== -1) scope.ftisdefail.push(ftis[idx]);
            }
          }
        }
        scope.modes = HpoCarteAppFactory.getAppFactory().getHpoFilterModes(
          true
        );

        /**
         * Create new model func
         * @type {Array}
         */
        scope.createJeu = function() {
          console.log(scope.currentModel);
          gaDomUtils.showGlobalLoader();
          HpoAppModelServices.createJeu(scope.currentModel).then(
            function(res) {
              try {
                if (res.data && res.status) {
                  AlertHpoFactory.successSave();
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.ftihistory.uid
                  );
                  $rootScope.$broadcast(
                    'reloadDatatable',
                    scope.ftijeudonnee.uid
                  );
                  getExistingNames();
                  scope.emptyModel();
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                console.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
              $rootScope.$broadcast('inititaliseApplicationBranch');
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        scope.$on('changedHpoValue', function(evt, arg) {
          if (arg && arg.clauseWhere && arg.operands) {
            scope.currentModel.result = {
              clauseWhere: arg.clauseWhere,
              operands: arg.operands,
            };
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('hpo.common.success'),
              $filter('translate')('hpo.data.validation.getsuccess'),
              false
            );
          }
        });
        
        scope.postRemove = function(resultat) {
          HpoCarteAppFactory.getAppFactory().checkDeleteStandardisations(resultat);
          $rootScope.$broadcast('inititaliseApplicationBranch');
        }
        
      },
    };
  };

  modelJeuHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'HpoAppModelServices',
    'gaDomUtils',
    'QueryFactory',
  ];
  return modelJeuHpo;
});
