'use strict';
define(() =>{
  class leakSearchHpo {
    constructor(HpoCarteAppFactory,
      QueryFactory,
      gaDomUtils,
      AlertHpoFactory,
      HpoDataVisServices,
      gcMapUtils,
      $timeout
     ) {
      return {
        templateUrl: 'js/XG/widgets/hpoapp/model/views/directives/model/leak_search_hpo.html',
        restrict: 'EA',
        link: (scope) => {
          let previsionUid = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'prevision'
          )[0].uid;
          let cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
          let baseMap = cfg.baseMap?cfg.baseMap:'toner-lite';

          QueryFactory.data(
            previsionUid,
            "\"STATUS\"='FINISHED' AND \"FINALISER\"='true'",
            HpoCarteAppFactory.getAppFactory().getSrid(),
            '',
            '',
            ''
          ).then((res) =>{
              if (res.data && res.data.features) {
                scope.previsionList = res.data.features;
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },(err) =>{
              AlertHpoFactory.showErrorMessage(err);
            }
          );

          scope.newLeakSelected = ()=>{
            gaDomUtils.showGlobalLoader();
            scope.components = {
              identifiant: scope.selectedPrevision.IDENTIFIANT,
              identifiantCalage: scope.selectedPrevision.IDENTIFIANT_CALAGE,
            }
            HpoDataVisServices.leakSearchGeometry(scope.components).then((res)=>{
              let layers = [];
              let source;
              if(!baseMap || baseMap === 'osm'){
                source = new ol.source.OSM();
              } else {
                source = new ol.source.XYZ({ 
                  url:'http://{1-4}.basemaps.cartocdn.com/'+baseMap+'/{z}/{x}/{y}.png',
                })
              }
              layers.push(new ol.layer.Tile({
                source: source,
              }));
              scope.zoomLevelsminMax = {
                "cana":{
                  min:0,
                  max:28
                },
                "low":{
                  min:0,
                  max:12
                },"med1":{
                  min:13,
                  max:14
                },"med2":{
                  min:15,
                  max:16
                },"high":{
                  min:17,
                  max:28
                }
              }
              scope.visibility = {
                "cana":{
                  bleu:true,
                  yellow:true,
                  orange:true,
                  red:true
                },
                "low":{
                  bleu:false,
                  yellow:true,
                  orange:true,
                  red:true
                },"med1":{
                  bleu:true,
                  yellow:true,
                  orange:true,
                  red:true
                },"med2":{
                  bleu:true,
                  yellow:true,
                  orange:true,
                  red:true
                },"high":{
                  bleu:true,
                  yellow:true,
                  orange:true,
                  red:true
                }
              }
              scope.allLayers = {};
              let colors = {
                'bleu':'rgba(0, 156, 205,0.4)',
                'bleu2':'rgba(0, 156, 205,1)',
                'yellow':'rgba(255, 192, 0, 0.4)',
                'orange':'rgba(237, 125, 49, 0.4)',
                'red':'rgba(255,0,0,0.4)'
              };
              let geometriesAll = [];
              ["cana","low","med1","med2","high"].forEach(zoom => {
                if(res.data[zoom]){
                  ["bleu","yellow","orange","red"].forEach(color => {
                    let geometryTemp = [];
                    let type = "";
                    if(res.data[zoom][color]){
                      res.data[zoom][color].forEach((g) => {
                        let feature = gcMapUtils.toGeometry(g)
                        if (feature) geometryTemp.push(feature);
                        type = g.geometry.type
                      });
                      geometriesAll = [...geometriesAll,...geometryTemp];
                      let style;
                      if(type === 'Point' || type === 'MultiPoint'){
                        style = new ol.style.Style({
                          image: new ol.style.Circle({
                            radius: 3,
                            fill: new ol.style.Fill({
                                color: colors[color]
                            }),
                          }),
                        });
                      } else {
                        style = new ol.style.Style({
                          stroke: new ol.style.Stroke({color: colors[color], width: 1}),
                          fill : new ol.style.Fill({
                            color: colors[color]
                        })
                        })
                      }
                      let vectorTemp = new ol.layer.Vector({
                        source: new ol.source.Vector({
                            features: geometryTemp
                        }),
                        style:style
                      });
                      layers.push(vectorTemp);
                      if(!scope.allLayers[zoom]){
                        scope.allLayers[zoom] = {};
                      }
                      scope.allLayers[zoom][color] = vectorTemp;
                    }
                  });
                }
              })
              scope.zoomLevels = Object.keys(scope.allLayers);
              var vectorAll = new ol.layer.Vector({
                source: new ol.source.Vector({
                    features: geometriesAll
                })
              });
  
              let extent= geometriesAll.length>0?vectorAll.getSource().getExtent():[0,0,0,0];
              scope.leakSearchMap = true;

              scope.map = new ol.Map({
                layers: layers,
                interactions: ol.interaction.defaults({mouseWheelZoom: false}).extend([gcMapUtils.altZoomInteraction()]),
                target: 'leakSearchMap',
                view: new ol.View({
                  projection: "EPSG:2154",
                  center: ol.extent.getCenter(extent),
                  zoom: 13,
                }),
                ol3Logo: false,
              });
              scope.map.getView().fit(extent,scope.map.getSize());
              scope.map.on('moveend', () => {
                $timeout(() =>{
                  scope.changeZoom();
                });
              });
              gaDomUtils.hideGlobalLoader();
            }, () => {
              gaDomUtils.hideGlobalLoader();
            })
          }

          scope.changeZoom = () => {
            let zoom = scope.map.getView().getZoom();
            if(angular.isDefined(zoom)){
              console.log(zoom);
              ["cana","low","med1","med2","high"].forEach(type => {
                if(scope.allLayers[type]){
                  ["bleu","yellow","orange","red"].forEach(color => {
                    if(scope.allLayers[type][color]){
                      if(scope.zoomLevelsminMax[type]['min']<=zoom && 
                          zoom<=scope.zoomLevelsminMax[type]['max']){
                        let found = false;
                        scope.map.getLayers().forEach(layer =>{
                          if(layer ===scope.allLayers[type][color]){
                            found = true;
                          }
                        })
                        if(!found){
                          scope.map.addLayer(scope.allLayers[type][color]);
                        }
                        scope.visibility[type][color] = true;
                      }else{
                        scope.map.getLayers().forEach(layer =>{
                          if(layer ===scope.allLayers[type][color]){
                            scope.map.removeLayer(scope.allLayers[type][color]);
                            scope.visibility[type][color] = false;
                          }
                        })
                      }
                    }
                  })
                }
              })                      
            }
          }

          scope.rowSpanLength = (zoomLevel) =>{
            return Object.keys(scope.allLayers[zoomLevel]).length;
          }

          scope.addRemoveLayer = (zoomLevel,color) =>{
            if(scope.visibility[zoomLevel][color]){
              scope.map.removeLayer(scope.allLayers[zoomLevel][color]);
            }else{
              scope.map.addLayer(scope.allLayers[zoomLevel][color]);
              if(scope.zoomLevelsminMax[zoomLevel]['min']>scope.map.getView().getZoom()){
                scope.zoomLevelsminMax[zoomLevel]['min'] = scope.map.getView().getZoom();
              }
              if(scope.zoomLevelsminMax[zoomLevel]['max']<scope.map.getView().getZoom()){
                scope.zoomLevelsminMax[zoomLevel]['max'] = scope.map.getView().getZoom();
              }
            }
            scope.visibility[zoomLevel][color] = !scope.visibility[zoomLevel][color];
          }

        },
      };
    }
  }

  leakSearchHpo.$inject = [
    'HpoCarteAppFactory',
    'QueryFactory',
    'gaDomUtils',
    'AlertHpoFactory',
    'HpoDataVisServices',
    'gcMapUtils',
    '$timeout'
  ];
  return leakSearchHpo;
});
