'use strict';
define(function() {
  var distributionTermsKmInstalledByYear = function(
    HpoCarteAppFactory,
    HpoDataVisServices,
    $filter,
    gaDomUtils,
    $q,
    $rootScope
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/distributionTermsKmInstalledByYear.html',
      restrict: 'EA',
      link: function(scope) {
      
        const MSG_PREFIX = 'hpo.admin.dashBoardAutomatique';
        let directiveFunction = () => {
          var cfg = HpoCarteAppFactory.getInitProvider().getHpoConfig();
          let defined = false;
          scope.portalid = $rootScope.xgos.portal.uid;

          if(scope.objStandardisation){
            defined = true;
            scope.components = {
              uidJeu: HpoCarteAppFactory.getAppFactory().getFeatureTypes(
                'jeu_de_donnee'
              )[0].uid,
              identifiantJeuDonnee: scope.objStandardisation.properties.SELECTED_JEU,
              composant: scope.objStandardisation.properties.COMPOSANT,
              cfg: cfg,
              s3: true,
              type:'standardisation'
            };
          }
          else if( cfg.ftiStatuid || cfg.ftiStatdefailuid){
            defined = true;
            scope.components = {
              canalisation: cfg.ftiStatuid,
              defailcanalisation: cfg.ftiStatdefailuid,
              cfg: cfg,
              s3: false
            };
          }
          if (defined){
            const colors = ['#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1',
              '#296d8a','#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
              '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb','#9986b3',
              '#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
              '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a',
              '#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
              '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb',
              '#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
              '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a',
              '#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
              '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb',
              '#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
              '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a',
              '#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
              '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb',
              '#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8',
              '#EB5389','#47B8DD','#eb795e','#289E75','#46ebb1','#296d8a',
              '#96B1FA','#EDB3A6','#42616b','#EBBA34','#c0504d','#9bbb59',
              '#9986B3','#fa9b2f','#be6fa0','#6d607f','#c9ffa6','#4095cb',
              '#9986b3','#62ddff','#b8406a','#89E3FA','#5bcfbd','#EE9BB8'];
            let promises = [];
            gaDomUtils.showGlobalLoader();
            let PromiseAutoModalite
              = HpoDataVisServices.getStatsDashboardAutoModalite(scope.components).then((res)=>{
                var data2 = [{
                  values: Object.values(res.data['MATERIAU']),
                  labels: Object.keys(res.data['MATERIAU']),
                  type: 'pie',
                  sort:false,
                  marker: {
                    colors: colors
                  }
                }];

                var layout2 = {
                  height: 400,
                  width: 500,
                  title:$filter('translate')(MSG_PREFIX + '.materials'),
                };

                Plotly.newPlot('distributionTermsMat', data2, layout2);
                scope.distributionTermsMat = true;
                var data3 = [{
                  values: Object.values(res.data['DATE_DE_POSE']),
                  labels: Object.keys(res.data['DATE_DE_POSE']),
                  type: 'pie',
                  sort:false,
                  marker: {
                    colors: colors
                  }
                }];

                var layout3 = {
                  height: 400,
                  width: 500,
                  title:$filter('translate')(MSG_PREFIX + '.installationPeriod')
                };

                Plotly.newPlot('distributionTermsYears', data3, layout3);
                scope.distributionTermsYears = true;
                var data4 = [{
                  values: Object.values(res.data['DIAMETER']),
                  labels: Object.keys(res.data['DIAMETER']),
                  type: 'pie',
                  sort:false,
                  marker: {
                    colors: colors
                  }
                }];

                var layout4 = {
                  height: 400,
                  width: 550,
                  title:$filter('translate')(MSG_PREFIX + '.diameterGroup')
                };

                Plotly.newPlot('distributionTermsDiam', data4, layout4);
                scope.distributionTermsDiam = true;
              });
            promises.push(PromiseAutoModalite);
            // -- Diagramme à barres
            let promiseAutoInstalledKm
              =  HpoDataVisServices.getStatsDashboardAutoInstalledKm(scope.components).then((res)=>{
                let data = [];
                let i=0;
                Object.keys(res.data).forEach(key => {
                  let trace =
                    {
                      x: Object.keys(res.data[key]),
                      y: Object.values(res.data[key]),
                      type: 'bar',
                      name: key,
                      marker: {color: colors[i++]},
                      xaxis: {
                        title: {
                          text: $filter('translate')(MSG_PREFIX + '.linearKilometers')
                        },
                      },
                    };
                  data.unshift(trace);
                });
                var layout = {
                  barmode: 'stack',
                  xaxis: {
                    title: {
                      text: $filter('translate')(MSG_PREFIX + '.yearInstallation')
                    },
                  },
                  yaxis: {
                    title: {
                      text: $filter('translate')(MSG_PREFIX + '.linearKilometers')
                    },
                  }
                };

                Plotly.newPlot('kmInstalledByYear', data, layout);
                scope.kmInstalledByYear = true;
              });
            promises.push(promiseAutoInstalledKm);
            $q.all(promises).then(()=>{
              gaDomUtils.hideGlobalLoader();
            }, () =>{
              gaDomUtils.hideGlobalLoader();
            });
          }
        };
        directiveFunction();
        // on reload la fonction quand on change la langue en locale
        $rootScope.$on('localeChanged', () => {
          directiveFunction();
        });
      },
    };
  };

  distributionTermsKmInstalledByYear.$inject = [
    'HpoCarteAppFactory',
    'HpoDataVisServices',
    '$filter',
    'gaDomUtils',
    '$q',
    '$rootScope',
  ];
  return distributionTermsKmInstalledByYear;
});
