'use strict';
define(function() {
  var HpoChantiersServices = function(
    $http,
    $q,
    HpoAppModelServices
  ) {
    /**
     * [createNewModel description]
     * @param  {[type]} hpoConfig [description]
     * @return {[type]}           [description]
     */
    function calculerChantier(uid, id, sendata) {
      var deferred = $q.defer();
      var promise = $http.post(
        '/services/{portalid}/hpoapp/chantiers/{appname}/calculate?uid=' +
          uid +
          '&id=' +
          id,
        sendata
      );
      promise.then(
        function(res) {
          HpoAppModelServices.checkLoadDataThread(res.data, deferred, 0);
        },
        function(res) {
          deferred.reject(res);
        }
      );
      return deferred.promise;
    }

    function createChantierAutomatique(sendata,uidjeu,uidmodel,uidcalage, uidprevision) {
      var promise = $http.post(
        '/services/{portalid}/hpoapp/chantiers/{appname}/chantierAutomatique/create?uidjeu=' +
          uidjeu +
          '&uidmodel=' +
          uidmodel+
          '&uidcalage=' +
          uidcalage +
          '&uidprevision=' +
          uidprevision,
        sendata
      );
      console.log(sendata);
      return promise;
    }

    function reloadCreateChantierAutomatique(uid, featureId,uidjeu,uidmodel,uidcalage, uidprevision, createUser) {
      var promise = $http.get(
        '/services/{portalid}/hpoapp/chantiers/{appname}/chantierAutomatique/reloadCreate?f=json' +
        '&uid=' +
        uid +
        '&featureId=' +
        featureId +
        '&uidjeu=' +
        uidjeu +
        '&uidmodel=' +
        uidmodel+
        '&uidcalage=' +
        uidcalage +
        '&uidprevision=' +
        uidprevision+
        '&createUser=' +
        createUser
      );
      return promise;
    }

    function generateChantierAutomatique(uid, featureId,uidjeu,uidmodel,uidcalage, uidprevision, uidChantierList, adminconfig) {
      var promise = $http.post(
        '/services/{portalid}/hpoapp/chantiers/{appname}/chantierAutomatique/generate?f=json' +
          '&uid=' +
          uid +
          '&featureId=' +
          featureId +
          '&uidjeu=' +
          uidjeu +
          '&uidmodel=' +
          uidmodel+
          '&uidcalage=' +
          uidcalage +
          '&uidprevision=' +
          uidprevision +
          '&uidChantierList=' +
          uidChantierList,
        adminconfig
      );
      return promise;
    }

    function exportResults(identifiantPrevision, identifiantChantier) {
      window.open(
        '/services/'+localStorage.portal+'/hpoapp/chantiers/'+localStorage.app+'/chantierAutomatique/exportResults?f=json' +
        '&identifiantPrevision=' +
        identifiantPrevision +
        '&identifiantChantier=' +
        identifiantChantier 
      );
    }
    
    return {
      calculerChantier: calculerChantier,
      createChantierAutomatique:createChantierAutomatique,
      reloadCreateChantierAutomatique:reloadCreateChantierAutomatique,
      generateChantierAutomatique:generateChantierAutomatique,
      exportResults:exportResults,
    };
  };
  HpoChantiersServices.$inject = [
    '$http',
    '$q',
    'HpoAppModelServices',
  ];
  return HpoChantiersServices;
});
