'use strict';

define(function() {
  var DUBCtrl = function(
    $scope,
    AncAppFactory,
    BacAppFactory,
    ngDialog,
    FeatureTypeFactory,
    EditFactory,
    UsersFactory,
    $timeout,
    $rootScope,
    gaJsUtils
  ) {
    $scope.kis_bac_listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
      'kis_bac_listes_deroulantes_controles'
    );
    $scope.parcellesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
      BacAppFactory.appCfg.main.datastore,
      BacAppFactory.appCfg.main.parcellesCfg.emplacement
    );
    //Calcul destination des constructions et tableau des surfaces
    console.log($scope.parcellesFti);

    $scope.calculateAll = function() {
      if (angular.isUndefined($scope.cdata)) $scope.cdata = {};

      if (angular.isUndefined($scope.cdata.avis_tech))
        $scope.cdata.avis_tech = {};

      if (angular.isUndefined($scope.cdata.avis_tech.surfaces))
        $scope.cdata.avis_tech.surfaces = {};

      $scope.cdata.avis_tech.surfaces.a10 = 0;
      $scope.cdata.avis_tech.surfaces.b10 = 0;
      $scope.cdata.avis_tech.surfaces.c10 = 0;
      $scope.cdata.avis_tech.surfaces.d10 = 0;
      $scope.cdata.avis_tech.surfaces.e10 = 0;
      $scope.cdata.avis_tech.surfaces.t10 = 0;

      for (let i = 1; i <= 9; i++) {
        if (angular.isDefined($scope.cdata.avis_tech.surfaces['a' + i]))
          $scope.cdata.avis_tech.surfaces.a10 +=
            $scope.cdata.avis_tech.surfaces['a' + i];
        else $scope.cdata.avis_tech.surfaces['a' + i] = 0;

        if (angular.isDefined($scope.cdata.avis_tech.surfaces['b' + i]))
          $scope.cdata.avis_tech.surfaces.b10 +=
            $scope.cdata.avis_tech.surfaces['b' + i];
        else $scope.cdata.avis_tech.surfaces['b' + i] = 0;

        if (angular.isDefined($scope.cdata.avis_tech.surfaces['c' + i]))
          $scope.cdata.avis_tech.surfaces.c10 +=
            $scope.cdata.avis_tech.surfaces['c' + i];
        else $scope.cdata.avis_tech.surfaces['c' + i] = 0;

        if (angular.isDefined($scope.cdata.avis_tech.surfaces['d' + i]))
          $scope.cdata.avis_tech.surfaces.d10 +=
            $scope.cdata.avis_tech.surfaces['d' + i];
        else $scope.cdata.avis_tech.surfaces['d' + i] = 0;

        if (angular.isDefined($scope.cdata.avis_tech.surfaces['e' + i]))
          $scope.cdata.avis_tech.surfaces.e10 +=
            $scope.cdata.avis_tech.surfaces['e' + i];
        else $scope.cdata.avis_tech.surfaces['e' + i] = 0;
      }

      for (let i = 1; i <= 9; i++) {
        if (angular.isDefined($scope.cdata.avis_tech.surfaces['t' + i])) {
          $scope.cdata.avis_tech.surfaces['t' + i] =
            Math.round(($scope.cdata.avis_tech.surfaces['a' + i] +
            $scope.cdata.avis_tech.surfaces['b' + i] +
            $scope.cdata.avis_tech.surfaces['c' + i] -
            $scope.cdata.avis_tech.surfaces['d' + i] -
            $scope.cdata.avis_tech.surfaces['e' + i])*100)/100;
        } else {
          $scope.cdata.avis_tech.surfaces['t' + i] = 0;
        }
      }

      $scope.cdata.avis_tech.surfaces.t10 = 0;
      $scope.cdata.avis_tech.surfaces.t10 =
        Math.round(($scope.cdata.avis_tech.surfaces.a10 +
        $scope.cdata.avis_tech.surfaces.b10 +
        $scope.cdata.avis_tech.surfaces.c10 -
        $scope.cdata.avis_tech.surfaces.d10 -
        $scope.cdata.avis_tech.surfaces.e10)*100)/100;
    };

    $scope.resetTab = function() {
      var ans = confirm(
        'Êtes-vous certain de vouloir réinitialiser le tableau de destinations des surface ?'
      );

      if (ans) reinitObject();
    };

    var reinitObject = function() {
      for (let i = 1; i <= 10; i++) {
        $scope.cdata.avis_tech.surfaces['a' + i] = 0;
        $scope.cdata.avis_tech.surfaces['b' + i] = 0;
        $scope.cdata.avis_tech.surfaces['c' + i] = 0;
        $scope.cdata.avis_tech.surfaces['d' + i] = 0;
        $scope.cdata.avis_tech.surfaces['e' + i] = 0;
        $scope.cdata.avis_tech.surfaces['t' + i] = 0;
      }
    };

    $scope.genereEnvoiCourrier = function(type_courrier) {
      $scope.getDocxControle('dub_' + type_courrier + '.docx');
    };

    if (angular.isUndefined($scope.cdata.demande_autorisation_urbanisme))
      $scope.cdata.demande_autorisation_urbanisme = {};

    $scope.resetRadio = function() {
      if (angular.isUndefined($scope.cdata.info_generales.demande))
        $scope.cdata.info_generales.demande = {};

      if (angular.isDefined($scope.cdata.info_generales.demande.type))
        delete $scope.cdata.info_generales.demande.type;
    };

    $scope.resetCheckbox = function() {
      if (angular.isUndefined($scope.cdata.info_generales))
        $scope.cdata.info_generales = {};

      if (angular.isUndefined($scope.cdata.info_generales.demande))
        $scope.cdata.info_generales.demande = {};

      if (
        angular.isDefined($scope.cdata.info_generales.demande.permis_construire)
      )
        delete $scope.cdata.info_generales.demande.permis_construire;

      if (angular.isDefined($scope.cdata.info_generales.demande.permis_demolir))
        delete $scope.cdata.info_generales.demande.permis_demolir;
    };

    $scope.getType = function(type) {
      if (angular.isDefined($scope.cdata.info_generales)) {
        if (type === 'PC' || type === 'PD') {
          var pc = false;
          var pd = false;
          if (
            angular.isDefined(
              $scope.cdata.info_generales.demande.permis_construire
            )
          )
            pc = $scope.cdata.info_generales.demande.permis_construire;
          if (
            angular.isDefined(
              $scope.cdata.info_generales.demande.permis_demolir
            )
          )
            pd = $scope.cdata.info_generales.demande.permis_demolir;

          if (pd && !pc)
            $scope.cdata.demande_autorisation_urbanisme.type = 'PD';
          else if (!pd && !pc)
            delete $scope.cdata.demande_autorisation_urbanisme.type;
          else $scope.cdata.demande_autorisation_urbanisme.type = 'PC';
        }

        if (angular.isUndefined($scope.cdata.demande_autorisation_urbanisme))
          $scope.cdata.demande_autorisation_urbanisme = {};

        if (angular.isDefined($scope.cdata.info_generales.demande.type))
          $scope.cdata.demande_autorisation_urbanisme.type = type;

        if (
          angular.isDefined($scope.cdata.info_generales.demande.type) &&
          $scope.cdata.demande_autorisation_urbanisme.type == 'CU'
        ) {
          if (gaJsUtils.checkNestedProperty('avis_tech.surfaces', $scope.cdata))
            reinitObject();
        }
      }
    };

    $scope.checkSurface = function() {
      if (
        angular.isDefined(
          $scope.cdata.avis_tech.surface_declaree_proprietaire
        ) &&
        angular.isDefined($scope.cdata.avis_tech.surfaces.t10)
      )
        if (
          $scope.cdata.avis_tech.surface_declaree_proprietaire !=
          $scope.cdata.avis_tech.surfaces.t10
        )
          $scope.cdata.avis_tech.surface_declaree_proprietaire_differente = true;
        else
          $scope.cdata.avis_tech.surface_declaree_proprietaire_differente = false;
    };
  };

  DUBCtrl.$inject = [
    '$scope',
    'AncAppFactory',
    'BacAppFactory',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
    'UsersFactory',
    '$timeout',
    '$rootScope',
    'gaJsUtils',
  ];
  return DUBCtrl;
});
