'use strict';
define([
  'angular',

  'widgets/bacapp/main/controllers/gcMainController',
  'widgets/bacapp/main/controllers/noCfgCtrl',
  'widgets/bacapp/main/controllers/reportsCtrl',
  'widgets/bacapp/main/controllers/facturationCtrl',
  'widgets/bacapp/main/controllers/documentsCtrl',
  'widgets/bacapp/main/controllers/dashboardCtrl',
  'widgets/bacapp/main/controllers/mailsCtrl',
  'widgets/bacapp/main/controllers/adminCtrl',
  'widgets/ancapp/main/controllers/configMobileCtrl',

  'widgets/bacapp/main/views/controllers/DRRACCtrl',
  'widgets/bacapp/main/views/controllers/DRCtrl',
  'widgets/bacapp/main/views/controllers/CSDICtrl',
  'widgets/bacapp/main/views/controllers/CSDNCtrl',
  'widgets/bacapp/main/views/controllers/DAACTCtrl',
  'widgets/bacapp/main/views/controllers/bac_fiche_controleCtrl',
  'widgets/bacapp/main/views/controllers/DCCtrl',
  'widgets/bacapp/main/views/controllers/AVICtrl',
  'widgets/bacapp/main/views/controllers/EREUCtrl',
  'widgets/bacapp/main/views/controllers/DBCtrl',
  'widgets/bacapp/main/views/controllers/DAUCtrl',
  'widgets/bacapp/main/views/controllers/RDRCtrl',
  'widgets/bacapp/main/views/controllers/DUBCtrl',
  'widgets/bacapp/main/views/controllers/CCICtrl',
  'widgets/bacapp/main/views/controllers/AUDCtrl',  

  'widgets/bacapp/main/services/BacAppFactory',
  'widgets/bacapp/main/services/BacAppSearchFactory',

  'widgets/bacapp/main/directives/listeDossiersBac',
  'widgets/bacapp/main/directives/bacNavigation',
  'widgets/bacapp/main/directives/bacMapWidget',
  'widgets/bacapp/main/directives/bacAvisControle',
  'widgets/bacapp/main/directives/bacVisite',
  'widgets/bacapp/main/directives/bacOperis',
  'widgets/bacapp/main/directives/textAutoSize',
  'widgets/ancapp/main/services/ancBacTools',
], function(
  angular,
  gcMainController,
  noCfgCtrl,
  reportsCtrl,
  facturationCtrl,
  documentsCtrl,
  dashboardCtrl,
  mailsCtrl,
  adminCtrl,
  configMobileCtrl,
  DRRACCtrl,
  DRCtrl,
  CSDICtrl,
  CSDNCtrl,
  DAACTCtrl,
  bac_fiche_controleCtrl,
  DCCtrl,
  AVICtrl,
  EREUCtrl,
  DBCtrl,
  DAUCtrl,
  RDRCtrl,
  DUBCtrl,
  CCICtrl,
  AUDCtrl,
  BacAppFactory,
  BacAppSearchFactory,
  listeDossiersBac,
  bacNavigation,
  bacMapWidget,
  bacAvisControle,
  bacVisite,
  bacOperis,
  textAutoSize,
  ancBacTools
) {
  var gcMain = angular.module('gcBacMain', []);
  gcMain.controller('gcBacController', gcMainController);
  gcMain.controller('noCfgCtrl', noCfgCtrl);
  gcMain.controller('reportsCtrl', reportsCtrl);
  gcMain.controller('facturationCtrl', facturationCtrl);
  gcMain.controller('dashboardCtrl', dashboardCtrl);
  gcMain.controller('documentsCtrl', documentsCtrl);
  gcMain.controller('mailsCtrl', mailsCtrl);
  gcMain.controller('adminCtrl', adminCtrl);
  gcMain.controller('configMobileCtrl', configMobileCtrl);

  gcMain.controller('DRRACCtrl', DRRACCtrl);
  gcMain.controller('DRCtrl', DRCtrl);
  gcMain.controller('CSDICtrl', CSDICtrl);
  gcMain.controller('CSDNCtrl', CSDNCtrl);
  gcMain.controller('DAACTCtrl', DAACTCtrl);
  gcMain.controller('bac_fiche_controleCtrl', bac_fiche_controleCtrl);
  gcMain.controller('DCCtrl', DCCtrl);
  gcMain.controller('AVICtrl', AVICtrl);
  gcMain.controller('EREUCtrl', EREUCtrl);
  gcMain.controller('DBCtrl', DBCtrl);
  gcMain.controller('DAUCtrl', DAUCtrl);
  gcMain.controller('RDRCtrl', RDRCtrl);
  gcMain.controller('DUBCtrl', DUBCtrl);
  gcMain.controller('CCICtrl', CCICtrl);
  gcMain.controller('AUDCtrl', AUDCtrl);

  
  
  gcMain.service('BacAppFactory', BacAppFactory);
  gcMain.service('BacAppSearchFactory', BacAppSearchFactory);

  gcMain.directive('listeDossiersBac', listeDossiersBac);
  gcMain.directive('bacNavigation', bacNavigation);
  gcMain.directive('bacmapwidget', bacMapWidget);
  gcMain.directive('bacAvisControle', bacAvisControle);
  gcMain.directive('bacVisite', bacVisite);
  gcMain.directive('bacOperis', bacOperis);
  gcMain.directive('textAutoSize', textAutoSize);

  gcMain.provider('ancBacTools', ancBacTools);

  gcMain.config([
    '$routeProvider',
    function($routeProvider, $location) {
      $routeProvider.when('/bac/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/main.html',
        controller: 'gcBacController',
      });
      $routeProvider.when('/bac/reports/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/reports.html',
        controller: reportsCtrl,
      });
      $routeProvider.when('/bac/facturation/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/facturation.html',
        controller: facturationCtrl,
      });
      $routeProvider.when('/bac/documents/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/documents.html',
        controller: documentsCtrl,
      });
      $routeProvider.when('/bac/dashboard/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/dashboard.html',
        controller: dashboardCtrl,
      });
      $routeProvider.when('/bac/mails/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/mails.html',
        controller: mailsCtrl,
      });
      $routeProvider.when('/bac/admin/', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/admin.html',
        controller: adminCtrl,
      });
      $routeProvider.when('/bac/config_mobile/', {
        templateUrl: 'js/XG/widgets/ancapp/main/views/config_mobile.html',
        controller: configMobileCtrl,
      });
      $routeProvider.when('/bac/nocfg', {
        templateUrl: 'js/XG/widgets/bacapp/main/views/no_cfg.html',
        controller: noCfgCtrl,
      });
    },
  ]);

  return gcMain;
});
