'use strict';

define(function() {
  /*
   * documentsCtrl
   */
  var documentsCtrl = function(
    $scope,
    DocumentFactory,
    AncAppFactory,
    gaDomUtils,
    IndicatorParamsFactory,
    $location,
    PortalsFactory
  ) {
    //GET dashboardCfg
    $scope.dashboardCfg = AncAppFactory.appCfg.main.dashboardCfg;

    if (!$scope.dashboardCfg) {
      $scope.dashboardCfg = [];
    }

    /**
     * getDocx (modele)
     * @param fichier
     */
    $scope.getDocx = function(fichier) {
      gaDomUtils.showGlobalLoader();
      DocumentFactory.generatedocx('{}', fichier).then(function(res) {
        window.open(
          '/services/' +
            res.data.portalid +
            '/documents/downloaddocx?' +
            '&name=' +
            res.data.name +
            '&token=' +
            encodeURIComponent(localStorage.getItem('auth_token'))
        );
        gaDomUtils.hideGlobalLoader();
      });
    };

    /**
     * getStaticFIle (static)
     * @param fichier
     */
    $scope.getStaticFIle = function(fichier) {
      window.open(
        '/services/' +
          PortalsFactory.getPortalId() +
          '/ancapp/downloaddashboarddoc?type=static' +
          '&name=' +
          fichier +
          '&bacapp=' +
          '&token=' +
          encodeURIComponent(localStorage.getItem('auth_token'))
      );
    };

    /**
     * getJasperReport (static)
     * @param fichier
     */
    $scope.getJasperReport = function(rapport) {
      var jsonParameters = IndicatorParamsFactory.buildJsonParams(
        rapport.indicateurs
      );
      gaDomUtils.showGlobalLoader();

      var nameWeExt = rapport.fichier.replace('.jasper', '');
      AncAppFactory.generatereport(nameWeExt, jsonParameters).then(
        function(res) {
          window.open(
            '/services/' +
              PortalsFactory.getPortalId() +
              '/ancapp/getreportpdf?filename=' +
              nameWeExt +
              '&bacapp=' +
              '&token=' +
              encodeURIComponent(localStorage.getItem('auth_token'))
          );
          gaDomUtils.hideGlobalLoader();
        },
        function(reason) {
          gaDomUtils.hideGlobalLoader();
          require('toastr').error('Erreur lors de la génération du rapport.');
        }
      );
    };

    // gestion du filemanager en option (ex : CCSB)
    $scope.documentsTabs = false;

    $scope.filemanager = angular.copy(
      AncAppFactory.appCfg.main.properties.filemanager
    );

    // peut acceder seulement si role ANC_rapports_consultation ou ANC_rapports_administration
    var canAccessFM = $scope.xgos.user.roles.filter(function(x) {
      return x.name.indexOf('ANC_rapports_') == 0;
    }).length;

    if (
      angular.isDefined($scope.filemanager) &&
      $scope.filemanager.active &&
      ($scope.xgos.isroot || canAccessFM)
    ) {
      $scope.fileManagerAdmin =
        $scope.xgos.isroot ||
        $scope.xgos.user.roles.filter(function(x) {
          return x.name == 'ANC_rapports_administration';
        }).length
          ? 1
          : 0;

      $scope.documentsTabs = [{ title: 'Documents' }, { title: 'Rapports' }];
      $scope.documentsTabs.activeTab = 0;
      $scope.includeElUrl =
        'php/elFinder2/elfinder.php?f=' +
        btoa($scope.filemanager.folder) +
        '&adm=' +
        $scope.fileManagerAdmin;

      // scope.$watch('dossierInfosSupTabs.activeTab', function (i) {
      //     if (i < 0) scope.dossierInfosSupTabs.activeTab = 0;
      // }, 1)
    }

    // tab actif selon #documents #rapports
    if ($scope.documentsTabs) {
      var activeTab = 0;
      if ($location.hash() == 'rapports') activeTab = 1;
      $scope.documentsTabs.activeTab = activeTab;
    }
  };

  documentsCtrl.$inject = [
    '$scope',
    'DocumentFactory',
    'AncAppFactory',
    'gaDomUtils',
    'IndicatorParamsFactory',
    '$location',
    'PortalsFactory',
  ];
  return documentsCtrl;
});
