'use strict';
define(['angular'], function(angular) {
  var mod = angular.module('ga_domutils_service', []);

  mod.provider('gaDomUtils', function() {
    this.$get = function(
      $filter,
      $timeout
    ) {


      const getTargets = (target) => {
        if (target.substring(0, 1) == '#') {
          return [document.getElementById(target.substring(1))];
        }
        else {
          return document.getElementsByClassName(
            target.replace('.', '')
          );
        }
      };


      // liste de promesses correspondantes aux loaders
      // dont la fermeture a été demandé(avec un délai)
      let loadersToHide = {};
      return {

        /**
         * showGlobalLoader
         * @param waitingId {string | null}
         */
        showGlobalLoader: function(waitingId = null) {
          if (typeof ProgressionAndroid !== 'undefined') {
            try {
              ProgressionAndroid.showProgress();
            } catch (e) {
              e.stack;
            }
          } else {
            if (!waitingId) {
              waitingId = 'xgos_loader';
            }
            // si la fonction hideGlobalLoaderAfterTimeout a été appellé avec
            // le même waitingId alors on supprime le timeout correspondant
            let loaderIsStillDisplayed = false;
            if (loadersToHide[waitingId]) {
              loaderIsStillDisplayed = $timeout.cancel(loadersToHide[waitingId]);
            }
            if (loaderIsStillDisplayed === false) {
              let loader = document.getElementById(waitingId);
              if (loader == null) {
              //   console.log('create global loader');
                loader = angular.element(
                  '<div id="' + waitingId + '" class="xgos_loader visible">'
                + '<div div class= "loader" > <i></i></div> <span class="main">' +
                  $filter('translate')('common.processing') +
                  '</translate></span></div>'
                );
                angular.element(document).find('body').eq(0).append(loader);
              }
              else {
              // force the value, it may not have been translated
              // during the init
                loader.getElementsByClassName('main')[0].innerHTML
                = $filter('translate')('common.processing');
                loader.className = loader.className + ' visible';
              }
            }
          }
        },
        /**
         * setGlobalLoaderScale
         * @param current
         * @param max
         */
        setGlobalLoaderScale: function(current, max) {
          var loader = document.getElementById('xgos_loader'),
            scale = angular.element(loader).find('.scale');

          // reset
          if (scale[0]) {
            //  console.log('reset');
            angular.element(scale).remove();
          }
          scale = angular.element(
            '<div class="scale"><div class="progressbar"></div><span class="val">' +
              current +
              '</span>/<span class="max">' +
              max +
              '</span></div>'
          );
          angular.element(loader).append(scale);
        },
        /**
         * setGlobalLoaderScale
         * @param current
         * @param max
         */
        setGlobalLoaderScaleBar: function(current, max) {
          var loader = document.getElementById('xgos_loader'),
            scaleBar = angular.element(loader).find('.scaleBar');

          // reset
          if (scaleBar[0]) {
            //  console.log('reset');
            angular.element(scaleBar).remove();
          }
          var progress = Math.round((current * 100) / max);
          progress = progress==0?1:progress;
          scaleBar = angular.element(
            '<div class="scaleBar"><div class="progress"><div class="progress-bar" role="progressbar" style="width:'+
            progress+'%">'+progress+'%</div></div></div>'
          );
          angular.element(loader).append(scaleBar);
        },
        /**
         * setGlobalLoaderScaleValue
         * @param value
         */
        setGlobalLoaderScaleValue: function(value) {
          var loader = document.getElementById('xgos_loader'),
            minHandler = angular.element(loader).find('.val'),
            max = parseInt(
              angular
                .element(loader)
                .find('.max')
                .text(),
              10
            ),
            progressbar = angular.element(loader).find('.progressbar'),
            progress = Math.round((value * 100) / max);

          minHandler.text(value);
          progressbar.width(progress + 1 + '%');
        },
        /**
         * masque le globalLoader correspondant au waitingId
         * @param {string|null} waitingId Chaque waitingId correspond à un loader indépendant.
         *     ça permet traiter le cas où on a 2 loaders pour 2 traitements différents qui se chevauche.
         *     si undefined on utilisera le loader par défault: 'xgos_loader'
         */
        hideGlobalLoader: function(waitingId= null) {
          if (typeof ProgressionAndroid !== 'undefined') {
            try {
              ProgressionAndroid.hideProgress();
            } catch (e) {
              e.stack;
            }
          } else {
            if (!waitingId) {
              waitingId = 'xgos_loader';
            }
            let loader = document.getElementById(waitingId);
            if (loader != null) {
              loader.className = loader.className.replace(/visible/g, '');
              var scale = angular.element(loader).find('.scale');
              if (scale[0]) {
                angular.element(scale).remove();
              }
              var scaleBar = angular.element(loader).find('.scaleBar');
              if (scaleBar[0]) {
                angular.element(scaleBar).remove();
              }
            }
          }
        },
        /**
         * hide globalLoader after a timeout in ms
         * mainly used for: avoid double saving on double click (kis-1911)
         * we wait a little so the dialog can close
         * @param {number} timeout timeout in ms. default is 300ms
         * @param {string} waitingId parametre envoyé au hideGlobalLoader
         */
        hideGlobalLoaderAfterTimeout: (timeout, waitingId) => {
          // default value
          if (typeof timeout !== 'number') {
            timeout = 300;
          }
          // register only one timeout for this waitingId
          if (!loadersToHide[waitingId] || loadersToHide[waitingId].$$state.status !== 0) {
            loadersToHide[waitingId] =
          $timeout(() => {
            this.$get().hideGlobalLoader(waitingId);
          }, timeout);
          }
        },
        /**
         * local loader set into target div
         * @param target
         * @returns {string}
         */
        showLocalLoader: function(target) {
          if (typeof ProgressionAndroid !== 'undefined') {
            try {
              ProgressionAndroid.showProgress();
            } catch (e) {
              e.stack;
            }
          } else {
            var uniqid = 'localloader_' + Date.now();
            const targets = target instanceof HTMLDivElement ? [target] : getTargets(target);

            for (var i = 0; i < targets.length; ++i) {
              var loader = angular.element(
                '<div class="xgos_loader visible mini ' +
                  uniqid +
                  '"><div class="loader"><i></i></div><span class="main">' +
                  $filter('translate')('common.processing') +
                  '</translate></span></div>'
              );
              targets[i].appendChild(loader[0]);
            }

            return uniqid;
          }
        },
        /**
         * local loader set into target div
         * @param target
         * @returns {string}
         */
        showPreciseLocalLoader: function(target) {
          if (typeof ProgressionAndroid !== 'undefined') {
            try {
              ProgressionAndroid.showProgress();
            } catch (e) {
              e.stack;
            }
          } else {
            var uniqid = 'localloader_' + Date.now();

            var targets = document.getElementsByClassName(
              target.replace('.', '')
            );

            for (var i = 0; i < targets.length; ++i) {
              target = targets[i];
              var loader = angular.element(
                '<div class="xgos_loader visible mini ' +
                  uniqid +
                  '"><div class="loader" style="position:absolute ; top:45%; left:23%"><i></i></div><span style="position:absolute ; top:47%; left:33%">' +
                  $filter('translate')('common.processing') +
                  '</translate></span></div>'
              );
              loader.css('top', target.offsetTop);
              loader.css('left', target.offsetLeft);
              loader.width(target.clientWidth);
              loader.height(target.clientHeight);
              loader.css('position', 'absolute');
              targets[i].appendChild(loader[0]);
            }

            return uniqid;
          }
        },
        /**
         * local loader set into target div
         * @param target
         * @returns {string}
         */
        showFixedLocalLoader: function(target) {
          if (typeof ProgressionAndroid !== 'undefined') {
            try {
              ProgressionAndroid.showProgress();
            } catch (e) {
              e.stack;
            }
          } else {
            var uniqid = 'localloader_' + Date.now();

            var targets = document.getElementsByClassName(
              target.replace('.', '')
            );

            for (var i = 0; i < targets.length; ++i) {
              target = targets[i];
              var loader = angular.element(
                '<div class="xgos_loader visible mini ' +
                  uniqid +
                  '"><div class="loader" style="position:absolute ; top:40%; left:27%"><i></i></div><span style="position:absolute ; top:42%; left:35%">' +
                  $filter('translate')('common.processing') +
                  '</translate></span></div>'
              );
              loader.css('top', target.offsetTop);
              loader.css('left', target.offsetLeft);
              loader.width(target.clientWidth);
              loader.height(target.clientHeight);
              loader.css('position', 'fixed');
              targets[i].appendChild(loader[0]);
            }

            return uniqid;
          }
        },

        /**
         * remove local loader
         * @param target
         */
        removeLocalLoader: function(target) {
          if (typeof ProgressionAndroid !== 'undefined') {
            try {
              ProgressionAndroid.hideProgress();
            } catch (e) {
              e.stack;
            }
          }
          else {
            const targets = getTargets(target);
            for (let i = 0; i < targets.length; ++i) {
              const loaders = targets[i].getElementsByClassName('xgos_loader');
              for (var j = 0; j < loaders.length; ++j) {
                loaders[j].parentNode.removeChild(loaders[j]);
              }
            }
          }
        },

        /**
         * convertDataURItoBlob
         * used in map canvas to blob for example
         * @param dataURI
         * @returns {Blob}
         */
        convertDataURItoBlob: function(dataURI) {
          var byteString, mimestring;

          if (dataURI.split(',')[0].indexOf('base64') !== -1) {
            byteString = atob(dataURI.split(',')[1]);
          } else {
            byteString = decodeURI(dataURI.split(',')[1]);
          }
          mimestring = dataURI
            .split(',')[0]
            .split(':')[1]
            .split(';')[0];

          var content = new Array();
          for (var i = 0; i < byteString.length; i++) {
            content[i] = byteString.charCodeAt(i);
          }
          var rawContent = new Uint8Array(content),
            returnBlob = new Blob([rawContent], {
              type: mimestring,
            });

          return returnBlob;
        },
      };
    };
    this.$get.$inject = [
      '$filter',
      '$timeout',
    ];
  });

  return mod;
});
