/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  var gcelement = function(
    ApplicationFactory,
    DataStoreFactory,
    $rootScope,
    ReportIndicatorFactory,
    AtlasFactory,
    gaDomUtils,
    $filter,
    ngDialog,
    ReportFactory,
    ngTableParams
  ) {
    return {
      templateUrl: 'js/XG/modules/tools/views/directives/addReport.html',
      restrict: 'E',
      scope: {
        currentatlasressource: '=currentAtlasRessource',
        types: '=types',
      },
      link: function(scope) {
        ApplicationFactory.get().then(function(res) {
          scope.appnames = res.data
            .map(function(x) {
              if (x.type === 'MapApp') return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            });
        });
        DataStoreFactory.get($rootScope.xgos.portal.uid).then(function(res) {
          scope.storeNames = res.data
            .map(function(x) {
              return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            });
        });

        scope.typeChanged = function(rapport) {
          switch (rapport.type) {
            case $filter('translate')('model.featuretypes.actions.StaticModel'):
              AtlasFactory.getfilesstatic().then(
                function(res) {
                  rapport.files = res.data;
                },
                function() {
                  require('toastr').error('error');
                }
              );
              break;
            case $filter('translate')('model.featuretypes.actions.JasperModel'):
              rapport.files = [];
              ReportIndicatorFactory.getAllReportNamesFromApplication(
                rapport.appname
              ).then(
                function(res) {
                  rapport.files = res.data;
                },
                function() {
                  require('toastr').error('error');
                }
              );
              break;
          }
        };

        scope.uploadedFile = function(input, str) {
          var file = input.files[0];
          var formdata = new FormData();
          formdata.append('file', file);
          gaDomUtils.showGlobalLoader();
          AtlasFactory.uploadfilestatic(file.name, formdata).then(
            function(res) {
              if (file.name === '' || file.name === null) return;
              scope.currentatlasressource[str].fileUploaded = file;
              scope.currentatlasressource[str].file = file.name;
              if (angular.isUndefined(scope.currentatlasressource[str].files))
                scope.currentatlasressource[str].files = [];
              if (
                scope.currentatlasressource[str].files.indexOf(file.name) === -1
              )
                scope.currentatlasressource[str].files.push(file.name);
              gaDomUtils.hideGlobalLoader();
            },
            function() {
              gaDomUtils.hideGlobalLoader();
              require('toastr').error('error');
            }
          );
        };

        scope.changeJasperReport = function(rapport, str) {
          if (
            rapport[str].type ===
            $filter('translate')('model.featuretypes.actions.JasperModel')
          )
            ReportFactory.getParams(
              rapport[str].file,
              rapport[str].appname
            ).then(
              function(res) {
                rapport[str].parameters = res.data;
                if (res.data.length > 0) {
                  scope.docsParamselement(str);
                  scope.openParametes(rapport[str]);
                }
              },
              function() {
                require('toastr').error('error');
              }
            );
        };

        scope.saisieModes = [
          $filter('translate')('model.featuretypes.actions.saisieStatic'),
        ];

        scope.validerParameters = function() {
          scope.currentatlasressource[
            scope.docsParams
          ].parameters = angular.copy(scope.rapportParameters.parameters);
        };

        scope.closeDiag = function() {
          scope.p.close();
        };

        scope.openParametes = function(rapport) {
          scope.rapportParameters = angular.copy(rapport);
          scope.p = ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.featuretypes.actions.parameters.html',
            scope: scope,
            closeByDocument: false,
            className: 'ngdialog-theme-plain width800',
          });
        };
        scope.docsParamselement = function(str) {
          scope.docsParams = str;
        };

        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.rapportParameters.parameters.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.rapportParameters.parameters.length); // set total for recalc pagination

              $defer.resolve(displayedTab);
            },
          }
        );
      },
    };
  };

  gcelement.$inject = [
    'ApplicationFactory',
    'DataStoreFactory',
    '$rootScope',
    'ReportIndicatorFactory',
    'AtlasFactory',
    'gaDomUtils',
    '$filter',
    'ngDialog',
    'ReportFactory',
    'ngTableParams',
  ];
  return gcelement;
});
