'use strict';
define(function() {
  /**
   * factory contenant des functions n'utilisant pas elastic. on rempace des appels élastic par des appels base de données.
   */
  var ElasticReplacementFactory = function($http, $q) {

    const queryOnJointureDossierAndControle = (whereClause, sendData) => {
      if (typeof whereClause != 'string') {
        whereClause = '';
      }
      return $http.post(
        '/services/{portalid}/elasticReplacement/queryOnJointureDossierAndControle?f=json' +
        '&whereClause=' + whereClause, 
        sendData
        ).then( (res) => {
          let def = $q.defer();
          
          res.data.crs = {"type": "name","properties": {"name": "EPSG:3857"}};
          res.data.type = "FeatureCollection";
          // result.fti = TODO kis-2711
          
          def.resolve(res);
          return def.promise;
        });
    }

    const facturationDatabaseQuery = (relations) => {
      // change date format to fit elasticRule
      // for (let attribute of elasticQuery.relations) {
      //   for (let clause of attribute.filters) {
      //     if (clause.choice === 'rule' && clause.type == 'java.sql.Timestamp') {
      //       clause.newValueUtil = {[clause.name]: new Date(clause.value)};
      //     }
      //   }
      // }
      let whereClause = getWhereClauseForRelations(relations);

      return queryOnJointureDossierAndControle(whereClause, relations[0]);
    }

    const getStringForClause = (clauseData) => {
      /// clauseData.operand contains the operator, not the operand !
      let stringWhereClause = null;
      if (clauseData.name && clauseData.operand) {
        let correctValue = undefined;
        if (clauseData.operand != 'exists' &&
          clauseData.operand != 'notExists') {
          //Handle specific cases and correct format of the value
          if (clauseData.operand == 'last' ||
            clauseData.operand == 'next') {
            //for some reason, in this specific case, the value is stored in .newvalue
            correctValue = clauseData.newvalue;
          } else if (clauseData.attr && clauseData.attr.restrictions && clauseData.attr.restrictions[0] &&
            clauseData.operand === "equals") {
            //when the field has a restriction (table, domain, user, ...) value is stored in .restrictedValue
            if (clauseData.restrictedValue != undefined) {
              correctValue = clauseData.restrictedValue[clauseData.name];
            }
          } else if (clauseData.name.startsWith('extraFormFields.') && clauseData.restrictedValue != undefined) {
            correctValue = clauseData.restrictedValue[clauseData.name];
          } else if (clauseData.type == 'java.util.Date') {
            if (typeof clauseData.value == "string") {
              //sometimes it is a string, no format needed
              correctValue = clauseData.value;
            } else {
            // format like that: 2012-03-31T22:00:00.000Z
              if (clauseData.value != undefined) {
                correctValue = clauseData.value.toISOString();
              }
            }
          } else if (clauseData.type == 'java.sql.Timestamp' && typeof clauseData.value === 'string') {
              correctValue = "'" + clauseData.value + "'";
          } else if ((clauseData.operand == 'equals') && (clauseData.type == 'java.lang.Boolean')) {
            //for some reasons, in this specific case, the value is stored in weird location
            if (clauseData.newValueUtil != undefined) {
              correctValue = clauseData.newValueUtil[clauseData.name];
            }
          } else {
            // ignore filter if value is empty string
            if (clauseData.value !== "" && typeof clauseData.value !== 'object') {
              correctValue = clauseData.value;
            }
          }
        }

        // ignore filter if correctValue is undefined
        //in case 'exists' and 'notExists' there is no value
        if (correctValue != undefined ||
          clauseData.operand == 'exists' ||
          clauseData.operand == 'notExists') {

          if (clauseData.guid === "extrafactu_controle") {
            // get data in 'document_json' field
            if (clauseData.name.startsWith('extraFormFields.')) {
              // au 11/01/23 seul Thierache du centre utilise un extraField sans ces critères avancées de factu
              stringWhereClause = "document_json::jsonb" + 
                " -> 'extraFormFields' ->> '" + clauseData.name.split('.')[1] + "'";
            } else {
              switch (clauseData.name) {
                case 'agent': stringWhereClause = 'conformite.agent';
                  break;
                case 'avis_agent': stringWhereClause = 'conformite.valeur_agent';
                  break;
                // --- ANC ----
                case 'avis': stringWhereClause = "document_json::jsonb" + 
                    " -> 'conformite' ->> 'valeur'";
                  break;
                case 'type': stringWhereClause = "document_json::jsonb" + 
                    " -> 'service_controle' ->> 'type'";
                  break;
                case 'filiere_sup_20_eh': stringWhereClause = "document_json::jsonb" + 
                    " -> 'service_controle' ->> 'type'";
                  break;

                // --- BAC ---
                case 'info_generales.type_controle':
                  stringWhereClause = "document_json::jsonb" + 
                    " -> 'info_generales' ->> 'type_controle'";
                  // on envlève les 0 au debut de la string car les typecontroles sont stocker sous forme de int en json
                  // --> 1 = '01' NOT ok
                  // --> 1 = '1' ok
                  if (correctValue.startsWith('0')) {
                    while (correctValue.startsWith('0')) correctValue = correctValue.substring(1);
                  }
                  break;
                case 'info_generales.montant_pfac': stringWhereClause = "document_json::jsonb" + 
                    " -> 'info_generales' ->> 'montant_pfac'";
                  break;
                default: stringWhereClause = undefined;
              }
            }
          } else if (clauseData.guid === "extrafactu_dossier") {
            // get data from a normal database field
            stringWhereClause = 'public.kis_anc_dossier.' + clauseData.name;
          } else {
            // get data from a normal database field
            stringWhereClause = clauseData.name;
          }



          switch (clauseData.operand) {
            case 'startWith':
              stringWhereClause += " LIKE '" + correctValue + "%'";
              break;
            case 'endWith':
              stringWhereClause += " LIKE '%" + correctValue + "'";
              break;
            case 'regexp':
              stringWhereClause += " LIKE '%" + correctValue + "%'";
              break;
            case 'equals':
              if ((clauseData.type == 'java.lang.String') || (clauseData.type == 'java.lang.Boolean')) {
                stringWhereClause += " = '" + correctValue + "'";
              } else {
                stringWhereClause += ' = ' + correctValue;
              }
              break;
            case 'notEquals':
              stringWhereClause += " <> '" + correctValue + "'";
              break;
            case 'include':
              // is included in a list of value
              stringWhereClause += " IN ('" + correctValue.replaceAll(',', "','") + "')";
              break;
            case 'gt':
              // '>' greater than
              stringWhereClause += ' > ' + correctValue;
              break;
            case 'gte':
              // '>=' greater than or equals
              stringWhereClause += ' >= ' + correctValue;
              break;
            case 'lt':
              // '<'
              stringWhereClause += ' < ' + correctValue;
              break;
            case 'lte':
              // '<='
              stringWhereClause += ' <= ' + correctValue;
              break;
            case 'exists':
              if (clauseData.type == 'java.lang.String') {
                stringWhereClause = stringWhereClause + ' IS NOT NULL AND ' + stringWhereClause + " <> ''";
              } else {
                stringWhereClause += ' IS NOT NULL';
              }
              break;
            case 'notExists':
              if (clauseData.type == 'java.lang.String') {
                stringWhereClause = '(' + stringWhereClause + ' IS NULL OR ' + stringWhereClause + " = '')";
              } else {
                stringWhereClause += ' IS NULL';
              }
              break;
            case 'last':
              stringWhereClause +=
                " BETWEEN datetime('now', '-" +
                correctValue +
                " days') AND datetime('now', 'localtime')";
              break;
            case 'next':
              stringWhereClause +=
                " BETWEEN datetime('now', '+" +
                correctValue +
                " days') AND datetime('now', 'localtime')";
              break;
            default:
              stringWhereClause = null;
              break;
          }
        } else {
          stringWhereClause = null;
        }
      } else {
        stringWhereClause = null;
      }
      if ((stringWhereClause == null) && (clauseData.name != undefined)) {
        console.log('intervention simple: ignoring "WHERE" clause -> ' + clauseData.name);
      }
      return stringWhereClause;
    }

    /**
     * 
     * @param {*} relations elastic filter relations
     * @returns 
     */
    const getWhereClauseForRelations = (relations) => {
      let globalWhereClause = '';

      for (let attribute of relations) {
        for (let clause of attribute.filters) {
          //add where clause
          const singleWhereClause = getStringForClause(clause);
          if(singleWhereClause != undefined) {
            if (globalWhereClause != "") {
              globalWhereClause += " AND ";
            }
            globalWhereClause += singleWhereClause;
          }
        }
        // Les critères de facturation avancée liés sont stocké à part:
        // Pour l'ANC c'est les ('extrafactu_dossier') qui sont stockés dans 'attribute.filters[0].filters'
        if (Array.isArray(attribute.filters) && attribute.filters.length > 0 && attribute.filters[0].filters) {
          for (let clause of attribute.filters[0].filters) {
            if (clause.guid === "extrafactu_dossier") {
              //add where clause
              const singleWhereClause = getStringForClause(clause);
              if(singleWhereClause != undefined) {
                if (globalWhereClause != "") {
                  globalWhereClause += " AND ";
                }
                globalWhereClause += singleWhereClause;
              }
            }
          }
        }
        // Pour BAC c'est les ('extrafactu_controle') qui sont stockés dans 'attribute.filters[1].filters'
        if (Array.isArray(attribute.filters) && attribute.filters.length > 1 && attribute.filters[1].filters) {
          for (let clause of attribute.filters[1].filters) {
            if (clause.guid === "extrafactu_controle") {
              //add where clause
              const singleWhereClause = getStringForClause(clause);
              if(singleWhereClause != undefined) {
                if (globalWhereClause != "") {
                  globalWhereClause += " AND ";
                }
                globalWhereClause += singleWhereClause;
              }
            }
          }
        }
      }

      return globalWhereClause;
    }

    return {
      queryOnJointureDossierAndControle: queryOnJointureDossierAndControle,
      facturationDatabaseQuery: facturationDatabaseQuery,
      getWhereClauseForRelations: getWhereClauseForRelations,
    };
  };
  ElasticReplacementFactory.$inject = ['$http', '$q'];
  return ElasticReplacementFactory;
});
