'use strict';

define([
  'angular',
  'modules/portals/services/PortalsFactory',
  'modules/portals/services/ThemesFactory',
  'modules/portals/services/RegionalFactory',
  'modules/portals/controllers/PortalsCtrl',
  'modules/portals/directives/portalSwitcher',
  'modules/portals/directives/portalSwitcherAvance',
  'modules/portals/directives/portalArcgisConfig',
], function(
  angular,
  PortalsFactory,
  ThemesFactory,
  RegionalFactory,
  PortalsCtrl,
  portalSwitcher,
  portalSwitcherAvance,
  portalArcgisConfig
) {
  // Module
  var mod = angular.module('portals', ['pascalprecht.translate',]);

  // Services
  mod.factory('PortalsFactory', PortalsFactory);
  mod.factory('ThemesFactory', ThemesFactory);
  mod.factory('RegionalFactory', RegionalFactory);

  // Controllers
  mod.controller('PortalsCtrl', PortalsCtrl);

  // directives
  mod.directive('portalSwitcher', portalSwitcher);
  mod.directive('portalSwitcherAvance', portalSwitcherAvance);
  mod.directive('portalArcgisConfig', portalArcgisConfig);

  // Configuration
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      // Routes
      $routeProvider.when('/supervision/', {
        controller: PortalsCtrl,
        templateUrl: 'js/XG/modules/portals/views/admin.html',
      });
    },
  ]);

  return mod;
});
