/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  var gcelement = function(ngDialog, $filter) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsForm.html',
      restrict: 'E',
      scope: {
        currentFormData: '=currentformdata',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.currentFormData.typeInfo = 'FORMULAIRE';

        if (scope.currentFormData.name)
          scope.name = angular.copy(scope.currentFormData.name);
        scope.openConfigBrowser = function() {
          if (scope.currentFormData.form)
            scope.currentFormData.name = scope.currentFormData.form.replace(
              '.form',
              ''
            );
          ngDialog.open({
            template:
              'js/XG/widgets/utilities/form/views/modal/builderOpen.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.openForm = function(openData) {
          openData.name.indexOf('.form') === -1
            ? (scope.currentFormData.form = openData.name + '.form')
            : (scope.currentFormData.form = openData.name);
          scope.currentFormData.name = scope.name || scope.currentFormData.name;
        };
      },
    };
  };

  gcelement.$inject = ['ngDialog', '$filter'];
  return gcelement;
});
