'use strict';
define(function() {
  var gcelement = function($filter, ngTableParams, ArcGisGeoprocess) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsEsrigeoprocess.html',
      restrict: 'E',
      scope: {
        currentFormData: '=currentformdata',
        fti: '=fti',
        allActionsNames: '=allactionsnames',
      },
      link: function(scope) {
        scope.currentFormData.actionType = $filter('translate')(
          'model.featuretypes.actions.esrigeoprocess'
        );
        scope.currentFormData.typeInfo = 'GEOPROCESS_ESRI';

        if (angular.isUndefined(scope.currentFormData.parameters)) {
          scope.currentFormData.parameters = [];
        }

        let names = [];
        scope.attributesAliases = [];
        for (const attribute of scope.fti.attributes) {
          names.push(attribute.name);
          scope.attributesAliases.push(attribute.alias);
        }

        /**
         * Paramètres du tableau listant les règles associées
         * au currentfeaturetype passé à cette directive
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: ($defer, params) => {
              let displayedTab = scope.currentFormData.parameters.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              // set total for recalc pagination
              params.total(scope.currentFormData.parameters.length);
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.attributChanged = (rapport) => {
          if (
            rapport.saisieMode ===
              $filter('translate')(
                'model.featuretypes.actions.saisieAttribut'
              ) ||
            rapport.typeInfo === 'saisieAttribut'
          ) {
            let idx = scope.attributesAliases.indexOf(rapport.attribute);
            rapport.value = names[idx];
          }
        };

        scope.addParameter = () => {
          scope.currentFormData.parameters.push({
            id: Math.floor(Math.random() * 10000),
          });
          scope.tableParams.reload();
        };

        scope.removeParameter = (idx) => {
          scope.currentFormData.parameters.splice(idx, 1);
          scope.tableParams.reload();
        };

        scope.saisieModes = [
          $filter('translate')('model.featuretypes.actions.saisieAttribut'),
          $filter('translate')('model.featuretypes.actions.saisieUtilisateur'),
          $filter('translate')('model.featuretypes.actions.saisieStatic'),
          $filter('translate')('model.featuretypes.actions.linearAtlasGeometry'),
          $filter('translate')('model.featuretypes.actions.surfaceAtlasGeometry'),
        ];

        scope.changedParameters = (rapport) => {
          switch (rapport.saisieMode) {
            case $filter('translate')(
              'model.featuretypes.actions.saisieAttribut'
            ):
              rapport.typeInfo = 'saisieAttribut';
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieUtilisateur'
            ):
              rapport.typeInfo = 'saisieUtilisateur';
              break;
            case $filter('translate')(
              'model.featuretypes.actions.saisieStatic'
            ):
              rapport.typeInfo = 'saisieStatic';
              break;
            case $filter('translate')(
              'model.featuretypes.actions.linearAtlasGeometry'
            ):
              rapport.typeInfo = 'linearAtlasGeometry';
              break;
            case $filter('translate')(
              'model.featuretypes.actions.surfaceAtlasGeometry'
            ):
              rapport.typeInfo = 'surfaceAtlasGeometry';
              break;
          }
        };

        /**
       * Fonction appelée suite à modification de l'URL ArcGIS.
       * Elle récupère la description du géoprocess ArcGIS grâce à son URL.
       * Si une description est trouvée, elle met à jour les paramètres ArcGIS dans le scope.
       * Si aucune description n'est trouvée, attendre que la promesse
       * soit résolue avant de s'appeler lui-même récursivement.
       */
        scope.ArcGISUrlChanged = () => {
          const result = ArcGisGeoprocess.getDescription(scope.currentFormData.url);
          if (result.description) {
            scope.arcGisParameters = result.description.parameters;
          }
          else {
            result.promise.then(() => {
              // -- En rappelant cette méthode, la description ayant été chargée,
              // --on passera dans le "if"
              scope.ArcGISUrlChanged();
            });
          }
        };

        scope.ArcGISUrlChanged();
      },
    };
  };

  gcelement.$inject = ['$filter', 'ngTableParams','ArcGisGeoprocess'];
  return gcelement;
});
