"use strict";
define(function () {
  var EditRuleSetDefaultValueByRole = {

    $get: function (
      $rootScope,
      $q,
      $filter,
      RolesFactory,
      QueryFactory
      ) {

      /**
       * regle metier (edit rule) 'setDefaultValueByRole'
       * sets the target attribute with a value depending on the role of the user
       * @param {*} editdescription 
       * @param {*} ruleConf 
       * @returns promise
       */
      function setDefaultValueByRole(editdescription, ruleConf, featureType) {
        const defer = $q.defer();
        const format = new ol.format.GeoJSON();
        if (editdescription.formFeature && editdescription.formFeature.current) {
          // set form variable if we need to
          editdescription.editedfeature = format.readFeatures(editdescription.formFeature.current)[0];
        }
        
        RolesFactory.getRolesByUser($rootScope.xgos.user.login).then((res) => {
          if (ruleConf && ruleConf.parameters && ruleConf.parameters.targetField
            && ruleConf.parameters.rolesAndValues && Array.isArray(ruleConf.parameters.rolesAndValues)
            && editdescription && editdescription.editedfeature
            && res.data && Array.isArray(res.data)) {

            // find if user has a matching role in the config
            let valueForHisRole = ruleConf.parameters.rolesAndValues.find(
                rolesAndValue => {
                  let correctConfigFound = false;
                  if (rolesAndValue.roles && Array.isArray(rolesAndValue.roles)) {
                    for(const configRole of rolesAndValue.roles) {
                      if (res.data.find(userRole => userRole.name === configRole) ) {
                        correctConfigFound = true;
                      }
                    }
                  }
                  return correctConfigFound;
                });

            let properties = editdescription.editedfeature.getProperties();
            // if no role matched -> put default value
            if (!valueForHisRole) {
              valueForHisRole = ruleConf.parameters.rolesAndValues.find(rolesAndValue => {
                if (rolesAndValue.roles && Array.isArray(rolesAndValue.roles)) {
                  return rolesAndValue.roles.indexOf("") > -1;
                } else {
                  return false;
                }
              });
            }
            if (valueForHisRole && valueForHisRole.value && properties) {

              let tableRestriction;
              const ftiAttribute = featureType.attributes.find(attribute => attribute.name===ruleConf.parameters.targetField)
              if (ftiAttribute && Array.isArray(ftiAttribute.restrictions) && ftiAttribute.restrictions.length > 0) {
                if (ftiAttribute.restrictions[0].type === 'Tables') {
                  tableRestriction = ftiAttribute.restrictions[0];
                }
              }
              let valueToUse;
              let shouldTranslateTableRestrictionValue = false;
              if (tableRestriction && valueForHisRole.keyTableRestriction && Object.keys(valueForHisRole.keyTableRestriction).length> 0) {
                valueToUse = valueForHisRole.keyTableRestriction;
              } else if (tableRestriction) {
                // handle legacy config
                shouldTranslateTableRestrictionValue = true;
                valueToUse = valueForHisRole.value;
              } else {
                valueToUse = valueForHisRole.value;
              }

              // we should set undefined instead of ""
              if (angular.isDefined(valueToUse[ruleConf.parameters.targetField]) && valueToUse[ruleConf.parameters.targetField] !== '') {
                if (shouldTranslateTableRestrictionValue) {
                  // traduire valueToUse[ruleConf.parameters.targetField]
                  // handle legacy config
                  const filter = tableRestriction.applyFilter && tableRestriction.filterDefinition.indexOf('#$') < 0 ?
                      tableRestriction.filterDefinition : '';
                  QueryFactory.getKeyRestrictionTable(
                    featureType.uid, ruleConf.parameters.targetField, valueToUse[ruleConf.parameters.targetField], filter).then(res => {
                      properties[ruleConf.parameters.targetField] = res.data.key;
                      
                      // set form variable if we need to
                      editdescription.editedfeature.setProperties(properties);
                      if (editdescription.formFeature && editdescription.formFeature.current) {
                        editdescription.formFeature.current = format.writeFeatureObject(editdescription.editedfeature);
                      }
                      defer.resolve();
                  }, (err) => {
                    require('toastr').error($filter('translate')("functions_browser.functions.executeSetDefaultValueByRole.executionError"));
                    defer.reject();
                  });
                } else {
                  properties[ruleConf.parameters.targetField] = valueToUse[ruleConf.parameters.targetField];
                }
              } else {
                properties[ruleConf.parameters.targetField] = undefined;
              }
              if (!shouldTranslateTableRestrictionValue) {
                editdescription.editedfeature.setProperties(properties);
                // set form variable if we need to
                if (editdescription.formFeature && editdescription.formFeature.current) {
                  editdescription.formFeature.current = format.writeFeatureObject(editdescription.editedfeature);
                }
                defer.resolve();
              }
            }
          } else {
            require('toastr').error($filter('translate')("functions_browser.functions.executeSetDefaultValueByRole.executionError"));
            defer.reject();
          }
        })
        .catch(() =>{
          defer.reject();
        });
        return defer.promise;
      }

      return {
        setDefaultValueByRole: setDefaultValueByRole
      };
    }
  };

  EditRuleSetDefaultValueByRole.$get.$inject = [
    '$rootScope',
    '$q',
    '$filter',
    'RolesFactory',
    'QueryFactory'
  ];
  return EditRuleSetDefaultValueByRole;
});