'use strict';
define(function() {
  var AdvancedEditionFactory = function(
    $http,
    $filter,
    $translate,
    FeatureTypeFactory
  ) {
    var AdvancedEditionFactory = {};

    var storeNameToLoadIds = null;

    var storedLotOfIds = [];

    var lastUsedId = -1;

    var indexUseLotOfIds = 0;

    var handlingIdsNotImplemented = false;

    var idsInUse = [];

    const ERROR_RESPONSE = 'ERROR_RESPONSE';
    const WARNING_RESPONSE = 'WARNING_RESPONSE';
    const INFO_RESPONSE = 'INFO_RESPONSE';

    const CAN_PROCESS_EDIT = { canProcessEdit: true };
    const CANNOT_PROCESS_EDIT = { canProcessEdit: false };

    function sendResponse(responseMessage, typeResponse, saveRelated, promise) {
      if (saveRelated == null) saveRelated = false;
      if (typeResponse == null) typeResponse = INFO_RESPONSE;
      else if (
        ERROR_RESPONSE != typeResponse &&
        WARNING_RESPONSE != typeResponse &&
        INFO_RESPONSE != typeResponse
      )
        typeResponse = INFO_RESPONSE;
      return {
        message: responseMessage,
        type: typeResponse,
        saveRelated: saveRelated,
        promise: promise,
        isEditionResponse: true,
      };
    }

    function logResponse(response) {
      if (ERROR_RESPONSE == response.type)
        require('toastr').error(response.message);
      else if (WARNING_RESPONSE == response.type)
        require('toastr').warning(response.message);
      else if (INFO_RESPONSE == response.type)
        require('toastr').info(response.message);
    }

    function isEditionResponse(response) {
      return response.isEditionResponse;
    }

    /**
     * Class : AdvancedEditionFactory
     * Factory WebServices
     */


    /**
     *     Recherche d'erreurs dans le retour du "applyEdits".
     * Les erreurs détectées sont affichées dans le toastr.
     *
     * @param {[[type]]} resdata [[Description]]
     */
    function manageApplyEditsErrors(resdata) {
      var ind,
        mess = '',
        ierr,
        ftiOps,
        fti,
        rdArray;

      if (resdata instanceof Array) rdArray = resdata;
      else rdArray = [resdata];
      for (ind = 0; ind < rdArray.length; ind++) {
        ftiOps = rdArray[ind].response;
        if (!ftiOps && rdArray[ind].data[0]) {
          ftiOps = rdArray[ind].data[0].response;
        }
        if (!ftiOps && rdArray[ind].data && rdArray[ind].data.errors) {
          ftiOps = rdArray[ind].data;
        }
        for (ierr = 0; ierr < ftiOps.errors.length; ierr++) {
          mess += JSON.stringify(ftiOps.errors[ierr]) + '\n';
        }
        if (mess.length == 0 && ftiOps.create.length == 0 &&
          ftiOps.delete.length == 0 && ftiOps.depose.length == 0 &&
          ftiOps.historic.length == 0 && ftiOps.update.length == 0) {
          fti = FeatureTypeFactory.getFeatureByUid(resdata.data[ind].ftiUID);
          mess +=
            'ApplyEdits: Erreur non détaillée pour le composant [' +
            fti.name +
            ']\n';
        }
      }
      if (mess.length) {
        require('toastr').error(mess);
      }
    }

    /**
     * Function: applyEdits
     */
    function applyEdits(senddata, crs, checktopology) {
      var promise = $http.post(
        '/services/{portalid}/processedition/{appname}/applyedits?f=json' +
          '&crs=' +
          crs +
          '&checktopology=' +
          checktopology +
          '&storename=' +
          storeNameToLoadIds,
        senddata
      );
      promise.then(
        function(res) {
          if (angular.isDefined(res.data)) {
            if (
              angular.isDefined(res.data.stopAllEdits) &&
              res.data.stopAllEdits == true
            ) {
              var errorMessage = $filter('translate')(
                res.data.stopAllEditsReason
              );
              require('toastr').error(errorMessage);
            } else manageApplyEditsErrors(res.data);
            if (angular.isDefined(res.data.lotOfIdsJSON)) {
              if (angular.isArray(res.data.lotOfIdsJSON)) {
                idsInUse = [];
                indexUseLotOfIds = 0;
                storedLotOfIds = res.data.lotOfIdsJSON;
              } else handlingIdsNotImplemented = true;
            }
          }
          lastUsedId = -1;
        },
        function(err) {
          console.log(err);
          lastUsedId = -1;
        }
      );
      return promise;
    }


    function isTemporaryId(idToCheck) {
      if (indexUseLotOfIds == 0 || idsInUse.length == 0) return false;
      else return idsInUse.indexOf(idToCheck) !== -1;
    }

    function getObjectId(feature) {
      if (angular.isDefined(feature.getId)) return feature.getId();
      else if (feature.properties && feature.properties.objectid)
        return feature.properties.objectid;
      else if (feature.id) return feature.id;
      else return -1;
    }

    return {
      AdvancedEditionFactory: AdvancedEditionFactory,
      applyEdits: applyEdits,
      getObjectId: getObjectId,
      isTemporaryId: isTemporaryId,
      sendResponse: sendResponse,
      logResponse: logResponse,
      isEditionResponse: isEditionResponse,
      INFO_RESPONSE: INFO_RESPONSE,
      WARNING_RESPONSE: WARNING_RESPONSE,
      ERROR_RESPONSE: ERROR_RESPONSE,
      CAN_PROCESS_EDIT: CAN_PROCESS_EDIT,
      CANNOT_PROCESS_EDIT: CANNOT_PROCESS_EDIT,
    };
  };
  AdvancedEditionFactory.$inject = [
    '$http',
    '$filter',
    '$translate',
    'FeatureTypeFactory',
  ];
  return AdvancedEditionFactory;
});