'use strict';
define(function() {
  var VersionsFactory = function($http, $q) {
    var VersionsFactory = {};


    const getIndigauVersion = (versData, versTreedata, def) => {
      $http.get(
        '/services/{portalid}/indigau/{appname}/getversion?f=json'
      ).then((res) => {
        const data = res.data;
        let version;
        if (!data.errorList || data.errorList.length != 0
          || !data.strValeur || data.strValeur.length == 0) {
          version = 'Indigau 2.0.1';
        }
        else {
          version = data.strValeur;
        }
        def.resolve([versData, versTreedata, version]);
      });
    };


    /**
     * Function: getVersions
     */
    function getVersions(sector) {
      var def = $q.defer();
      // recuperation des versions
      $http.get('./versions_kis/versions.json').then(
        function(response) {
          let data = response.data;
          let status = response.status;

          if (data && status === 200) {
            let versionsData = data;
            let versionTreedata = [];

            let actuelleList = versionsData.current.split('.');
            for (let version of versionsData.versions) {
              let compare = version.number.split('.');
              let valideVersion = true;
              for(let i=0;i<actuelleList.length;i++){
                if(!angular.isDefined(compare[i])){
                  break;
                }else if(parseInt(actuelleList[i])>parseInt(compare[i])){
                  break;
                }else if(parseInt(actuelleList[i])<parseInt(compare[i])){
                  valideVersion = false;
                  break;
                }
              }
              // ne prend que les versions <= version actuelle
              if (valideVersion) {
                let pdfLink;

                if (
                  angular.isDefined(version.blank) &&
                  version.blank == true
                ) {
                  pdfLink = null;
                } else {
                  pdfLink =
                    './versions_kis/' + version.number + '.pdf';

                  versionTreedata.push({
                    label: version.number,
                    date: version.date,
                    pdf: pdfLink,
                  });
                }
              }
            }
            if (sector !== 'indigau') {
              def.resolve([versionsData, versionTreedata]);
            }
            else {
              getIndigauVersion(versionsData, versionTreedata, def);
            }
          } else {
            def.reject();
            console.log(
              '%c  cannot get version number ',
              'background: #f00; color: #fff'
            );
          }
        },
        function() {
          def.reject();
          console.log(
            '%c  cannot get version number ',
            'background: #f00; color: #fff'
          );
        }
      );

      return def.promise;
    }

    return {
      VersionsFactory: VersionsFactory,
      getVersions: getVersions,
    };
  };
  VersionsFactory.$inject = ['$http', '$q'];
  return VersionsFactory;
});
