/**
 *
 */
'use strict';
define(function() {
  var TypeProjetCtrl = function($scope, ConfigFactory, gaJsUtils) {
    $scope.defineDefaultConfig = function() {
      if ($scope.ConfigName != undefined && $scope.ConfigName != '') {
        var cfg = ($scope.config = {});
        cfg['new'] = {};
        cfg.search = {};
        cfg['new'].directive = 'typeprojetdirective';
        cfg['new'].configName = $scope.ConfigName;
        cfg.search.directive = 'cherchermodsupdirective';
        cfg.search.configName = $scope.ConfigName;
        return true;
      }
      return false;
    };

    /**
     *        Get configuration, description of tables/layers
     *    and eventually database object from server
     *    while this is not done the widget construction is waiting.
     *    When it is done  << $scope.ready >> is set to true
     *    and the compilation starts.
     */
    $scope.loadWidget = function() {
      if ($scope.config == undefined) {
        //-- Ask for configuration.
        ConfigFactory.get('edit_object_widget', $scope.ConfigName).then(
          function(res) {
            if (res.data == undefined || res.data == '') {
              if (!$scope.defineDefaultConfig())
                gaJsUtils.errorMessage(
                  'Pas de configuration pour EditObjectWidget !',
                  ''
                );
            } else $scope.config = res.data;
          }
        );
      }
    };

    $scope.loadWidget();

    //--=============================================================
    //--
    //--    Actions to trigger on command ativation

    $scope.removePreviousDirective = function() {
      if ($scope.childScope !== undefined) {
        $scope.childScope.$destroy();
        var elt = document.getElementById($scope.childId);
        if (elt != null) {
          var eltParent = document.getElementById(
            'editobjectwidget_' + $scope.$id
          );
          eltParent.removeChild(elt);
        }
      }
    };

    $scope.openDirective = function(config) {
      var elt = document.getElementById('editobjectwidget_' + $scope.$id);

      $scope.removePreviousDirective();

      $scope.childDirective = config.directive;
      $scope.childId = 'editObjChild_' + $scope.$id;
      var str =
        "<div  id='" + $scope.childId + "' " + config.directive + '></div>';
      if ($scope.childScope != undefined) $scope.childScope.$destroy();
      $scope.childScope = $scope.$new();
      $scope.childScope.ConfigName = config.configName;
      var cmp = $scope.compile(str)($scope.childScope);
      angular.element(elt).append(cmp);
    };

    $scope.addNewObject = function() {
      $scope.openDirective($scope.config['new']);
      $scope.$broadcast('openTools_typeprojetdirective', $scope.config['new']);
    };

    $scope.searchObject = function() {
      $scope.openDirective($scope.config.search);
      $scope.$broadcast(
        'openTools_cherchermodsupdirective',
        $scope.config.search
      );
    };
  };

  TypeProjetCtrl.$inject = ['$scope', 'ConfigFactory', 'gaJsUtils'];
  return TypeProjetCtrl;
});
