#!C:/Python27/python.exe

import cssmin , os , sys
from path import path
from jsmin import jsmin
from optparse import OptionParser,OptionGroup


def optionParsing():
	usage = "usage: %prog [options] arg"
	parser = OptionParser(usage=usage)
	parser.add_option("-i", "--in", dest="in_directory",
                      help="input directory")
	parser.add_option("-o", "--out", dest="out_directory",
                      help="output directory")
	parser.add_option("-v", "--verbose",
                      action="store_true", dest="verbose")
	parser.add_option("-q", "--quiet",
                      action="store_false", dest="verbose")
	group = OptionGroup( parser, "Exemple",
		"minify.py \n" + 
		"-i kis\n" + 
		"-o kis-min\n")

	parser.add_option_group(group)

	(options, args) = parser.parse_args()
	if options.verbose:
		print "reading %s..." % options.filename
	return parser.parse_args()[0]

def main():
	args = optionParsing();
	for f in path('%s' %args.in_directory).walkfiles():
		if 'svn' not in f :
			dirin = args.in_directory.split('/')[-1]
			dirout = args.out_directory.split('/')[-1]
			abspath = f.abspath().dirname();
			outbasepath = abspath.replace('%s' %dirin, '%s' %dirout)
			filename = f.basename();
			extension = f.ext;
			if not os.path.exists(outbasepath):
				path(outbasepath).makedirs()
			if str(f).find("/lib/") == -1 and str(f).find("\\lib\\") == -1 and str(f).find("/swf/") == -1 and str(f).find("\\swf\\") == -1:
				if f.isfile() and extension == '.js' and '.min.' not in f :
					with open('%s/%s' %(abspath,filename),'r') as js_file:
						minified = jsmin(js_file.read());
						js_file.close()
					with open('%s/%s' %(outbasepath,filename),'w') as js_out :
						js_out.write(minified)
						js_out.close()
				elif f.isfile() and extension == '.css' and '.min.' not in f :
					with open('%s/%s' %(abspath,filename),'r') as csssmin:
						cssminified = cssmin.cssmin(csssmin.read());
					with open('%s/%s' %(outbasepath,filename),'w') as csssout:
						csssout.write(cssminified);
						csssout.close();
				elif extension != '.rar' or extension != '.zip':
					f.copy(outbasepath)
			else:
				f.copy(outbasepath)

if __name__ == "__main__":
	main()