import { defineConfig } from "eslint/config";
import globals from "globals";

export default defineConfig([{
    languageOptions: {
        globals: {
            ...globals.node,
        },

        ecmaVersion: 6,
        sourceType: "commonjs",
    },

    rules: {
        "comma-dangle": [2, "never"],
        "no-cond-assign": 2,
        "no-console": 1,
        "no-constant-condition": 2,
        "no-control-regex": 2,
        "no-debugger": 1,
        "no-dupe-args": 2,
        "no-dupe-keys": 2,
        "no-duplicate-case": 2,
        "no-empty-character-class": 2,
        "no-empty": 2,
        "no-ex-assign": 2,
        "no-extra-boolean-cast": 2,
        "no-extra-parens": [0],
        "no-extra-semi": 2,
        "no-func-assign": 2,
        "no-inner-declarations": 2,
        "no-invalid-regexp": 2,
        "no-irregular-whitespace": 2,
        "no-negated-in-lhs": 2,
        "no-obj-calls": 2,
        "no-regex-spaces": 2,
        "no-reserved-keys": 0,
        "no-sparse-arrays": 2,
        "no-unreachable": 1,
        "use-isnan": 2,
        "valid-jsdoc": 0,
        "valid-typeof": 2,

        "accessor-pairs": [2, {
            getWithoutSet: false,
            setWithoutGet: true,
        }],

        "block-scoped-var": 2,
        complexity: 0,
        "consistent-return": 0,
        curly: [2, "all"],
        "default-case": 0,
        "dot-notation": 2,
        "dot-location": [2, "property"],
        eqeqeq: 2,
        "guard-for-in": 0,
        "no-alert": 1,
        "no-caller": 2,
        "no-div-regex": 0,
        "no-else-return": 2,
        labeled: 0,
        "no-eq-null": 2,
        "no-eval": 2,
        "no-extend-native": 2,
        "no-extra-bind": 2,
        "no-fallthrough": 2,
        "no-floating-decimal": 2,
        "no-implied-eval": 2,
        "no-iterator": 2,
        "no-labels": 2,
        "no-lone-blocks": 2,
        "no-loop-func": 2,
        "no-multi-spaces": 2,
        "no-native-reassign": 2,
        "no-new-func": 2,
        "no-new-wrappers": 2,
        "no-new": 0,
        "no-octal-escape": 2,
        "no-octal": 2,
        "no-param-reassign": 0,
        "no-process-env": 0,
        "no-proto": 0,
        "no-redeclare": 2,
        "no-return-assign": 2,
        "no-script-url": 2,
        "no-self-compare": 2,
        "no-sequences": 2,
        "no-throw-literal": 2,
        "no-unused-expressions": 2,
        "no-void": 2,
        "no-warning-comments": 0,
        "no-with": 2,
        radix: 0,
        "vars-on-top": 0,
        "wrap-iife": [2, "outside"],
        yoda: 2,
        strict: [2, "global"],
        "no-catch-shadow": 2,
        "no-delete-var": 2,
        "no-label-var": 0,
        "no-shadow-restricted-names": 2,
        "no-shadow": 2,
        "no-undef-init": 2,
        "no-undef": 2,
        "no-undefined": 0,

        "no-unused-vars": [2, {
            vars: "all",
            args: "after-used",
        }],

        "no-use-before-define": 0,
        "callback-return": 2,
        "global-require": 2,
        "handle-callback-err": [2, "^(e|err|error)$"],
        "no-mixed-requires": [2, true],
        "no-new-require": 2,
        "no-path-concat": 2,
        "no-process-exit": 2,
        "no-restricted-modules": 0,
        "no-sync": 0,

        "brace-style": [2, "1tbs", {
            allowSingleLine: false,
        }],

        camelcase: [2, {
            properties: "always",
        }],

        "comma-spacing": [2, {
            before: false,
            after: true,
        }],

        "comma-style": [2, "last"],
        "computed-property-spacing": [2, "never"],
        "consistent-this": [0],
        "eol-last": 2,
        "func-names": 0,
        "func-style": [2, "declaration"],

        indent: [2, 4, {
            SwitchCase: 1,
        }],

        "keyword-spacing": [2, {
            before: true,
            after: true,
            overrides: {},
        }],

        "key-spacing": [2, {
            beforeColon: false,
            afterColon: true,
        }],

        "lines-around-comment": 0,
        "linebreak-style": [2, "unix"],
        "max-nested-callbacks": 0,
        "new-cap": 2,
        "new-parens": 2,
        "newline-after-var": 0,
        "no-array-constructor": 2,
        "no-continue": 0,
        "no-lonely-if": 2,
        "no-mixed-spaces-and-tabs": 0,

        "no-multiple-empty-lines": [2, {
            max: 2,
        }],

        "no-nested-ternary": 2,
        "no-new-object": 2,
        "no-spaced-func": 2,
        "no-ternary": 0,
        "no-trailing-spaces": 2,
        "no-underscore-dangle": 0,
        "no-unneeded-ternary": 2,
        "object-curly-spacing": [2, "never"],
        "one-var": [2, "never"],
        "operator-assignment": [2, "always"],
        "operator-linebreak": [2, "after"],
        "padded-blocks": [2, "never"],
        "quote-props": [2, "as-needed"],
        quotes: [2, "single", "avoid-escape"],

        "semi-spacing": [2, {
            before: false,
            after: true,
        }],

        semi: 2,

        "sort-vars": [2, {
            ignoreCase: true,
        }],

        "space-before-blocks": [2, "always"],
        "space-before-function-paren": [2, "never"],
        "space-in-parens": [2, "never"],
        "space-infix-ops": 2,

        "space-unary-ops": [2, {
            words: true,
            nonwords: false,
        }],

        "spaced-comment": [1, "always"],
        "wrap-regex": 0,
        "max-depth": 0,

        "max-len": [0, 120, 4, {
            ignoreComments: false,
            ignoreUrls: true,
        }],

        "max-params": 0,
        "max-statements": 0,
        "no-bitwise": 0,
        "no-plusplus": 0,
    },
}, {
    files: ["test/**"],
    languageOptions: {
        globals: {
            ...globals.mocha,
        },
    },
},]);
