angular.module("ui.rCalendar.tpls",["template/rcalendar/calendar.html","template/rcalendar/day.html","template/rcalendar/month.html","template/rcalendar/week.html"]),angular.module("ui.rCalendar",["ui.rCalendar.tpls"]).constant("calendarConfig",{formatDay:"dd",formatDayHeader:"EEE",formatDayTitle:"MMMM dd, yyyy",formatWeekTitle:"MMMM yyyy, Week w",formatMonthTitle:"MMMM yyyy",calendarMode:"month",showWeeks:!1,showEventDetail:!0,startingDay:0,eventSource:null,queryMode:"local"}).controller("ui.rCalendar.CalendarController",["$scope","$attrs","$parse","$interpolate","$log","dateFilter","calendarConfig",function($scope,$attrs,$parse,$interpolate,$log,dateFilter,calendarConfig){"use strict";function overlap(event1,event2){return!(event1.endIndex<=event2.startIndex||event2.endIndex<=event1.startIndex)}function calculatePosition(events){var i,j,col,len=events.length,maxColumn=0,isForbidden=new Array(len);for(i=0;len>i;i+=1){for(col=0;maxColumn>col;col+=1)isForbidden[col]=!1;for(j=0;i>j;j+=1)overlap(events[i],events[j])&&(isForbidden[events[j].position]=!0);for(col=0;maxColumn>col&&isForbidden[col];col+=1);maxColumn>col?events[i].position=col:events[i].position=maxColumn++}}function calculateWidth(orderedEvents){var event,index,i,j,len,eventCountInCell,currentEventInCell,cells=new Array(24);for(orderedEvents.sort(function(eventA,eventB){return eventB.position-eventA.position}),i=0;24>i;i+=1)cells[i]={calculated:!1,events:[]};for(len=orderedEvents.length,i=0;len>i;i+=1)for(event=orderedEvents[i],index=event.startIndex;index<event.endIndex;)cells[index].events.push(event),index+=1;for(i=0;len>i;){if(event=orderedEvents[i],!event.overlapNumber){var overlapNumber=event.position+1;event.overlapNumber=overlapNumber;for(var eventQueue=[event];event=eventQueue.shift();)for(index=event.startIndex;index<event.endIndex;){if(!cells[index].calculated&&(cells[index].calculated=!0,cells[index].events))for(eventCountInCell=cells[index].events.length,j=0;eventCountInCell>j;j+=1)currentEventInCell=cells[index].events[j],currentEventInCell.overlapNumber||(currentEventInCell.overlapNumber=overlapNumber,eventQueue.push(currentEventInCell));index+=1}}i+=1}}var self=this,ngModelCtrl={$setViewValue:angular.noop};angular.forEach(["formatDay","formatDayHeader","formatDayTitle","formatWeekTitle","formatMonthTitle","showWeeks","showEventDetail","startingDay","eventSource","queryMode"],function(key,index){self[key]=angular.isDefined($attrs[key])?5>index?$interpolate($attrs[key])($scope.$parent):$scope.$parent.$eval($attrs[key]):calendarConfig[key]}),$scope.$parent.$watch($attrs.eventSource,function(value){self.onEventSourceChanged(value)}),$scope.calendarMode=$scope.calendarMode||calendarConfig.calendarMode,angular.isDefined($attrs.initDate)&&(self.currentCalendarDate=$scope.$parent.$eval($attrs.initDate)),self.currentCalendarDate||(self.currentCalendarDate=new Date,$attrs.ngModel&&!$scope.$parent.$eval($attrs.ngModel)&&$parse($attrs.ngModel).assign($scope.$parent,self.currentCalendarDate)),self.init=function(ngModelCtrl_){ngModelCtrl=ngModelCtrl_,ngModelCtrl.$render=function(){self.render()}},self.render=function(){if(ngModelCtrl.$modelValue){var date=new Date(ngModelCtrl.$modelValue),isValid=!isNaN(date);isValid?this.currentCalendarDate=date:$log.error('"ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.'),ngModelCtrl.$setValidity("date",isValid)}this.refreshView()},self.refreshView=function(){this.mode&&(this.range=this._getRange(this.currentCalendarDate),this._refreshView(),this.rangeChanged())},self.split=function(arr,size){for(var arrays=[];arr.length>0;)arrays.push(arr.splice(0,size));return arrays},self.onEventSourceChanged=function(value){self.eventSource=value,self._onDataLoaded&&self._onDataLoaded()},$scope.move=function(direction){var firstDayInNextMonth,step=self.mode.step,currentCalendarDate=self.currentCalendarDate,year=currentCalendarDate.getFullYear()+direction*(step.years||0),month=currentCalendarDate.getMonth()+direction*(step.months||0),date=currentCalendarDate.getDate()+direction*(step.days||0);currentCalendarDate.setFullYear(year,month,date),"month"===$scope.calendarMode&&(firstDayInNextMonth=new Date(year,month+1,1),firstDayInNextMonth.getTime()<=currentCalendarDate.getTime()&&(self.currentCalendarDate=new Date(firstDayInNextMonth-864e5))),ngModelCtrl.$setViewValue(self.currentCalendarDate),self.refreshView()},self.move=function(direction){$scope.move(direction)},self.rangeChanged=function(){"local"===self.queryMode?self.eventSource&&self._onDataLoaded&&self._onDataLoaded():"remote"===self.queryMode&&$scope.rangeChanged&&$scope.rangeChanged({startTime:this.range.startTime,endTime:this.range.endTime})},self.placeEvents=function(orderedEvents){calculatePosition(orderedEvents),calculateWidth(orderedEvents)},self.placeAllDayEvents=function(orderedEvents){calculatePosition(orderedEvents)}}]).directive("calendar",function(){"use strict";return{restrict:"EA",replace:!0,templateUrl:"template/rcalendar/calendar.html",scope:{calendarMode:"=",rangeChanged:"&",eventSelected:"&",timeSelected:"&"},require:["calendar","?^ngModel"],controller:"ui.rCalendar.CalendarController",link:function(scope,element,attrs,ctrls){var calendarCtrl=ctrls[0],ngModelCtrl=ctrls[1];ngModelCtrl&&calendarCtrl.init(ngModelCtrl),scope.$on("changeDate",function(event,direction){calendarCtrl.move(direction)}),scope.$on("eventSourceChanged",function(event,value){calendarCtrl.onEventSourceChanged(value)})}}}).directive("monthview",["dateFilter",function(dateFilter){"use strict";return{restrict:"EA",replace:!0,templateUrl:"template/rcalendar/month.html",require:["^calendar","?^ngModel"],link:function(scope,element,attrs,ctrls){function getDates(startDate,n){var dates=new Array(n),current=new Date(startDate),i=0;for(current.setHours(12);n>i;)dates[i++]=new Date(current),current.setDate(current.getDate()+1);return dates}function createDateObject(date,format){return{date:date,label:dateFilter(date,format),selected:0===ctrl.compare(date,ctrl.currentCalendarDate),current:0===ctrl.compare(date,new Date)}}function compareEvent(event1,event2){return event1.allDay?1:event2.allDay?-1:event1.startTime.getTime()-event2.startTime.getTime()}function getISO8601WeekNumber(date){var checkDate=new Date(date);checkDate.setDate(checkDate.getDate()+4-(checkDate.getDay()||7));var time=checkDate.getTime();return checkDate.setMonth(0),checkDate.setDate(1),Math.floor(Math.round((time-checkDate)/864e5)/7)+1}var ctrl=ctrls[0],ngModelCtrl=ctrls[1];scope.showWeeks=ctrl.showWeeks,scope.showEventDetail=ctrl.showEventDetail,ctrl.mode={step:{months:1}},scope.select=function(selectedDate){var rows=scope.rows;if(rows){var currentCalendarDate=ctrl.currentCalendarDate,currentMonth=currentCalendarDate.getMonth(),currentYear=currentCalendarDate.getFullYear(),selectedMonth=selectedDate.getMonth(),selectedYear=selectedDate.getFullYear(),direction=0;if(currentYear===selectedYear?currentMonth!==selectedMonth&&(direction=selectedMonth>currentMonth?1:-1):direction=selectedYear>currentYear?1:-1,ctrl.currentCalendarDate=selectedDate,ngModelCtrl&&ngModelCtrl.$setViewValue(selectedDate),0===direction)for(var row=0;6>row;row+=1)for(var date=0;7>date;date+=1){var selected=0===ctrl.compare(selectedDate,rows[row][date].date);rows[row][date].selected=selected,selected&&(scope.selectedDate=rows[row][date])}else ctrl.refreshView();scope.timeSelected&&scope.timeSelected({selectedTime:selectedDate})}},ctrl._refreshView=function(){for(var startDate=ctrl.range.startTime,date=startDate.getDate(),month=(startDate.getMonth()+(1!==date?1:0))%12,year=startDate.getFullYear()+(1!==date&&0===month?1:0),days=getDates(startDate,42),i=0;42>i;i++)days[i]=angular.extend(createDateObject(days[i],ctrl.formatDay),{secondary:days[i].getMonth()!==month});scope.labels=new Array(7);for(var j=0;7>j;j++)scope.labels[j]=dateFilter(days[j].date,ctrl.formatDayHeader);var headerDate=new Date(year,month,1);if(scope.$parent.title=dateFilter(headerDate,ctrl.formatMonthTitle),scope.rows=ctrl.split(days,7),scope.showWeeks){scope.weekNumbers=[];for(var weekNumber=getISO8601WeekNumber(scope.rows[0][0].date),numWeeks=scope.rows.length,len=0;numWeeks>len;)len=scope.weekNumbers.push(weekNumber),weekNumber+=1}},ctrl._onDataLoaded=function(){var row,date,eventSource=ctrl.eventSource,len=eventSource?eventSource.length:0,startTime=ctrl.range.startTime,endTime=ctrl.range.endTime,timeZoneOffset=-(new Date).getTimezoneOffset(),utcStartTime=new Date(startTime.getTime()+6e4*timeZoneOffset),utcEndTime=new Date(endTime.getTime()+6e4*timeZoneOffset),rows=scope.rows,oneDay=864e5,eps=.001,hasEvent=!1;if(rows.hasEvent)for(row=0;6>row;row+=1)for(date=0;7>date;date+=1)rows[row][date].hasEvent&&(rows[row][date].events=null,rows[row][date].hasEvent=!1);for(var i=0;len>i;i+=1){var st,et,event=eventSource[i],eventStartTime=new Date(event.startTime),eventEndTime=new Date(event.endTime);if(event.allDay){if(utcStartTime>=eventEndTime||eventStartTime>=utcEndTime)continue;st=utcStartTime,et=utcEndTime}else{if(startTime>=eventEndTime||eventStartTime>=endTime)continue;st=startTime,et=endTime}var timeDifferenceStart;timeDifferenceStart=st>=eventStartTime?0:(eventStartTime-st)/oneDay;var timeDifferenceEnd;timeDifferenceEnd=eventEndTime>=et?(et-st)/oneDay:(eventEndTime-st)/oneDay;for(var eventSet,index=Math.floor(timeDifferenceStart);timeDifferenceEnd-eps>index;){var rowIndex=Math.floor(index/7),dayIndex=Math.floor(index%7);rows[rowIndex][dayIndex].hasEvent=!0,eventSet=rows[rowIndex][dayIndex].events,eventSet?eventSet.push(event):(eventSet=[],eventSet.push(event),rows[rowIndex][dayIndex].events=eventSet),index+=1}}for(row=0;6>row;row+=1)for(date=0;7>date;date+=1)rows[row][date].hasEvent&&(hasEvent=!0,rows[row][date].events.sort(compareEvent));rows.hasEvent=hasEvent;var findSelected=!1;for(row=0;6>row;row+=1){for(date=0;7>date;date+=1)if(rows[row][date].selected){scope.selectedDate=rows[row][date],findSelected=!0;break}if(findSelected)break}},ctrl.compare=function(date1,date2){return new Date(date1.getFullYear(),date1.getMonth(),date1.getDate())-new Date(date2.getFullYear(),date2.getMonth(),date2.getDate())},ctrl._getRange=function(currentDate){var endDate,year=currentDate.getFullYear(),month=currentDate.getMonth(),firstDayOfMonth=new Date(year,month,1),difference=ctrl.startingDay-firstDayOfMonth.getDay(),numDisplayedFromPreviousMonth=difference>0?7-difference:-difference,startDate=new Date(firstDayOfMonth);return numDisplayedFromPreviousMonth>0&&startDate.setDate(-numDisplayedFromPreviousMonth+1),endDate=new Date(startDate),endDate.setDate(endDate.getDate()+42),{startTime:startDate,endTime:endDate}},ctrl.refreshView()}}}]).directive("weekview",["dateFilter","$timeout",function(dateFilter,$timeout){"use strict";return{restrict:"EA",replace:!0,templateUrl:"template/rcalendar/week.html",require:"^calendar",link:function(scope,element,attrs,ctrl){function updateScrollGutter(){var children=element.children(),allDayEventBody=children[1].children[1],allDayEventGutterWidth=allDayEventBody.offsetWidth-allDayEventBody.clientWidth,normalEventBody=children[2],normalEventGutterWidth=normalEventBody.offsetWidth-normalEventBody.clientWidth,gutterWidth=allDayEventGutterWidth||normalEventGutterWidth||0;gutterWidth>0&&(scope.gutterWidth=gutterWidth,0>=allDayEventGutterWidth?scope.allDayEventGutterWidth=gutterWidth:scope.allDayEventGutterWidth=0,0>=normalEventGutterWidth?scope.normalGutterWidth=gutterWidth:scope.normalGutterWidth=0)}function getDates(startTime,n){var dates=new Array(n),current=new Date(startTime),i=0;for(current.setHours(12);n>i;)dates[i++]={date:new Date(current)},current.setDate(current.getDate()+1);return dates}function createDateObjects(startTime){for(var row,times=[],time=new Date(startTime.getTime()),currentHour=time.getHours(),currentDate=time.getDate(),hour=0;24>hour;hour+=1){row=[];for(var day=0;7>day;day+=1)time.setHours(currentHour+hour),time.setDate(currentDate+day),row.push({time:new Date(time.getTime())});times.push(row)}return times}function getISO8601WeekNumber(date){var checkDate=new Date(date);checkDate.setDate(checkDate.getDate()+4-(checkDate.getDay()||7));var time=checkDate.getTime();return checkDate.setMonth(0),checkDate.setDate(1),Math.floor(Math.round((time-checkDate)/864e5)/7)+1}$timeout(function(){updateScrollGutter()}),ctrl.mode={step:{days:7}},ctrl._onDataLoaded=function(){var eventSet,day,hour,eventSource=ctrl.eventSource,len=eventSource?eventSource.length:0,startTime=ctrl.range.startTime,endTime=ctrl.range.endTime,timeZoneOffset=-(new Date).getTimezoneOffset(),utcStartTime=new Date(startTime.getTime()+60*timeZoneOffset*1e3),utcEndTime=new Date(endTime.getTime()+60*timeZoneOffset*1e3),rows=scope.rows,dates=scope.dates,oneHour=36e5,oneDay=864e5,eps=.016,allDayEventInRange=!1,normalEventInRange=!1;if(rows.hasEvent){for(day=0;7>day;day+=1)for(hour=0;24>hour;hour+=1)rows[hour][day].events&&(rows[hour][day].events=null);rows.hasEvent=!1}if(dates.hasEvent){for(day=0;7>day;day+=1)dates[day].events&&(dates[day].events=null);dates.hasEvent=!1}for(var i=0;len>i;i+=1){var event=eventSource[i],eventStartTime=new Date(event.startTime),eventEndTime=new Date(event.endTime);if(event.allDay){if(utcStartTime>=eventEndTime||eventStartTime>=utcEndTime)continue;allDayEventInRange=!0;var allDayStartIndex;allDayStartIndex=utcStartTime>=eventStartTime?0:Math.floor((eventStartTime-utcStartTime)/oneDay);var allDayEndIndex;allDayEndIndex=eventEndTime>=utcEndTime?Math.ceil((utcEndTime-utcStartTime)/oneDay):Math.ceil((eventEndTime-utcStartTime)/oneDay);var displayAllDayEvent={event:event,startIndex:allDayStartIndex,endIndex:allDayEndIndex};eventSet=dates[allDayStartIndex].events,eventSet?eventSet.push(displayAllDayEvent):(eventSet=[],eventSet.push(displayAllDayEvent),dates[allDayStartIndex].events=eventSet)}else{if(startTime>=eventEndTime||eventStartTime>=endTime)continue;normalEventInRange=!0;var timeDifferenceStart;timeDifferenceStart=startTime>=eventStartTime?0:(eventStartTime-startTime)/oneHour;var timeDifferenceEnd;timeDifferenceEnd=eventEndTime>=endTime?(endTime-startTime)/oneHour:(eventEndTime-startTime)/oneHour;var endRowIndex,startIndex=Math.floor(timeDifferenceStart),endIndex=Math.ceil(timeDifferenceEnd-eps),startRowIndex=startIndex%24,dayIndex=Math.floor(startIndex/24),endOfDay=24*dayIndex;do{endOfDay+=24,endRowIndex=endIndex>=endOfDay?24:endIndex%24;var displayEvent={event:event,startIndex:startRowIndex,endIndex:endRowIndex};eventSet=rows[startRowIndex][dayIndex].events,eventSet?eventSet.push(displayEvent):(eventSet=[],eventSet.push(displayEvent),rows[startRowIndex][dayIndex].events=eventSet),startRowIndex=0,dayIndex+=1}while(endIndex>endOfDay)}}if(normalEventInRange)for(day=0;7>day;day+=1){var orderedEvents=[];for(hour=0;24>hour;hour+=1)rows[hour][day].events&&(orderedEvents=orderedEvents.concat(rows[hour][day].events));orderedEvents.length>0&&(rows.hasEvent=!0,ctrl.placeEvents(orderedEvents))}if(allDayEventInRange){var orderedAllDayEvents=[];for(day=0;7>day;day+=1)dates[day].events&&(orderedAllDayEvents=orderedAllDayEvents.concat(dates[day].events));orderedAllDayEvents.length>0&&(dates.hasEvent=!0,ctrl.placeAllDayEvents(orderedAllDayEvents))}$timeout(function(){updateScrollGutter()})},ctrl._refreshView=function(){var weekNumberIndex,title,firstDayOfWeek=ctrl.range.startTime,dates=getDates(firstDayOfWeek,7),weekFormatPattern="w";scope.rows=createDateObjects(firstDayOfWeek),scope.dates=dates,weekNumberIndex=ctrl.formatWeekTitle.indexOf(weekFormatPattern),title=dateFilter(firstDayOfWeek,ctrl.formatWeekTitle),-1!==weekNumberIndex&&(title=title.replace(weekFormatPattern,getISO8601WeekNumber(firstDayOfWeek))),scope.$parent.title=title},ctrl._getRange=function(currentDate){var year=currentDate.getFullYear(),month=currentDate.getMonth(),date=currentDate.getDate(),day=currentDate.getDay(),firstDayOfWeek=new Date(year,month,date-day),endTime=new Date(year,month,date-day+7);return{startTime:firstDayOfWeek,endTime:endTime}},ctrl.refreshView()}}}]).directive("dayview",["dateFilter","$timeout",function(dateFilter,$timeout){"use strict";return{restrict:"EA",replace:!0,templateUrl:"template/rcalendar/day.html",require:"^calendar",link:function(scope,element,attrs,ctrl){function updateScrollGutter(){var children=element.children(),allDayEventBody=children[0].children[1],allDayEventGutterWidth=allDayEventBody.offsetWidth-allDayEventBody.clientWidth,normalEventBody=children[1],normalEventGutterWidth=normalEventBody.offsetWidth-normalEventBody.clientWidth,gutterWidth=allDayEventGutterWidth||normalEventGutterWidth||0;gutterWidth>0&&(0>=allDayEventGutterWidth?scope.allDayEventGutterWidth=gutterWidth:scope.allDayEventGutterWidth=0,0>=normalEventGutterWidth?scope.normalGutterWidth=gutterWidth:scope.normalGutterWidth=0)}function createDateObjects(startTime){for(var rows=[],time=new Date(startTime.getTime()),currentHour=time.getHours(),currentDate=time.getDate(),hour=0;24>hour;hour+=1)time.setHours(currentHour+hour),time.setDate(currentDate),rows.push({time:new Date(time.getTime())});return rows}$timeout(function(){updateScrollGutter()}),ctrl.mode={step:{days:1}},ctrl._onDataLoaded=function(){var eventSet,hour,eventSource=ctrl.eventSource,len=eventSource?eventSource.length:0,startTime=ctrl.range.startTime,endTime=ctrl.range.endTime,timeZoneOffset=-(new Date).getTimezoneOffset(),utcStartTime=new Date(startTime.getTime()+60*timeZoneOffset*1e3),utcEndTime=new Date(endTime.getTime()+60*timeZoneOffset*1e3),rows=scope.rows,allDayEvents=[],oneHour=36e5,eps=.016,normalEventInRange=!1;if(rows.hasEvent){for(hour=0;24>hour;hour+=1)rows[hour].events&&(rows[hour].events=null);rows.hasEvent=!1}for(var i=0;len>i;i+=1){var event=eventSource[i],eventStartTime=new Date(event.startTime),eventEndTime=new Date(event.endTime);if(event.allDay){if(utcStartTime>=eventEndTime||eventStartTime>=utcEndTime)continue;allDayEvents.push({event:event})}else{if(startTime>=eventEndTime||eventStartTime>=endTime)continue;normalEventInRange=!0;var timeDifferenceStart;timeDifferenceStart=startTime>=eventStartTime?0:(eventStartTime-startTime)/oneHour;var timeDifferenceEnd;timeDifferenceEnd=eventEndTime>=endTime?(endTime-startTime)/oneHour:(eventEndTime-startTime)/oneHour;var startIndex=Math.floor(timeDifferenceStart),endIndex=Math.ceil(timeDifferenceEnd-eps),displayEvent={event:event,startIndex:startIndex,endIndex:endIndex};eventSet=rows[startIndex].events,eventSet?eventSet.push(displayEvent):(eventSet=[],eventSet.push(displayEvent),rows[startIndex].events=eventSet)}}if(normalEventInRange){var orderedEvents=[];for(hour=0;24>hour;hour+=1)rows[hour].events&&(orderedEvents=orderedEvents.concat(rows[hour].events));orderedEvents.length>0&&(rows.hasEvent=!0,ctrl.placeEvents(orderedEvents))}scope.allDayEvents=allDayEvents,$timeout(function(){updateScrollGutter()})},ctrl._refreshView=function(){var startingDate=ctrl.range.startTime;scope.rows=createDateObjects(startingDate),scope.allDayEvents=[],scope.dates=[startingDate],scope.$parent.title=dateFilter(startingDate,ctrl.formatDayTitle)},ctrl._getRange=function(currentDate){var year=currentDate.getFullYear(),month=currentDate.getMonth(),date=currentDate.getDate(),startTime=new Date(year,month,date),endTime=new Date(year,month,date+1);return{startTime:startTime,endTime:endTime}},ctrl.refreshView()}}}]),angular.module("template/rcalendar/calendar.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("template/rcalendar/calendar.html",'<div ng-switch="calendarMode">\n    <div class="row calendar-navbar">\n        <div class="nav-left col-xs-2">\n            <button type="button" class="btn btn-default btn-sm" ng-click="move(-1)"><i\n                    class="glyphicon glyphicon-chevron-left"></i></button>\n        </div>\n        <div class="calendar-header col-xs-8">{{title}}</div>\n        <div class="nav-right col-xs-2">\n            <button type="button" class="btn btn-default btn-sm" ng-click="move(1)"><i\n                    class="glyphicon glyphicon-chevron-right"></i></button>\n        </div>\n    </div>\n    <dayview ng-switch-when="day"></dayview>\n    <monthview ng-switch-when="month"></monthview>\n    <weekview ng-switch-when="week"></weekview>\n</div>\n')}]),angular.module("template/rcalendar/day.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("template/rcalendar/day.html",'<div>\n    <div class="dayview-allday-table">\n        <div class="dayview-allday-label">\n            all day\n        </div>\n        <div class="dayview-allday-content-wrapper">\n            <table class="table table-bordered" style="height: 100%; margin-bottom: 0px">\n                <tbody>\n                <tr>\n                    <td class="calendar-cell" ng-class="{\'calendar-event-wrap\':allDayEvents}">\n                        <div ng-repeat="displayEvent in allDayEvents" class="calendar-event"\n                             ng-click="eventSelected({event:displayEvent.event})"\n                             ng-style="{top: 25*$index+\'px\',width: \'100%\',height:\'25px\'}">\n                            <div class="calendar-event-inner">{{displayEvent.event.title}}</div>\n                        </div>\n                    </td>\n                    <td ng-if="allDayEventGutterWidth>0" ng-style="{width:allDayEventGutterWidth+\'px\'}"></td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n    <div class="scrollable" style="height: 400px">\n        <table class="table table-bordered table-fixed">\n            <tbody>\n            <tr ng-repeat="tm in rows track by $index">\n                <td class="calendar-hour-column text-center">\n                    {{$index<12?($index === 0?12:$index)+\'am\':($index === 12?$index:$index-12)+\'pm\'}}\n                </td>\n                <td class="calendar-cell">\n                    <div ng-class="{\'calendar-event-wrap\': tm.events}" ng-if="tm.events">\n                        <div ng-repeat="displayEvent in tm.events" class="calendar-event"\n                             ng-click="eventSelected({event:displayEvent.event})"\n                             ng-style="{left: 100/displayEvent.overlapNumber*displayEvent.position+\'%\', width: 100/displayEvent.overlapNumber+\'%\', height: 37*(displayEvent.endIndex-displayEvent.startIndex)+\'px\'}">\n                            <div class="calendar-event-inner">{{displayEvent.event.title}}</div>\n                        </div>\n                    </div>\n                </td>\n            </tr>\n            </tbody>\n        </table>\n    </div>\n</div>')}]),angular.module("template/rcalendar/month.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("template/rcalendar/month.html",'<div>\n    <table class="table table-bordered monthview-datetable monthview-datetable">\n        <thead>\n        <tr>\n            <th ng-show="showWeeks" class="calendar-week-column text-center">#</th>\n            <th ng-repeat="label in labels track by $index" class="text-center">\n                <small>{{label}}</small>\n            </th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat="row in rows track by $index">\n            <td ng-show="showWeeks" class="calendar-week-column text-center">\n                <small><em>{{ weekNumbers[$index] }}</em></small>\n            </td>\n            <td ng-repeat="dt in row track by dt.date" class="monthview-dateCell" ng-click="select(dt.date)"\n                ng-class="{\'text-center\':true, \'monthview-current\': dt.current&&!dt.selected&&!dt.hasEvent,\'monthview-secondary-with-event\': dt.secondary&&dt.hasEvent, \'monthview-primary-with-event\':!dt.secondary&&dt.hasEvent&&!dt.selected, \'monthview-selected\': dt.selected}">\n                <div ng-class="{\'text-muted\':dt.secondary}">\n                    {{dt.label}}\n                </div>\n            </td>\n        </tr>\n        </tbody>\n    </table>\n    <div ng-if="showEventDetail" class="event-detail-container">\n        <div class="scrollable" style="height: 200px">\n            <table class="table table-bordered table-striped table-fixed">\n                <tr ng-repeat="event in selectedDate.events" ng-if="selectedDate.events">\n                    <td ng-if="!event.allDay" class="monthview-eventdetail-timecolumn">{{event.startTime|date: \'HH:mm\'}}\n                        -\n                        {{event.endTime|date: \'HH:mm\'}}\n                    </td>\n                    <td ng-if="event.allDay" class="monthview-eventdetail-timecolumn">All day</td>\n                    <td class="event-detail" ng-click="eventSelected({event:event})">{{event.title}}</td>\n                </tr>\n                <tr ng-if="!selectedDate.events"><td class="no-event-label">No Events</td></tr>\n            </table>\n        </div>\n    </div>\n</div>')}]),angular.module("template/rcalendar/week.html",[]).run(["$templateCache",function($templateCache){$templateCache.put("template/rcalendar/week.html",'<div>\n    <table class="table table-bordered table-fixed weekview-header">\n        <thead>\n        <tr>\n            <th class="calendar-hour-column"></th>\n            <th ng-repeat="dt in dates" class="text-center weekview-header-label">{{dt.date| date: \'EEE d\'}}</span></th>\n            <th ng-if="gutterWidth>0" ng-style="{width: gutterWidth+\'px\'}"></th>\n        </tr>\n        </thead>\n    </table>\n    <div class="weekview-allday-table">\n        <div class="weekview-allday-label">\n            all day\n        </div>\n        <div class="weekview-allday-content-wrapper">\n            <table class="table table-bordered table-fixed" style="height: 100%; margin-bottom: 0px">\n                <tbody>\n                <tr>\n                    <td ng-repeat="day in dates track by day.date" class="calendar-cell">\n                        <div ng-class="{\'calendar-event-wrap\': day.events}" ng-if="day.events">\n                            <div ng-repeat="displayEvent in day.events" class="calendar-event"\n                                 ng-click="eventSelected({event:displayEvent.event})"\n                                 ng-style="{top: 25*displayEvent.position+\'px\', width: 100*(displayEvent.endIndex-displayEvent.startIndex)+\'%\', height: \'25px\'}">\n                                <div class="calendar-event-inner">{{displayEvent.event.title}}</div>\n                            </div>\n                        </div>\n                    </td>\n                    <td ng-if="allDayEventGutterWidth>0" ng-style="{width: allDayEventGutterWidth+\'px\'}"></td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n    <div class="scrollable" style="height: 400px">\n        <table class="table table-bordered table-fixed">\n            <tbody>\n            <tr ng-repeat="row in rows track by $index">\n                <td class="calendar-hour-column text-center">\n                    {{$index<12?($index === 0?12:$index)+\'am\':($index === 12?$index:$index-12)+\'pm\'}}\n                </td>\n                <td ng-repeat="tm in row track by tm.time" class="calendar-cell">\n                    <div ng-class="{\'calendar-event-wrap\': tm.events}" ng-if="tm.events">\n                        <div ng-repeat="displayEvent in tm.events" class="calendar-event"\n                             ng-click="eventSelected({event:displayEvent.event})"\n                             ng-style="{left: 100/displayEvent.overlapNumber*displayEvent.position+\'%\', width: 100/displayEvent.overlapNumber+\'%\', height: 37*(displayEvent.endIndex-displayEvent.startIndex)+\'px\'}">\n                            <div class="calendar-event-inner">{{displayEvent.event.title}}</div>\n                        </div>\n                    </div>\n                </td>\n                <td ng-if="normalGutterWidth>0" ng-style="{width: normalGutterWidth+\'px\'}"></td>\n            </tr>\n            </tbody>\n        </table>\n    </div>\n</div>')}]);