'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    gcInteractions,
    SelectManager,
    $timeout,
    gaJsUtils, ogcFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/select/views/gcselectline.html',
      restrict: 'A',
      scope: {
        map: '=map',
        result: '=res',
        geom: '=?geom',
        geomselect: '=geomselect',
        ftisid: '=ftisid',
        toolBarWidget: '=?toolbarwidget',
        onfinish: '&',
        field: '=?'
      },
      link: function(scope) {
        scope.ftis = [];
        scope.geom = '';

        scope.$watch('ftisid', function() {
          updateFtis();
        });
        function updateFtis() {
          scope.ftis.splice(0);
          // je prend chaque uid et je recupere le fti associe que j'injecte dans ftis
          for (var i in scope.ftisid) {
            scope.ftis.push(
              FeatureTypeFactory.getFeatureByUid(scope.ftisid[i])
            );
          }
        }
        updateFtis();

        scope.draw = new ol.interaction.Draw({
          type: 'LineString',
        });

        scope.draw.set('gctype', 'kis');
        scope.draw.set('interaction', 'Draw');
        scope.draw.set('widget', 'gcselectline' + Math.random());
        scope.draw.setActive(false);
        //Traitement de l'evenement de fin de dessin de sélection
        scope.draw.on('drawend', function(evt) {
          scope.geom = evt.feature.getGeometry();
          var type = scope.geom.getType();
          var coords = scope.geom.getCoordinates();
          scope.geomselect = {
            coordinates: coords,
            type: type,
          };
          // URL de rcup des objets
          var types = '';

          // WFS a besoin des typesName (layer)
          scope.ftis.forEach(function(fType) {
            types = types + fType.uid + ',';
          });

          const wktObj = new ol.format.WKT();
          const wktStr = wktObj.writeGeometry(evt.feature.getGeometry());
          const spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';

          let useMode = 'query';
          if (scope.field
             && scope.field.config.geomselect && scope.field.config.geomselect!=='') {
            useMode = 'edition';
          }
          const promise = ogcFactory.getfeatures('GetFeature', 'WFS', '1.0.0', types, 'json',
            scope.map.getView().getProjection().getCode(), spatialClause, '',
            undefined, undefined, useMode
          );

          var promise2 = promise.then(function(res) {

            // Dans le cas d'un formulaire d'intervention simple, si on veut cumuler les sélections
            if(scope.field && scope.result && scope.field.config.cumulateSelections === true) {
              scope.result = gaJsUtils.mergeTwoGetFeatResult(res.data, scope.result);
            } else {
              scope.result = res.data;
            }

            SelectManager.addFeaturesFromGeojson(scope.result);
            try {
              scope.$apply();
            } catch(err) {}
          });
          promise2.then(function() {
            scope.draw.setActive(false);
            scope.map.removeInteraction(scope.draw);
            scope.isActive = false;
            $timeout(function() {
              scope.onfinish();
            });
          });
          //}
        });

        scope.selectinterv = function() {
          var map = scope.map;
          scope.isActive = !scope.isActive;
          if (!scope.isActive) {
            scope.draw.setActive(false);
            map.removeInteraction(scope.draw);
            return;
          }
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.draw.setActive(true);
          map.addInteraction(scope.draw);
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'gcInteractions',
    'SelectManager',
    '$timeout',
    'gaJsUtils', 'ogcFactory'
  ];
  return gcelement;
});
