'use strict';
define(function() {
  var gcelement = function(
    $http,
    gclayers,
    gcStyleFactory,
    FeatureTypeFactory,
    GeometryFactory,
    gcInteractions,
    HpoCarteAppFactory,
    $rootScope,
    $filter,
    gaDomUtils,
    $timeout,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/select/views/gcselectandchoosecomponent.html',

      restrict: 'A',
      scope: {
        map: '=map',
        result: '=res',
        resbuffer: '=resbuffer',
        geomselection: '=geomselection',
        updateselection: '=?updateselection',
        typebuffer: '=typebuffer',
        distance: '=distance',
        templatefields: '=?',
        toolBarWidget: '=?toolbarwidget',
        conddatatable: '=?conddatatable',
        currentobj: '=?currentobj',
        ftisToUse: '=?',
        ftisData: '=?',
        templateEvents: '=?',
        onfinish: '&',
        feats : '=?'
      },
      link: function(scope, element, attrs, ctrl) {
        console.log(scope.updateselection);
        console.log(scope.field);
        console.log(scope.currentobj);
        if (!scope.obj) {
          scope.obj = {
            ftisid: {},
          };
        }
        if (
          $rootScope.xgos &&
          ($rootScope.xgos.sector === 'hpo' ||
            $rootScope.xgos.sector === 'mapv2')
        ) {
          var ftis = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();
          scope.ftisToUse = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();
        }

        scope.ftis = [];
        scope.diabledAll = true;
        if (
          scope.conddatatable &&
          scope.conddatatable == true &&
          scope.currentobj &&
          scope.currentobj['current'] &&
          scope.currentobj['current'].properties &&
          scope.currentobj['current'].properties.FTIUID
        ) {
          var ftiChantiers = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'chantiers'
          )[0];
          var fticurrentObj = FeatureTypeFactory.getFeatureByUid(
            scope.currentobj.current.properties.FTIUID
          );
          scope.obj.ftid = fticurrentObj.uid;
          scope.obj.ftisid = fticurrentObj;
          scope.diabledAll = false;
          scope.ftis.push(
            FeatureTypeFactory.getFeatureByUid(
              scope.currentobj.current.properties.FTIUID
            )
          );
          var fti = scope.ftis[0];

          var fieldDifferent = false;
          scope.templatefields.fields.map(function(x) {
            if (
              x &&
              x.type === 'data' &&
              x.config &&
              x.config.ftid !== fti.uid
            ) {
              x.config.ftid = fti.uid;
              x.config.attributes = fti.attributes.map(function(x) {
                return x.name;
              });
              fieldDifferent = true;
            }
          });

          if (scope.templateEvents && scope.templateEvents.length > 0) {
            scope.templateEvents.map(function(evt, j) {
              if (
                evt &&
                evt.hasOwnProperty('actions') &&
                evt.actions.length > 0
              ) {
                evt.actions.map(function(action, k) {
                  if (
                    action &&
                    typeof action === 'string' &&
                    action.indexOf(
                      "loadRelations('" +
                        ftiChantiers.uid +
                        "','chantier_canas'"
                    ) !== -1
                  ) {
                    var relName;
                    for (var i = 0; i < ftiChantiers.relations.length; i++) {
                      var rel = ftiChantiers.relations[i];
                      if (rel.type === 'REL_NM' && rel.idEnd === fti.uid) {
                        relName = rel.name;
                        break;
                      }
                    }
                    if (
                      relName &&
                      scope.templateEvents[j].actions[k].indexOf(
                        "loadRelations('" +
                          ftiChantiers.uid +
                          "','chantier_canas'"
                      ) !== -1
                    ) {
                      scope.templateEvents[j].actions[k] = scope.templateEvents[
                        j
                      ].actions[k].replace(
                        "loadRelations('" +
                          ftiChantiers.uid +
                          "','chantier_canas'",
                        "loadRelations('" +
                          ftiChantiers.uid +
                          "','" +
                          relName +
                          "'"
                      );
                      fieldDifferent = true;
                    }
                  }
                });
              }
            });
          }

          scope.currentobj.current.properties.FTIUID = fti.uid;
          if (fieldDifferent) scope.$emit('reloadActions');
        }

        scope.intervFeature = {};
        scope.tempIntervFeature = {};
        scope.tempresbuffer = {};
        scope.generatebuffer = function(data) {
          console.log(data);

          gclayers.clearEditLayer();

          if (scope.tempIntervFeature == {}) {
            scope.tempIntervFeature = scope.templatefeat;
          }

          if (!angular.isDefined(data.features)) return;
          // gclayers.clearEditLayer();

          if (data.features.length == 0) {
            scope.tempresbuffer = '';
            scope.currentobj.current.geometry = '';
          } else {
            var geom = [];
            data.features.forEach(function(f) {
              geom.push(f.geometry);
            });
            GeometryFactory.unionandbuffer(
              geom,
              scope.typebuffer,
              scope.distance
            ).then(function(res) {
              scope.tempIntervFeature.geometry = res.data;
              scope.tempIntervFeature.type = 'Feature';
              scope.tempIntervFeature.properties = {};
              scope.tempresbuffer = res.data;
              scope.currentobj.current.geometry = angular.copy(scope.tempresbuffer);

              var vector_source = gclayers.getDrawLayer().getSource();
              var parser = new ol.format.GeoJSON();
              vector_source.addFeature(
                parser.readFeature(scope.tempIntervFeature)
              );

              // scope.onfinish();
            });
          }
        };

        scope.addfeatures = true;
        // template geojson
        scope.templatefeat = {
          type: 'Feature',
          id: 'newid',
          geometry: {},
          geometry_name: 'geom',
          properties: {},
        };
        scope.altKeyPressed = false;
        // selection et gestion des evenements
        scope.selectinterv = function() {
          scope.ftis = [];
          for (var i in scope.obj.ftisid) {
            //     console.log(scope.ftisid[i]);
            scope.ftis.push(
              FeatureTypeFactory.getFeatureByUid(scope.obj.ftisid.uid)
            );
          }

          var map = scope.map;
          scope.isActive = true;
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              console.log(evt.originalEvent.altkey);
              scope.altKeyPressed = evt.originalEvent.ctrlKey;
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.isActive
              ); /* ||
                             (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });

          scope.tempResult = angular.copy(scope.result);
          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'gcselectbufferise');
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.dragBox.setActive(true);
          map.addInteraction(scope.dragBox);
          scope.dragBox.on('boxend', function(evt) {
            // URL de rcup des objets
            // URL de rcup des objets
            var res = '';

            // WFS a besoin des typesName (layer)
            scope.ftis.forEach(function(fType) {
              res = res + fType.uid + ',';
            });
            if (!res) {
              require('toastr').info(
                $filter('translate')('hpo.common.choosecomponantfirst')
              );
              scope.removeInterv();
              return;
            }

            // var filter = gclayers.getSelectFilterasStringuid(map);
            var geometryExtent = scope.dragBox.getGeometry().getExtent();
            scope.geomselection = scope.dragBox.getGeometry();
            var leftX = geometryExtent[0];
            var bottomY = geometryExtent[1];

            var rightX = geometryExtent[2];
            var topY = geometryExtent[3];

            //var catchments_url = '/geoserver/'+PortalsFactory.getPortalId()+'/ows?service=WFS&version=1.0.0&request=GetFeature&typeName='+ filter +'&outputformat=json&srsName='+map.getView().getProjection().getCode()+'&bbox=' + scope.dragBox.getGeometry().getExtent() +','+map.getView().getProjection().getCode();

            var catchments_url =
              '/services/' +
              PortalsFactory.getPortalId() +
              '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' +
              res +
              '&outputformat=json&srsName=' +
              map
                .getView()
                .getProjection()
                .getCode() +
              '&cql_filter=INTERSECTS(geom, POLYGON((' +
              leftX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              bottomY +
              ',' +
              rightX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              topY +
              ',' +
              leftX +
              ' ' +
              bottomY +
              ')))';

            var promise = $http.get(catchments_url);
            gaDomUtils.showGlobalLoader();
            promise.then(function(res) {
              if (scope.altKeyPressed) {
                var feats = scope.tempResult;
                if (angular.isUndefined(feats.length)) {
                  feats = scope.tempResult.features;
                }
                for (var i = 0; i < feats.length; i++) {
                  res.data.features.push(feats[i]);
                }
                res.data.totalFeatures = res.data.features.length;
              }
              if (
                scope.addfeatures &&
                scope.tempResult &&
                scope.tempResult.features
              ) {
                var ids = scope.tempResult.features
                  .map(function(x) {
                    if (x && x.id) return x.id;
                  })
                  .filter(function(x) {
                    if (x) return x;
                  });
                res.data.features.map(function(x) {
                  if (x && x.id && ids.indexOf(x.id) === -1)
                    scope.tempResult.features.push(x);
                });
                // scope.tempResult.features = scope.tempResult.features.concat(res.data.features);
              } else {
                gclayers.clearEditLayer();
                scope.tempResult = res.data;
              }
              if (scope.conddatatable && scope.conddatatable == true) {
                var ftiselected = scope.tempResult.features.map(function(feat) {
                  if (feat.id) return feat.id.split('.')[0];
                });
                ftiselected = $.unique(ftiselected);
                var idx = scope.ftis
                  .map(function(x) {
                    return x.name;
                  })
                  .indexOf(ftiselected[0]);
                if (~idx) {
                  var fti = scope.ftis[idx];
                  // var ftiobjet;
                  // for ( var i = 0 ; i < fti.relations.length ; i++ ){
                  //     var relation = fti.relations[i];
                  //     if ( relation.type = "REL_SIMPLE" ){
                  //         var ftidrelation = relation.idEnd;
                  //         var ftiobjet = FeatureTypeFactory.getFeatureByUid(ftidrelation)
                  //         break;

                  //     }
                  // }
                  scope.templatefields.fields.map(function(x) {
                    if (x && x.type === 'data' && x.config) {
                      x.config.ftid = fti.uid;
                      x.config.attributes = fti.attributes.map(function(x) {
                        return x.name;
                      });
                    }
                  });

                  if (
                    scope.currentobj &&
                    scope.currentobj['current'] &&
                    scope.currentobj['current'].properties
                  ) {
                    scope.currentobj.current.properties.FTIUID = fti.uid;
                  }

                  // if ( scope.ftisData ) {
                  //   for ( var key in scope.ftisData ){
                  //     if ( key && scope.ftisData.hasOwnProperty(key) ){
                  //
                  //     }
                  //   }
                  // }
                }
              }

              scope.generatebuffer(scope.tempResult);
              gaDomUtils.hideGlobalLoader();
            });

            // updateselection was modified
            scope.$watch(
              'updateselection',
              function(updateselection) {
                if (angular.isDefined(updateselection)) {
                  if (
                    updateselection.constructor === Object &&
                    Object.keys(updateselection).length === 0
                  ) {
                    return;
                  }
                  if (
                    updateselection.hasOwnProperty('type') &&
                    updateselection.type == 'FeatureCollection'
                  ) {
                    scope.generatebuffer(updateselection);
                    return;
                  }

                  var featureCollection = {};
                  featureCollection.type = 'FeatureCollection';
                  featureCollection.features = updateselection;
                  scope.generatebuffer(featureCollection);
                }
              },
              1
            );
            // scope.dragBox.setActive(false);
            // map.removeInteraction(scope.dragBox);
          });

          scope.validateInterv = function() {
            scope.intervFeature = angular.copy(scope.tempIntervFeature);
            scope.resbuffer = angular.copy(scope.tempresbuffer);
            scope.result = angular.copy(scope.tempResult);
            try {
              scope.$apply();
            } catch(err) {}
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
            $timeout(function() {
              scope.onfinish();
            });
          };

          scope.removeInterv = function() {
            scope.resbuffer = '';
            scope.tempResult = angular.copy(scope.result);
            gclayers.clearEditLayer();
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
            try {
              scope.$apply();
            } catch(err) {}
          };
        };
      },
    };
  };

  gcelement.$inject = [
    '$http',
    'gclayers',
    'gcStyleFactory',
    'FeatureTypeFactory',
    'GeometryFactory',
    'gcInteractions',
    'HpoCarteAppFactory',
    '$rootScope',
    '$filter',
    'gaDomUtils',
    '$timeout',
    'PortalsFactory',
  ];
  return gcelement;
});
