'use strict';
define(function() {
  var gcelement = function(
      gclayers,
      gcStyleFactory,
      $http,
      gcInteractions,
      PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/select/views/gcselectandbufferise.html',

      restrict: 'A',
      scope: {
        map: '=map',
        result: '=res',
        resbuffer: '=res',
        ftisid: '=ftisid',
        typebuffer: '=typebuffer',
        distance: '=distance',
        toolBarWidget: '=?toolbarwidget',
        onfinish: '&',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.selectinterv = function() {
          var map = scope.map;
          scope.isActive = true;
          scope.dragBox = new ol.interaction.DragBox({
            condition: function(evt) {
              //MacEnvironments don't get here because the event is not
              //recognized as mouseEvent on Mac by the google closure.
              //We have to use the apple key on those devices
              return (
                evt.originalEvent.ctrlKey || scope.isActive
              ); /* ||
                      (gaBrowserSniffer.mac && evt.originalEvent.metaKey);*/
            },
            style: gcStyleFactory.getStyle('selectrectangle'),
          });

          scope.dragBox.set('gctype', 'kis');
          scope.dragBox.set('interaction', 'Select');
          scope.dragBox.set('widget', 'rights');
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.dragBox.setActive(true);
          map.addInteraction(scope.dragBox);

          scope.dragBox.on('boxend', function(evt) {
            // URL de rcup des objets
            var res = '';
            scope.ftis.forEach(function(fType) {
              res = res + fType.name + ',';
            });
            res = res.substr(0, res.length - 1);
            console.log(res);
            var filter = res;

            var catchments_url =
              '/services/' +
              PortalsFactory.getPortalId() +
              '/geoserver/ows?service=WFS&version=1.0.0' +
              '&request=GetFeature&typeName=' +
              res +
              '&outputformat=json&srsName=' +
              map
                .getView()
                .getProjection()
                .getCode() +
              '&bbox=' +
              scope.dragBox.getGeometry().getExtent() +
              ',' +
              map
                .getView()
                .getProjection()
                .getCode();

            var promise = $http.get(catchments_url);
            promise.then(function(res) {
              scope.result = res.data;
            });
            scope.dragBox.setActive(false);
            map.removeInteraction(scope.dragBox);
          });
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    'gcStyleFactory',
    '$http',
    'gcInteractions',
    'PortalsFactory'
  ];
  return gcelement;
});
