'use strict';
define(function() {
  var numberInputWithTextValue = function() {
    return {
      templateUrl:
        'js/XG/widgets/utilities/numberInputWithTextValue/views/numberInputWithTextValue.html',
      restrict: 'EA',
      scope: {
        bindModel: '=ngModel',
        bindDisabled: '&ngDisabled',
        max: '=max',
        min: '=min',
      },
      link: function(scope) {

        if (scope.bindDisabled === undefined) {
          scope.thisIsDisabled = () => { return false; };
        }
        else {
          scope.thisIsDisabled = scope.bindDisabled();
        }

        /**
         *      Cette directive permet d'utiliser une valeur de type texte
         *  dans une saisie de nombre entier.
         *  Depuis la 1.8 et son évolution de version d'angular,
         *  ce dernier a de plus forte contrainte sur les types.
         *  Cette directive en remplacement de <input type="number" ...
         *  de ne changer que la directive et rien d'autre dans le code.
         *  De plus elle vérifie le cas échéant que la valeur saisie
         *  se trouve dans l'intervale [min,max].
         */
        scope.updateValueFrom = function(from) {
          let newVal;
          if (from == 'fromText') {
            newVal = parseFloat(scope.bindModel);
            if (scope.max != undefined && newVal > scope.max)
              newVal = scope.max;
            if (scope.min != undefined && newVal < scope.min)
              newVal = scope.min;
            if (newVal != scope.value) scope.value = newVal;
          } else {
            // 'fromNumber')
            if (scope.max != undefined && scope.value > scope.max)
              scope.value = scope.max;
            if (scope.min != undefined && scope.value < scope.min)
              scope.value = scope.min;
            newVal = '' + scope.value;
            if (scope.bindModel != newVal) scope.bindModel = newVal;
          }
        };
        scope.updateValueFrom('fromText');
      },
    };
  };

  numberInputWithTextValue.$inject = ['sldUtils', '$filter'];
  return numberInputWithTextValue;
});
