'use strict';
define([
  'angular',
  'widgets/utilities/network/directives/gcnodeselect',
  'widgets/utilities/network/directives/gcaddbarrier',
  'widgets/utilities/network/directives/gcgetfastway',
  'widgets/utilities/network/directives/gcpathselect',
  'widgets/utilities/network/directives/gcpathroute',
  'widgets/utilities/network/directives/gcsubnetworkselect',
  'widgets/utilities/network/directives/gcpathhtoolbar',
  'widgets/utilities/network/directives/gcnetworks',
  'widgets/utilities/network/directives/gcgetdirectednetworkpart',
  'widgets/utilities/network/directives/gcgetamontavalpart',
  'widgets/utilities/network/directives/gcorthogonalhit',
  'widgets/utilities/network/directives/gcdistancenetwork',
  'widgets/utilities/network/services/networkDirectivesProvider',
  'modules/common/filters/roundDouble',
  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',
  'ol3js',
  'ng-table',
], function(
  angular,
  gcnodeselect,
  gcaddbarrier,
  gcgetfastway,
  gcpathselect,
  gcpathroute,
  gcsubnetworkselect,
  gcpathhtoolbar,
  gcnetworks,
  gcgetdirectednetworkpart,
  gcgetamontavalpart,
  gcorthogonalhit,
  gcdistancenetwork,
  networkDirectivesProvider,
  roundDouble
) {
  var networkUtilities = angular.module('networkutilities', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
  ]);
  networkUtilities.provider(
    'networkDirectivesProvider',
    networkDirectivesProvider
  );
  networkUtilities.directive('nodeSelect', gcnodeselect);
  networkUtilities.directive('addBarrier', gcaddbarrier);
  networkUtilities.directive('getFastWay', gcgetfastway);
  networkUtilities.directive('getPathSelect', gcpathselect);
  networkUtilities.directive('getPathRoute', gcpathroute);
  networkUtilities.directive('getSubNetworkSelect', gcsubnetworkselect);
  networkUtilities.directive('pathToolbar', gcpathhtoolbar);
  networkUtilities.directive(
    'getDirectedNetworkPart',
    gcgetdirectednetworkpart
  );
  networkUtilities.directive('gcGetAmontAvalPart', gcgetamontavalpart);
  networkUtilities.directive('gcOrthogonalHit', gcorthogonalhit);
  networkUtilities.directive('gcDistanceNetwork', gcdistancenetwork);
  networkUtilities.directive('selNetworks', gcnetworks);
  networkUtilities.filter('roundDouble', roundDouble);
  return networkUtilities;
});
