'use strict';
define(function() {
  var gcelement = function(NetworkFactory, $timeout) {
    var FEATURE_COLLECTION_TEMPLATE = {
      type: 'FeatureCollection',
      features: [],
    };

    return {
      templateUrl: 'js/XG/widgets/utilities/network/views/gcgetfastway.html',

      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        pathprocessconfig: '=pathprocessconfig',
        noeudamont: '=noeudamont',
        noeudaval: '=noeudaval',
        barriers: '=barriers',
        result: '=res',
        minNodesToParse: '=minnodes',
        maxNodesToParse: '=maxnodes',
        nodesIncrementWalk: '=nodesincr',
        featuresResult: '=featuresres',
        nfeaturesResult: '=netfeaturesres',
        disabled: '=ngDisabled',
        onfinish: '&',
      },
      transclude: true,
      link: function(scope, element) {
        var networkName = scope.netname;
        var pathProcessConfig = null;

        console.log(scope.minNodesToParse);
        console.log(scope.maxNodesToParse);
        console.log(scope.nodesIncrementWalk);

        if (scope.pathprocessconfig)
          pathProcessConfig = simplifyPathProcessConfig(
            scope.pathprocessconfig
          );

        var map = scope.map;
        var inSrid = map
          .getView()
          .getProjection()
          .getCode();

        var btnElt = $(element.children()[0]);

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function simplifyPathProcessConfig(networkTool) {
          var networkToolConfig = {
            label: networkTool.label,
            toolType: networkTool.toolType,
            amontElements: [],
            avalElements: [],
            networkElements: [],
            amontElementsFilters: [],
            avalElementsFilters: [],
            networkElementsFilters: [],
          };

          var amontElementsConfigPart = dataToSavePartConfig(
            networkTool.amontElementsData
          );
          var avalElementsConfigPart = dataToSavePartConfig(
            networkTool.avalElementsData
          );
          var networkElementsConfigPart = dataToSavePartConfig(
            networkTool.edgesAndNodesData
          );

          networkToolConfig.amontElements = amontElementsConfigPart;
          networkToolConfig.avalElements = avalElementsConfigPart;
          networkToolConfig.networkElements = networkElementsConfigPart;

          var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAmontEditFTypeAttributeValues
          );
          var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAvalEditFTypeAttributeValues
          );
          var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentEditFTypeAttributeValues
          );

          networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
          networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
          networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

          return networkToolConfig;
        }

        function featureAlreadyAdded(features, modelFeatureJSON) {
          for (var i = 0; i < features.length; i++) {
            var featureJSON = features[i];
            if (featureJSON.id == modelFeatureJSON.id) return true;
          }

          return false;
        }

        function toFeatureCollection(simpleResult, isNetworkFeatureCollection) {
          var resultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );

          for (var j = 0; j < simpleResult.elements.length; j++) {
            var pathElement = simpleResult.elements[j];
            var feature = isNetworkFeatureCollection
              ? pathElement.feature
              : pathElement.modelFeature;
            var modelFeatureJSON = angular.fromJson(feature);
            if (
              !featureAlreadyAdded(
                resultFeatureCollection.features,
                modelFeatureJSON
              )
            )
              resultFeatureCollection.features.push(modelFeatureJSON);
          }

          return resultFeatureCollection;
        }

        function getFastWayHandler() {
          if (scope.pathprocessconfig)
            pathProcessConfig = simplifyPathProcessConfig(
              scope.pathprocessconfig
            );

          var data = {
            noeudAmont: scope.noeudamont,
            noeudAval: scope.noeudaval,
            barriers: scope.barriers,
            processConfig: pathProcessConfig,
          };

          NetworkFactory.getfastestway(data, networkName, inSrid).then(function(
            res
          ) {
            scope.result = res.data;
            scope.featuresResult = toFeatureCollection(scope.result, false);
            scope.nfeaturesResult = toFeatureCollection(scope.result, true);

            $timeout(scope.onfinish, 100);
          });
        }

        scope.getFastWay = function() {
          getFastWayHandler();
        };
      },
    };
  };

  gcelement.$inject = ['NetworkFactory', '$timeout'];
  return gcelement;
});
