'use strict';
define(function() {
  var gcelement = function(NetworkFactory, $timeout) {
    var FEATURE_COLLECTION_TEMPLATE = {
      type: 'FeatureCollection',
      features: [],
    };

    var NOEUD_AMONT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudamont.png',
        })
      ),
    });

    var BARRIER_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          opacity: 0.75,
          src: 'img/widget/network/barrier.png',
        })
      ),
    });

    var GEOJSON_FORMAT = new ol.format.GeoJSON();

    var styles = {
      MultiPolygon: [
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'yellow',
            width: 1,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(255, 255, 0, 0.1)',
          }),
        }),
      ],
      Polygon: [
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'blue',
            lineDash: [4],
            width: 3,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(0, 0, 255, 0.7)',
          }),
        }),
      ],
      Point: [
        new ol.style.Style({
          image: new ol.style.Circle({
            radius: 6,
            fill: new ol.style.Fill({
              color: 'rgba(255,255,255,1)',
            }),
            stroke: new ol.style.Stroke({
              color: 'rgba(255,0,0,1)',
            }),
          }),
        }),
      ],
    };

    var styleFunction = function(feature, resolution) {
      return styles[feature.getGeometry().getType()];
    };

    var nodesSource = new ol.source.Vector({
      //create empty vector
    });

    var nodesLayer = new ol.layer.Vector({
      source: nodesSource,
    });

    var originSource = new ol.source.Vector({
      //create empty vector
    });

    var originLayer = new ol.layer.Vector({
      source: originSource,
      style: styleFunction,
    });

    var pathsSource = new ol.source.Vector({
      //create empty vector
    });

    var pathsLayer = new ol.layer.Vector({
      source: pathsSource,
      style: styleFunction,
    });

    var validPathSource = new ol.source.Vector({
      //create empty vector
    });

    var validPathLayer = new ol.layer.Vector({
      source: validPathSource,
      style: styleFunction,
    });

    var lastNodesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastNodesLayer = new ol.layer.Vector({
      source: lastNodesSource,
      style: styleFunction,
    });

    var lastClosingNodesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastClosingNodesLayer = new ol.layer.Vector({
      source: lastClosingNodesSource,
      style: styleFunction,
    });

    return {
      templateUrl:
        'js/XG/widgets/utilities/network/views/gcgetdirectednetworkpart.html',

      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        minnodes: '=minnodes',
        maxnodes: '=maxnodes',
        nodesincr: '=nodesincr',
        pathprocessconfig: '=pathprocessconfig',
        result: '=res',
        featuresResult: '=featuresres',
        nfeaturesResult: '=netfeaturesres',
        onfinish: '&',
        toolBarWidget: '=?toolbarwidget',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.networkExtendSelectInteraction = null;
        scope.allPaths = [];
        scope.resultIsNotReady = true;
        scope.showConfig = false;
        scope.originSource = originSource;
        scope.pathsSource = pathsSource;
        scope.validPathSource = validPathSource;
        scope.lastNodesSource = lastNodesSource;
        scope.lastClosingNodesSource = lastClosingNodesSource;
        scope.lastClosingNodesLayer = lastClosingNodesLayer;
        scope.amontNodeExist = false;

        var map = scope.map;
        var nodesLayerRegistered = false;
        var amontFeature = null;

        scope.xPart = {};
        scope.xPartFeatures = {};
        scope.netXPartFeatures = {};

        scope.noeudAmontIsActive = 'DEACTIVATED';
        scope.addBarrierIsActive = 'DEACTIVATED';

        scope.nodesToParse = {
          value: scope.minnodes,
          lastRequestValue: scope.minnodes,
        };

        scope.path = {
          noeudAmont: {},
          lastAddedBarrier: {},
          barriers: [],
        };

        function removeExtendSelectInteraction() {
          if (scope.networkExtendSelectInteraction) {
            scope.networkExtendSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkExtendSelectInteraction);
            scope.networkExtendSelectInteraction.un('select');
            scope.networkExtendSelectInteraction = null;
          }
        }

        function activate() {
          if (nodesLayerRegistered == false) {
            map.addLayer(pathsLayer);
            map.addLayer(originLayer);
            map.addLayer(validPathLayer);
            map.addLayer(lastNodesLayer);
            map.addLayer(lastClosingNodesLayer);

            map.addLayer(nodesLayer);
            nodesLayerRegistered = true;
          }
        }

        function deactivate() {
          if (nodesLayerRegistered == true) {
            map.removeLayer(nodesLayer);

            map.removeLayer(pathsLayer);
            map.removeLayer(originLayer);
            map.removeLayer(validPathLayer);
            map.removeLayer(lastNodesLayer);
            map.removeLayer(lastClosingNodesLayer);

            pathsSource.clear();
            originSource.clear();
            validPathSource.clear();
            lastNodesSource.clear();
            lastClosingNodesSource.clear();

            nodesLayerRegistered = false;
          }
          nodesSource.clear();
          amontFeature = null;

          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';

          scope.allPaths = [];
          scope.resultIsNotReady = true;
          scope.amontNodeExist = false;

          scope.path = {
            noeudAmont: {},
            lastAddedBarrier: {},
            barriers: [],
          };
        }

        function featureAlreadyAdded(features, modelFeatureJSON) {
          for (var i = 0; i < features.length; i++) {
            var featureJSON = features[i];
            if (featureJSON.id == modelFeatureJSON.id) return true;
          }

          return false;
        }

        function handleValidatePath() {
          removeExtendSelectInteraction();
          var resultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );
          var networkResultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );
          var mergedPathElements = [];
          var mergedGeometry = new ol.geom.MultiLineString('');
          //var allGeometries = [];
          for (var i = 0; i < scope.allPaths.length; i++) {
            var path = scope.allPaths[i];
            if (mergedPathElements.length != 0) path.elements.shift();

            for (var j = 0; j < path.elements.length; j++) {
              var pathElement = path.elements[j];
              if (pathElement) {
                var modelFeatureJSON = angular.fromJson(
                  pathElement.modelFeature
                );
                if (
                  !featureAlreadyAdded(
                    resultFeatureCollection.features,
                    modelFeatureJSON
                  )
                ) {
                  resultFeatureCollection.features.push(modelFeatureJSON);
                  networkResultFeatureCollection.features.push(
                    angular.fromJson(pathElement.feature)
                  );
                  mergedPathElements.push(pathElement);
                }
              }
            }

            var pathGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            if (pathGeometry.getType() == 'LineString')
              mergedGeometry.appendLineString(pathGeometry);
            else {
              for (var k = 0; k < pathGeometry.getLineStrings().length; k++)
                mergedGeometry.appendLineString(pathGeometry.getLineString(k));
            }
          }

          var finalPath = {
            elements: mergedPathElements,
            features: resultFeatureCollection,
            netFeatures: networkResultFeatureCollection,
            geometry: GEOJSON_FORMAT.writeGeometry(mergedGeometry),
            //olGeometry: mergedGeometry
          };

          scope.featuresResult = resultFeatureCollection;
          scope.nfeaturesResult = networkResultFeatureCollection;

          $timeout(scope.onfinish, 100);
          deactivate();
        }

        function handleToggleConfigPath() {
          scope.showConfig = !scope.showConfig;
        }

        scope.noeudAmontSelected = function() {
          activate();

          if (
            amontFeature &&
            nodesSource.getFeatureById(amontFeature.getId()) != null
          ) {
            nodesSource.removeFeature(amontFeature);
            amontFeature == null;
            scope.amontNodeExist = false;
          }

          if (scope.path.noeudAmont && scope.path.noeudAmont.geometry) {
            var nodeGeometry = scope.path.noeudAmont.geometry;

            var olOriginGeometry = GEOJSON_FORMAT.readGeometry(nodeGeometry);
            amontFeature = new ol.Feature({
              name: '',
              geometry: olOriginGeometry,
            });

            amontFeature.setId(Math.floor(Math.random() * 1000));
            amontFeature.setStyle(NOEUD_AMONT_STYLE);

            nodesSource.addFeature(amontFeature);
            scope.amontNodeExist = true;
          }
        };

        scope.barrierAdded = function() {
          activate();

          if (
            scope.path.lastAddedBarrier &&
            scope.path.lastAddedBarrier.hitPoint
          ) {
            var barrierGeometry = scope.path.lastAddedBarrier.hitPoint;

            var olDestGeometry = GEOJSON_FORMAT.readGeometry(barrierGeometry);
            var barrierFeature = new ol.Feature({
              name: '',
              geometry: olDestGeometry,
            });

            barrierFeature.setStyle(BARRIER_STYLE);

            nodesSource.addFeature(barrierFeature);
            scope.path.barriers.push(scope.path.lastAddedBarrier.edge);
            scope.path.lastAddedBarrier = {};
          }
        };

        scope.noeudamontActivated = function() {
          scope.noeudAmontIsActive = 'ACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';
        };

        scope.addBarrierActivated = function() {
          scope.addBarrierIsActive = 'ACTIVATED';
          scope.noeudAmontIsActive = 'DEACTIVATED';
        };

        scope.xPartValidated = function() {
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.addBarrierIsActive = 'DEACTIVATED';

          nodesSource.clear();
          amontFeature = null;
        };

        scope.resetXPartToolbar = function() {
          deactivate();
        };

        scope.toggleConfigPath = function() {
          handleToggleConfigPath();
        };

        scope.validatePath = function() {
          handleValidatePath();
        };
      },
    };
  };

  gcelement.$inject = ['NetworkFactory', '$timeout'];
  return gcelement;
});
