'use strict';
define(function() {
  var gcelement = function(
    NetworkFactory,
    GeometryFactory,
    $timeout,
    gaDomUtils,
    gclayers
  ) {
    var BUFFER_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        color: 'blue',
        width: 3,
      }),
      fill: new ol.style.Fill({
        color: 'rgba(0, 0, 255, 0.1)',
      }),
    });

    var PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 4,
        color: 'rgba(255, 0, 0, 1)',
        lineDash: [0.1, 5],
      }),
      zIndex: 2,
    });

    var DIST_PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 4,
        color: 'rgba(100, 0, 200, 1)',
        lineDash: [0.1, 5],
      }),
      zIndex: 2,
    });

    var ORTHOGONAL_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          opacity: 0.75,
          src: 'img/widget/network/aim.png',
        })
      ),
    });

    var ORTHOGONAL_HIT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          opacity: 0.75,
          src: 'img/widget/network/hit.png',
        })
      ),
    });

    var LAST_CLOSING_NODE_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 20],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/lastnode.png',
        })
      ),
    });

    var GEOJSON_FORMAT = new ol.format.GeoJSON();

    var nodesSource = new ol.source.Vector({
      //create empty vector
    });

    var nodesLayer = new ol.layer.Vector({
      source: nodesSource,
    });

    var lastNodesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastNodesLayer = new ol.layer.Vector({
      source: lastNodesSource,
    });

    var pathsSource = new ol.source.Vector({
      //create empty vector
    });

    var pathsLayer = new ol.layer.Vector({
      source: pathsSource,
    });

    var distPathsSource = new ol.source.Vector({
      //create empty vector
    });

    var distPathsLayer = new ol.layer.Vector({
      source: distPathsSource,
    });

    var bufferSource = new ol.source.Vector({
      //create empty vector
    });

    var bufferLayer = new ol.layer.Vector({
      source: bufferSource,
    });

    return {
      templateUrl:
        'js/XG/widgets/utilities/network/views/gcdistancenetwork.html',

      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        minnodes: '=minnodes',
        maxnodes: '=maxnodes',
        nodesincr: '=nodesincr',
        pathprocessconfig: '=pathprocessconfig',
        result: '=res',
        featuresResult: '=featuresres',
        nfeaturesResult: '=netfeaturesres',
        onfinish: '&',
        toolBarWidget: '=?toolbarwidget',
      },
      link: function(scope, element, attrs, ctrl) {
        var allPathsGeometries = [];
        var allHitPathsGeometries = [];

        var genericConfig = scope.pathprocessconfig.genericConfig;
        scope.projectConfig = {
          defaultProject: genericConfig.defProjectDist,
          minProject: genericConfig.minProject,
          maxProject: genericConfig.maxProject,
          projectStep: genericConfig.stepProject,
        };
        scope.distanceConfig = {
          defaultDistance: genericConfig.defPropDist,
          minDistance: genericConfig.minProp,
          maxDistance: genericConfig.maxProp,
          distanceStep: genericConfig.stepProp,
        };
        scope.bufferConfig = {
          defaultBuffer: genericConfig.defBuffer,
          minBuffer: genericConfig.minBuffer,
          maxBuffer: genericConfig.maxBuffer,
          bufferStep: genericConfig.stepBuffer,
          typeBuffer: genericConfig.typeBuffer,
        };

        scope.amontNodeExist = false;
        scope.avalNodeExist = false;

        var map = scope.map;
        var layersRegistered = false;

        var networkName = scope.netname;
        var pathProcessConfig = null;

        if (scope.pathprocessconfig)
          pathProcessConfig = simplifyPathProcessConfig(
            scope.pathprocessconfig
          );

        var map = scope.map;
        var inSrid = map
          .getView()
          .getProjection()
          .getCode();

        scope.shortestPath = {};
        scope.shortestPathFeatures = {};
        scope.netShortestPathFeatures = {};

        scope.addOrthogonalHitIsActive = 'DEACTIVATED';

        scope.path = {
          lastAddedOrthogonalHit: {},
          orthogonalHits: [],
        };

        function activate() {
          if (layersRegistered == false) {
            map.addLayer(nodesLayer);
            map.addLayer(pathsLayer);
            map.addLayer(distPathsLayer);
            map.addLayer(lastNodesLayer);
            map.addLayer(bufferLayer);
            layersRegistered = true;
          }
        }

        function deactivate() {
          if (layersRegistered == true) {
            map.removeLayer(nodesLayer);
            map.removeLayer(pathsLayer);
            map.removeLayer(distPathsLayer);
            map.removeLayer(lastNodesLayer);
            map.removeLayer(bufferLayer);
            layersRegistered = false;
          }
          nodesSource.clear();
          pathsSource.clear();
          distPathsSource.clear();
          lastNodesSource.clear();
          bufferSource.clear();

          scope.addOrthogonalHitIsActive = 'DEACTIVATED';

          scope.path = {
            lastAddedOrthogonalHit: {},
            orthogonalHits: [],
          };

          allHitPathsGeometries = [];
          gclayers.clearhighLightFeatures();
        }

        function handleHighlightOrthogonalHit(orthogonalHit) {
          gclayers.clearhighLightFeatures();
          gclayers.addhighLightFeature(orthogonalHit.clickFeature);
          map
            .getView()
            .setCenter(
              orthogonalHit.clickFeature.getGeometry().getFirstCoordinate()
            );
        }

        function handleRemoveOrthogonalHit(orthogonalHit) {
          if (orthogonalHit.features) {
            if (
              orthogonalHit.features.nodesFeatures &&
              orthogonalHit.features.nodesFeatures.length > 0
            ) {
              angular.forEach(orthogonalHit.features.nodesFeatures, function(
                nodeFeature
              ) {
                nodesSource.removeFeature(nodeFeature);
              });
            }

            if (orthogonalHit.features.pathFeature)
              pathsSource.removeFeature(orthogonalHit.features.pathFeature);
          }
          var orthogonalHitIndex = scope.path.orthogonalHits.indexOf(
            orthogonalHit
          );
          scope.path.orthogonalHits.splice(orthogonalHitIndex, 1);
          allHitPathsGeometries.splice(orthogonalHitIndex, 1);
        }

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function simplifyPathProcessConfig(networkTool) {
          var networkToolConfig = {
            label: networkTool.label,
            toolType: networkTool.toolType,
            amontElements: [],
            avalElements: [],
            networkElements: [],
            amontElementsFilters: [],
            avalElementsFilters: [],
            networkElementsFilters: [],
          };

          var amontElementsConfigPart = dataToSavePartConfig(
            networkTool.amontElementsData
          );
          var avalElementsConfigPart = dataToSavePartConfig(
            networkTool.avalElementsData
          );
          var networkElementsConfigPart = dataToSavePartConfig(
            networkTool.edgesAndNodesData
          );

          networkToolConfig.amontElements = amontElementsConfigPart;
          networkToolConfig.avalElements = avalElementsConfigPart;
          networkToolConfig.networkElements = networkElementsConfigPart;

          var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAmontEditFTypeAttributeValues
          );
          var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAvalEditFTypeAttributeValues
          );
          var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentEditFTypeAttributeValues
          );

          networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
          networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
          networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

          return networkToolConfig;
        }

        function simplifyOrthogonalHits() {
          var simplifiedOrthoHits = [];
          for (var i = 0; i < scope.path.orthogonalHits.length; i++) {
            var orthoHit = scope.path.orthogonalHits[i];
            simplifiedOrthoHits.push({
              distance: orthoHit.distance,
              edge: orthoHit.edge,
              hitPoint: orthoHit.hitPoint,
            });
          }

          return simplifiedOrthoHits;
        }

        function handleBufferingPaths() {
          bufferSource.clear();

          var allPGeometries = allPathsGeometries.concat(allHitPathsGeometries);
          GeometryFactory.unionandbuffer(
            allPGeometries,
            scope.bufferConfig.typeBuffer,
            scope.bufferConfig.defaultBuffer
          ).then(function(res) {
            var olGeometry = GEOJSON_FORMAT.readGeometry(res.data);
            var bufferFeature = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });

            bufferFeature.setStyle(BUFFER_STYLE);
            bufferSource.addFeature(bufferFeature);
          });
        }

        function handleParsingNetwork() {
          if (scope.pathprocessconfig)
            pathProcessConfig = simplifyPathProcessConfig(
              scope.pathprocessconfig
            );
          var data = {
            hitDirectedEdges: simplifyOrthogonalHits(),
            processConfig: pathProcessConfig,
          };

          gaDomUtils.showGlobalLoader();
          NetworkFactory.processpathdistanceparse(
            data,
            networkName,
            inSrid,
            scope.distanceConfig.defaultDistance
          ).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              /*if ((res.data.nextPaths == null || res.data.nextPaths.length == 0) && scope.nodesToParse.value < scope.maxNodesToParse)
                            showDialogToExtendPath();
                        else {*/
              handlePossiblePaths(res.data, true);
              //}
            },
            function errorCallback(response) {
              gaDomUtils.hideGlobalLoader();
            }
          );
        }

        function getNextNodeEl(path) {
          return path.elements[path.elements.length - 1];
        }

        function handlePossiblePathFotOneHit(nextNodePaths) {
          angular.forEach(nextNodePaths.nextPaths, function(path) {
            allPathsGeometries.push(path.geometry);
            var olGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            var possibleNextPath = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });

            possibleNextPath.setStyle(DIST_PATH_STYLE);

            distPathsSource.addFeature(possibleNextPath);
          });
        }

        function handlePossiblePaths(nextNodesPaths, clear) {
          if (clear) {
            distPathsSource.clear();
            lastNodesSource.clear();
            bufferSource.clear();
            allPathsGeometries = [];
          }

          angular.forEach(nextNodesPaths, function(nextNodePaths) {
            handlePossiblePathFotOneHit(nextNodePaths);
          });

          scope.resultIsNotReady = false;
          //$timeout(scope.onfinish(), 100);
        }

        scope.orthogonalHitAdded = function() {
          activate();

          if (
            scope.path.lastAddedOrthogonalHit &&
            scope.path.lastAddedOrthogonalHit.hitPoint
          ) {
            var clickFeature = scope.path.lastAddedOrthogonalHit.clickFeature;
            var hitGeometry = scope.path.lastAddedOrthogonalHit.hitPoint;

            var olDestGeometry = GEOJSON_FORMAT.readGeometry(hitGeometry);
            var orthogonalHitFeature = new ol.Feature({
              name: '',
              geometry: olDestGeometry,
            });

            clickFeature.setStyle(ORTHOGONAL_HIT_STYLE);
            nodesSource.addFeature(clickFeature);

            orthogonalHitFeature.setStyle(ORTHOGONAL_STYLE);
            nodesSource.addFeature(orthogonalHitFeature);

            var hitPathGeometry = new ol.geom.LineString([
              clickFeature.getGeometry().getFirstCoordinate(),
              olDestGeometry.getFirstCoordinate(),
            ]);
            var hitPathFeature = new ol.Feature({
              name: '',
              geometry: hitPathGeometry,
            });
            hitPathFeature.setStyle(PATH_STYLE);
            var hitPathGeometryString = GEOJSON_FORMAT.writeGeometry(
              hitPathGeometry
            );
            allHitPathsGeometries.push(hitPathGeometryString);
            pathsSource.addFeature(hitPathFeature);

            scope.path.lastAddedOrthogonalHit.features = {
              nodesFeatures: [clickFeature, orthogonalHitFeature],
              pathFeature: hitPathFeature,
            };
            scope.path.orthogonalHits.push(scope.path.lastAddedOrthogonalHit);
            scope.path.lastAddedOrthogonalHit = {};
          }
        };

        scope.addOrthogonalHitIsActivated = function() {
          scope.addOrthogonalHitIsActive = 'ACTIVATED';
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.noeudAvalIsActive = 'DEACTIVATED';
        };

        scope.pathValidated = function() {
          scope.noeudAmontIsActive = 'DEACTIVATED';
          scope.noeudAvalIsActive = 'DEACTIVATED';
          scope.addOrthogonalHitIsActive = 'DEACTIVATED';

          scope.result = scope.shortestPath;
          scope.featuresResult = scope.shortestPathFeatures;
          scope.nfeaturesResult = scope.netShortestPathFeatures;

          $timeout(scope.onfinish, 100);

          deactivate();
        };

        scope.resetPathToolbar = function() {
          deactivate();
        };

        scope.processParsingNetwork = function() {
          scope.addOrthogonalHitIsActive = 'DEACTIVATED';
          handleParsingNetwork();
        };

        scope.validateResults = function() {
          scope.addOrthogonalHitIsActive = 'DEACTIVATED';
          handleBufferingPaths();
        };

        scope.removeOrthogonalHit = function(orthogonalHit) {
          handleRemoveOrthogonalHit(orthogonalHit);
        };

        scope.highlightOrthogonalHit = function(orthogonalHit) {
          handleHighlightOrthogonalHit(orthogonalHit);
        };
      },
    };
  };

  gcelement.$inject = [
    'NetworkFactory',
    'GeometryFactory',
    '$timeout',
    'gaDomUtils',
    'gclayers',
  ];
  return gcelement;
});
