'use strict';
define(function() {
  var gctabledata = function(
    ngTableParams,
    $filter,
    FeatureTypeFactory,
    QueryFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gctabledata.html',
      restrict: 'EA',
      scope: {
        fti: '=',
        whereclause: '@',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.$watch(
          function() {
            return scope.fti;
          },
          function() {
            if (!angular.isUndefined(scope.fti)) {
              QueryFactory.data(scope.fti.uid, scope.whereclause).then(function(
                res
              ) {
                // scope.feat = FeatureTypeFactory.resources.featuretypes;
                var resData = res.data;
                scope.features = resData.features;
                scope.tableParams = new ngTableParams(
                  {
                    page: 1, // show first page
                    count: 10, // count per page
                    sorting: {
                      //   name: 'asc'     // initial sorting
                    },
                  },
                  {
                    total: scope.features.length, // length of data
                    getData: function($defer, params) {
                      // use build-in angular filter
                      var orderedData = params.sorting()
                        ? $filter('orderBy')(scope.features, params.orderBy())
                        : scope.features;
                      $defer.resolve(
                        orderedData.slice(
                          (params.page() - 1) * params.count(),
                          params.page() * params.count()
                        )
                      );
                    },
                  }
                );
              });
            }
          },
          true
        );

        scope.getTableData = function() {
          var ftiuid = scope.featureType.uid;
          console.log('uid');
          console.log(ftiuid);
          //       console.log("fti");
          //     console.log(scope.fti);
          QueryFactory.data(ftiuid, scope.whereclause).then(function(res) {
            // scope.feat = FeatureTypeFactory.resources.featuretypes;
            var resData = res.data;
            scope.features = resData.features;

            //scope.data=[];
            /*
                        for(var i=0;i<features.length;i++){
                           scope.data.push(features[i].properties);
                        };
*/

            scope.tableParams = new ngTableParams(
              {
                page: 1, // show first page
                count: 10, // count per page
                // sorting: {
                //   name: 'asc'     // initial sorting
                // }
              },
              {
                total: scope.features.length, // length of data
                getData: function($defer, params) {
                  // use build-in angular filter
                  var orderedData = params.sorting()
                    ? $filter('orderBy')(scope.features, params.orderBy())
                    : scope.features;
                  $defer.resolve(
                    orderedData.slice(
                      (params.page() - 1) * params.count(),
                      params.page() * params.count()
                    )
                  );
                },
              }
            );

            // console.log(scope.feat[0].uid);
            //scope.initfeatureTypesArray();
          });
        };

        scope.getFeatureTypesData = function() {
          if (FeatureTypeFactory.resources.featuretypes.length > 0) {
            scope.featureTypes = FeatureTypeFactory.resources.featuretypes;
            scope.featureType = scope.featureTypes[2];
            console.log('featureType');
            console.log(scope.featureType);
            scope.getTableData();

            // scope.initfeatureTypesArray();
          } else {
            FeatureTypeFactory.get().then(function() {
              scope.featureTypes = FeatureTypeFactory.resources.featuretypes;
              scope.featureType = scope.featureTypes[2];
              scope.getTableData();
              //scope.initfeatureTypesArray();
            });
          }
        };
        /*
            scope.initfeatureTypesArray = function() {

                for(var i= 0; i < scope.feat.length; i++)
                {
                    var featureType = scope.feat[i];

                    console.log("is geographic : " + featureType.alias);

                    if(featureType.geographic == true)
                    {

                        var newAttributes = [];
                    
                        var featureAttributes = featureType.attributes;

                        for(var j= 0; j < featureAttributes.length; j++)
                        {

                            var attrib = featureAttributes[j];

                            var newAttribute = {
                                name: attrib.name,
                                include: true
                            };

                            newAttributes.push(newAttribute);
                        }

                        var newFeatureType = {
                            name: featureType.name,
                            uid: featureType.uid,
                            attributes: newAttributes,
                            include: false
                        };

                        scope.featureTypes.push(newFeatureType);

                    }
                }

                scope.isLayerSelected = scope.checkLayersSelection();
            };
*/
        // scope.getFeatureTypesData();
        //scope.getTableData();
      },
    };
  };

  gctabledata.$inject = [
    'ngTableParams',
    '$filter',
    'FeatureTypeFactory',
    'QueryFactory',
  ];
  return gctabledata;
});
