'use strict';
define(function () {
  var gcfilter = function (ParametersFactory, $filter) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcfilter.html',
      restrict: 'AE',
      scope: {
        filter: '=',
      },
      link: function (scope) {
        ParametersFactory.getbytype('defaultfilter').then(
            (res) => {
              if (res.data && Array.isArray(res.data)) {
                scope.filters = res.data;
                console.log("gcfilter: filtres récupérés");
              } else {
                scope.filters = [];
                console.log(
                    "gcfilter: la config n'est pas un tableau, aucun filtre");
              }
            },
            () => {
              require('toastr').error(
                  $filter('translate')('elastic.search.search_failed'));
            }
        );

        /**
         * Sauvegarde la valeur choisie dans le select sous forme de string dans filter
         */
        scope.writeFilter = () => {
          if (scope.filterSelected.length > 0){
            scope.filter = '\'' + scope.filterSelected + '\'';
          }
        }
      }
    };
  };
  gcfilter.$inject = ['ParametersFactory','$filter'];
  return gcfilter;
});