'use strict';
define(function() {
  var itvMassSoumFactory = function (
    $http,
    $timeout,
    $q,
    IndigauFactory,
    $filter,
    PortalsFactory
  ) {
    var portalid = angular.module('gcMain').portalid;
    if (portalid == undefined || portalid == '') {
      portalid = PortalsFactory.getPortalId();
    }
    var app = angular.module('gcMain').app;
    function getApp() {
      app = localStorage.getItem('app');
      if (!app) {
        $timeout(getApp, 500);
      }
    }
    if (app == undefined || app == '') {
      getApp();
    }


    function getItvMassLoadingStatus(datastore, network, configname, locale) {
      var promise = $http.get(
        '/services/' +
          portalid +
          '/itv/{appname}/getItvMassLoadingStatus?f=json' +
          '&datastore=' +
          datastore +
          '&network=' +
          network +
          '&configname=' +
          configname +
          '&locale=' +
          locale
      );
      return promise;
    }


    /**
     * Préparation des paramétres contenant le nom du champ nombre de défauts
     * et le nom du champ nombre de branchements des canalisations,
     * selon qu'ils sont configurés ou non.
     *
     * @param {*} itvConfig Configuration des outils ITV
     * @returns Objet à 2 propriétés "defaultCount" et "conectionCount"
     */
    const getCountFieldsForPipe = (itvConfig) => {
      let connectionCountField;
      let defaultCountField;
      if (itvConfig.extraconfig) {
        connectionCountField = itvConfig.extraconfig.connectionCountField;
        defaultCountField = itvConfig.extraconfig.defaultCountField;
      }
      if (connectionCountField === undefined) {
        connectionCountField = '';
      }
      if (defaultCountField === undefined) {
        defaultCountField = '';
      }
      return {
        defaultCount: defaultCountField,
        conectionCount: connectionCountField
      };
    };


    /**
     * Integre les ITVs d'un dossier vers la base.
     *
     * @param {string} loadName : nom du chargement en masse
     * @param {string} idField : nom du champ identifiant
     * @param {string} network : réseau d'assainisssement concerné
     * @param {*} datastore : source de données des ITVs
     * @param {*} automaticcalculation : calculer score rerau ?
     * @param {*} configname : nom du fichier de configuration
     * @param {*} locale : fr ou en ou ...
     * @param {*} agLayers : couches arcgis le cas échéant
     * @param {string} zipNames nom des fichiers zip chargés séparés par une virgule
     * @param {boolean} attachVideo true quand les vidéos doivent être attachés à la portion pour exploitation dans la visualisation
     * @returns : promesse de la requête HTTP
     */
    const getIntegrerITVsCalSce = ( itvConfig,
      loadName, idField, network, datastore, automaticcalculation,
      configname, locale, agLayers, tolerance, useIndigauEngine, zipNames,
      createConnectionPipes, attachVideo) => {
      const countFields = getCountFieldsForPipe(itvConfig);
      return $http.get( '/services/' + portalid +
            '/itv/{appname}/getIntegrerITVs?f=json' +
        '&loadName=' + loadName +
        '&idfield=' + idField +
        '&network=' + network +
        '&datastore=' + datastore +
        '&automaticcalculation=' + automaticcalculation +
        '&configname=' + configname +
        '&locale=' + locale +
        '&arcgislayers=' + agLayers +
        '&indigauEngine=' + !!useIndigauEngine +
        '&tolerance=' + tolerance +
        '&zipnames=' + zipNames +
        '&createConnectionPipes=' + createConnectionPipes +
        '&connectionCountField=' + countFields.conectionCount +
        '&defaultCountField=' + countFields.defaultCount +
        '&attachVideo=' + attachVideo
      );
    };

    function getIntegrerITVs(itvConfig, loadName, idField, network, datastore,
      automaticcalculation, configname,
      locale, agLayers, tolerance, useIndigauEngine, zipNames, createConnectionPipes, attachVideo) {
      if (automaticcalculation) {
        let def = $q.defer();
        //-- On veut invoquer le moteur indigau.
        //-- On vérifie d'abord qu'il est fonctionnel.
        IndigauFactory.checkIndigau(app, datastore, useIndigauEngine).then(
          (res) => {
            if (res.data.etat === 'erreur') {
              swal({
                title: $filter('translate')(
                  'indigau.itv.refreshrerau.' + res.data.errorList[0].message_kis
                ),
                text: res.data.errorMessage,
                type: 'error',
              });
              def.reject();
            }
            else {
              getIntegrerITVsCalSce(itvConfig, loadName, idField, network,
                datastore, automaticcalculation, configname,
                locale, agLayers, tolerance, useIndigauEngine, zipNames, createConnectionPipes, attachVideo).then(
                () => {
                  def.resolve();
                },
                () => {
                  def.reject();
                }
              );
            }
          },
          () => {
            def.reject();
          }

        );
        return def.promise;
      }

      return getIntegrerITVsCalSce(itvConfig, loadName, idField, network,
        datastore, automaticcalculation, configname, locale, agLayers,
        tolerance, useIndigauEngine, zipNames, createConnectionPipes, attachVideo);
    }

    function stopIntegrerITVs() {
      var promise = $http.get(
        '/services/' + portalid + '/itv/{appname}/stopIntegrerITVs?f=json'
      );
      return promise;
    }

    function emptyUploadedITVs() {
      var promise = $http.get(
        '/services/' + portalid + '/itv/{appname}/emptyUploadedITVs?f=json'
      );
      return promise;
    }
    function emptyBackedupITVs() {
      var promise = $http.get(
        '/services/' + portalid + '/itv/{appname}/emptyBackedupITVs?f=json'
      );
      return promise;
    }
    function pendingFilesList() {
      var promise = $http.get(
        '/services/' + portalid + '/itv/{appname}/pendingitv?f=json'
      );
      return promise;
    }
    function deletePendingFile(absolutePath) {
      var promise = $http.post(
        '/services/' + portalid + '/itv/{appname}/deletependingitv?f=json',
        absolutePath
      );
      return promise;
    }


    return {
      getItvMassLoadingStatus: getItvMassLoadingStatus,
      getIntegrerITVs: getIntegrerITVs,
      stopIntegrerITVs: stopIntegrerITVs,
      emptyUploadedITVs: emptyUploadedITVs,
      emptyBackedupITVs: emptyBackedupITVs,
      pendingFilesList: pendingFilesList,
      deletePendingFile: deletePendingFile,
    };
  };
  itvMassSoumFactory.$inject = [
    '$http',
    '$timeout',
    '$q',
    'IndigauFactory',
    '$filter',
    'PortalsFactory'
  ];
  return itvMassSoumFactory;
});
