'use strict';
/*-------------------------------------------------------------
 * Dessin de la portion inspectée sur la carte.
*/
define(function () {
  const itvDrawPartsFactory = function (itvSoumFactory, gclayers,
    itvUtilsFactory, $q) {



    const getMapProjCode = (scope) => {
      return scope.map.getView().getProjection().getCode();
    };


    const getPartsGetPolygons1 = (partheaderAmont, partheaderAval, part,
      partheaderCenter) => {
      return [
        {
          name: 'polygonAval',
          partHeader: partheaderAval,
          part: part
        },
        {
          name: 'polygonAmont',
          partHeader: partheaderAmont,
          part: part
        },
        {
          name: 'polygonCenter',
          partHeader: partheaderCenter,
          part: part
        },
      ];
    };


    /**
     * Dessine les tronçons récupérés pour un même Feature Type, et
     * défini les propriétés de travail pourla suite des traitements.
     *
     * @param {*} ids
     * @param {*} pa
     * @param {*} ftiUid
     */
    const drawPipesOfFti = (scope, ids, pa, ftiUid) => {
      const parts = scope.information.correspondance.parts;
      if (!parts.polygons) {
        parts.polygons = {};
      }
      const polygons = parts.polygons;
      const position
        = pa.partHeader.code === '@01' ? 'centerBranchement' : 'center';

      //-- Dessin des tronçons du Feature Type pointé par ftiUid.
      const promise = itvUtilsFactory.drawFeature(ftiUid, ids, getMapProjCode(scope), position);
      promise.then(() => {
        //-- Préparation des données pour les traitements ultérieurs.
        const layers = itvUtilsFactory.getitvoperationalLayers();
        for (const featureLayer of layers) {
          const properties = featureLayer.getProperties();
          if (properties.name == 'canal') {
            scope.map.getLayers().insertAt(5, featureLayer);
            if (angular.isUndefined(pa.features)) {
              pa.features = [];
            }
            pa.features = pa.features.concat(properties.features);
            pa.id = gclayers.getOperationalLayerByName(
              properties.feature.id.split('.')[0]).uid;
            const keyname = 'part' + itvUtilsFactory.getIndTronconFrom(pa.part);
            if (angular.isUndefined(polygons)) {
              parts.polygons = {};
            }
            if (angular.isUndefined(polygons[keyname])) {
              polygons[keyname] = {};
            }
            polygons[keyname][pa.name] = angular.copy(pa);
          }
        }
      });
      return promise;
    };


    const setLayer = (scope, pa, name, layerIndex) => {
      itvUtilsFactory.getitvoperationalLayers().forEach((featureLayer) => {
        let parts = scope.information.correspondance.parts;
        if (featureLayer.getProperties().name == name) {
          pa.feature = angular.copy(
            featureLayer.getProperties().feature
          );
          pa.id = gclayers.getOperationalLayerByName(
            featureLayer.getProperties().feature.id.split('.')[0]).uid;
          const keyname = 'part' + itvUtilsFactory.getIndTronconFrom(pa.part);
          if (angular.isUndefined(parts.polygons))
            parts.polygons = {};
          if (angular.isUndefined(parts.polygons[keyname]))
            parts.polygons[keyname] = {};
          parts.polygons[keyname][pa.name] = angular.copy(pa);
          scope.map.getLayers().forEach(function (Layer) {
            if (featureLayer.getProperties().name ===
              Layer.getProperties().name
            )
              itvUtilsFactory.removeLayer(scope,Layer);
          });
          scope.map.getLayers().insertAt(layerIndex, featureLayer);
        }
      });
    };


    /**
     * Dessin du ou des tronçon inspectés en vert sur la carte,
     * et positionnement de propriétés de travail dont la liste des features
     * que sont les objets dessinés sur la carte
     * pour traitements ultérieurs tels que zoom.
     *
     * @param {*} p
     * @param {*} pa
     */
    const drawPipesOnTheMap = (scope, ind, pa, promises) => {
      if (pa.partHeader.featUids.length > 0) {
        //-- Cas où plusieurs objets comme c'est possible avec les tronçons.
        itvUtilsFactory.clearoriginsourcecanal();
        itvUtilsFactory.removeLayerByName(scope, 'center');
        pa.features = [];

        let ids = '', prevFtiUid = '', ftiUid;
        for (let iFeat = 0; iFeat < pa.partHeader.featUids.length; iFeat++) {
          ftiUid = pa.partHeader.featUids[iFeat];
          if (ftiUid !== prevFtiUid && prevFtiUid!=='') {
            promises.push( drawPipesOfFti(scope, ids, pa, ftiUid) );
            ids = '';
          }
          if (ids != '') {
            ids += ',';
          }
          // -- Demander la value (champ value du header) car dans le car ArCGIS,
          // -- on veut être sûr de prendre la valeur "id" pour les cas où
          // -- le champ "id" est utilisé comme champ identifiant car
          // -- la recherche ensuite es basé sur "id" et non sur "objectid".
          ids += itvUtilsFactory.getIdValue(pa.partHeader, iFeat, true);
        }
        if (ids !== '') {
          promises.push( drawPipesOfFti(scope, ids, pa, ftiUid) );
        }
      }
      else if (pa.partHeader.featUid != null && pa.partHeader.featUid != '') {
        //-- Cas d'un seul objet en correspondance.
        itvUtilsFactory.clearoriginsourcecanal();
        const promise = itvUtilsFactory.drawFeature(pa.partHeader.featUid,
          itvUtilsFactory.getIdValue(pa.partHeader), getMapProjCode(scope), 'center');
        promise.then(
          () => {
            setLayer(scope, pa, 'center', 5);
          });
        promises.push(promise);
      }
    };


    const setPartHeader = (scope, codes, code, headerType, part) => {
      let partHeader;
      if (codes.includes(code)) {
        const indexheader = codes.indexOf(code);
        partHeader = itvUtilsFactory.getHeadersFrom(part)[indexheader];
      }
      else {
        partHeader = undefined;
      }
      if (!scope.corresp['partHeader' + headerType]) {
        scope.corresp['partHeader' + headerType] = {};
      }
      scope.corresp['partHeader' + headerType].partHeader = partHeader;
      scope.corresp['partHeader' + headerType].part = part;
      return partHeader;
    };


    const drawPartOnTheMap = (scope, ind, promises) => {
      //-- pa = part ?
      let pa = scope.correspPolygons[ind];
      let newkey;
      if (pa.part.objValeur) {
        newkey = 'part' + pa.part.objValeur.indTroncon;
      }
      else {
        newkey = 'part' + pa.part.partIndex;
      }
      const partsPolygons
            = scope.information.correspondance.parts.polygons;
      if (partsPolygons && partsPolygons[newkey]
              && partsPolygons[newkey][pa.name]) {
        pa.feature = partsPolygons[newkey][pa.name].feature;
        pa.id = partsPolygons[newkey][pa.name].id;
        pa.crs = partsPolygons[newkey][pa.name].crs;
        partsPolygons[newkey][pa.name].name = pa.name;
        const featUidSav = pa.partHeader.featUid;
        itvUtilsFactory.checkFeatureTypeUID(pa);
        pa = angular.copy(partsPolygons[newkey][pa.name]);
        if (!pa.partHeader.featUid) {
          pa.partHeader.featUid = featUidSav;
        }
      }

      //-- pa.partHeader n'est pas défini quand pas correspondance automatique
      if (pa.partHeader
        && (pa.partHeader.validated || pa.partHeader.matchedAutomatically)) {
        const idValue
          = itvUtilsFactory.getIdValue(pa.partHeader, undefined, true);
        if (pa.name.indexOf('Amont') !== -1) {
          const promise = itvUtilsFactory.drawFeature(pa.partHeader.featUid, idValue,
            getMapProjCode(scope), 'amont');
          promise.then(() => {
            setLayer(scope, pa, 'amont', 10);
          });
          promises.push(promise);
        }
        else if (pa.name.indexOf('Aval') !== -1) {
          const promise = itvUtilsFactory.drawFeature(pa.partHeader.featUid, idValue,
            getMapProjCode(scope), 'aval');
          promise.then(() => {
            setLayer(scope, pa, 'aval', 11);
          });
          promises.push(promise);
        }
        else if (pa.name.indexOf('Center') !== -1) {
          drawPipesOnTheMap(scope, ind, pa, promises);
        }
        else if (pa.name.indexOf('Alone') !== -1) {
          const promise = itvUtilsFactory.drawFeature(pa.partHeader.featUid,
            itvUtilsFactory.getIdValue(pa.partHeader), getMapProjCode(scope),'alone');
          promise.then(() => {
            setLayer(scope, pa, 'alone', 12);
          });
          promises.push(promise);
        }
      }
    };


    const drawParts = (scope, part) => {
      const def = $q.defer();
      itvUtilsFactory.clearAllSources();
      const codes = itvUtilsFactory.getCodesOfPart(part);

      //-- Le code AAT fait partie de la nome, s'il est présent,
      //-- il peut donner lieu à la créationde @01. Un code AAT
      //-- sans correspondance ne permet pas de trouver le branchement (@01),
      //-- toutefois on a bien affaire à un branchement)
      if (codes.includes('AAT')) {
        //-- Inspection de branchement
        scope.corresp.inspectionType = 'branchement';
        let amont = setPartHeader(scope, codes, 'AAT', 'Amont', part);
        const aval = setPartHeader(scope, codes, 'AAU', 'Aval', part);
        const center = setPartHeader(scope, codes, '@01', 'Center', part);

        scope.correspPolygons
          = getPartsGetPolygons1(amont, aval, part, center);
        scope.corresp.inspectionType = 'branchement';
      }
      else if (((codes.includes('AAD') || codes.includes('AAB'))
        && codes.includes('AAF')) || codes.includes('AAA')
      ) {
        scope.corresp.inspectionType = 'collecteur';
        let amont = setPartHeader(scope, codes, 'AAD', 'Amont', part);
        if (!amont) {
          amont = setPartHeader(scope, codes, 'AAB', 'Amont', part);
        }
        const aval = setPartHeader(scope, codes, 'AAF', 'Aval', part);
        const center = setPartHeader(scope, codes, 'AAA', 'Center', part);

        scope.correspPolygons
          = getPartsGetPolygons1(amont, aval, part, center);
      }
      else {
        // When code is CAA (solo Regard)
        scope.corresp.inspectionType = 'regard';
        const indexheader = codes.indexOf('CAA');
        let headers;
        if (part.objValeur) {
          headers = part.objValeur.headers;
        }
        else {
          headers = part.headers;
        }
        scope.correspPolygons = [{
          name: 'polygonAlone',
          partHeader: headers[indexheader],
          part: part
        }];
        scope.corresp.partHeaderAmont = scope.corresp.partHeaderAval
          = undefined;
        if (!scope.corresp.partHeaderCenter) {
          scope.corresp.partHeaderCenter = {};
        }
        scope.corresp.partHeaderCenter.partHeader
          = part.objValeur.headers[indexheader];
        scope.corresp.partHeaderCenter.part = part;
      }


      if (itvUtilsFactory.getitvoperationalLayers().length > 0) {
        itvUtilsFactory.removeLayers(scope);
        itvUtilsFactory.clearitvoperationalLayers();
      }

      //--  DESSIN  SUR  LA  CARTE
      const promises = [];
      for (let ind = 0; ind < scope.correspPolygons.length; ind++) {
        drawPartOnTheMap(scope, ind, promises);
      }
      $q.all(promises).finally(() => {
        def.resolve();
      });
      return def.promise;
    };



    return {
      drawParts: drawParts
    };
  };
  itvDrawPartsFactory.$inject = ['itvSoumFactory', 'gclayers',
    'itvUtilsFactory', '$q'];
  return itvDrawPartsFactory;
});
