'use strict';
define(function() {
  var itvSoumission = function(
    $filter,
    extendedNgDialog,
    FeatureAttachmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationVueEclate.html',
      restrict: 'A',
      scope: {
        vue: '=vue',
        type: '=type',
        map: '=map',
        conf: '=conf'
      },
      controller: [
        '$scope',
        '$element',
        '$attrs',
        function() {},
      ],
      link: function(scope) {
        var dataPoints = [];
        var dataBar = [];
        var details = angular.copy(scope.vue.details);
        if (scope.type == 'part') {
          // Création des données à lire
          var emplacements = details.map(function(x) {
            if (x._code_principal == 'BCD' || x._code_principal == 'BCE')
              return parseFloat(x._emplct_lng_vert);
          });
          var maxemplc = d3.max(emplacements);

          var maxdetail = details
            .map(function(x) {
              if (parseFloat(x._emplct_lng_vert) == maxemplc) return x;
            })
            .filter(function(x) {
              if (x !== undefined) return x;
            })[0];

          var minemplc = d3.min(emplacements);
          if (minemplc == parseFloat(0)) {
            var mindetail = details
              .map(function(x) {
                if (parseFloat(x._emplct_lng_vert) == minemplc) return x;
              })
              .filter(function(x) {
                if (x !== undefined) return x;
              })[0];
          } else {
            var bool = false;
            details.map(function(x) {
              if (parseFloat(x._emplct_lng_vert) == parseFloat(0) && !bool) {
                minemplc = parseFloat(x._emplct_lng_vert);
                mindetail = x;
                bool = true;
              }
            });
          }

          dataBar = [
            [minemplc, 12, mindetail],
            [maxemplc, 12, maxdetail],
          ];

          angular.forEach(details, function(detail) {
            if (
              !angular.equals(detail, mindetail) &&
              !angular.equals(detail, maxdetail)
            ) {
              if (detail.emplct_circ_1 !== '' && detail.emplct_circ_1 !== null)
                dataPoints.push([
                  parseFloat(detail._emplct_lng_vert),
                  parseInt(detail.emplct_circ_1.replace('h', '')),
                  detail,
                ]);
              if (detail.emplct_circ_2 !== '' && detail.emplct_circ_2 !== null)
                dataPoints.push([
                  parseFloat(detail._emplct_lng_vert),
                  parseInt(detail.emplct_circ_2.replace('h', '')),
                  detail,
                ]);
              if (detail.emplct_circ_1 == '' && detail.emplct_circ_2 == '')
                dataPoints.push([
                  parseFloat(detail._emplct_lng_vert),
                  6,
                  detail,
                ]);
            }
          });

          if (dataPoints.length > 1) {
            dataPoints = dataPoints.sort(function(a, b) {
              if (a[0] >= b[0]) return 1;
              if (a[0] < b[0]) return -1;
              if (a[0] == b[0]) {
                if (a[1] >= b[1]) return 1;
                if (a[1] < b[1]) return -1;
              }
            });
          }
        } else {
          var d = 0;
          details = [];
          var parts = angular.copy(scope.vue.parts);
          parts.map((x) => {
            if (!x.branchement) {
              x.details.map( (detail) => {
              //if ( x._code_principal == "BCD" || x._code_principal == "BCE" )
                detail._emplct_lng_vert = parseFloat(detail._emplct_lng_vert) + d;
                details.push(detail);
              });
              d = d3.max(
                x.details.map( (g) => {
                  return parseFloat(g._emplct_lng_vert);
                })
              );
            }
          });

          angular.forEach(details, function(x) {
            if (x._code_principal == 'BCD' || x._code_principal == 'BCE')
              dataBar.push([parseFloat(x._emplct_lng_vert), 12, x]);
          });

          dataBar = dataBar.sort(function(a, b) {
            if (a[0] >= b[0]) return 1;
            if (a[0] < b[0]) return -1;
          });

          minemplc = d3.min(
            dataBar.map(function(x) {
              return x[0];
            })
          );
          maxemplc = d3.max(
            dataBar.map(function(x) {
              return x[0];
            })
          );

          angular.forEach(details, function(detail, i) {
            if (
              detail._code_principal !== 'BCD' &&
              detail._code_principal !== 'BCE'
            ) {
              if (detail.emplct_circ_1 !== '')
                dataPoints.push([
                  parseFloat(detail._emplct_lng_vert),
                  parseInt(detail.emplct_circ_1.replace('h', '')),
                  detail,
                ]);
              if (detail.emplct_circ_2 !== '')
                dataPoints.push([
                  parseFloat(detail._emplct_lng_vert),
                  parseInt(detail.emplct_circ_2.replace('h', '')),
                  detail,
                ]);
              if (detail.emplct_circ_1 == '' && detail.emplct_circ_2 == '')
                dataPoints.push([
                  parseFloat(detail._emplct_lng_vert),
                  6,
                  detail,
                ]);
            }
          });

          if (dataPoints.length > 1) {
            dataPoints = dataPoints.sort(function(a, b) {
              if (a[0] > b[0]) return 1;
              if (a[0] < b[0]) return -1;
              if (a[0] == b[0]) {
                if (a[1] >= b[1]) return 1;
                if (a[1] < b[1]) return -1;
              }
            });
          }
        }

        // Création du premier SVG
        var w = 750;
        var h = 400;
        var margin = {
          top: 50,
          right: 50,
          bottom: 50,
          left: 50,
        };

        var widthScale = w - margin.right;

        var svg = d3
          .select('#main-svg')
          .append('svg')
          .attr('class', 'bars')
          .attr('width', w)
          .attr('height', h);

        // fonction Scale convertit une valeur Date en position sur la largeur du SVG sous forme d'histogramme
        var xdomain = [minemplc, maxemplc];
        const xScale = d3.scale.linear().domain(xdomain)
          .range([margin.left, widthScale]);

        d3.scale.linear().domain(xdomain).range([margin.left, widthScale + 10]);
        // fonction Scale convertit une valeur Anomalie en position sur la largeur du SVG sous format continue
        const yScale = d3.scale.linear().domain([0, 12])
          .range([h - margin.top, margin.bottom]).nice();

        d3.scale.linear().domain([0, 12])
          .range([h - margin.top + 6, margin.bottom]).nice();

        // Water draw
        var layers = [
          {
            name: 'transparent',
            values: [
              { x: minemplc, y: 5.5 },
              { x: maxemplc, y: 5.5 },
            ],
          },
          {
            name: 'opac',
            values: [
              { x: minemplc, y: 6.5 },
              { x: maxemplc, y: 6.5 },
            ],
          },
        ];

        var stack = d3.layout
          .stack()
          .offset('wiggle')
          .values(function(d) {
            return d.values;
          });

        var area = d3.svg
          .area()
          .x(function(d) {
            return xScale(d.x);
          })
          .y0(function(d) {
            return yScale(d.y0);
          })
          .y1(function(d) {
            return yScale(d.y);
          });

        var browser = svg
          .selectAll('.browser')
          .data(stack(layers))
          .enter()
          .append('g')
          .attr('class', 'browser')
          .style('fill', function(d) {
            if (d.name == 'transparent') {
              return 'rgba(174, 199, 232,0)';
            } else {
              return 'rgba(174, 199, 232,0.7)';
            }
          });

        browser
          .append('path')
          .attr('d', function(d) {
            return area(d.values);
          })
          .append('title')
          .text(function(d) {
            return d.name;
          });

        // Draw nodes
        var rects = svg
          .selectAll('rect')
          .data(dataBar)
          .enter()
          .append('rect')
          .attr('class', 'rects')
          .attr('x', function(d) {
            return xScale(d[0]);
          })
          .attr('y', function(d) {
            return yScale(d[1]);
          })
          .attr('width', () => {
            if (scope.type == 'part') {
              return '10';
            } else {
              return '5';
            }
          })
          .attr('height', () => {
            return yScale(0) - margin.top;
          })
          .style('fill', 'black')
          .style('border', 'solid #000000 10px');

        var arc = d3.svg
          .symbol()
          .type('triangle-up')
          .size(60);

        var dx = 0.004 * (xScale.domain()[1] - xScale.domain()[0]);
        var dy = 0.02 * (yScale.range()[1] - yScale.range()[0]);
        // add circles to svg
        var g = svg.append('g');

        var circles = g
          .selectAll('path')
          .data(dataPoints)
          .enter()
          .append('path')
          .attr('class', 'circles')
          .attr('transform', function(d) {
            switch (d[2].type) {
              case 'structurel':
                return (
                  'translate(' +
                  xScale(d[0] - dx) +
                  ',' +
                  (yScale(d[1]) - dy) +
                  ')'
                );
              case 'fonctionnel':
                return (
                  'translate(' +
                  xScale(d[0] - dx) +
                  ',' +
                  (yScale(d[1]) + dy) +
                  ')'
                );
              case 'inventaire':
                return (
                  'translate(' +
                  xScale(d[0] + dx) +
                  ',' +
                  (yScale(d[1]) + dy) +
                  ')'
                );
              case 'autre':
                return (
                  'translate(' +
                  xScale(d[0] + dx) +
                  ',' +
                  (yScale(d[1]) - dy) +
                  ')'
                );
              default:
                return (
                  'translate(' +
                  xScale(d[0] + dx) +
                  ',' +
                  (yScale(d[1]) - dy) +
                  ')'
                );
            }
          })
          .attr('d', arc)
          .attr('fill', function(d) {
            return d[2].color;
          })
          .attr('stroke', '#000')
          .attr('stroke-width', '1');

        // draw axis and grides
        var xAxis = d3.svg
          .axis()
          .scale(xScale)
          .tickSize(-yScale.range()[0] + yScale.range()[1], 0, 0)
          .orient('bottom');
        var yAxis = d3.svg
          .axis()
          .tickSize(-xScale.range()[1] + xScale.range()[0], 0, 0)
          .scale(yScale)
          .orient('left');

        svg
          .append('g')
          .attr('class', 'x axis')
          .attr('transform', 'translate(0,' + (h - margin.bottom) + ')')
          .style('opacity', '0.7')
          .call(xAxis);

        svg
          .append('g')
          .attr('class', 'y axis')
          .attr('transform', 'translate(' + margin.top + ',0)')
          .style('opacity', '0.7')
          .call(yAxis);

        // Add the text label for the x axis
        svg
          .append('text')
          .attr(
            'transform',
            'translate(' + w / 2 + ',' + (h - margin.bottom / 2) + ')'
          )
          .style('text-anchor', 'middle')
          .text($filter('translate')('itv.visualisation.xaxis'));

        // Add the text label for the Y axis
        svg.append('text').attr( 'transform',
          'translate(' + margin.left / 3 + ',' + h / 2 + '),rotate(-90)'
        ).attr('dy', '1em').style('text-anchor', 'middle')
          .text($filter('translate')('itv.visualisation.yaxis'));

        // filters go in defs element
        var defs = svg.append('defs');

        // create filter with id #drop-shadow
        // height=130% so that the shadow is not clipped
        var pattern = defs
          .append('pattern')
          .attr('id', 'image')
          .attr('x', '0')
          .attr('y', '0')
          //.attr("patternUnits","userSpaceOnUse")
          .attr('height', function() {
            if (scope.type == 'part') {
              return '15';
            } else {
              return '7.5';
            }
          })
          .attr('width', function() {
            if (scope.type == 'part') {
              return '15';
            } else {
              return '7.5';
            }
          });

        pattern.append('image').attr('x', '0').attr('y', '0')
          .attr('height', () => {
            if (scope.type == 'part') {
              return '15';
            } else {
              return '7.5';
            }
          })
          .attr('width', function() {
            if (scope.type == 'part') {
              return '15';
            } else {
              return '7.5';
            }
          })
          .attr('xlink:href', 'img/itv/attention.png');


        const createRapport = () => {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationImageRapport.html',
            className:
              'ngdialog-theme-plain width400 nopadding miniclose itv-soumission-rapport',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('itv.correspondance.obsDetails'),
            draggable: true,
            doNotForcePopupHeightToMinHeight: true,
            minWidth: '400px',
            minHeight: '550px',
            preCloseCallback: function () {
              scope.map.getLayers().forEach(function (l) {
                if (l.getProperties().name == 'detail')
                  scope.map.removeLayer(l);
              });
            },
          });
        };


        /**
         * Fabrication du contenu de la bulle d'aide descriptive
         * de l'observation dans la vue éclatée.
         *
         * @param {*} keys : Nom des propriétés d'ue observation
         * @param {*} d : Détail (observation) courant(e).
         * @returns Chaîne de caractères à mettre dans la bulle d'aide
         */
        const getTooltipText = (keys, d) => {
          let str = '';
          angular.forEach(keys, (key) => {
            if (key !== 'libelles') {
              let val = d[2][key];
              let lib = $filter('translate')('itv.correspondance.' + key);
              if (key.startsWith('_')) {
                if (d[2].libelles[key]) {
                  val = d[2].libelles[key];
                }
              }
              else {
                if (d[2].libelles[key]) {
                  lib = d[2].libelles[key];
                }
              }
              str += lib + ' : ' + val + '<br/>';
            }
          });
          return str;
        };


        circles.on('mouseover', function(d) {
          this.style.cursor = 'hand';
          div.transition().duration(200).style('opacity', 0.9);
          var str = '';
          var keys = Object.keys(d[2])
            .map(function(value) {
              if (angular.isDefined(d[2][value]) &&
                  d[2][value] !== null && d[2][value] !== '') {
                return value;
              }
            }).filter(function(value) {
              if (value !== undefined &&
                  ['color', 'id_inspection', 'id'].indexOf(value) == -1
              )
                return value;
            });
          str = getTooltipText(keys, d);
          div.html(str).style('left', d3.event.pageX + 'px')
            .style('top', d3.event.pageY - 28 + 'px');
        })
          .on('mouseout', function() {
            div.transition().duration(500).style('opacity', 0);
          })
          .on('click', function() {
            var posX = this.__data__[0];
            var posY = this.__data__[1];
            scope.partdetail = angular.copy(this.__data__[2]);
            scope.partdetails = details.map(function(x) {
              if (parseFloat(x._emplct_lng_vert) == posX &&
                  (parseInt(x.emplct_circ_1) == posY ||
                    parseInt(x.emplct_circ_2) == posY ||
                    (posY == 6 &&
                      (x.emplct_circ_2 == '') & (x.emplct_circ_1 == '')))
              )
                return x;
            })
              .filter(function(x) {
                if (x !== undefined) return x;
              });
            scope.picname = scope.partdetail.ref_photo;
            createRapport();
          });

        var div = d3
          .select('body')
          .append('div')
          .attr('class', 'itvtooltip')
          .style('opacity', 0);

        rects.on('mouseover', function(d) {
          this.style.cursor = 'hand';
          this.style.fill = 'rgba( 0 , 0 , 0 , 0.7)';
          div.transition().duration(200).style('opacity', 0.9);
          var str = '';
          var keys = Object.keys(d[2]).map(function(value) {
            if (angular.isDefined(d[2][value]) &&
                  d[2][value] !== null && d[2][value] !== '')
              return value;
          })
            .filter(function(value) {
              if (value !== undefined &&
                  ['color', 'id_inspection', 'id'].indexOf(value) == -1
              )
                return value;
            });

          str = getTooltipText(keys, d);

          div.html(str).style('left', d3.event.pageX + 'px')
            .style('top', d3.event.pageY - 28 + 'px');
        })
          .on('mouseout', function() {
            this.style.fill = 'rgba( 0 , 0 , 0 , 1)';
            div.transition().duration(500).style('opacity', 0);
          })
          .on('click', function() {
            var posX = this.__data__[0];
            scope.partdetail = angular.copy(this.__data__[2]);
            scope.partdetails = details
              .map(function(x) {
                if (parseFloat(x._emplct_lng_vert) == posX) return x;
              })
              .filter(function(x) {
                if (x !== undefined) return x;
              });
            scope.picname = scope.partdetail.ref_photo;
            createRapport();
          });

        var colors = [
          {
            type: $filter('translate')('itv.visualisation.inventaire'),
            color: '#5a89ad',
            x: margin.left,
            y: 40,
          },
          {
            type: $filter('translate')('itv.visualisation.structurel'),
            color: '#eaf903',
            x: margin.left * 4,
            y: 40,
          },
          {
            type: $filter('translate')('itv.visualisation.fonctionnel'),
            color: '#d87047',
            x: margin.left,
            y: 65,
          },
          {
            type: $filter('translate')('itv.visualisation.autre'),
            color: '#62e515',
            x: margin.left * 4,
            y: 65,
          },
          {
            type: $filter('translate')('itv.visualisation.noeudentreesortie'),
            color: '#000',
            x: margin.left * 7,
            y: 40,
          },
        ];

        var svg2 = d3
          .select('#secondary-svg')
          .append('svg')
          .attr('class', 'bars')
          .attr('width', w)
          .attr('height', 100);

        svg2.append('rect').attr('x', margin.left / 2).attr('y', 0)
          .attr('width', (w * 2) / 3).attr('height', 100)
          .style('fill', 'transparent').style('stroke', 'rgb(0, 0, 0)')
          .style('stroke-width', '1');
        var g2 = svg2.append('g');

        var arc2 = d3.svg
          .symbol()
          .type('triangle-up')
          .size(200);

        g2.selectAll('path')
          .data(colors)
          .enter()
          .append('path')
          .attr('class', 'rects')
          .attr('d', arc2)
          .attr('transform', function(d) {
            return 'translate(' + d.x + ',' + d.y + ')';
          })
          .attr('width', 40)
          .attr('height', 20)
          .style('fill', (d) =>  d.color)
          .style('stroke', '#000000')
          .style('stroke-width', 1);

        g2.selectAll('text')
          .data(colors)
          .enter()
          .append('text')
          .attr('transform', function(d) {
            switch (d.type) {
              case $filter('translate')('itv.visualisation.inventaire'):
              case $filter('translate')('itv.visualisation.structurel'):
                return 'translate(' + (d.x + 40) + ',' + d.y + ')';
              case $filter('translate')('itv.visualisation.fonctionnel'):
                return 'translate(' + (d.x + 42) + ',' + d.y + ')';
              case $filter('translate')('itv.visualisation.autre'):
                return 'translate(' + (d.x + 30) + ',' + d.y + ')';
              case $filter('translate')('itv.visualisation.noeudentreesortie'):
                return 'translate(' + (d.x + 66) + ',' + d.y + ')';
            }
          })
          .attr('dy', '1em')
          .style('text-anchor', 'middle')
          .text(function(d) {
            return d.type;
          });

        g2.append('text')
          .attr('transform', 'translate(' + margin.left + ',5)')
          .attr('dy', '1em')
          .style('text-anchor', 'left')
          .style('font-weight', 'bold')
          .style('font-size', '12')
          .text($filter('translate')('itv.visualisation.legend'));

        scope.$on('attachedFiles', function (event, files) {
          if (scope.attachedfiles) {
            scope.attachedfiles.splice(0, scope.attachedfiles.length);
            for (let file in files) {
              scope.attachedfiles.push(file);
            }
          }
          else {
            scope.attachedfiles = files;
          }
        });

        scope.downloadAttachment = function(pdfFn, ftiname, objid) {
          FeatureAttachmentFactory.getdownloadurl(pdfFn, ftiname, objid).then(
            function(res) {
              window.open(res.data);
              scope.wait = false;
            }
          );
        };
      },
    };
  };

  itvSoumission.$inject = [
    '$filter',
    'extendedNgDialog',
    'FeatureAttachmentFactory',
  ];
  return itvSoumission;
});
