'use strict';
define(function () {
  /**
   * Fonction "maintaSave2" appel le WebService Mainta pour la modification des coordonnées du BT ou de l'équipement en fonction de l’objet source.<br>
   * <a href="https://altereo-informatique.atlassian.net/browse/KIS-3538">KIS-3538</a><ul><li>
   */
  const maintaSave2Function = function() {
    this.$get = ($q, $filter, QueryFactory) => {
      return  {
        getParametersDesc: () => {
          return [
            [0, 'variable'],
            [1, 'string'],
            [2, 'string']
          ];
        },

        /**
         * Appel le WebService Mainta pour la modification des coordonnées du BT ou de l'équipement en fonction de l'objet source.
         * @param {Object} objects -  objet res qui contient les variables du formulaire courant
         * @param {String} source - La source des données
         * @param {String} urlSetXY - l'URL du Webservice Mainta pour la modification des coordonnées
         * @param {String} xApiKey - La clé d'accès pour appeler le Webservice Mainta
         * @returns {Promise} - Une promesse qui sera résolue avec le résultat de l'appel au Webservice Mainta
         */
        maintaSave2: (objects, source, urlSetXY, xApiKey) => {
          let def = $q.defer();

          //Extraire le nom de la variable depuis l'urlSetXY (entre les accolades)
          let paramInBrackets = urlSetXY.match(/\{(.*?)\}/)[1];
          let id = objects.res[source].properties[paramInBrackets];

          // Vérifier que l'ID a bien été trouvé
          if (!id) {
            require('toastr').error('Le champ ' + paramInBrackets + ' non trouvé dans l\'objet source');
            def.reject('ID non trouvé');
            return def.promise;
          }

          // Extraire les coordonnées de la source
          let coords = objects.res[source].geometry.coordinates;
          // Convertir les coordonnées de la géométrie de l'objet en EPSG:4326
          let coords2 = ol.proj.transform(
            coords,
            objects.map.getView().getProjection().getCode(),
            'EPSG:4326'
          );
          let x = coords2[0];
          let y = coords2[1];

          //Remplacer {id} dans l'URL par l'ID trouvé
          let finalUrl = urlSetXY.replace(/\{(.*?)\}/, id);

          let data = {
            urlSetXY: finalUrl,
            xApiKey: xApiKey,
            x: x,
            y: y,
          };
          let promise = QueryFactory.updateMaintaSave2(data);
          // Retouner le resultat du WS
          promise.then((res) => {
            if(res.status == 204 || res.status == 200){
              require('toastr').success('Mise à jour réussie');
            }
            def.resolve(res);
          }, (error) => {
            const errorMessage = error.data.message? error.data.message : error.data.Message;
            require('toastr').error(errorMessage);
            def.reject(error);
          });
          return def.promise;
        },
      };
    };
    this.$get.$inject = ['$q', '$filter', 'QueryFactory'];
  };
  return maintaSave2Function;
});
