'use strict';
define(function() {
  var javalanginteger = function(gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/javalanginteger.html',
      restrict: 'A',
      scope: {
        att: '=gcatt',
        result: '=result',
        activelabel: '=activelabel',
        initvalue: '=initvalue',
        fieldData: '=?fieldData',
        missingMandatoryAttributes: '=missingmandatoryattributes',
        deleteNullDefaultValues: '&?'
      },

      link: function(scope, elt) {

        // gère l'attribut "required" du select en JS
        // quand cet attribut est placé sur des champs masqués alors l'erreur suivante est levée:
        //  "invalid form control with name='' is not focusable."
        if (scope.fieldData && scope.fieldData.required) {
          elt[0].setAttribute('required', '');
        }

        // to init the value of the toggle switch, dans le cas où on interprete les entier comme Boolean
        scope.$watch('result', () => {
          if (scope.result && scope.att.name && scope.att.interpretAsBoolean) {
            scope.toggleSwitch = {value : scope.result[scope.att.name] ===1 ? true : false};
          }
        });

        /**
         * Si le navigateur est safari ou firefox alors on palie le bug de ces navigateurs sur les inputs numérique
         * en évitant les caractères textuels
         * @param {KeyboardEvent} event évènement à la pression d'une touche clavier
         * @return {boolean} <code>true</code> si la saisie contient un caractère textuel
         */
        scope.skipTextChars = (event) => {
          const toBypassKeys = ['Backspace', 'Delete', 'Clear', 'ArrowLeft', 'ArrowRight', 'ArrowDown',
            'ArrowUp', 'End', 'Home', 'PageDown', 'PageUp'];
          if (!toBypassKeys.includes(event.key)) {
            return gaJsUtils.skipTextInNumericInput(event, false);
          }
          return false;
        };

        // la variable est de type entier donc on doit mettre 1 ou 0 par rapport au changement du toggle
        scope.toggleSwitchChange = () => {
          scope.result[scope.att.name] = scope.toggleSwitch.value ? 1 : 0;
        }
      },
    };
  };

  javalanginteger.$inject = ['gaJsUtils'];
  return javalanginteger;
});
