'use strict';
define(function() {
  var javalangdouble = function(gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/javalangdouble.html',
      restrict: 'A',
      scope: {
        att: '=gcatt',
        result: '=result',
        activelabel: '=activelabel',
        initvalue: '=initvalue',
        fieldData: '=?fieldData',
        missingMandatoryAttributes: '=missingmandatoryattributes',
        deleteNullDefaultValues: '&?'
      },

      link: function(scope, element, attrs, ctrl) {
        /* console.log(scope.att);
                console.log(scope.fieldData);
            
                scope.unit = "";
                if (scope.att.unit.type.startsWith("superf")){
                var area = scope.result[scope.att.name];

                        if (scope.result[scope.att.name] > 10000) {
                          scope.result[scope.att.name] = (Math.round(area / 1000000 * 100) / 100) ;
                          scope.unit = " km²";
                          //scope.alias = scope.alias2 + " km²"
                        } else {
                          scope.result[scope.att.name] = (Math.round(area * 100) / 100);
                          scope.unit = " m²";
                          //scope.alias2 = scope.alias2 + " m²"
                        }
                }*/

        scope.restrict = false;
        scope.restricttype = '';

        /**
         * Gestion des espaces à la saisie
         * Si le navigateur est safari ou firefox alors on palie le bug de ces navigateurs sur les inputs numérique
         * en évitant les caractères textuels
         * @param {KeyboardEvent} event évènement à la pression d'une touche clavier
         * @return {boolean} <code>true</code> si la saisie contient un caractère textuel
         */
        scope.skipTextChars = (event) => {
          const toBypassKeys = ['Backspace', 'Delete', 'Clear', 'ArrowLeft', 'ArrowRight', 'ArrowDown',
            'ArrowUp', 'End', 'Home', 'PageDown', 'PageUp'];

          // prévient la saisie d'un 2nd séparateur de décimales
          if (String(scope.result[scope.att.name]).includes('.') && event.key === '.') {
            event.preventDefault();
            return true;
          }

          if (!toBypassKeys.includes(event.key)) {
            return gaJsUtils.skipTextInNumericInput(event);
          }
          return false;
        };

        /**
         * Gestion des espaces lors d'un copier/coller
         * Si le navigateur est safari ou firefox alors on palie le bug de ces navigateurs sur les inputs numériques
         * en évitant les caractères textuels
         * @param {object} event objet de type Event contenant une propriété originalEvent de type ClipboardEvent (sauf ds ie)
         */
        scope.onPaste = (event) => {

          // Initialisation du texte collé
          let pastedText;

          // Vérifie la compatibilité avec le Presse-papiers (clipboard)
          if (event.clipboardData || (event.originalEvent && event.originalEvent.clipboardData)) {
            // Accède aux données du Presse-papiers
            pastedText = (event.originalEvent || event).clipboardData.getData('text/plain');
          } else if (window.clipboardData) {
            // Pour les anciennes versions d'Internet Explorer
            pastedText = window.clipboardData.getData('Text');
          }

          // Créé un évènement clavier qui est le type d'argument accepté par la méthode skipTextChars
          const fakeEvent = new KeyboardEvent('keydown', {
            key: pastedText
          });

          // Vérifie si le texte doit être ignoré ou si le texte collé n'est pas un nombre
          if (scope.skipTextChars(fakeEvent) || Number.isNaN(pastedText)) {
            // Si le texte doit être ignoré ou n'est pas un nombre, empêche l'action par défaut du collage
            event.preventDefault();
          } else {
            // Si le texte n'est pas ignoré et est un nombre, l'affecte au modèle de l'input
            scope.result[scope.att.name] = Number.parseFloat(pastedText);
          }
        };
      },
    };
  };

  javalangdouble.$inject = ['gaJsUtils'];
  return javalangdouble;
});
